/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

interface SecurityActions {
    public static final SecurityActions NON_PRIVILEGED = new SecurityActions(){

        public Principal getPrincipal() {
            Principal p = null;
            SecurityContext sc = SecurityContextAssociation.getSecurityContext();
            if (sc != null) {
                p = sc.getUtil().getUserPrincipal();
            }
            return p;
        }

        public Object getCredential() {
            Object cred = null;
            SecurityContext sc = SecurityContextAssociation.getSecurityContext();
            if (sc != null) {
                cred = sc.getUtil().getCredential();
            }
            return cred;
        }

        public RunAs getCallerRunAsIdentity() {
            RunAs rai = null;
            SecurityContext existingSC = this.getSecurityContext();
            if (existingSC != null) {
                rai = existingSC.getOutgoingRunAs();
            }
            return rai;
        }

        public SecurityContext getSecurityContext() {
            return SecurityContextAssociation.getSecurityContext();
        }

        public void setSecurityContext(SecurityContext sc) {
            SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
        }

        public SecurityContext createSecurityContext(Principal p, Object cred, String sdomain) throws Exception {
            return SecurityContextFactory.createSecurityContext((Principal)p, (Object)cred, null, (String)sdomain);
        }
    };
    public static final SecurityActions PRIVILEGED = new SecurityActions(){
        private final PrivilegedAction getPrincipalAction = new PrivilegedAction(){

            public Object run() {
                Principal p = null;
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc != null) {
                    p = sc.getUtil().getUserPrincipal();
                }
                return p;
            }
        };
        private final PrivilegedAction getCredentialAction = new PrivilegedAction(){

            public Object run() {
                Object cred = null;
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc != null) {
                    cred = sc.getUtil().getCredential();
                }
                return cred;
            }
        };
        private final PrivilegedAction getSecurityContextAction = new PrivilegedAction(){

            public Object run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        };

        public Principal getPrincipal() {
            return (Principal)AccessController.doPrivileged(this.getPrincipalAction);
        }

        public Object getCredential() {
            return AccessController.doPrivileged(this.getCredentialAction);
        }

        public RunAs getCallerRunAsIdentity() {
            return (RunAs)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    RunAs rai = null;
                    SecurityContext existingSC = this.getSecurityContext();
                    if (existingSC != null) {
                        rai = existingSC.getOutgoingRunAs();
                    }
                    return rai;
                }
            });
        }

        public SecurityContext getSecurityContext() {
            return (SecurityContext)AccessController.doPrivileged(this.getSecurityContextAction);
        }

        public void setSecurityContext(final SecurityContext sc) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                    return null;
                }
            });
        }

        public SecurityContext createSecurityContext(final Principal p, final Object cred, final String sdomain) throws PrivilegedActionException {
            return (SecurityContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return SecurityContextFactory.createSecurityContext((Principal)p, (Object)cred, null, (String)sdomain);
                }
            });
        }
    };

    public Principal getPrincipal();

    public Object getCredential();

    public RunAs getCallerRunAsIdentity();

    public SecurityContext createSecurityContext(Principal var1, Object var2, String var3) throws Exception;

    public SecurityContext getSecurityContext();

    public void setSecurityContext(SecurityContext var1);

    public static class UTIL {
        static SecurityActions getSecurityActions() {
            return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
        }
    }
}

