/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJBException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionLocal;

public class GlobalTxEntityMap {
    private static final Logger log = Logger.getLogger(GlobalTxEntityMap.class);
    private final TransactionLocal txSynch = new TransactionLocal();
    public static final TxAssociation NONE = new TxAssociation(){

        public void scheduleSync(Transaction tx, EntityEnterpriseContext instance) throws SystemException, RollbackException {
            EntityContainer.getGlobalTxEntityMap().associate(tx, instance);
            instance.setTxAssociation(SYNC_SCHEDULED);
        }

        public void synchronize(Thread thread, Transaction tx, EntityEnterpriseContext instance) {
            throw new UnsupportedOperationException();
        }

        public void invokeEjbStore(Thread thread, EntityEnterpriseContext instance) {
            throw new UnsupportedOperationException();
        }
    };
    public static final TxAssociation SYNC_SCHEDULED = new TxAssociation(){

        public void scheduleSync(Transaction tx, EntityEnterpriseContext instance) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeEjbStore(Thread thread, EntityEnterpriseContext instance) throws Exception {
            if (instance.getId() != null) {
                EntityContainer container = (EntityContainer)instance.getContainer();
                SecurityActions.setContextClassLoader(thread, container.getClassLoader());
                container.pushENC();
                try {
                    container.invokeEjbStore(instance);
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    container.popENC();
                    throw throwable;
                }
                container.popENC();
                {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void synchronize(Thread thread, Transaction tx, EntityEnterpriseContext instance) throws Exception {
            if (instance.getId() != null) {
                EntityContainer container = (EntityContainer)instance.getContainer();
                SecurityActions.setContextClassLoader(thread, container.getClassLoader());
                container.pushENC();
                try {
                    container.storeEntity(instance);
                    instance.setTxAssociation(SYNCHRONIZED);
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    container.popENC();
                    throw throwable;
                }
                container.popENC();
                {
                }
            }
        }
    };
    public static final TxAssociation SYNCHRONIZED = new TxAssociation(){

        public void scheduleSync(Transaction tx, EntityEnterpriseContext instance) {
            instance.setTxAssociation(SYNC_SCHEDULED);
        }

        public void invokeEjbStore(Thread thread, EntityEnterpriseContext instance) {
        }

        public void synchronize(Thread thread, Transaction tx, EntityEnterpriseContext instance) {
        }
    };
    public static final TxAssociation PREVENT_SYNC = new TxAssociation(){

        public void scheduleSync(Transaction tx, EntityEnterpriseContext instance) {
        }

        public void synchronize(Thread thread, Transaction tx, EntityEnterpriseContext instance) throws Exception {
            EntityContainer container = (EntityContainer)instance.getContainer();
            if (container.getPersistenceManager().isStoreRequired(instance)) {
                throw new EJBException("The instance of " + container.getBeanMetaData().getEjbName() + " with pk=" + instance.getId() + " was not stored to prevent potential inconsistency of data in the database:" + " the instance was evicted from the cache during the transaction" + " and the database was possibly updated by another process.");
            }
        }

        public void invokeEjbStore(Thread thread, EntityEnterpriseContext instance) throws Exception {
            SYNC_SCHEDULED.invokeEjbStore(thread, instance);
        }
    };
    public static final TxAssociation NOT_READY = new TxAssociation(){

        public void scheduleSync(Transaction tx, EntityEnterpriseContext instance) {
        }

        public void synchronize(Thread thread, Transaction tx, EntityEnterpriseContext instance) throws Exception {
        }

        public void invokeEjbStore(Thread thread, EntityEnterpriseContext instance) throws Exception {
        }
    };

    public void synchronizeEntities(Transaction tx) {
        GlobalTxSynchronization globalSync = (GlobalTxSynchronization)this.txSynch.get(tx);
        if (globalSync != null) {
            globalSync.synchronize();
        }
    }

    private void associate(Transaction tx, EntityEnterpriseContext entity) throws RollbackException, SystemException {
        GlobalTxSynchronization globalSync = (GlobalTxSynchronization)this.txSynch.get(tx);
        if (globalSync == null) {
            globalSync = new GlobalTxSynchronization(tx);
            this.txSynch.set(tx, (Object)globalSync);
            tx.registerSynchronization((Synchronization)globalSync);
        }
        globalSync.associate(entity);
    }

    private class GlobalTxSynchronization
    implements Synchronization {
        private Transaction tx;
        private List instances = new ArrayList();
        private boolean synchronizing;

        public GlobalTxSynchronization(Transaction tx) {
            this.tx = tx;
        }

        public void associate(EntityEnterpriseContext ctx) {
            this.instances.add(ctx);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void synchronize() {
            ClassLoader oldCl;
            block16: {
                block15: {
                    block14: {
                        if (this.synchronizing) return;
                        if (this.instances.isEmpty()) {
                            return;
                        }
                        this.synchronizing = true;
                        Thread currentThread = Thread.currentThread();
                        oldCl = SecurityActions.getContextClassLoader();
                        EntityEnterpriseContext instance = null;
                        try {
                            try {
                                int i;
                                for (i = 0; i < this.instances.size(); ++i) {
                                    if (this.tx.getStatus() == 1) {
                                        Object var7_6 = null;
                                        break block14;
                                    }
                                    instance = (EntityEnterpriseContext)this.instances.get(i);
                                    instance.getTxAssociation().invokeEjbStore(currentThread, instance);
                                }
                                for (i = 0; i < this.instances.size(); ++i) {
                                    if (this.tx.getStatus() == 1) {
                                        break block15;
                                    }
                                    instance = (EntityEnterpriseContext)this.instances.get(i);
                                    instance.getTxAssociation().synchronize(currentThread, this.tx, instance);
                                }
                                break block16;
                            }
                            catch (Exception causeByException) {
                                String string;
                                try {
                                    this.tx.setRollbackOnly();
                                }
                                catch (Exception e) {
                                    log.warn((Object)("Exception while trying to rollback tx: " + this.tx), (Throwable)e);
                                }
                                if (causeByException instanceof EJBException) {
                                    throw (EJBException)((Object)causeByException);
                                }
                                StringBuilder stringBuilder = new StringBuilder().append("Exception in store of entity:");
                                if (instance != null && instance.getId() != null) {
                                    string = instance.getId().toString();
                                    throw new EJBException(stringBuilder.append(string).toString(), causeByException);
                                }
                                string = "<null>";
                                throw new EJBException(stringBuilder.append(string).toString(), causeByException);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_9 = null;
                            SecurityActions.setContextClassLoader(oldCl);
                            this.synchronizing = false;
                            throw throwable;
                        }
                    }
                    SecurityActions.setContextClassLoader(oldCl);
                    this.synchronizing = false;
                    return;
                }
                Object var7_7 = null;
                SecurityActions.setContextClassLoader(oldCl);
                this.synchronizing = false;
                return;
            }
            Object var7_8 = null;
            SecurityActions.setContextClassLoader(oldCl);
            this.synchronizing = false;
        }

        public void beforeCompletion() {
            if (log.isTraceEnabled()) {
                log.trace((Object)("beforeCompletion called for tx " + this.tx));
            }
            this.synchronize();
        }

        public void afterCompletion(int status) {
        }
    }

    public static interface TxAssociation {
        public void scheduleSync(Transaction var1, EntityEnterpriseContext var2) throws SystemException, RollbackException;

        public void synchronize(Thread var1, Transaction var2, EntityEnterpriseContext var3) throws Exception;

        public void invokeEjbStore(Thread var1, EntityEnterpriseContext var2) throws Exception;
    }
}

