/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.security;

import java.lang.reflect.Method;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import org.jboss.ejb.Container;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.security.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityIdentity;

public class PreSecurityInterceptor
extends AbstractInterceptor {
    private String securityDomain = null;
    private String timedObjectMethod = null;

    public void setContainer(Container container) {
        AuthenticationManager am;
        super.setContainer(container);
        if (container != null && (am = container.getSecurityManager()) != null) {
            this.securityDomain = am.getSecurityDomain();
        }
        try {
            this.timedObjectMethod = TimedObject.class.getMethod("ejbTimeout", Timer.class).getName();
        }
        catch (Exception e) {
            this.log.trace((Object)"Exception in creating TimedObject method:", (Throwable)e);
        }
    }

    public Object invoke(Invocation mi) throws Exception {
        boolean isInvoke = true;
        return this.process(mi, isInvoke);
    }

    public Object invokeHome(Invocation mi) throws Exception {
        boolean isInvoke = false;
        return this.process(mi, isInvoke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object process(Invocation mi, boolean isInvoke) throws Exception {
        SecurityIdentity si;
        block11: {
            Object object;
            boolean isEjbTimeOutMethod;
            if (this.securityDomain == null) {
                if (isInvoke) {
                    return this.getNext().invoke(mi);
                }
                return this.getNext().invokeHome(mi);
            }
            this.log.trace((Object)("process:isInvoke=" + isInvoke + " bean=" + this.container.getServiceName()));
            si = null;
            Method m = mi.getMethod();
            boolean bl = isEjbTimeOutMethod = m != null && m.getName().equals(this.timedObjectMethod);
            if (mi.isLocal() && !isEjbTimeOutMethod) {
                this.log.trace((Object)"True mi.isLocal() && !isEjbTimeOutMethod");
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc != null) {
                    si = sc.getUtil().getSecurityIdentity();
                }
                this.log.trace((Object)("SecurityIdentity=" + SecurityActions.trace(si)));
                mi.setSecurityContext(sc);
            } else {
                this.log.trace((Object)"False mi.isLocal() && !isEjbTimeOutMethod");
                this.establishSecurityContext(mi);
            }
            try {
                SecurityContext currentSC = SecurityActions.getSecurityContext();
                SecurityActions.pushCallerRunAsIdentity(currentSC.getOutgoingRunAs());
                this.log.trace((Object)("Going to the SecurityInterceptor with SC=" + SecurityActions.trace(currentSC)));
                if (!isInvoke) break block11;
                object = this.getNext().invoke(mi);
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                SecurityActions.popCallerRunAsIdentity();
                if (mi.isLocal() && si != null) {
                    SecurityActions.getSecurityContext().getUtil().setSecurityIdentity(si);
                }
                this.log.trace((Object)("Exit process():isInvoke=" + isInvoke));
                throw throwable;
            }
            SecurityActions.popCallerRunAsIdentity();
            if (mi.isLocal() && si != null) {
                SecurityActions.getSecurityContext().getUtil().setSecurityIdentity(si);
            }
            this.log.trace((Object)("Exit process():isInvoke=" + isInvoke));
            return object;
        }
        Object object = this.getNext().invokeHome(mi);
        Object var9_10 = null;
        SecurityActions.popCallerRunAsIdentity();
        if (mi.isLocal() && si != null) {
            SecurityActions.getSecurityContext().getUtil().setSecurityIdentity(si);
        }
        this.log.trace((Object)("Exit process():isInvoke=" + isInvoke));
        return object;
    }

    private void establishSecurityContext(Invocation mi) throws Exception {
        SecurityContext sc = mi.getSecurityContext();
        SecurityContext newSC = SecurityActions.createAndSetSecurityContext(this.securityDomain, this.container.getSecurityContextClassName());
        if (sc != null) {
            SecurityActions.setSecurityIdentity(newSC, sc.getUtil().getSecurityIdentity());
        } else {
            mi.setSecurityContext(newSC);
        }
        newSC.setSecurityManagement(this.container.getSecurityManagement());
        this.log.trace((Object)("establishSecurityIdentity:SecCtx=" + SecurityActions.trace(newSC)));
    }
}

