/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.ejb.plugins.cmp.ejbql;

/**
 * Parent class of all abstract syntax tree nodes.
 *
 * @author <a href="mailto:dain@daingroup.com">Dain Sundstrom</a>
 * @version $Revision: 37459 $
 */                            
public class SimpleNode implements Node {
   protected Node parent;
   protected Node[] children;
   protected final int id;

   public SimpleNode(int i) {
      id = i;
   }

   public void jjtOpen() {
   }

   public void jjtClose() {
   }
   
   public void jjtSetParent(Node n) { parent = n; }
   public Node jjtGetParent() { return parent; }

   public void jjtAddChild(Node n, int i) {
      if (children == null) {
         children = new Node[i + 1];
      } else if (i >= children.length) {
         Node c[] = new Node[i + 1];
         System.arraycopy(children, 0, c, 0, children.length);
         children = c;
      }
      children[i] = n;
   }

   public Node jjtGetChild(int i) {
      return children[i];
   }

   public int jjtGetNumChildren() {
      return (children == null) ? 0 : children.length;
   }

   /** Accept the visitor. **/
   public Object jjtAccept(JBossQLParserVisitor visitor, Object data) {
      return visitor.visit(this, data);
   }

   /* You can override these two methods in subclasses of SimpleNode to
       customize the way the node appears when the tree is dumped.   If
       your output uses more than one line you should override
       toString(String), otherwise overriding toString() is probably all
       you need to do. */

   public String toString() { return EJBQLParserTreeConstants.jjtNodeName[id]; }
   public String toString(String prefix) { return prefix + toString(); }

   /* Override this method if you want to customize how the node dumps
       out its children. */

   public void dump(String prefix) {
      System.out.println(toString(prefix));
      if (children != null) {
         for (int i = 0; i < children.length; ++i) {
            SimpleNode n = (SimpleNode)children[i];
            if (n != null) {
               n.dump(prefix + ' ');
            }
         }
      }
   }
}

