/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.structure.spi.helpers.RelativeDeploymentContextComparator;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSArchiveStructureDeployer;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.jboss.ServiceModuleMetaData;
import org.jboss.metadata.ear.spec.AbstractModule;
import org.jboss.metadata.ear.spec.ConnectorModuleMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.ear.spec.EjbModuleMetaData;
import org.jboss.metadata.ear.spec.JavaModuleMetaData;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.metadata.ear.spec.ModulesMetaData;
import org.jboss.metadata.ear.spec.WebModuleMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.util.SuffixMatchFilter;
import org.jboss.vfs.util.automount.Automounter;
import org.jboss.vfs.util.automount.MountOption;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;

public class EARStructure
extends AbstractVFSArchiveStructureDeployer {
    public static final VirtualFileFilter DEFAULT_EAR_LIB_FILTER = new SuffixMatchFilter(".jar");
    private VirtualFileFilter earLibFilter = DEFAULT_EAR_LIB_FILTER;
    private SchemaBindingResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
    UnmarshallerFactory unmarshallerFactory = UnmarshallerFactory.newInstance();
    private boolean includeEarRootInClasspath = true;
    private String comparatorClassName;
    private boolean useValidation = true;

    public EARStructure() {
        this.setRelativeOrder(1000);
    }

    public VirtualFileFilter getEarLibFilter() {
        return this.earLibFilter;
    }

    public void setEarLibFilter(VirtualFileFilter earLibFilter) {
        if (earLibFilter == null) {
            throw new IllegalArgumentException("Null filter");
        }
        this.earLibFilter = earLibFilter;
    }

    public SchemaBindingResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(SchemaBindingResolver resolver) {
        this.resolver = resolver;
    }

    protected boolean hasValidSuffix(String name) {
        return name.toLowerCase().endsWith(".ear");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doDetermineStructure(StructureContext structureContext) throws DeploymentException {
        boolean valid;
        boolean trace = log.isTraceEnabled();
        VirtualFile file = structureContext.getFile();
        try {
            ModulesMetaData modules;
            InputStream in;
            if (!this.hasValidName(file)) {
                return false;
            }
            ContextInfo context = this.createContext(structureContext, "META-INF");
            context.setComparatorClassName(this.comparatorClassName);
            VirtualFile applicationXml = this.getMetaDataFile(file, "META-INF/application.xml");
            VirtualFile jbossAppXml = this.getMetaDataFile(file, "META-INF/jboss-app.xml");
            boolean scan = true;
            Unmarshaller unmarshaller = this.unmarshallerFactory.newUnmarshaller();
            unmarshaller.setValidation(this.useValidation);
            EarMetaData specMetaData = null;
            JBossAppMetaData appMetaData = null;
            if (applicationXml != null) {
                in = applicationXml.openStream();
                try {
                    specMetaData = (EarMetaData)unmarshaller.unmarshal(in, this.resolver);
                }
                finally {
                    in.close();
                }
                scan = false;
            }
            if (jbossAppXml != null) {
                in = jbossAppXml.openStream();
                try {
                    appMetaData = (JBossAppMetaData)unmarshaller.unmarshal(in, this.resolver);
                }
                finally {
                    in.close();
                }
            }
            if (appMetaData == null) {
                appMetaData = new JBossAppMetaData();
            }
            appMetaData.merge(appMetaData, specMetaData);
            String libDir = appMetaData.getLibraryDirectory();
            if (libDir == null || libDir.length() > 0) {
                if (libDir == null) {
                    libDir = "lib";
                }
                if (trace) {
                    log.trace((Object)("Checking for ear lib directory: " + libDir));
                }
                try {
                    VirtualFile lib = file.getChild(libDir);
                    if (lib.exists()) {
                        if (trace) {
                            log.trace((Object)("Found ear lib directory: " + lib));
                        }
                        List archives = lib.getChildren(this.earLibFilter);
                        for (VirtualFile archive : archives) {
                            Automounter.mount((VirtualFile)file, (VirtualFile)archive, (MountOption[])new MountOption[0]);
                            this.addClassPath(structureContext, archive, true, true, context);
                            if (archive.getChild("META-INF/persistence.xml").exists()) {
                                log.trace((Object)(archive.getName() + " in ear lib directory has persistence units"));
                                if (structureContext.determineChildStructure(archive)) continue;
                                throw new RuntimeException(archive.getName() + " in lib directory has persistence.xml but is not a recognized deployment, .ear: " + file.getName());
                            }
                            if (!trace) continue;
                            log.trace((Object)(archive.getPathName() + " does not contain META-INF/persistence.xml"));
                        }
                    } else if (trace) {
                        log.trace((Object)"No lib directory in ear archive.");
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Exception while searching for lib dir: " + e));
                }
            } else if (trace) {
                log.trace((Object)"Ignoring library directory, got empty library-directory element.");
            }
            this.addClassPath(structureContext, file, this.includeEarRootInClasspath, true, context);
            if (scan) {
                this.scanEar(file, appMetaData);
            }
            if ((modules = appMetaData.getModules()) != null) {
                for (ModuleMetaData mod : modules) {
                    VirtualFile module;
                    String fileName = mod.getFileName();
                    if (fileName == null || (fileName = fileName.trim()).length() <= 0) continue;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Checking application.xml module: " + fileName));
                    }
                    if (!(module = file.getChild(fileName)).exists()) {
                        throw new RuntimeException(fileName + " module listed in application.xml does not exist within .ear " + file.toURI());
                    }
                    if (structureContext.determineChildStructure(module)) continue;
                    throw new RuntimeException(fileName + " module listed in application.xml is not a recognized deployment, .ear: " + file.getName());
                }
                if (appMetaData.getModuleOrderEnum() == JBossAppMetaData.ModuleOrder.STRICT) {
                    context.setComparatorClassName(RelativeDeploymentContextComparator.class.getName());
                    int i = 0;
                    for (ContextInfo ctx : structureContext.getMetaData().getContexts()) {
                        ctx.setRelativeOrder(i++);
                    }
                }
            }
            valid = true;
        }
        catch (Exception e) {
            throw new RuntimeException("Error determining structure: " + file.getName(), e);
        }
        return valid;
    }

    private void scanEar(VirtualFile root, JBossAppMetaData appMetaData) throws IOException {
        List archives = root.getChildren();
        if (archives != null) {
            String earPath = root.getPathName();
            ModulesMetaData modules = appMetaData.getModules();
            if (modules == null) {
                modules = new ModulesMetaData();
                appMetaData.setModules(modules);
            }
            for (VirtualFile vfArchive : archives) {
                String filename = this.earRelativePath(earPath, vfArchive.getPathName());
                ModuleMetaData moduleMetaData = appMetaData.getModule(filename);
                int type = this.typeFromSuffix(filename, vfArchive);
                if (type < 0 || moduleMetaData != null) continue;
                moduleMetaData = new ModuleMetaData();
                EjbModuleMetaData module = null;
                switch (type) {
                    case 0: {
                        module = new EjbModuleMetaData();
                        break;
                    }
                    case 2: {
                        module = new JavaModuleMetaData();
                        break;
                    }
                    case 3: {
                        module = new ConnectorModuleMetaData();
                        break;
                    }
                    case 4: 
                    case 5: {
                        module = new ServiceModuleMetaData();
                        break;
                    }
                    case 1: {
                        module = new WebModuleMetaData();
                    }
                }
                module.setFileName(filename);
                moduleMetaData.setValue((AbstractModule)module);
                modules.add((MappableMetaData)moduleMetaData);
            }
        }
    }

    private int typeFromSuffix(String path, VirtualFile archive) throws IOException {
        int type = -1;
        if (path.endsWith(".war")) {
            type = 1;
        } else if (path.endsWith(".rar")) {
            type = 3;
        } else if (path.endsWith(".har")) {
            type = 5;
        } else if (path.endsWith(".sar")) {
            type = 4;
        } else if (path.endsWith(".jar")) {
            Manifest mf;
            Attributes attrs;
            VirtualFile mfFile = this.getMetaDataFile(archive, "META-INF/MANIFEST.MF");
            VirtualFile clientXml = this.getMetaDataFile(archive, "META-INF/application-client.xml");
            VirtualFile ejbXml = this.getMetaDataFile(archive, "META-INF/ejb-jar.xml");
            VirtualFile jbossXml = this.getMetaDataFile(archive, "META-INF/jboss.xml");
            type = clientXml != null ? 2 : (mfFile != null ? ((attrs = (mf = VFSUtils.readManifest((VirtualFile)mfFile)).getMainAttributes()).containsKey(Attributes.Name.MAIN_CLASS) ? 2 : 0) : (ejbXml != null || jbossXml != null ? 0 : 0));
        }
        return type;
    }

    private String earRelativePath(String earPath, String pathName) {
        StringBuilder tmp = new StringBuilder(pathName);
        tmp.delete(0, earPath.length() + 1);
        return tmp.toString();
    }

    private VirtualFile getMetaDataFile(VirtualFile file, String path) {
        VirtualFile metaFile = null;
        metaFile = file.getChild(path);
        return metaFile.exists() ? metaFile : null;
    }

    public void setIncludeEarRootInClasspath(boolean includeEarRootInClasspath) {
        this.includeEarRootInClasspath = includeEarRootInClasspath;
    }

    public void setComparatorClassName(String comparatorClassName) {
        this.comparatorClassName = comparatorClassName;
    }

    public void setUseValidation(boolean validateXml) {
        this.useValidation = validateXml;
    }

    public boolean isUseValidation() {
        return this.useValidation;
    }
}

