/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCApplicationMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.RelationshipRoleMetaData;
import org.w3c.dom.Element;

public final class JDBCRelationshipRoleMetaData {
    private final JDBCRelationMetaData relationMetaData;
    private final String relationshipRoleName;
    private final boolean multiplicityOne;
    private final boolean foreignKeyConstraint;
    private final boolean cascadeDelete;
    private final boolean batchCascadeDelete;
    private final JDBCEntityMetaData entity;
    private final String cmrFieldName;
    private final boolean navigable;
    private final String cmrFieldType;
    private boolean genIndex;
    private final JDBCReadAheadMetaData readAhead;
    private JDBCRelationshipRoleMetaData relatedRole;
    private Map keyFields;

    public JDBCRelationshipRoleMetaData(JDBCRelationMetaData relationMetaData, JDBCApplicationMetaData application, RelationshipRoleMetaData role) throws DeploymentException {
        this.relationMetaData = relationMetaData;
        this.relationshipRoleName = role.getRelationshipRoleName();
        this.multiplicityOne = role.isMultiplicityOne();
        this.cascadeDelete = role.isCascadeDelete();
        this.batchCascadeDelete = false;
        this.foreignKeyConstraint = false;
        this.readAhead = null;
        String fieldName = JDBCRelationshipRoleMetaData.loadCMRFieldName(role);
        if (fieldName == null) {
            this.cmrFieldName = JDBCRelationshipRoleMetaData.generateNonNavigableCMRName(role);
            this.navigable = false;
        } else {
            this.cmrFieldName = fieldName;
            this.navigable = true;
        }
        this.cmrFieldType = role.getCMRFieldType();
        this.entity = application.getBeanByEjbName(role.getEntityName());
        if (this.entity == null) {
            throw new DeploymentException("Entity: " + role.getEntityName() + " not found for relation: " + role.getRelationMetaData().getRelationName());
        }
    }

    public JDBCRelationshipRoleMetaData(JDBCRelationMetaData relationMetaData, JDBCApplicationMetaData application, Element element, JDBCRelationshipRoleMetaData defaultValues) throws DeploymentException {
        this.relationMetaData = relationMetaData;
        this.entity = application.getBeanByEjbName(defaultValues.getEntity().getName());
        this.relationshipRoleName = defaultValues.getRelationshipRoleName();
        this.multiplicityOne = defaultValues.isMultiplicityOne();
        this.cascadeDelete = defaultValues.isCascadeDelete();
        this.cmrFieldName = defaultValues.getCMRFieldName();
        this.navigable = defaultValues.isNavigable();
        this.cmrFieldType = defaultValues.getCMRFieldType();
        String fkString = MetaData.getOptionalChildContent((Element)element, (String)"fk-constraint");
        this.foreignKeyConstraint = fkString != null ? Boolean.valueOf(fkString).booleanValue() : defaultValues.hasForeignKeyConstraint();
        Element readAheadElement = MetaData.getOptionalChild((Element)element, (String)"read-ahead");
        this.readAhead = readAheadElement != null ? new JDBCReadAheadMetaData(readAheadElement, this.entity.getReadAhead()) : this.entity.getReadAhead();
        boolean bl = this.batchCascadeDelete = MetaData.getOptionalChild((Element)element, (String)"batch-cascade-delete") != null;
        if (this.batchCascadeDelete) {
            if (!this.cascadeDelete) {
                throw new DeploymentException(relationMetaData.getRelationName() + '/' + this.relationshipRoleName + " has batch-cascade-delete in jbosscmp-jdbc.xml but has no cascade-delete in ejb-jar.xml");
            }
            if (relationMetaData.isTableMappingStyle()) {
                throw new DeploymentException("Relationship " + relationMetaData.getRelationName() + " with relation-table-mapping style was setup for batch cascade-delete." + " Batch cascade-delete supported only for foreign key mapping style.");
            }
        }
    }

    public void init(JDBCRelationshipRoleMetaData relatedRole) throws DeploymentException {
        this.init(relatedRole, null);
    }

    public void init(JDBCRelationshipRoleMetaData relatedRole, Element element) throws DeploymentException {
        this.relatedRole = relatedRole;
        this.keyFields = element == null || "defaults".equals(element.getTagName()) ? this.loadKeyFields() : this.loadKeyFields(element);
    }

    private static String loadCMRFieldName(RelationshipRoleMetaData role) {
        return role.getCMRFieldName();
    }

    private static String generateNonNavigableCMRName(RelationshipRoleMetaData role) {
        RelationshipRoleMetaData relatedRole = role.getRelatedRoleMetaData();
        return relatedRole.getEntityName() + "_" + relatedRole.getCMRFieldName();
    }

    public JDBCRelationMetaData getRelationMetaData() {
        return this.relationMetaData;
    }

    public String getRelationshipRoleName() {
        return this.relationshipRoleName;
    }

    public boolean hasForeignKeyConstraint() {
        return this.foreignKeyConstraint;
    }

    public boolean isMultiplicityOne() {
        return this.multiplicityOne;
    }

    public boolean isMultiplicityMany() {
        return !this.multiplicityOne;
    }

    public boolean isCascadeDelete() {
        return this.cascadeDelete;
    }

    public boolean isBatchCascadeDelete() {
        return this.batchCascadeDelete;
    }

    public JDBCEntityMetaData getEntity() {
        return this.entity;
    }

    public String getCMRFieldName() {
        return this.cmrFieldName;
    }

    public boolean isNavigable() {
        return this.navigable;
    }

    private String getCMRFieldType() {
        return this.cmrFieldType;
    }

    public JDBCRelationshipRoleMetaData getRelatedRole() {
        return this.relationMetaData.getOtherRelationshipRole(this);
    }

    public JDBCReadAheadMetaData getReadAhead() {
        return this.readAhead;
    }

    public Collection getKeyFields() {
        return Collections.unmodifiableCollection(this.keyFields.values());
    }

    public boolean isIndexed() {
        return this.genIndex;
    }

    private Map loadKeyFields() {
        if (this.relationMetaData.isForeignKeyMappingStyle()) {
            if (this.isMultiplicityMany()) {
                return Collections.EMPTY_MAP;
            }
            if (this.getRelatedRole().isMultiplicityOne() && !this.getRelatedRole().isNavigable()) {
                return Collections.EMPTY_MAP;
            }
        }
        ArrayList<JDBCCMPFieldMetaData> pkFields = new ArrayList<JDBCCMPFieldMetaData>();
        for (JDBCCMPFieldMetaData cmpField : this.entity.getCMPFields()) {
            if (!cmpField.isPrimaryKeyMember()) continue;
            pkFields.add(cmpField);
        }
        HashMap<String, JDBCCMPFieldMetaData> fields = new HashMap<String, JDBCCMPFieldMetaData>(pkFields.size());
        for (JDBCCMPFieldMetaData cmpField : pkFields) {
            String columnName = this.relationMetaData.isTableMappingStyle() ? (this.entity.equals(this.relatedRole.getEntity()) ? this.getCMRFieldName() : this.entity.getName()) : this.relatedRole.getCMRFieldName();
            if (pkFields.size() > 1) {
                columnName = columnName + "_" + cmpField.getFieldName();
            }
            cmpField = new JDBCCMPFieldMetaData(this.entity, cmpField, columnName, false, this.relationMetaData.isTableMappingStyle(), this.relationMetaData.isReadOnly(), this.relationMetaData.getReadTimeOut(), this.relationMetaData.isTableMappingStyle());
            fields.put(cmpField.getFieldName(), cmpField);
        }
        return Collections.unmodifiableMap(fields);
    }

    private Map loadKeyFields(Element element) throws DeploymentException {
        Element keysElement = MetaData.getOptionalChild((Element)element, (String)"key-fields");
        if (keysElement == null) {
            return this.loadKeyFields();
        }
        Iterator iter = MetaData.getChildrenByTagName((Element)keysElement, (String)"key-field");
        if (!iter.hasNext()) {
            return Collections.EMPTY_MAP;
        }
        if (this.relationMetaData.isForeignKeyMappingStyle() && this.isMultiplicityMany()) {
            throw new DeploymentException("Role: " + this.relationshipRoleName + " with multiplicity many using " + "foreign-key mapping is not allowed to have key-fields");
        }
        Map defaultFields = this.getPrimaryKeyFields();
        HashMap<String, JDBCCMPFieldMetaData> fields = new HashMap<String, JDBCCMPFieldMetaData>(defaultFields.size());
        while (iter.hasNext()) {
            Element keyElement = (Element)iter.next();
            String fieldName = MetaData.getUniqueChildContent((Element)keyElement, (String)"field-name");
            JDBCCMPFieldMetaData cmpField = (JDBCCMPFieldMetaData)defaultFields.remove(fieldName);
            if (cmpField == null) {
                throw new DeploymentException("Role '" + this.relationshipRoleName + "' on Entity Bean '" + this.entity.getName() + "' : CMP field for key not found: field " + "name='" + fieldName + "'");
            }
            String isIndexedtmp = MetaData.getOptionalChildContent((Element)keyElement, (String)"dbindex");
            boolean isIndexed = isIndexedtmp != null;
            this.genIndex = isIndexed;
            cmpField = new JDBCCMPFieldMetaData(this.entity, keyElement, cmpField, false, this.relationMetaData.isTableMappingStyle(), this.relationMetaData.isReadOnly(), this.relationMetaData.getReadTimeOut(), this.relationMetaData.isTableMappingStyle());
            fields.put(cmpField.getFieldName(), cmpField);
        }
        if (!defaultFields.isEmpty()) {
            throw new DeploymentException("Mappings were not provided for all fields: unmaped fields=" + defaultFields.keySet() + " in role=" + this.relationshipRoleName);
        }
        return Collections.unmodifiableMap(fields);
    }

    private Map getPrimaryKeyFields() {
        HashMap<String, JDBCCMPFieldMetaData> pkFields = new HashMap<String, JDBCCMPFieldMetaData>();
        for (JDBCCMPFieldMetaData cmpField : this.entity.getCMPFields()) {
            if (!cmpField.isPrimaryKeyMember()) continue;
            pkFields.put(cmpField.getFieldName(), cmpField);
        }
        return pkFields;
    }
}

