/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.keygen;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.ejb.EJBException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCIdentityColumnCreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;

public class JDBCSQLServerCreateCommand
extends JDBCIdentityColumnCreateCommand {
    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) throws DeploymentException {
        super.initEntityCommand(entityCommand);
        this.pkSQL = entityCommand.getAttribute("pk-sql");
        if (this.pkSQL == null) {
            this.pkSQL = "SELECT SCOPE_IDENTITY()";
        }
    }

    protected void initInsertSQL() {
        super.initInsertSQL();
        this.insertSQL = this.insertSQL + "; " + this.pkSQL;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int executeInsert(int index, PreparedStatement ps, EntityEnterpriseContext ctx) throws SQLException {
        int n;
        ps.execute();
        ResultSet rs = null;
        try {
            int rows = ps.getUpdateCount();
            if (rows != 1) {
                throw new EJBException("Expected updateCount of 1, got " + rows);
            }
            if (!ps.getMoreResults()) {
                throw new EJBException("Expected ResultSet but got an updateCount. Is NOCOUNT set for all triggers?");
            }
            rs = ps.getResultSet();
            if (!rs.next()) {
                throw new EJBException("ResultSet was empty");
            }
            this.pkField.loadInstanceResults(rs, 1, ctx);
            n = rows;
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new EJBException("Error extracting generated keys", e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(rs);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(rs);
        return n;
    }
}

