/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.annotations.ScanningMetaData;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.AnnotatedClassFilter;
import org.jboss.metadata.annotation.creator.web.Web30MetaDataCreator;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.annotation.finder.DefaultAnnotationFinder;
import org.jboss.metadata.web.spec.Web30MetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarAnnotationMetaDataDeployer
extends AbstractDeployer {
    public static final String WEB_ANNOTATED_ATTACHMENT_NAME = "annotated." + WebMetaData.class.getName();
    private boolean metaDataCompleteIsDefault = false;

    public WarAnnotationMetaDataDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(WebMetaData.class);
        this.addInput(ScanningMetaData.class);
        this.addOutput(WEB_ANNOTATED_ATTACHMENT_NAME);
    }

    public boolean isMetaDataCompleteIsDefault() {
        return this.metaDataCompleteIsDefault;
    }

    public void setMetaDataCompleteIsDefault(boolean metaDataCompleteIsDefault) {
        this.metaDataCompleteIsDefault = metaDataCompleteIsDefault;
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        this.deploy(vfsDeploymentUnit);
    }

    public void undeploy(DeploymentUnit unit) {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        this.undeploy(vfsDeploymentUnit);
    }

    protected void deploy(VFSDeploymentUnit unit) throws DeploymentException {
        if (!unit.getSimpleName().endsWith(".war")) {
            return;
        }
        VirtualFile root = unit.getRoot();
        if (root.isFile()) {
            return;
        }
        List classpath = unit.getClassPath();
        if (classpath == null || classpath.isEmpty()) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Deploying annotations for unit: " + unit + ", classpath: " + classpath));
        }
        try {
            this.processMetaData(unit, classpath);
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Cannot process metadata", (Throwable)e);
        }
    }

    protected void processMetaData(VFSDeploymentUnit unit, List<VirtualFile> classpath) throws Exception {
        ScanningMetaData scanningMetaData = (ScanningMetaData)unit.getAttachment(ScanningMetaData.class);
        HashMap classesPerJar = new HashMap();
        boolean foundAnnotations = false;
        for (VirtualFile path : classpath) {
            if (scanningMetaData != null && (scanningMetaData.getPaths() == null || !scanningMetaData.getPaths().contains(path.getName()))) continue;
            Collection<Class<?>> currentClasses = this.getClasses(unit, path);
            classesPerJar.put(path, currentClasses);
            if (currentClasses.size() <= 0) continue;
            foundAnnotations = true;
        }
        if (foundAnnotations) {
            DefaultAnnotationFinder finder = new DefaultAnnotationFinder();
            this.processJBossWebMetaData(unit, (AnnotationFinder<AnnotatedElement>)finder, classesPerJar);
        }
    }

    protected Collection<Class<?>> getClasses(VFSDeploymentUnit unit, VirtualFile classpath) throws IOException {
        AnnotatedClassFilter classVisitor = new AnnotatedClassFilter(unit, unit.getClassLoader(), classpath, null);
        classpath.visit((VirtualFileVisitor)classVisitor);
        Map<VirtualFile, Class<?>> classes = classVisitor.getAnnotatedClasses();
        if (classes != null && classes.size() > 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Annotated classes: " + classes));
            }
        } else {
            classes = new HashMap();
        }
        return classes.values();
    }

    protected void undeploy(VFSDeploymentUnit unit) {
    }

    protected void processJBossWebMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder, Map<VirtualFile, Collection<Class<?>>> classes) {
        Web30MetaDataCreator creator = new Web30MetaDataCreator(finder);
        boolean metaData = false;
        for (VirtualFile path : classes.keySet()) {
            Web30MetaData annotationMetaData = creator.create(classes.get(path));
            this.log.debug((Object)("Add annotations: " + WEB_ANNOTATED_ATTACHMENT_NAME + ":" + path.getName()));
            if (annotationMetaData == null) continue;
            unit.addAttachment(WEB_ANNOTATED_ATTACHMENT_NAME + ":" + path.getName(), (Object)annotationMetaData, WebMetaData.class);
            metaData = true;
        }
        if (metaData) {
            unit.addAttachment(WEB_ANNOTATED_ATTACHMENT_NAME, (Object)Boolean.TRUE);
        }
    }
}

