/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.IOException;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.ear.jboss.JBoss50AppMetaData;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.jboss.ServiceModuleMetaData;
import org.jboss.metadata.ear.spec.AbstractModule;
import org.jboss.metadata.ear.spec.ConnectorModuleMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.ear.spec.EjbModuleMetaData;
import org.jboss.metadata.ear.spec.JavaModuleMetaData;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.metadata.ear.spec.ModulesMetaData;
import org.jboss.metadata.ear.spec.WebModuleMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class EARContentsDeployer
extends AbstractDeployer {
    private boolean requiresEarSuffix = false;

    public EARContentsDeployer() {
        this.setStage(DeploymentStages.PARSE);
        this.addInput(EarMetaData.class);
        this.addOutput(JBossAppMetaData.class);
        this.setTopLevelOnly(true);
    }

    public boolean isRequiresEarSuffix() {
        return this.requiresEarSuffix;
    }

    public void setRequiresEarSuffix(boolean requiresEarSuffix) {
        this.requiresEarSuffix = requiresEarSuffix;
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (unit.isAttachmentPresent(EarMetaData.class)) {
            this.log.tracef("Ignoring ear with META-INF/application.xml: %1s", (Object)unit.getSimpleName());
            return;
        }
        if (!(unit instanceof VFSDeploymentUnit)) {
            this.log.tracef("Not a vfs deployment: %1s", (Object)unit.getName());
            return;
        }
        if (this.requiresEarSuffix && !unit.getSimpleName().endsWith(".ear")) {
            this.log.tracef("Unit name does not end in .ear: %1s", (Object)unit.getSimpleName());
            return;
        }
        VFSDeploymentUnit vfsunit = (VFSDeploymentUnit)VFSDeploymentUnit.class.cast(unit);
        this.deploy(vfsunit);
    }

    public void deploy(VFSDeploymentUnit unit) throws DeploymentException {
        VirtualFile root = unit.getRoot();
        VirtualFile ear = unit.getFile(unit.getRelativePath());
        this.deploy(unit, root, ear);
    }

    protected void deploy(VFSDeploymentUnit unit, VirtualFile root, VirtualFile file) {
        try {
            JBoss50AppMetaData j2eeMetaData = new JBoss50AppMetaData();
            this.scanEar(unit, file, (JBossAppMetaData)j2eeMetaData);
            unit.addAttachment(JBossAppMetaData.class, (Object)j2eeMetaData);
        }
        catch (Exception e) {
            throw new RuntimeException("Error determining ear contents: " + file.getName(), e);
        }
    }

    private void scanEar(VFSDeploymentUnit unit, VirtualFile root, JBossAppMetaData j2eeMetaData) throws IOException {
        List archives = root.getChildren();
        if (archives != null) {
            String earPath = root.getPathName();
            ModulesMetaData modules = j2eeMetaData.getModules();
            if (modules == null) {
                modules = new ModulesMetaData();
                j2eeMetaData.setModules(modules);
            }
            for (VirtualFile vfArchive : archives) {
                String filename = this.earRelativePath(earPath, vfArchive.getPathName());
                ModuleMetaData moduleMetaData = j2eeMetaData.getModule(filename);
                int type = this.typeFromSuffix(unit, filename, vfArchive);
                if (type < 0 || moduleMetaData != null) continue;
                moduleMetaData = new ModuleMetaData();
                EjbModuleMetaData module = null;
                switch (type) {
                    case 0: {
                        module = new EjbModuleMetaData();
                        break;
                    }
                    case 2: {
                        module = new JavaModuleMetaData();
                        break;
                    }
                    case 3: {
                        module = new ConnectorModuleMetaData();
                        break;
                    }
                    case 4: 
                    case 5: {
                        module = new ServiceModuleMetaData();
                        break;
                    }
                    case 1: {
                        module = new WebModuleMetaData();
                    }
                }
                module.setFileName(filename);
                moduleMetaData.setValue((AbstractModule)module);
                modules.add((MappableMetaData)moduleMetaData);
            }
        }
    }

    private int typeFromSuffix(VFSDeploymentUnit unit, String path, VirtualFile archive) throws IOException {
        int type = -1;
        if (path.endsWith(".war")) {
            type = 1;
        } else if (path.endsWith(".rar")) {
            type = 3;
        } else if (path.endsWith(".har")) {
            type = 5;
        } else if (path.endsWith(".sar")) {
            type = 4;
        } else if (path.endsWith(".jar")) {
            Manifest mf;
            Attributes attrs;
            VirtualFile mfFile = unit.getMetaDataFile("MANIFEST.MF");
            VirtualFile clientXml = unit.getMetaDataFile("application-client.xml");
            VirtualFile ejbXml = unit.getMetaDataFile("ejb-jar.xml");
            VirtualFile jbossXml = unit.getMetaDataFile("jboss.xml");
            type = clientXml != null ? 2 : (mfFile != null ? ((attrs = (mf = VFSUtils.readManifest((VirtualFile)mfFile)).getMainAttributes()).containsKey(Attributes.Name.MAIN_CLASS) ? 2 : 0) : (ejbXml != null || jbossXml != null ? 0 : 0));
        }
        return type;
    }

    private String earRelativePath(String earPath, String pathName) {
        StringBuilder tmp = new StringBuilder(pathName);
        tmp.delete(0, earPath.length() + 1);
        return tmp.toString();
    }
}

