/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.dependency;

import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.logging.Logger;
import org.jboss.util.JBossStringBuilder;

public class JndiDependencyItem
extends AbstractDependencyItem
implements DependencyItem {
    private static final Logger log = Logger.getLogger(JndiDependencyItem.class);
    private String jndiName;
    private Object demand;
    private ClassLoader loader;

    public JndiDependencyItem(String jndiName, ClassLoader loader, ControllerState whenRequired) {
        super((Object)jndiName, null, whenRequired, null);
        this.jndiName = jndiName;
        this.loader = loader;
    }

    public Object getDemand() {
        return this.demand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean resolve(Controller controller) {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.loader);
                InitialContext ctx = new InitialContext();
                this.demand = ctx.lookup(this.jndiName);
                this.setResolved(true);
                boolean bl = this.isResolved();
                Object var6_7 = null;
                Thread.currentThread().setContextClassLoader(tcl);
                return bl;
            }
            catch (NameNotFoundException e) {
                Object var6_8 = null;
                Thread.currentThread().setContextClassLoader(tcl);
            }
            catch (Throwable ignored) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Unexpected error", ignored);
                }
                Object var6_9 = null;
                Thread.currentThread().setContextClassLoader(tcl);
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            Thread.currentThread().setContextClassLoader(tcl);
            throw throwable;
        }
        this.setResolved(false);
        return this.isResolved();
    }

    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        buffer.append(" depend=").append(this.jndiName);
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getName()).append(" depend ").append(this.jndiName);
    }

    public String toHumanReadableString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JndiDepends: '");
        builder.append(this.jndiName);
        builder.append("'");
        return builder.toString();
    }
}

