/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy.ejb;

import java.security.Principal;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationKey;
import org.jboss.proxy.Interceptor;
import org.jboss.proxy.ejb.SecurityActions;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;

public class SecurityContextInterceptor
extends Interceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        SecurityContext sc = null;
        boolean compatib = this.validateASVersionCompatibility(invocation);
        if (compatib) {
            sc = SecurityActions.getSecurityContext();
            RunAs callerRAI = SecurityActions.getCallerRunAsIdentity();
            SecurityContext newSc = this.createSecurityContext(invocation);
            if (callerRAI != null) {
                SecurityActions.setOutgoingRunAs(newSc, callerRAI);
                SecurityActions.setIncomingRunAs(newSc, callerRAI);
            }
            invocation.setSecurityContext(newSc);
        }
        try {
            Object object = this.getNext().invoke(invocation);
            return object;
        }
        finally {
            if (compatib && sc != null) {
                SecurityActions.setSecurityContext(sc);
            }
        }
    }

    private SecurityContext createSecurityContext(Invocation invocation) throws Exception {
        Principal p = invocation.getPrincipal();
        Object cred = invocation.getCredential();
        String domain = (String)invocation.getInvocationContext().getValue(InvocationKey.SECURITY_DOMAIN);
        if (domain == null) {
            domain = "CLIENT_PROXY";
        }
        return SecurityActions.createSecurityContext(p, cred, domain);
    }

    private boolean validateASVersionCompatibility(Invocation invocation) {
        try {
            invocation.getInvocationContext().getValue(InvocationKey.SECURITY_DOMAIN);
        }
        catch (NoSuchFieldError nsfe) {
            return false;
        }
        return true;
    }
}

