/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployment.dependency.ContainerDependencyMetaData;
import org.jboss.deployment.dependency.JndiDependencyMetaData;
import org.jboss.deployment.plugin.MappedDeploymentEndpointResolver;
import org.jboss.deployment.spi.DeploymentEndpointResolver;
import org.jboss.deployment.spi.EndpointInfo;
import org.jboss.logging.Logger;
import org.jboss.metadata.client.jboss.JBossClientMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossEntityBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossGenericBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndi.resolver.impl.JNDIPolicyBasedJNDINameResolverFactory;
import org.jboss.metadata.ejb.jboss.jndi.resolver.spi.EntityBeanJNDINameResolver;
import org.jboss.metadata.ejb.jboss.jndi.resolver.spi.SessionBeanJNDINameResolver;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.DefaultJNDIBindingPolicyFactory;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DeploymentSummary;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.PackagingType;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.metadata.javaee.spec.AnnotatedEJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.AnnotatedEJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.EJBLocalReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBLocalReferencesMetaData;
import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedReferenceMetaDataResolverDeployer
extends AbstractRealDeployer {
    public static final String ENDPOINT_MAP_KEY = "MappedReferenceMetaDataResolverDeployer.endpointMap";
    public static final String DEPENDS_SET_KEY = "MappedReferenceMetaDataResolverDeployer.dependsSet";
    public static final String ALTERNATE_MAP_KEY = "MappedReferenceMetaDataResolverDeployer.endpointAlternateMap";
    private static Logger log = Logger.getLogger(MappedReferenceMetaDataResolverDeployer.class);
    private boolean failOnUnresolvedRefs;
    private DefaultJndiBindingPolicy defaultJNDIBindingPolicy = DefaultJNDIBindingPolicyFactory.getDefaultJNDIBindingPolicy();

    public MappedReferenceMetaDataResolverDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        HashSet<String> inputs = new HashSet<String>();
        inputs.add(JBossClientMetaData.class.getName());
        inputs.add(JBossMetaData.class.getName());
        inputs.add(JBossWebMetaData.class.getName());
        super.setInputs(inputs);
        super.setOutput(DeploymentEndpointResolver.class);
    }

    public boolean isParentFirst() {
        return false;
    }

    public boolean isFailOnUnresolvedRefs() {
        return this.failOnUnresolvedRefs;
    }

    public void setFailOnUnresolvedRefs(boolean failOnUnresolvedRefs) {
        this.failOnUnresolvedRefs = failOnUnresolvedRefs;
    }

    public void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        MappedDeploymentEndpointResolver resolver;
        JBossMetaData ejbMetaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        JBossWebMetaData webMetaData = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
        JBossClientMetaData clientMetaData = (JBossClientMetaData)unit.getAttachment(JBossClientMetaData.class);
        if (ejbMetaData == null && webMetaData == null && clientMetaData == null) {
            return;
        }
        DeploymentUnit top = unit.getTopLevel();
        ConcurrentHashMap<String, ContainerDependencyMetaData> endpointMap = (ConcurrentHashMap<String, ContainerDependencyMetaData>)top.getAttachment(ENDPOINT_MAP_KEY, Map.class);
        ConcurrentHashMap<String, String> endpointAlternateMap = (ConcurrentHashMap<String, String>)top.getAttachment(ALTERNATE_MAP_KEY, Map.class);
        if (endpointMap == null) {
            endpointMap = new ConcurrentHashMap<String, ContainerDependencyMetaData>();
            endpointAlternateMap = new ConcurrentHashMap<String, String>();
            this.mapEndpoints(top, endpointMap, endpointAlternateMap);
            top.addAttachment(ENDPOINT_MAP_KEY, endpointMap, Map.class);
            top.addAttachment(ALTERNATE_MAP_KEY, endpointAlternateMap);
            resolver = new MappedDeploymentEndpointResolver(endpointMap, endpointAlternateMap, unit.getRelativePath());
            top.addAttachment(DeploymentEndpointResolver.class, (Object)resolver);
        }
        resolver = new MappedDeploymentEndpointResolver(endpointMap, (Map<String, String>)endpointAlternateMap, unit.getRelativePath());
        ArrayList<String> unresolvedPaths = new ArrayList<String>();
        if (ejbMetaData != null) {
            JBossEnterpriseBeansMetaData beans = ejbMetaData.getEnterpriseBeans();
            try {
                this.resolve(unit, endpointMap, beans, resolver, unresolvedPaths);
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
            if (unresolvedPaths.size() > 0) {
                log.warn((Object)("Unresolved references exist in JBossMetaData:" + unresolvedPaths));
            }
        }
        if (webMetaData != null) {
            ContainerDependencyMetaData webAppCDMD = new ContainerDependencyMetaData(unit.getSimpleName(), "web-app", unit.getRelativePath());
            try {
                this.resolve(webAppCDMD, unit, endpointMap, webMetaData.getJndiEnvironmentRefsGroup(), resolver, unresolvedPaths);
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
            if (unresolvedPaths.size() > 0) {
                log.warn((Object)("Unresolved references exist in JBossWebMetaData:" + unresolvedPaths));
            }
        }
        if (clientMetaData != null) {
            ContainerDependencyMetaData clientCDMD = new ContainerDependencyMetaData(unit.getSimpleName(), "client", unit.getRelativePath());
            try {
                this.resolve(clientCDMD, unit, endpointMap, clientMetaData.getJndiEnvironmentRefsGroup(), resolver, unresolvedPaths);
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
            if (unresolvedPaths.size() > 0) {
                log.warn((Object)("Unresolved references exist in JBossClientMetaData: " + unresolvedPaths));
            }
        }
        HashSet<ContainerDependencyMetaData> depends = new HashSet<ContainerDependencyMetaData>();
        for (ContainerDependencyMetaData cdmd : endpointMap.values()) {
            depends.add(cdmd);
        }
        top.addAttachment(DEPENDS_SET_KEY, depends, Set.class);
        unit.addAttachment(DeploymentEndpointResolver.class, (Object)resolver);
        this.dump(unit);
    }

    protected void mapEndpoints(DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, Map<String, String> endpointAlternateMap) {
        boolean trace = log.isTraceEnabled();
        this.mapEjbs(unit, endpointMap, endpointAlternateMap, trace);
        this.mapMessageDestinations(unit, endpointMap, endpointAlternateMap, trace);
        this.mapPersistenceUnits(unit, endpointMap, trace);
        this.displayEndpoints(unit.getName(), endpointMap);
    }

    protected void mapPersistenceUnits(DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, boolean trace) {
        String vfsPath = unit.getRelativePath();
    }

    protected void mapMessageDestinations(DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, Map<String, String> endpointAlternateMap, boolean trace) {
        List children;
        JBossClientMetaData clientMetaData;
        JBossWebMetaData webMetaData;
        String vfsPath = unit.getRelativePath();
        JBossMetaData ejbMetaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        MessageDestinationsMetaData msgDestinations = null;
        ClassLoader loader = unit.getClassLoader();
        if (ejbMetaData != null) {
            msgDestinations = ejbMetaData.getAssemblyDescriptor().getMessageDestinations();
            this.mapMessageDestinations(vfsPath, msgDestinations, endpointMap, endpointAlternateMap, loader, trace);
        }
        if ((webMetaData = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class)) != null) {
            msgDestinations = webMetaData.getMessageDestinations();
            this.mapMessageDestinations(vfsPath, msgDestinations, endpointMap, endpointAlternateMap, loader, trace);
        }
        if ((clientMetaData = (JBossClientMetaData)unit.getAttachment(JBossClientMetaData.class)) != null) {
            msgDestinations = clientMetaData.getMessageDestinations();
            this.mapMessageDestinations(vfsPath, msgDestinations, endpointMap, endpointAlternateMap, loader, trace);
        }
        if ((children = unit.getChildren()) != null) {
            for (DeploymentUnit child : children) {
                this.mapMessageDestinations(child, endpointMap, endpointAlternateMap, trace);
            }
        }
    }

    protected void mapMessageDestinations(String vfsPath, MessageDestinationsMetaData msgDestinations, Map<String, ContainerDependencyMetaData> endpointMap, Map<String, String> endpointAlternateMap, ClassLoader loader, boolean trace) {
        if (msgDestinations == null || msgDestinations.size() == 0) {
            return;
        }
        String prefix = "message-destination/" + vfsPath;
        for (MessageDestinationMetaData dest : msgDestinations) {
            String destKey;
            String mappedName = dest.getMappedName();
            String destName = dest.getMessageDestinationName();
            if (mappedName == null || mappedName.length() == 0) {
                log.debug((Object)("Message-destination: " + destName + " has no mappedName"));
                continue;
            }
            String destPath = prefix + "#" + destName;
            ContainerDependencyMetaData destMD = new ContainerDependencyMetaData(mappedName, destName, vfsPath);
            endpointMap.put(destPath, destMD);
            if (trace) {
                log.trace((Object)("mapMessageDestinations: " + destPath + ", mappedName: " + mappedName));
            }
            if (!endpointAlternateMap.containsKey(destKey = "message-destination/" + destName)) {
                endpointAlternateMap.put(destKey, destPath);
                if (!trace) continue;
                log.trace((Object)("mapMessageDestinations, added alternate root message-destination: " + destPath));
                continue;
            }
            log.debug((Object)("Duplicate root ejb-name: " + destKey + " from: " + destPath));
        }
    }

    protected void mapEjbs(DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, Map<String, String> endpointAlternateMap, boolean trace) {
        List children;
        JBossMetaData ejbMetaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        JBossEnterpriseBeansMetaData beans = null;
        if (ejbMetaData != null) {
            if (ejbMetaData.getDeploymentSummary() == null) {
                DeploymentSummary deploymentSummary = MappedReferenceMetaDataResolverDeployer.getDeploymentSummary(unit);
                ejbMetaData.setDeploymentSummary(deploymentSummary);
            }
            beans = ejbMetaData.getEnterpriseBeans();
        }
        if (beans != null) {
            String vfsPath = unit.getRelativePath();
            String prefix = "ejb/" + vfsPath;
            for (JBossEnterpriseBeanMetaData bean : beans) {
                String local;
                String local2;
                String localHomeJNDIName;
                String remote;
                String ifacePath;
                String home;
                String ejbCompID = prefix + "#" + bean.getEjbName();
                String jndiName = bean.determineJndiName();
                ContainerDependencyMetaData cdmd = new ContainerDependencyMetaData(jndiName, bean.getEjbName(), vfsPath);
                cdmd.setEjb3X(ejbMetaData.isEJB3x());
                EjbDeploymentSummary unitSummary = MappedReferenceMetaDataResolverDeployer.getEjbDeploymentSummary(unit, bean);
                cdmd.setUnitSummary(unitSummary);
                endpointMap.put(ejbCompID, cdmd);
                ArrayList<String> mappings = new ArrayList<String>();
                String ejbNameKey = "ejb/" + bean.getEjbName();
                if (!endpointAlternateMap.containsKey(ejbNameKey)) {
                    endpointAlternateMap.put(ejbNameKey, ejbCompID);
                    mappings.add(ejbNameKey);
                    if (trace) {
                        log.trace((Object)("mapEjbs, added alternate root ejb-name: " + ejbNameKey));
                    }
                } else {
                    log.debug((Object)("Duplicate root ejb-name: " + ejbNameKey + " from: " + ejbCompID));
                }
                if (bean instanceof JBossSessionBeanMetaData) {
                    JBossSessionBean31MetaData sessionBean31;
                    BusinessRemotesMetaData remotes;
                    BusinessLocalsMetaData locals;
                    JBossSessionBeanMetaData sbean = (JBossSessionBeanMetaData)bean;
                    String ejbName = sbean.getEjbName();
                    SessionBeanJNDINameResolver sessionbeanJNDINameResolver = JNDIPolicyBasedJNDINameResolverFactory.getJNDINameResolver((JBossSessionBeanMetaData)sbean, (DefaultJndiBindingPolicy)this.defaultJNDIBindingPolicy);
                    if (sbean.getHome() != null && sbean.getHome().length() > 0) {
                        String remoteHomeJNDIName = sessionbeanJNDINameResolver.resolveRemoteHomeJNDIName(sbean);
                        cdmd.addJndiName(remoteHomeJNDIName);
                        home = sbean.getHome();
                        ifacePath = prefix + "@" + home;
                        if (endpointAlternateMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates home: " + home + ", existing: " + endpointAlternateMap.get(ifacePath)));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local-home: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                        ifacePath = "ejb@" + home;
                        if (endpointMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates home: " + home + ", existing: " + (Object)((Object)endpointMap.get(ifacePath))));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, home: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                    }
                    if (sbean.getRemote() != null && sbean.getRemote().length() > 0) {
                        remote = sbean.getRemote();
                        String remoteJndiName = sessionbeanJNDINameResolver.resolveJNDIName(sbean, remote);
                        cdmd.addJndiName(remoteJndiName);
                        ifacePath = prefix + "@" + remote;
                        if (endpointAlternateMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates remote: " + remote + ", existing: " + endpointAlternateMap.get(ifacePath)));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, remote: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                        ifacePath = "ejb@" + remote;
                        if (endpointMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates remote: " + remote + ", existing: " + (Object)((Object)endpointMap.get(ifacePath))));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                    }
                    if (sbean.getLocalHome() != null && sbean.getLocalHome().length() > 0) {
                        localHomeJNDIName = sessionbeanJNDINameResolver.resolveLocalHomeJNDIName(sbean);
                        cdmd.addJndiName(localHomeJNDIName);
                        local2 = sbean.getLocalHome();
                        ifacePath = prefix + "@" + local2;
                        if (endpointAlternateMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates local-home: " + local2 + ", existing: " + endpointAlternateMap.get(ifacePath)));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local-home: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                        ifacePath = "ejb@" + local2;
                        if (endpointMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates local-home: " + local2 + ", existing: " + (Object)((Object)endpointMap.get(ifacePath))));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local-home: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                    }
                    if (sbean.getLocal() != null && sbean.getLocal().length() > 0) {
                        local = sbean.getLocal();
                        String localJndiName = sessionbeanJNDINameResolver.resolveJNDIName(sbean, local);
                        cdmd.addJndiName(localJndiName);
                        ifacePath = prefix + "@" + local;
                        if (endpointAlternateMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates local: " + local + ", existing: " + endpointAlternateMap.get(ifacePath)));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                        ifacePath = "ejb@" + local;
                        if (endpointMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates local: " + local + ", existing: " + (Object)((Object)endpointMap.get(ifacePath))));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                    }
                    if ((locals = sbean.getBusinessLocals()) != null && locals.size() > 0) {
                        String defaultLocalBusinessJNDIName = sessionbeanJNDINameResolver.resolveLocalBusinessDefaultJNDIName(sbean);
                        cdmd.addJndiName(defaultLocalBusinessJNDIName);
                        for (String local3 : locals) {
                            String localBusinessJNDIName = sessionbeanJNDINameResolver.resolveJNDIName(sbean, local3);
                            cdmd.addJndiName(localBusinessJNDIName);
                            String ifacePath2 = prefix + "@" + local3;
                            if (endpointAlternateMap.containsKey(ifacePath2)) {
                                log.debug((Object)(ejbName + " duplicates business local: " + local3 + ", existing: " + endpointAlternateMap.get(ifacePath2)));
                            } else {
                                endpointAlternateMap.put(ifacePath2, ejbCompID);
                                mappings.add(ifacePath2);
                                if (trace) {
                                    log.trace((Object)("mapEjbs, business-local: " + ifacePath2 + ", ejbName: " + ejbName));
                                }
                            }
                            ifacePath2 = "ejb@" + local3;
                            if (endpointMap.containsKey(ifacePath2)) {
                                log.debug((Object)(ejbName + " duplicates business-local: " + local3 + ", existing: " + (Object)((Object)endpointMap.get(ifacePath2))));
                                continue;
                            }
                            endpointAlternateMap.put(ifacePath2, ejbCompID);
                            mappings.add(ifacePath2);
                            if (!trace) continue;
                            log.trace((Object)("mapEjbs, business-local: " + ifacePath2 + ", ejbName: " + ejbName));
                        }
                    }
                    if ((remotes = sbean.getBusinessRemotes()) != null && remotes.size() > 0) {
                        String defaultRemoteBusinessJNDIName = sessionbeanJNDINameResolver.resolveRemoteBusinessDefaultJNDIName(sbean);
                        cdmd.addJndiName(defaultRemoteBusinessJNDIName);
                        for (String remote2 : remotes) {
                            String remoteBusinessJNDIName = sessionbeanJNDINameResolver.resolveJNDIName(sbean, remote2);
                            cdmd.addJndiName(remoteBusinessJNDIName);
                            String ifacePath3 = prefix + "@" + remote2;
                            if (endpointAlternateMap.containsKey(ifacePath3)) {
                                log.debug((Object)(ejbName + " duplicates business remote: " + remote2 + ", existing: " + endpointAlternateMap.get(ifacePath3)));
                            } else {
                                endpointAlternateMap.put(ifacePath3, ejbCompID);
                                mappings.add(ifacePath3);
                                if (trace) {
                                    log.trace((Object)("mapEjbs, business-remote: " + ifacePath3 + ", ejbName: " + ejbName));
                                }
                            }
                            ifacePath3 = "ejb@" + remote2;
                            if (endpointMap.containsKey(ifacePath3)) {
                                log.debug((Object)(ejbName + " duplicates business-remote: " + remote2 + ", existing: " + (Object)((Object)endpointMap.get(ifacePath3))));
                                continue;
                            }
                            endpointAlternateMap.put(ifacePath3, ejbCompID);
                            mappings.add(ifacePath3);
                            if (!trace) continue;
                            log.trace((Object)("mapEjbs, business-remote: " + ifacePath3 + ", ejbName: " + ejbName));
                        }
                    }
                    if (sbean.getJBossMetaData().isEJB31() && sbean instanceof JBossSessionBean31MetaData && (sessionBean31 = (JBossSessionBean31MetaData)sbean).isNoInterfaceBean()) {
                        String ejbClassName = sessionBean31.getEjbClass();
                        String ifacePath4 = prefix + "@" + ejbClassName;
                        if (endpointAlternateMap.containsKey(ifacePath4)) {
                            log.debug((Object)(ejbName + " duplicates nointerface bean: " + ejbClassName + ", existing: " + endpointAlternateMap.get(ifacePath4)));
                        } else {
                            endpointAlternateMap.put(ifacePath4, ejbCompID);
                            mappings.add(ifacePath4);
                            if (trace) {
                                log.trace((Object)("mapEjbs, nointerface bean: " + ifacePath4 + ", ejbName: " + ejbName));
                            }
                        }
                        ifacePath4 = "ejb@" + ejbClassName;
                        if (endpointMap.containsKey(ifacePath4)) {
                            log.debug((Object)(ejbName + " duplicates nointerface bean : " + ejbClassName + ", existing: " + (Object)((Object)endpointMap.get(ifacePath4))));
                        } else {
                            endpointAlternateMap.put(ifacePath4, ejbCompID);
                            mappings.add(ifacePath4);
                            if (trace) {
                                log.trace((Object)("mapEjbs, nointerface bean : " + ifacePath4 + ", ejbName: " + ejbName));
                            }
                        }
                    }
                    if (!trace) continue;
                    log.trace((Object)("mapEjbs: " + ejbCompID + ", mappings: " + mappings));
                    continue;
                }
                if (bean instanceof JBossEntityBeanMetaData) {
                    String ifacePath5;
                    JBossEntityBeanMetaData ebean = (JBossEntityBeanMetaData)bean;
                    EntityBeanJNDINameResolver entityBeanJNDINameResolver = JNDIPolicyBasedJNDINameResolverFactory.getJNDINameResolver((JBossEntityBeanMetaData)ebean, (DefaultJndiBindingPolicy)this.defaultJNDIBindingPolicy);
                    String ejbName = ebean.getEjbName();
                    if (ebean.getHome() != null && ebean.getHome().length() > 0) {
                        String homeJNDIName = entityBeanJNDINameResolver.resolveRemoteHomeJNDIName(ebean);
                        cdmd.addJndiName(homeJNDIName);
                        home = ebean.getHome();
                        ifacePath = prefix + "@" + home;
                        if (endpointAlternateMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates home: " + home + ", existing: " + endpointAlternateMap.get(ifacePath)));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local-home: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                        ifacePath = "ejb@" + home;
                        if (endpointMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates home: " + home + ", existing: " + (Object)((Object)endpointMap.get(ifacePath))));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, home: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                    }
                    if (ebean.getRemote() != null && ebean.getRemote().length() > 0) {
                        remote = ebean.getRemote();
                        ifacePath5 = prefix + "@" + remote;
                        if (endpointAlternateMap.containsKey(ifacePath5)) {
                            log.debug((Object)(ejbName + " duplicates remote: " + remote + ", existing: " + endpointAlternateMap.get(ifacePath5)));
                        } else {
                            endpointAlternateMap.put(ifacePath5, ejbCompID);
                            mappings.add(ifacePath5);
                            if (trace) {
                                log.trace((Object)("mapEjbs, remote: " + ifacePath5 + ", ejbName: " + ejbName));
                            }
                        }
                        ifacePath5 = "ejb@" + remote;
                        if (endpointMap.containsKey(ifacePath5)) {
                            log.debug((Object)(ejbName + " duplicates remote: " + remote + ", existing: " + (Object)((Object)endpointMap.get(ifacePath5))));
                        } else {
                            endpointAlternateMap.put(ifacePath5, ejbCompID);
                            mappings.add(ifacePath5);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local: " + ifacePath5 + ", ejbName: " + ejbName));
                            }
                        }
                    }
                    if (ebean.getLocalHome() != null && ebean.getLocalHome().length() > 0) {
                        localHomeJNDIName = entityBeanJNDINameResolver.resolveLocalHomeJNDIName(ebean);
                        cdmd.addJndiName(localHomeJNDIName);
                        local2 = ebean.getLocalHome();
                        ifacePath = prefix + "@" + local2;
                        if (endpointAlternateMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates local-home: " + local2 + ", existing: " + endpointAlternateMap.get(ifacePath)));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local-home: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                        ifacePath = "ejb@" + local2;
                        if (endpointMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates local-home: " + local2 + ", existing: " + (Object)((Object)endpointMap.get(ifacePath))));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local-home: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                    }
                    if (ebean.getLocal() == null || ebean.getLocal().length() <= 0) continue;
                    local = ebean.getLocal();
                    ifacePath5 = prefix + "@" + local;
                    if (endpointAlternateMap.containsKey(ifacePath5)) {
                        log.debug((Object)(ejbName + " duplicates local: " + local + ", existing: " + endpointAlternateMap.get(ifacePath5)));
                    } else {
                        endpointAlternateMap.put(ifacePath5, ejbCompID);
                        mappings.add(ifacePath5);
                        if (trace) {
                            log.trace((Object)("mapEjbs, local: " + ifacePath5 + ", ejbName: " + ejbName));
                        }
                    }
                    ifacePath5 = "ejb@" + local;
                    if (endpointMap.containsKey(ifacePath5)) {
                        log.debug((Object)(ejbName + " duplicates local: " + local + ", existing: " + (Object)((Object)endpointMap.get(ifacePath5))));
                        continue;
                    }
                    endpointAlternateMap.put(ifacePath5, ejbCompID);
                    mappings.add(ifacePath5);
                    if (!trace) continue;
                    log.trace((Object)("mapEjbs, local: " + ifacePath5 + ", ejbName: " + ejbName));
                    continue;
                }
                if (!(bean instanceof JBossGenericBeanMetaData)) continue;
                log.warn((Object)("JBossGenericBeanMetaData seen for: " + bean.getEjbName()));
            }
        }
        if ((children = unit.getChildren()) != null) {
            for (DeploymentUnit child : children) {
                this.mapEjbs(child, endpointMap, endpointAlternateMap, trace);
            }
        }
    }

    protected void resolve(ContainerDependencyMetaData cdmd, DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, Environment env, DeploymentEndpointResolver resolver, List<String> unresolvedRefs) throws Exception {
        if (env == null) {
            return;
        }
        AnnotatedEJBReferencesMetaData annotatedRefs = env.getAnnotatedEjbReferences();
        this.resolveEjbAnnotatedRefs(cdmd, unit, endpointMap, annotatedRefs, resolver, unresolvedRefs);
        EJBLocalReferencesMetaData localRefs = env.getEjbLocalReferences();
        this.resolveEjbLocalRefs(cdmd, unit, endpointMap, localRefs, resolver, unresolvedRefs);
        EJBReferencesMetaData ejbRefs = env.getEjbReferences();
        this.resolveEjbRefs(cdmd, unit, endpointMap, ejbRefs, resolver, unresolvedRefs);
        MessageDestinationReferencesMetaData msgRefs = env.getMessageDestinationReferences();
        this.resolveMsgRefs(cdmd, unit, endpointMap, msgRefs, resolver, unresolvedRefs);
    }

    protected void resolve(DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, JBossEnterpriseBeansMetaData beans, DeploymentEndpointResolver resolver, List<String> unresolvedPaths) throws Exception {
        if (beans == null || beans.size() == 0) {
            return;
        }
        String vfsPath = unit.getRelativePath();
        for (JBossEnterpriseBeanMetaData bean : beans) {
            String ejbCompID = "ejb/" + vfsPath + "#" + bean.getEjbName();
            ContainerDependencyMetaData cdmd = endpointMap.get(ejbCompID);
            if (cdmd == null) {
                throw new IllegalStateException("Failed to find ContainerDependencyMetaData for: " + ejbCompID);
            }
            Environment env = bean.getJndiEnvironmentRefsGroup();
            this.resolve(cdmd, unit, endpointMap, env, resolver, unresolvedPaths);
        }
    }

    protected void resolveEjbAnnotatedRefs(ContainerDependencyMetaData cdmd, DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, AnnotatedEJBReferencesMetaData annotatedRefs, DeploymentEndpointResolver resolver, List<String> unresolvedRefs) {
        if (annotatedRefs == null) {
            return;
        }
        String vfsContext = unit.getRelativePath();
        for (AnnotatedEJBReferenceMetaData ref : annotatedRefs) {
            Class iface = ref.getBeanInterface();
            String link = ref.getLink();
            EndpointInfo info = null;
            if (link != null) {
                info = resolver.getEndpointInfo(link, "ejb", vfsContext);
            }
            if (info == null && iface != null) {
                info = resolver.getEndpointInfo(iface, "ejb", vfsContext);
            }
            if (info != null) {
                ContainerDependencyMetaData target = endpointMap.get(info.getComponentKey());
                if (target != null) {
                    SessionBeanJNDINameResolver jndiNameResolver;
                    cdmd.addDependency(target);
                    String ifaceName = iface != null ? iface.getName() : null;
                    JBossEnterpriseBeanMetaData beanMD = target.getBeanMetaData();
                    String containerJndiName = null;
                    if (beanMD.isSession() || beanMD.isService()) {
                        jndiNameResolver = JNDIPolicyBasedJNDINameResolverFactory.getJNDINameResolver((JBossSessionBeanMetaData)((JBossSessionBeanMetaData)beanMD), (DefaultJndiBindingPolicy)this.defaultJNDIBindingPolicy);
                        containerJndiName = jndiNameResolver.resolveJNDIName((JBossSessionBeanMetaData)beanMD, ifaceName);
                    } else if (beanMD.isEntity()) {
                        jndiNameResolver = JNDIPolicyBasedJNDINameResolverFactory.getJNDINameResolver((JBossEntityBeanMetaData)((JBossEntityBeanMetaData)beanMD), (DefaultJndiBindingPolicy)this.defaultJNDIBindingPolicy);
                        containerJndiName = jndiNameResolver.resolveJNDIName((JBossEntityBeanMetaData)beanMD, ifaceName);
                    }
                    if (containerJndiName == null) continue;
                    ref.setResolvedJndiName(containerJndiName);
                    continue;
                }
                unresolvedRefs.add(cdmd.getComponentID() + ":" + ref);
                continue;
            }
            unresolvedRefs.add(cdmd.getComponentID() + ":" + ref);
        }
    }

    protected void resolveEjbLocalRefs(ContainerDependencyMetaData cdmd, DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, EJBLocalReferencesMetaData localRefs, DeploymentEndpointResolver resolver, List<String> unresolvedRefs) throws Exception {
        if (localRefs == null) {
            return;
        }
        String vfsContext = unit.getRelativePath();
        ClassLoader loader = unit.getClassLoader();
        for (EJBLocalReferenceMetaData ref : localRefs) {
            if (ref.getIgnoreDependency() != null) {
                log.debug((Object)("IGNORING <ejb-ref> DEPENDENCY: " + ref));
                return;
            }
            String link = ref.getLink();
            String mappedName = ref.getMappedName();
            if (mappedName == null || mappedName.length() == 0) {
                JBossSessionBeanMetaData smd;
                String ejb2xLocalInterface;
                ContainerDependencyMetaData target = null;
                if (link != null) {
                    EndpointInfo info = resolver.getEndpointInfo(link, "ejb", vfsContext);
                    if (info != null) {
                        target = endpointMap.get(info.getComponentKey());
                    } else {
                        List<String> ejbPaths = this.getEjbDeploymentPaths(unit);
                        for (String path : ejbPaths) {
                            EndpointInfo altInfo = resolver.getEndpointInfo(link, "ejb", path);
                            if (altInfo != null) {
                                target = endpointMap.get(altInfo.getComponentKey());
                            }
                            if (target == null) continue;
                            break;
                        }
                    }
                }
                if (target == null && ref.getLocal() != null) {
                    target = this.resolveEjbInterface(ref.getLocal(), unit, endpointMap, resolver);
                }
                if (target == null) {
                    unresolvedRefs.add(cdmd.getComponentID() + ":" + ref);
                    continue;
                }
                String localInterface = ref.getLocal();
                JBossEnterpriseBeanMetaData md = target.getBeanMetaData();
                boolean useDefaultProxy = false;
                if (md.isSession() && localInterface.equals(ejb2xLocalInterface = (smd = (JBossSessionBeanMetaData)md).getLocal())) {
                    useDefaultProxy = true;
                }
                JBossMetaData ejbJarMd = md.getEnterpriseBeansMetaData().getEjbJarMetaData();
                String localJndiName = null;
                if (ejbJarMd.isEJB3x()) {
                    if (md.isSession() || md.isService()) {
                        SessionBeanJNDINameResolver sessionBeanJNDINameResolver = JNDIPolicyBasedJNDINameResolverFactory.getJNDINameResolver((JBossSessionBeanMetaData)((JBossSessionBeanMetaData)md), (DefaultJndiBindingPolicy)this.defaultJNDIBindingPolicy);
                        localJndiName = useDefaultProxy ? sessionBeanJNDINameResolver.resolveLocalBusinessDefaultJNDIName((JBossSessionBeanMetaData)md) : sessionBeanJNDINameResolver.resolveJNDIName((JBossSessionBeanMetaData)md, localInterface);
                    } else if (md.isEntity()) {
                        EntityBeanJNDINameResolver entityBeanJNDINameResolver = JNDIPolicyBasedJNDINameResolverFactory.getJNDINameResolver((JBossEntityBeanMetaData)((JBossEntityBeanMetaData)md), (DefaultJndiBindingPolicy)this.defaultJNDIBindingPolicy);
                        localJndiName = entityBeanJNDINameResolver.resolveJNDIName((JBossEntityBeanMetaData)md, localInterface);
                    }
                } else {
                    localJndiName = md.determineLocalJndiName();
                }
                if (localJndiName != null) {
                    ref.setResolvedJndiName(localJndiName);
                }
                cdmd.addDependency(target);
                continue;
            }
            ref.setResolvedJndiName(mappedName);
            JndiDependencyMetaData jdmd = new JndiDependencyMetaData(mappedName, loader);
            cdmd.addJndiDependency(jdmd);
        }
    }

    protected void resolveEjbRefs(ContainerDependencyMetaData cdmd, DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, EJBReferencesMetaData ejbRefs, DeploymentEndpointResolver resolver, List<String> unresolvedRefs) throws Exception {
        if (ejbRefs == null) {
            return;
        }
        String vfsContext = unit.getRelativePath();
        ClassLoader loader = unit.getClassLoader();
        for (EJBReferenceMetaData ref : ejbRefs) {
            if (ref.getIgnoreDependency() != null) {
                log.debug((Object)("IGNORING <ejb-ref> DEPENDENCY: " + ref));
                return;
            }
            String link = ref.getLink();
            String mappedName = ref.getMappedName();
            if (mappedName == null || mappedName.length() == 0) {
                JBossSessionBeanMetaData smd;
                String ejb2xRemoteInterface;
                ContainerDependencyMetaData target = null;
                if (link != null) {
                    EndpointInfo info = resolver.getEndpointInfo(link, "ejb", vfsContext);
                    if (info != null) {
                        target = endpointMap.get(info.getComponentKey());
                    } else {
                        List<String> ejbPaths = this.getEjbDeploymentPaths(unit);
                        for (String path : ejbPaths) {
                            EndpointInfo altInfo = resolver.getEndpointInfo(link, "ejb", path);
                            if (altInfo != null) {
                                target = endpointMap.get(altInfo.getComponentKey());
                            }
                            if (target == null) continue;
                            break;
                        }
                    }
                    if (target == null) {
                        unresolvedRefs.add(cdmd.getComponentID() + ":" + ref);
                        continue;
                    }
                }
                if (target == null && ref.getRemote() != null) {
                    target = this.resolveEjbInterface(ref.getRemote(), unit, endpointMap, resolver);
                }
                if (target == null) {
                    unresolvedRefs.add(cdmd.getComponentID() + ":" + ref);
                    continue;
                }
                String remoteInterface = ref.getRemote();
                JBossEnterpriseBeanMetaData md = target.getBeanMetaData();
                boolean useDefaultProxy = false;
                if (md.isSession() && remoteInterface.equals(ejb2xRemoteInterface = (smd = (JBossSessionBeanMetaData)md).getRemote())) {
                    useDefaultProxy = true;
                }
                JBossMetaData ejbMarMd = md.getEnterpriseBeansMetaData().getEjbJarMetaData();
                String remoteJNDIName = null;
                if (ejbMarMd.isEJB3x()) {
                    if (md.isSession() || md.isService()) {
                        SessionBeanJNDINameResolver sessionBeanJNDINameResolver = JNDIPolicyBasedJNDINameResolverFactory.getJNDINameResolver((JBossSessionBeanMetaData)((JBossSessionBeanMetaData)md), (DefaultJndiBindingPolicy)this.defaultJNDIBindingPolicy);
                        remoteJNDIName = useDefaultProxy ? sessionBeanJNDINameResolver.resolveRemoteBusinessDefaultJNDIName((JBossSessionBeanMetaData)md) : sessionBeanJNDINameResolver.resolveJNDIName((JBossSessionBeanMetaData)md, remoteInterface);
                    } else if (md.isEntity()) {
                        EntityBeanJNDINameResolver entityBeanJNDINameResolver = JNDIPolicyBasedJNDINameResolverFactory.getJNDINameResolver((JBossEntityBeanMetaData)((JBossEntityBeanMetaData)md), (DefaultJndiBindingPolicy)this.defaultJNDIBindingPolicy);
                        remoteJNDIName = entityBeanJNDINameResolver.resolveJNDIName((JBossEntityBeanMetaData)md, remoteInterface);
                    }
                } else {
                    remoteJNDIName = md.determineJndiName();
                }
                if (remoteJNDIName != null) {
                    ref.setResolvedJndiName(remoteJNDIName);
                }
                cdmd.addDependency(target);
                continue;
            }
            ref.setResolvedJndiName(mappedName);
            JndiDependencyMetaData jdmd = new JndiDependencyMetaData(mappedName, loader);
            cdmd.addJndiDependency(jdmd);
        }
    }

    protected String getInterface(EJBReferenceMetaData ref) {
        String iface = ref.getHome();
        if (iface == null) {
            iface = ref.getRemote();
        }
        return iface;
    }

    protected void resolveMsgRefs(ContainerDependencyMetaData cdmd, DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, MessageDestinationReferencesMetaData msgRefs, DeploymentEndpointResolver resolver, List<String> unresolvedRefs) {
        if (msgRefs == null) {
            return;
        }
        ClassLoader loader = unit.getClassLoader();
        String vfsContext = unit.getRelativePath();
        for (MessageDestinationReferenceMetaData ref : msgRefs) {
            String mappedName = ref.getMappedName();
            if (mappedName == null || mappedName.length() == 0) {
                EndpointInfo info;
                String link = ref.getLink();
                ContainerDependencyMetaData target = null;
                if (link != null && (info = resolver.getEndpointInfo(link, "message-destination", vfsContext)) != null) {
                    target = endpointMap.get(info.getComponentKey());
                }
                if (target == null) {
                    unresolvedRefs.add(cdmd.getComponentID() + ":" + ref);
                    continue;
                }
                cdmd.addDependency(target);
                String containerJndiName = target.getContainerName();
                if (containerJndiName == null) continue;
                ref.setResolvedJndiName(containerJndiName);
                continue;
            }
            ref.setResolvedJndiName(mappedName);
            JndiDependencyMetaData jdmd = new JndiDependencyMetaData(mappedName, loader);
            cdmd.addJndiDependency(jdmd);
        }
    }

    protected ContainerDependencyMetaData resolveEjbInterface(String iface, DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, DeploymentEndpointResolver resolver) throws Exception {
        String vfsContext;
        ClassLoader loader = unit.getClassLoader();
        Class<?> ifaceClass = loader.loadClass(iface);
        EndpointInfo info = resolver.getEndpointInfo(ifaceClass, "ejb", vfsContext = unit.getRelativePath());
        if (info == null) {
            throw new IllegalStateException("Failed to find ContainerDependencyMetaData for interface: " + iface);
        }
        ContainerDependencyMetaData cdmd = endpointMap.get(info.getComponentKey());
        return cdmd;
    }

    private List<String> getEjbDeploymentPaths(DeploymentUnit unit) {
        ArrayList<String> paths = new ArrayList<String>();
        DeploymentUnit root = unit.getTopLevel();
        this.getEjbDeploymentPaths(root, paths);
        return paths;
    }

    private void getEjbDeploymentPaths(DeploymentUnit unit, ArrayList<String> paths) {
        List children;
        if (unit.isAttachmentPresent(JBossMetaData.class)) {
            paths.add(unit.getRelativePath());
        }
        if ((children = unit.getChildren()) != null) {
            for (DeploymentUnit child : children) {
                this.getEjbDeploymentPaths(child, paths);
            }
        }
    }

    private static <T> void getAllAttachments(DeploymentUnit unit, Class<T> type, ArrayList<T> attachments) {
        List children;
        Object attachment = unit.getAttachment(type);
        if (attachment != null) {
            attachments.add(attachment);
        }
        if ((children = unit.getChildren()) != null) {
            for (DeploymentUnit child : children) {
                MappedReferenceMetaDataResolverDeployer.getAllAttachments(child, type, attachments);
            }
        }
    }

    private static EjbDeploymentSummary getEjbDeploymentSummary(DeploymentUnit unit, JBossEnterpriseBeanMetaData beanMD) {
        DeploymentSummary dSummary = MappedReferenceMetaDataResolverDeployer.getDeploymentSummary(unit);
        EjbDeploymentSummary summary = new EjbDeploymentSummary(beanMD, dSummary);
        return summary;
    }

    private static DeploymentSummary getDeploymentSummary(DeploymentUnit unit) {
        boolean isEar;
        DeploymentSummary dSummary = new DeploymentSummary();
        dSummary.setDeploymentName(unit.getSimpleName());
        String baseName = unit.getTopLevel().getSimpleName();
        int dot = baseName.lastIndexOf(46);
        if (dot > 0) {
            baseName = baseName.substring(0, dot);
        }
        dSummary.setDeploymentScopeBaseName(baseName);
        PackagingType packagingType = PackagingType.JAR;
        boolean bl = isEar = unit != unit.getTopLevel();
        if (isEar) {
            packagingType = PackagingType.EAR;
        }
        dSummary.setPackagingType(packagingType);
        return dSummary;
    }

    private void dump(DeploymentUnit unit) {
        DeploymentUnit top = unit.getTopLevel();
        StringBuffer tmp = new StringBuffer();
        this.dump(top, tmp, 0);
        log.debug((Object)("Processing unit=" + unit.getSimpleName() + ", structure:\n" + tmp));
    }

    private void dump(DeploymentUnit unit, StringBuffer tmp, int depth) {
        for (int n = 0; n < depth; ++n) {
            tmp.append('+');
        }
        if (depth == 0) {
            tmp.append(unit.getSimpleName());
        } else {
            tmp.append(unit.getRelativePath());
        }
        tmp.append('\n');
        JBossMetaData metaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        if (metaData != null) {
            JBossEnterpriseBeansMetaData beans = metaData.getEnterpriseBeans();
            if (beans != null) {
                for (JBossEnterpriseBeanMetaData bean : beans) {
                    for (int n = 0; n < depth + 1; ++n) {
                        tmp.append('+');
                    }
                    tmp.append("EjbEndpoint:ejbName=");
                    tmp.append(bean.getEjbName());
                    if (bean.getEjbClass() != null) {
                        tmp.append(",ejbClass=");
                        tmp.append(bean.getEjbClass());
                    }
                    if (bean instanceof JBossSessionBeanMetaData) {
                        BusinessRemotesMetaData remotes;
                        BusinessLocalsMetaData locals;
                        JBossSessionBeanMetaData sbean = (JBossSessionBeanMetaData)bean;
                        if (sbean.getHome() != null) {
                            tmp.append(",home=");
                            tmp.append(sbean.getHome());
                        }
                        if (sbean.getRemote() != null) {
                            tmp.append(",remote=");
                            tmp.append(sbean.getRemote());
                        }
                        if ((locals = sbean.getBusinessLocals()) != null) {
                            tmp.append(",BusinessLocals: ");
                            tmp.append(locals);
                        }
                        if ((remotes = sbean.getBusinessRemotes()) != null) {
                            tmp.append(",BusinessRemotes: ");
                            tmp.append(remotes);
                        }
                        this.dumpEnv(bean.getJndiEnvironmentRefsGroup(), tmp, depth + 1);
                    }
                    tmp.append('\n');
                }
            }
        } else if (unit.isAttachmentPresent(JBossWebMetaData.class)) {
            JBossWebMetaData webMD = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
            this.dumpEnv(webMD.getJndiEnvironmentRefsGroup(), tmp, depth++);
        } else if (unit.isAttachmentPresent(JBossClientMetaData.class)) {
            JBossClientMetaData clientMD = (JBossClientMetaData)unit.getAttachment(JBossClientMetaData.class);
            this.dumpEnv(clientMD.getJndiEnvironmentRefsGroup(), tmp, depth++);
        }
        tmp.append('\n');
        List children = unit.getChildren();
        if (children != null) {
            for (DeploymentUnit child : children) {
                this.dump(child, tmp, depth + 1);
            }
        }
    }

    private void dumpEnv(Environment env, StringBuffer tmp, int depth) {
        EJBReferencesMetaData ejbRefs;
        EJBLocalReferencesMetaData localRefs;
        if (env == null) {
            return;
        }
        AnnotatedEJBReferencesMetaData annotatedRefs = env.getAnnotatedEjbReferences();
        if (annotatedRefs != null) {
            for (AnnotatedEJBReferenceMetaData ref : annotatedRefs) {
                for (int n = 0; n < depth + 1; ++n) {
                    tmp.append('+');
                }
                tmp.append("@EJB(");
                tmp.append(ref.getEjbRefName());
                tmp.append(") -> mappedName=");
                tmp.append(ref.getMappedName());
                tmp.append("| resolvedJndiName=");
                tmp.append(ref.getResolvedJndiName());
                tmp.append('\n');
            }
        }
        if ((localRefs = env.getEjbLocalReferences()) != null) {
            for (EJBLocalReferenceMetaData ref : localRefs) {
                for (int n = 0; n < depth + 1; ++n) {
                    tmp.append('+');
                }
                tmp.append("ejb-local-ref(");
                tmp.append(ref.getEjbRefName());
                tmp.append(") -> mappedName=");
                tmp.append(ref.getMappedName());
                tmp.append("| resolvedJndiName=");
                tmp.append(ref.getResolvedJndiName());
                tmp.append('\n');
            }
        }
        if ((ejbRefs = env.getEjbReferences()) != null) {
            for (EJBReferenceMetaData ref : ejbRefs) {
                for (int n = 0; n < depth + 1; ++n) {
                    tmp.append('+');
                }
                tmp.append("ejb-ref(");
                tmp.append(ref.getEjbRefName());
                tmp.append(") -> mappedName=");
                tmp.append(ref.getMappedName());
                tmp.append("| resolvedJndiName=");
                tmp.append(ref.getResolvedJndiName());
                tmp.append('\n');
            }
        }
        MessageDestinationReferencesMetaData msgRefs = env.getMessageDestinationReferences();
    }

    private void displayEndpoints(String unitName, Map<String, ContainerDependencyMetaData> endpointMap) {
        StringBuilder tmp = new StringBuilder(unitName + " endpoint mappings:\n");
        for (Map.Entry<String, ContainerDependencyMetaData> entry : endpointMap.entrySet()) {
            tmp.append("  + " + entry.getKey() + " -> " + (Object)((Object)entry.getValue()));
            tmp.append('\n');
        }
        log.debug((Object)tmp.toString());
    }
}

