/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.BindException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.security.AccessController;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.jboss.logging.Logger;
import org.jboss.util.loading.ContextClassLoaderSwitcher;
import org.jboss.web.WebClassLoader;

public class WebServer
implements Runnable {
    private static Logger log = Logger.getLogger(WebServer.class);
    private int port = 8083;
    private InetAddress bindAddress;
    private int backlog = 50;
    private final ConcurrentReaderHashMap loaderMap = new ConcurrentReaderHashMap();
    private ServerSocket server = null;
    private boolean downloadServerClasses = true;
    private boolean downloadResources = false;
    private static final Properties mimeTypes = new Properties();
    private Executor executor;
    private final ContextClassLoaderSwitcher tclSwitcher;

    public WebServer() {
        ContextClassLoaderSwitcher clSwitcher;
        this.tclSwitcher = clSwitcher = (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setBindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        if (backlog <= 0) {
            backlog = 50;
        }
        this.backlog = backlog;
    }

    public boolean getDownloadServerClasses() {
        return this.downloadServerClasses;
    }

    public void setDownloadServerClasses(boolean flag) {
        this.downloadServerClasses = flag;
    }

    public boolean getDownloadResources() {
        return this.downloadResources;
    }

    public void setDownloadResources(boolean flag) {
        this.downloadResources = flag;
    }

    public Executor getThreadPool() {
        return this.executor;
    }

    public void setThreadPool(Executor executor) {
        this.executor = executor;
    }

    public void addMimeType(String extension, String type) {
        mimeTypes.put(extension, type);
    }

    public void start() throws Exception {
        if (this.executor == null) {
            throw new IllegalArgumentException("Required property 'executor' not specified");
        }
        try {
            this.server = new ServerSocket(this.port, this.backlog, this.bindAddress);
            log.debug((Object)("Started server: " + this.server));
            this.listen();
        }
        catch (BindException be) {
            throw new Exception("Port " + this.port + " already in use.", be);
        }
        catch (IOException e) {
            throw e;
        }
    }

    public void stop() {
        try {
            ServerSocket srv = this.server;
            this.server = null;
            srv.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public URL addClassLoader(ClassLoader cl) {
        String key = cl instanceof WebClassLoader ? ((WebClassLoader)((Object)cl)).getKey() : this.getClassLoaderKey(cl);
        this.loaderMap.put((Object)key, (Object)cl);
        URL loaderURL = null;
        String codebase = System.getProperty("java.rmi.server.codebase");
        if (codebase != null) {
            if (!codebase.endsWith("/")) {
                codebase = codebase + '/';
            }
            codebase = codebase + key;
            codebase = codebase + '/';
            try {
                loaderURL = new URL(codebase);
            }
            catch (MalformedURLException e) {
                log.error((Object)"invalid url", (Throwable)e);
            }
        }
        log.trace((Object)("Added ClassLoader: " + cl + " URL: " + loaderURL));
        return loaderURL;
    }

    public void removeClassLoader(ClassLoader cl) {
        String key = this.getClassLoaderKey(cl);
        this.loaderMap.remove((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.server == null) {
            return;
        }
        socket = null;
        try {
            socket = this.server.accept();
        }
        catch (IOException e) {
            if (this.server == null) return;
            WebServer.log.error((Object)"Failed to accept connection", (Throwable)e);
            return;
        }
        this.listen();
        try {
            try {
                out = new DataOutputStream(socket.getOutputStream());
                try {
                    block37: {
                        httpCode = "200 OK";
                        in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        rawPath = this.getPath(in);
                        endOfKey = rawPath.indexOf(93);
                        filePath = rawPath.substring(endOfKey + 2);
                        loaderKey = rawPath.substring(0, endOfKey + 1);
                        WebServer.log.trace((Object)("loaderKey = " + loaderKey));
                        WebServer.log.trace((Object)("filePath = " + filePath));
                        loader = (ClassLoader)this.loaderMap.get((Object)loaderKey);
                        if (loader == null && rawPath.indexOf(91) < 0 && this.downloadServerClasses) {
                            filePath = rawPath;
                            WebServer.log.trace((Object)("No loader, reset filePath = " + filePath));
                            loader = Thread.currentThread().getContextClassLoader();
                        }
                        WebServer.log.trace((Object)("loader = " + loader));
                        bytes = new byte[]{};
                        tclSwitchContext = null;
                        try {
                            tclSwitchContext = this.tclSwitcher.getSwitchContext(this.getClass().getClassLoader());
                            if (loader != null && filePath.endsWith(".class")) {
                                className = filePath.substring(0, filePath.length() - 6).replace('/', '.');
                                WebServer.log.trace((Object)("loading className = " + className));
                                clazz = loader.loadClass(className);
                                clazzUrl = clazz.getProtectionDomain().getCodeSource().getLocation();
                                WebServer.log.trace((Object)("clazzUrl = " + clazzUrl));
                                if (clazzUrl == null) {
                                    bytes = ((WebClassLoader)clazz.getClassLoader()).getBytes(clazz);
                                    if (bytes == null) {
                                        throw new Exception("Class not found: " + className);
                                    }
                                } else {
                                    if (!clazzUrl.getFile().endsWith("/")) {
                                        clazzUrl = new URL("jar:" + clazzUrl + "!/" + filePath);
                                    } else if (clazzUrl.getFile().indexOf("/org_jboss_aop_proxy$") < 0) {
                                        clazzUrl = new URL(clazzUrl, filePath);
                                    }
                                    WebServer.log.trace((Object)("new clazzUrl: " + clazzUrl));
                                    bytes = this.getBytes(clazzUrl);
                                }
                            } else if (loader != null && filePath.length() > 0 && this.downloadServerClasses && this.downloadResources) {
                                WebServer.log.trace((Object)("loading resource = " + filePath));
                                resourceURL = loader.getResource(filePath);
                                if (resourceURL == null) {
                                    httpCode = "404 Resource not found:" + filePath;
                                } else {
                                    WebServer.log.trace((Object)("resourceURL = " + resourceURL));
                                    bytes = this.getBytes(resourceURL);
                                }
                            } else {
                                httpCode = "404 Not Found";
                            }
                            var16_21 = null;
                            if (tclSwitchContext == null) break block37;
                        }
                        catch (Throwable var15_23) {
                            var16_22 = null;
                            if (tclSwitchContext == null) throw var15_23;
                            tclSwitchContext.reset();
                            throw var15_23;
                        }
                        tclSwitchContext.reset();
                    }
                    try {
                        WebServer.log.trace((Object)("HTTP code=" + httpCode + ", Content-Length: " + bytes.length));
                        out.writeBytes("HTTP/1.0 " + httpCode + "\r\n");
                        out.writeBytes("Content-Length: " + bytes.length + "\r\n");
                        out.writeBytes("Content-Type: " + this.getMimeType(filePath));
                        out.writeBytes("\r\n\r\n");
                        out.write(bytes);
                        out.flush();
                        ** GOTO lbl110
                    }
                    catch (IOException ie) {
                        var18_24 = null;
                        var20_28 = null;
                        try {
                            socket.close();
                            return;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        return;
                    }
                }
                catch (Throwable e) {
                    block39: {
                        try {
                            WebServer.log.trace((Object)("HTTP code=404, " + e.getMessage()));
                            out.writeBytes("HTTP/1.0 404 Not Found\r\n");
                            out.writeBytes("Content-Type: text/html\r\n\r\n");
                            out.flush();
                        }
                        catch (IOException ex) {
                        }
                        break block39;
                        catch (Throwable var17_36) {
                            var18_27 = null;
                            throw var17_36;
                        }
lbl110:
                        // 1 sources

                        var18_25 = null;
                    }
                    var18_26 = null;
                }
                var20_29 = null;
            }
            catch (IOException ex) {
                WebServer.log.error((Object)"error writting response", (Throwable)ex);
                var20_30 = null;
                try {}
                catch (IOException e) {
                    return;
                }
                socket.close();
                return;
            }
        }
        catch (Throwable var19_37) {
            var20_31 = null;
            ** try [egrp 8[TRYBLOCK] [16 : 992->999)] { 
lbl129:
            // 1 sources

            socket.close();
            throw var19_37;
lbl131:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            throw var19_37;
        }
        try {}
        catch (IOException e) {}
        socket.close();
        return;
    }

    protected String getClassLoaderKey(ClassLoader cl) {
        String className = cl.getClass().getName();
        int dot = className.lastIndexOf(46);
        if (dot >= 0) {
            className = className.substring(dot + 1);
        }
        String key = className + '[' + cl.hashCode() + ']';
        return key;
    }

    protected void listen() {
        this.executor.execute(this);
    }

    protected String getPath(BufferedReader in) throws IOException {
        String line = in.readLine();
        log.trace((Object)("raw request=" + line));
        int start = line.indexOf(32) + 1;
        int end = line.indexOf(32, start + 1);
        String filePath = line.substring(start + 1, end);
        return filePath;
    }

    protected byte[] getBytes(URL url) throws IOException {
        int bytes;
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        log.debug((Object)("Retrieving " + url));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] tmp = new byte[1024];
        while ((bytes = ((InputStream)in).read(tmp)) != -1) {
            out.write(tmp, 0, bytes);
        }
        ((InputStream)in).close();
        return out.toByteArray();
    }

    protected String getMimeType(String path) {
        String suffix;
        String mimeType;
        int dot = path.lastIndexOf(".");
        String type = "text/html";
        if (dot >= 0 && (mimeType = mimeTypes.getProperty(suffix = path.substring(dot + 1))) != null) {
            type = mimeType;
        }
        return type;
    }
}

