/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.security.Principal;
import javax.ejb.EJBContext;
import javax.naming.InitialContext;
import org.jboss.ejb.Container;
import org.jboss.ejb.EJBProxyFactoryContainer;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.invocation.Invocation;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SecurityProxy;
import org.jboss.security.SecurityProxyFactory;

public class SecurityProxyInterceptor
extends AbstractInterceptor {
    public final String SECURITY_PROXY_FACTORY_NAME = "java:/SecurityProxyFactory";
    protected Logger log = Logger.getLogger(this.getClass());
    protected AuthenticationManager securityManager;
    protected SecurityProxy securityProxy;

    public void setContainer(Container container) {
        super.setContainer(container);
        if (container != null) {
            this.securityManager = container.getSecurityManager();
            Object secProxy = container.getSecurityProxy();
            if (secProxy != null) {
                if (!(secProxy instanceof SecurityProxy)) {
                    try {
                        InitialContext iniCtx = new InitialContext();
                        SecurityProxyFactory proxyFactory = (SecurityProxyFactory)iniCtx.lookup("java:/SecurityProxyFactory");
                        this.securityProxy = proxyFactory.create(secProxy);
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Failed to initialze DefaultSecurityProxy", (Throwable)e);
                    }
                } else {
                    this.securityProxy = (SecurityProxy)secProxy;
                }
                try {
                    EJBProxyFactoryContainer ic = (EJBProxyFactoryContainer)((Object)container);
                    Class beanHome = ic.getHomeClass();
                    Class beanRemote = ic.getRemoteClass();
                    Class beanLocalHome = ic.getLocalHomeClass();
                    Class beanLocal = ic.getLocalClass();
                    if (beanLocal == null) {
                        this.securityProxy.init(beanHome, beanRemote, (Object)this.securityManager);
                    } else {
                        this.securityProxy.init(beanHome, beanRemote, beanLocalHome, beanLocal, (Object)this.securityManager);
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)"Failed to initialze SecurityProxy", (Throwable)e);
                }
                this.log.info((Object)("Initialized SecurityProxy=" + this.securityProxy));
            }
        }
    }

    public void start() throws Exception {
        super.start();
    }

    public Object invokeHome(Invocation mi) throws Exception {
        if (this.securityProxy != null) {
            EJBContext ctx = null;
            EnterpriseContext ectx = (EnterpriseContext)mi.getEnterpriseContext();
            if (ectx != null) {
                ctx = ectx.getEJBContext();
            }
            Object[] args = mi.getArguments();
            this.securityProxy.setEJBContext(ctx);
            try {
                this.securityProxy.invokeHome(mi.getMethod(), args);
            }
            catch (SecurityException e) {
                Principal principal = mi.getPrincipal();
                String msg = "SecurityProxy.invokeHome exception, principal=" + principal;
                this.log.error((Object)msg, (Throwable)e);
                throw e;
            }
        }
        return this.getNext().invokeHome(mi);
    }

    public Object invoke(Invocation mi) throws Exception {
        if (this.securityProxy != null) {
            EnterpriseContext ectx = (EnterpriseContext)mi.getEnterpriseContext();
            Object bean = ectx.getInstance();
            EJBContext ctx = ectx.getEJBContext();
            Object[] args = mi.getArguments();
            this.securityProxy.setEJBContext(ctx);
            try {
                this.securityProxy.invoke(mi.getMethod(), args, bean);
            }
            catch (SecurityException e) {
                Principal principal = mi.getPrincipal();
                String msg = "SecurityProxy.invoke exception, principal=" + principal;
                this.log.error((Object)msg, (Throwable)e);
                throw e;
            }
        }
        return this.getNext().invoke(mi);
    }
}

