/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.keygenerator.hilo;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.keygenerator.KeyGenerator;
import org.jboss.ejb.plugins.keygenerator.KeyGeneratorFactory;
import org.jboss.ejb.plugins.keygenerator.hilo.HiLoKeyGenerator;
import org.jboss.ejb.plugins.keygenerator.hilo.HiLoKeyGeneratorFactoryMBean;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.naming.Util;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.TransactionManagerLocator;

public class HiLoKeyGeneratorFactory
extends ServiceMBeanSupport
implements KeyGeneratorFactory,
HiLoKeyGeneratorFactoryMBean,
Serializable {
    private ObjectName dataSource;
    private transient DataSource ds;
    private transient TransactionManager tm;
    private String jndiName;
    private String tableName;
    private String sequenceColumn;
    private String sequenceName;
    private String idColumnName;
    private String createTableDdl;
    private String selectHiSql;
    private long blockSize;
    private boolean createTable = true;
    private boolean dropTable;

    public void setFactoryName(String factoryName) {
        this.jndiName = factoryName;
    }

    public String getFactoryName() {
        return this.jndiName;
    }

    public void setDataSource(ObjectName dataSource) throws Exception {
        if (this.getState() == 3 && !dataSource.equals(this.dataSource)) {
            this.ds = this.lookupDataSource(dataSource);
        }
        this.dataSource = dataSource;
    }

    public ObjectName getDataSource() {
        return this.dataSource;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) throws Exception {
        if (this.getState() == 3 && !tableName.equals(this.tableName)) {
            this.initSequence(tableName, this.sequenceColumn, this.sequenceName, this.idColumnName);
        }
        this.tableName = tableName;
    }

    public String getSequenceColumn() {
        return this.sequenceColumn;
    }

    public void setSequenceColumn(String sequenceColumn) {
        this.sequenceColumn = sequenceColumn;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public String getIdColumnName() {
        return this.idColumnName;
    }

    public void setIdColumnName(String idColumnName) {
        this.idColumnName = idColumnName;
    }

    public String getCreateTableDdl() {
        return this.createTableDdl;
    }

    public void setCreateTableDdl(String createTableDdl) {
        this.createTableDdl = createTableDdl;
    }

    public String getSelectHiSql() {
        return this.selectHiSql;
    }

    public void setSelectHiSql(String selectHiSql) {
        this.selectHiSql = selectHiSql;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public boolean isCreateTable() {
        return this.createTable;
    }

    public void setCreateTable(boolean createTable) {
        this.createTable = createTable;
    }

    public boolean isDropTable() {
        return this.dropTable;
    }

    public void setDropTable(boolean dropTable) {
        this.dropTable = dropTable;
    }

    public KeyGenerator getKeyGenerator() throws Exception {
        return new HiLoKeyGenerator(this.ds, this.tableName, this.sequenceColumn, this.sequenceName, this.idColumnName, this.selectHiSql, this.blockSize, this.tm);
    }

    public void startService() throws Exception {
        InitialContext ctx = new InitialContext();
        Util.rebind((Context)ctx, (String)this.getFactoryName(), (Object)this);
        this.tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
        this.ds = this.lookupDataSource(this.dataSource);
        this.initSequence(this.tableName, this.sequenceColumn, this.sequenceName, this.idColumnName);
    }

    public void stopService() throws Exception {
        if (this.dropTable) {
            this.dropTableIfExists(this.tableName);
        }
        this.ds = null;
        this.tm = null;
        InitialContext ctx = new InitialContext();
        Util.unbind((Context)ctx, (String)this.getFactoryName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSequence(String tableName, String sequenceColumn, String sequenceName, String idColumnName) throws SQLException, DeploymentException {
        if (this.createTable) {
            this.createTableIfNotExists(tableName);
        }
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            block7: {
                String sql = "select " + idColumnName + " from " + tableName + " where " + sequenceColumn + "='" + sequenceName + "'";
                this.log.debug((Object)("Executing SQL: " + sql));
                con = this.ds.getConnection();
                st = con.createStatement();
                rs = st.executeQuery(sql);
                if (!rs.next()) {
                    sql = "insert into " + tableName + "(" + sequenceColumn + ", " + idColumnName + ") values ('" + sequenceName + "', 0)";
                    this.log.debug((Object)("Executing SQL: " + sql));
                    Statement insertSt = con.createStatement();
                    try {
                        int i = insertSt.executeUpdate(sql);
                        if (i != 1) {
                            throw new SQLException("Expected one updated row but got: " + i);
                        }
                        Object var12_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        JDBCUtil.safeClose(insertSt);
                        throw throwable;
                    }
                    JDBCUtil.safeClose(insertSt);
                    {
                        break block7;
                    }
                }
                HiLoKeyGenerator.setHighestHi(rs.getLong(1));
            }
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableIfNotExists(String tableName) throws SQLException, DeploymentException {
        Connection con = null;
        Statement st = null;
        try {
            if (!SQLUtil.tableExists(tableName, this.ds)) {
                this.log.debug((Object)("Executing DDL: " + this.createTableDdl));
                con = this.ds.getConnection();
                st = con.createStatement();
                st.executeUpdate(this.createTableDdl);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTableIfExists(String tableName) throws SQLException, DeploymentException {
        Connection con = null;
        Statement st = null;
        try {
            if (SQLUtil.tableExists(tableName, this.ds)) {
                String ddl = "drop table " + tableName;
                this.log.debug((Object)("Executing DDL: " + ddl));
                con = this.ds.getConnection();
                st = con.createStatement();
                st.executeUpdate(ddl);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
    }

    private DataSource lookupDataSource(ObjectName dataSource) throws Exception {
        try {
            String dsJndi = (String)this.server.getAttribute(dataSource, "BindName");
            return (DataSource)new InitialContext().lookup(dsJndi);
        }
        catch (NamingException e) {
            throw new Exception("Failed to lookup data source: " + dataSource);
        }
    }

    private Object readResolve() throws ObjectStreamException {
        this.server = MBeanServerLocator.locateJBoss();
        this.tm = TransactionManagerLocator.getInstance().locate();
        try {
            this.ds = this.lookupDataSource(this.dataSource);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to lookup the DataSource " + this.dataSource, e);
        }
        return this;
    }
}

