/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.util.Enumeration;
import org.jboss.bootstrap.api.as.config.JBossASBasedServerConfig;
import org.jboss.bootstrap.api.as.server.JBossASBasedServer;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingProviderURLWriter {
    public static final String DEFAULT_PERSIST_FILE_NAME = "jnp-service.url";
    private static final Logger log = Logger.getLogger(NamingProviderURLWriter.class);
    private String bootstrapUrl;
    private String bindAddress;
    private int port;
    private JBossASBasedServer<?, ?> server;
    private URI outputDir;
    private String filename = "jnp-service.url";
    private File outputFile;

    public URI getOutputDirURI() {
        return this.outputDir;
    }

    public void setOutputDirURL(URI dir) {
        this.outputDir = dir;
    }

    public String getOutputFileName() {
        return this.filename == null ? DEFAULT_PERSIST_FILE_NAME : this.filename;
    }

    public void setOutputFileName(String name) {
        this.filename = name;
    }

    public void setServer(JBossASBasedServer<?, ?> server) {
        this.server = server;
    }

    public String getBootstrapURL() {
        return this.bootstrapUrl;
    }

    public void setBootstrapURL(String url) {
        this.bootstrapUrl = url;
    }

    public String getBootstrapAddress() {
        return this.bindAddress;
    }

    public void setBootstrapAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public int getBootstrapPort() {
        return this.port;
    }

    public void setBootstrapPort(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        this.establishBootStrapURL();
        if (this.bootstrapUrl != null) {
            File base = null;
            if (this.outputDir == null) {
                if (this.server != null) {
                    base = new File(((JBossASBasedServerConfig)this.server.getConfiguration()).getServerDataLocation().toURI());
                    this.outputDir = base.toURI();
                }
            } else {
                base = new File(this.outputDir);
            }
            if (base != null) {
                base.mkdirs();
                this.outputFile = new File(base, this.getOutputFileName());
                if (this.outputFile.exists()) {
                    this.outputFile.delete();
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Creating file " + this.outputFile));
                }
                this.outputFile.createNewFile();
                PrintWriter writer = new PrintWriter(this.outputFile);
                try {
                    writer.println(this.bootstrapUrl);
                    writer.flush();
                }
                finally {
                    this.outputFile.deleteOnExit();
                    writer.close();
                }
                this.outputFile.deleteOnExit();
            } else {
                log.warn((Object)("No directory specified for " + this.getOutputFileName() + " cannot write the naming service url. Please configure either " + "the 'server' property or the 'outputDir' property."));
            }
        } else {
            log.debug((Object)"No URLs to write");
        }
    }

    public void stop() throws Exception {
        if (this.outputFile != null) {
            this.outputFile.delete();
        }
    }

    protected void establishBootStrapURL() throws IOException {
        if (this.getBootstrapURL() == null && this.getBootstrapAddress() != null) {
            InetAddress addr = InetAddress.getByName(this.getBootstrapAddress());
            if (addr.isAnyLocalAddress() && (addr = NamingProviderURLWriter.findLoopbackAddress()) == null) {
                addr = InetAddress.getLocalHost();
            }
            StringBuilder sb = new StringBuilder("jnp://");
            if (addr instanceof Inet6Address) {
                sb.append('[');
                sb.append(addr.getHostAddress());
                sb.append(']');
            } else {
                sb.append(addr.getHostAddress());
            }
            sb.append(':');
            sb.append(this.getBootstrapPort());
            this.setBootstrapURL(sb.toString());
        }
    }

    private static InetAddress findLoopbackAddress() throws SocketException {
        Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
        while (ifaces.hasMoreElements()) {
            NetworkInterface iface = ifaces.nextElement();
            Enumeration<InetAddress> addrs = iface.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (!addr.isLoopbackAddress()) continue;
                return addr;
            }
        }
        return null;
    }
}

