/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.deployers;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractTopLevelClassLoaderDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.DeploymentUnitVisitor;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.helpers.ClassPathVisitor;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.system.ServiceController;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.virtual.VirtualFile;

public class ServiceClassLoaderDeployer
extends AbstractTopLevelClassLoaderDeployer {
    private final ServiceController controller;

    public ServiceClassLoaderDeployer(ServiceController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("Null controller");
        }
        this.controller = controller;
    }

    public ClassLoader createTopLevelClassLoader(DeploymentUnit unit) throws Exception {
        LoaderRepositoryFactory.LoaderRepositoryConfig loaderConfig;
        MBeanServer server = this.controller.getMBeanServer();
        VirtualFile root = null;
        URL url = null;
        if (unit instanceof VFSDeploymentUnit) {
            VFSDeploymentUnit vfsUnit = (VFSDeploymentUnit)unit;
            root = vfsUnit.getRoot();
            try {
                if (root != null) {
                    url = this.trimJARURL(root.toURL());
                }
            }
            catch (Exception ignored) {
                this.log.debug((Object)("Unable to get URL for " + unit.getName() + " reason=" + ignored));
            }
        }
        if ((loaderConfig = (LoaderRepositoryFactory.LoaderRepositoryConfig)unit.getAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class)) != null) {
            this.log.debug((Object)("Using loader repository config: " + loaderConfig.repositoryName));
        }
        if (loaderConfig == null) {
            loaderConfig = new LoaderRepositoryFactory.LoaderRepositoryConfig();
            unit.addAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class, (Object)loaderConfig);
            this.log.trace((Object)("Using default loader repository config: " + loaderConfig.repositoryName));
        }
        LoaderRepositoryFactory.createLoaderRepository((MBeanServer)server, (LoaderRepositoryFactory.LoaderRepositoryConfig)loaderConfig);
        Object[] args = new Object[]{url, url, Boolean.TRUE};
        String[] sig = new String[]{"java.net.URL", "java.net.URL", "boolean"};
        RepositoryClassLoader ucl = (RepositoryClassLoader)server.invoke(loaderConfig.repositoryName, "newClassLoader", args, sig);
        try {
            ClassPathVisitor visitor = new ClassPathVisitor(unit);
            unit.visit((DeploymentUnitVisitor)visitor);
            Set classpath = visitor.getClassPath();
            for (VirtualFile path : classpath) {
                if (path == root) continue;
                ucl.addURL(this.trimJARURL(path.toURL()));
            }
            ObjectName uclName = ucl.getObjectName();
            if (!server.isRegistered(uclName)) {
                server.registerMBean(ucl, uclName);
            }
        }
        catch (Throwable t) {
            this.internalRemoveClassLoader(unit, ucl);
            throw DeploymentException.rethrowAsDeploymentException((String)("Error creating classloader: " + unit.getName()), (Throwable)t);
        }
        return ucl;
    }

    public void removeTopLevelClassLoader(DeploymentUnit unit) {
        RepositoryClassLoader ucl = (RepositoryClassLoader)unit.getClassLoader();
        if (ucl == null) {
            return;
        }
        this.internalRemoveClassLoader(unit, ucl);
    }

    private void internalRemoveClassLoader(DeploymentUnit unit, RepositoryClassLoader ucl) {
        MBeanServer server = this.controller.getMBeanServer();
        try {
            ObjectName uclName = ucl.getObjectName();
            if (server.isRegistered(uclName)) {
                server.unregisterMBean(uclName);
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error unregistering classloader mbean: " + ucl + " for " + unit.getName()), t);
        }
        try {
            ucl.unregister();
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error unregistering ucl: " + ucl + " for " + unit.getName()), t);
        }
        try {
            LoaderRepositoryFactory.LoaderRepositoryConfig config;
            ServiceDeployment deployment = (ServiceDeployment)unit.getAttachment(ServiceDeployment.class);
            if (deployment != null && (config = (LoaderRepositoryFactory.LoaderRepositoryConfig)unit.getAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class)) != null) {
                LoaderRepositoryFactory.destroyLoaderRepository((MBeanServer)server, (ObjectName)config.repositoryName);
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error removing classloader from repository: " + ucl + " for " + unit.getName()), t);
        }
    }

    private URL trimJARURL(URL url) throws MalformedURLException {
        String temp = url.toString();
        if (temp.startsWith("jar:") && temp.endsWith("!/")) {
            temp = temp.substring(4, temp.length() - 2);
            return new URL(temp);
        }
        return url;
    }
}

