/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.jmx;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jboss.bootstrap.spi.ServerConfig;
import org.jboss.bootstrap.spi.ServerProcess;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.vfs.policy.VFSClassLoaderPolicy;
import org.jboss.kernel.Kernel;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceController;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.server.ServerConfigImpl;
import org.jboss.system.server.ServerConfigImplMBean;
import org.jboss.system.server.ServerImplMBean;
import org.jboss.system.server.ServerInfoMBean;
import org.jboss.system.server.jmx.JMXKernelMBean;
import org.jboss.system.server.jmx.LazyMBeanServer;
import org.jboss.util.JBossObject;
import org.jboss.util.file.FileSuffixFilter;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXKernel
extends JBossObject
implements JMXKernelMBean,
NotificationEmitter {
    private static final ObjectName DEFAULT_LOADER_NAME = ObjectNameFactory.create((String)"JMImplementation:service=LoaderRepository,name=Default");
    private MBeanServer mbeanServer;
    private ServerProcess serverImpl;
    private ServiceController controller;
    private ServerConfig serverConfig;
    private ServerConfigImplMBean serverConfigMBean;
    private ServerInfoMBean serverInfo;
    private Kernel kernel;
    private NotificationEmitter notificationEmitter;
    private ObjectName bootstrapUCLName;
    private boolean started;
    private boolean oldClassLoader;

    public ServerProcess getServerImpl() {
        return this.serverImpl;
    }

    public void setServerImpl(ServerProcess serverImpl) {
        this.serverImpl = serverImpl;
        this.notificationEmitter = (NotificationEmitter)serverImpl;
    }

    public ServiceControllerMBean getServiceController() {
        return this.controller;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public ServerInfoMBean getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(ServerInfoMBean serverInfo) {
        this.serverInfo = serverInfo;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public boolean isOldClassLoader() {
        return this.oldClassLoader;
    }

    public void setOldClassLoader(boolean oldClassLoader) {
        this.oldClassLoader = oldClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        ClassLoader cl;
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        String builder = System.getProperty("javax.management.builder.initial", "org.jboss.mx.server.MBeanServerBuilderImpl");
        System.setProperty("javax.management.builder.initial", builder);
        this.serverConfig = this.serverImpl.getConfig();
        this.serverConfigMBean = new ServerConfigImpl(this.serverConfig);
        if (this.serverConfig.getPlatformMBeanServer()) {
            cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = cl.loadClass("java.lang.management.ManagementFactory");
            Class<?>[] sig = null;
            Method method = clazz.getMethod("getPlatformMBeanServer", sig);
            Object[] args = null;
            this.mbeanServer = (MBeanServer)method.invoke(null, args);
            MBeanServerLocator.setJBoss((MBeanServer)this.mbeanServer);
            this.mbeanServer = LazyMBeanServer.resetToJBossServer(this.mbeanServer);
        } else {
            this.mbeanServer = MBeanServerFactory.createMBeanServer("jboss");
        }
        this.log.debug((Object)("Created MBeanServer: " + this.mbeanServer));
        this.mbeanServer.registerMBean(this, ServerImplMBean.OBJECT_NAME);
        this.mbeanServer.registerMBean(this.serverConfigMBean, ServerConfigImplMBean.OBJECT_NAME);
        cl = this.oldClassLoader ? this.initBootLibrariesOld() : this.initBootLibraries();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            this.mbeanServer.registerMBean(this.serverInfo, new ObjectName("jboss.system:type=ServerInfo"));
            this.controller = new ServiceController();
            this.controller.setKernel(this.kernel);
            this.controller.setMBeanServer(this.mbeanServer);
            this.mbeanServer.registerMBean(this.controller, new ObjectName("jboss.system:service=ServiceController"));
            this.log.info((Object)"Legacy JMX core initialized");
            this.started = true;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcl);
        }
    }

    public void stop() throws IllegalStateException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"stop caller:", new Throwable("Here"));
        }
        if (!this.started) {
            throw new IllegalStateException("Server not started");
        }
        this.log.debug((Object)"Shutting down all services");
        this.shutdownServices();
        this.removeMBeans();
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.notificationEmitter.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notificationEmitter.removeNotificationListener(listener);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.notificationEmitter.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.notificationEmitter.getNotificationInfo();
    }

    public void init(Properties props) throws Exception {
        this.serverImpl.init(props);
    }

    public void exit() {
        this.serverImpl.exit();
    }

    public void exit(int exitcode) {
        this.serverImpl.exit(exitcode);
    }

    public ServerConfig getConfig() {
        return this.serverConfig;
    }

    public String getBuildDate() {
        return this.serverImpl.getBuildDate();
    }

    public String getBuildID() {
        return this.serverImpl.getBuildID();
    }

    public String getBuildJVM() {
        return this.serverImpl.getBuildJVM();
    }

    public String getBuildNumber() {
        return this.serverImpl.getBuildNumber();
    }

    public String getBuildOS() {
        return this.serverImpl.getBuildOS();
    }

    public Date getStartDate() {
        return this.serverImpl.getStartDate();
    }

    public String getVersion() {
        return this.serverImpl.getVersion();
    }

    public String getVersionName() {
        return this.serverImpl.getVersionName();
    }

    public String getVersionNumber() {
        return this.serverImpl.getVersionNumber();
    }

    public void halt() {
        this.serverImpl.halt();
    }

    public void halt(int exitcode) {
        this.serverImpl.halt(exitcode);
    }

    public boolean isInShutdown() {
        return this.serverImpl.isInShutdown();
    }

    public boolean isStarted() {
        return this.serverImpl.isStarted();
    }

    @Override
    public void runFinalization() {
    }

    @Override
    public void runGarbageCollector() {
    }

    @Override
    public void traceInstructions(Boolean flag) {
    }

    @Override
    public void traceMethodCalls(Boolean flag) {
    }

    public void shutdown() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Shutdown caller:", new Throwable("Here"));
        }
        this.serverImpl.shutdown();
    }

    protected void shutdownServices() {
        try {
            this.controller.shutdown();
        }
        catch (Exception e) {
            Throwable t = JMXExceptionDecoder.decode((Throwable)e);
            this.log.error((Object)"Failed to shutdown services", t);
        }
    }

    protected void removeMBeans() {
        Throwable t;
        try {
            this.mbeanServer.unregisterMBean(ServerConfigImplMBean.OBJECT_NAME);
        }
        catch (Exception e) {
            t = JMXExceptionDecoder.decode((Throwable)e);
            this.log.error((Object)"Failed to unregister mbeans", t);
        }
        try {
            this.mbeanServer.unregisterMBean(ServerImplMBean.OBJECT_NAME);
        }
        catch (Exception e) {
            t = JMXExceptionDecoder.decode((Throwable)e);
            this.log.error((Object)"Failed to unregister mbeans", t);
        }
        try {
            MBeanServer registeredServer = this.mbeanServer;
            if (this.serverConfig.getPlatformMBeanServer()) {
                registeredServer = LazyMBeanServer.getRegisteredMBeanServer(this.mbeanServer);
            }
            MBeanServerFactory.releaseMBeanServer(registeredServer);
        }
        catch (Exception e) {
            t = JMXExceptionDecoder.decode((Throwable)e);
            this.log.error((Object)"Failed to release mbean mbeanServer", t);
        }
    }

    private List<URL> getBootURLs() throws Exception {
        ArrayList<URL> list = new ArrayList<URL>();
        URL patchURL = this.serverConfig.getPatchURL();
        if (patchURL != null) {
            if (patchURL.getProtocol().equals("file")) {
                File dir = new File(patchURL.getFile());
                if (dir.exists()) {
                    list.add(dir.toURL());
                    File[] jars = dir.listFiles((FileFilter)new FileSuffixFilter(new String[]{".jar", ".zip"}, true));
                    for (int j = 0; jars != null && j < jars.length; ++j) {
                        list.add(jars[j].getCanonicalFile().toURL());
                    }
                }
            } else {
                list.add(patchURL);
            }
        }
        list.add(this.serverConfig.getServerConfigURL());
        this.log.debug((Object)("Boot url list: " + list));
        return list;
    }

    private ClassLoader initBootLibrariesOld() throws Exception {
        List<URL> list = this.getBootURLs();
        RepositoryClassLoader loader = null;
        for (URL url : list) {
            this.log.debug((Object)("Creating loader for URL: " + url));
            Object[] args = new Object[]{url, Boolean.TRUE};
            String[] sig = new String[]{"java.net.URL", "boolean"};
            loader = (RepositoryClassLoader)this.mbeanServer.invoke(DEFAULT_LOADER_NAME, "newClassLoader", args, sig);
        }
        this.bootstrapUCLName = loader.getObjectName();
        this.mbeanServer.registerMBean(loader, this.bootstrapUCLName);
        return loader;
    }

    private ClassLoader initBootLibraries() throws Exception {
        ClassLoaderSystem system = ClassLoaderSystem.getInstance();
        this.mbeanServer.registerMBean(system, new ObjectName("jboss.classloader:service=ClassLoaderSystem"));
        List<URL> list = this.getBootURLs();
        VirtualFile[] files = new VirtualFile[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            URL url = list.get(i);
            files[i] = VFS.getRoot((URL)url);
        }
        VFSClassLoaderPolicy policy = new VFSClassLoaderPolicy(files);
        policy.setExportAll(ExportAll.NON_EMPTY);
        policy.setImportAll(true);
        ClassLoader classLoader = system.registerClassLoaderPolicy((ClassLoaderPolicy)policy);
        if (classLoader instanceof RealClassLoader) {
            this.bootstrapUCLName = ((RealClassLoader)classLoader).getObjectName();
        }
        return classLoader;
    }

    private ObjectName createMBean(String classname, String name) throws Exception {
        ObjectName mbeanName = null;
        if (name != null) {
            mbeanName = new ObjectName(name);
        }
        try {
            URL xmbeanDD = new URL("resource:xmdesc/" + classname + "-xmbean.xml");
            Object resource = this.mbeanServer.instantiate(classname);
            Object[] args = new Object[]{resource, xmbeanDD};
            String[] sig = new String[]{Object.class.getName(), URL.class.getName()};
            ObjectInstance instance = this.mbeanServer.createMBean("org.jboss.mx.modelmbean.XMBean", mbeanName, this.bootstrapUCLName, args, sig);
            mbeanName = instance.getObjectName();
            this.log.debug((Object)("Created system XMBean: " + mbeanName));
        }
        catch (Exception e) {
            this.log.debug((Object)("Failed to create xmbean for: " + classname));
            mbeanName = this.mbeanServer.createMBean(classname, mbeanName).getObjectName();
            this.log.debug((Object)("Created system MBean: " + mbeanName));
        }
        return mbeanName;
    }
}

