/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.bootstrap.api.as.config.JBossASServerConfig;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.DeploymentState;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.main.MainDeployerInternals;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.deployment.Deployer;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.file.Files;
import org.jboss.util.file.JarUtils;
import org.jboss.util.stream.Streams;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class MainDeployer
extends ServiceMBeanSupport
implements Deployer,
MainDeployerMBean {
    private KernelController controller;
    private DeployerClient delegate;
    private Map<URL, String> contextMap = Collections.synchronizedMap(new HashMap());
    private VFSDeploymentFactory deploymentFactory = VFSDeploymentFactory.getInstance();
    private ObjectName serviceController;
    private boolean copyFiles = true;
    private File tempDir;
    private String tempDirString;

    public MainDeployer() {
        String localCopy = System.getProperty("jboss.deploy.localcopy");
        if (localCopy != null && (localCopy.equalsIgnoreCase("false") || localCopy.equalsIgnoreCase("no") || localCopy.equalsIgnoreCase("off"))) {
            this.log.debug((Object)"Disabling local copies of file: urls");
            this.copyFiles = false;
        }
    }

    public DeployerClient getKernelMainDeployer() {
        return this.delegate;
    }

    public void setKernelMainDeployer(DeployerClient delegate) {
        this.delegate = delegate;
    }

    public KernelController getController() {
        return this.controller;
    }

    public void setController(KernelController controller) {
        this.controller = controller;
    }

    public boolean getCopyFiles() {
        return this.copyFiles;
    }

    public void setCopyFiles(boolean copyFiles) {
        this.copyFiles = copyFiles;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    public String getTempDirString() {
        return this.tempDirString;
    }

    public void setServiceController(ObjectName serviceController) {
        this.serviceController = serviceController;
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? OBJECT_NAME : name;
    }

    protected void createService() throws Exception {
        JBossASServerConfig config = ServerConfigLocator.locate();
        File basedir = new File(config.getServerTempLocation().toURI());
        this.tempDir = new File(basedir, "deploy");
        Files.delete((File)this.tempDir);
        this.tempDir.mkdirs();
        this.tempDirString = this.tempDir.toURL().toString();
    }

    public void shutdown() {
        this.tempDir = null;
    }

    public void redeploy(String urlspec) throws DeploymentException, MalformedURLException {
        this.redeploy(new URL(urlspec));
    }

    public void redeploy(URL url) throws DeploymentException {
        String deploymentName = this.contextMap.get(url);
        if (deploymentName != null) {
            try {
                Deployment deployment = this.delegate.getDeployment(deploymentName);
                this.delegate.addDeployment(deployment);
                this.delegate.process();
                this.delegate.checkComplete(new Deployment[]{deployment});
            }
            catch (org.jboss.deployers.spi.DeploymentException e) {
                throw new DeploymentException(e);
            }
        } else {
            this.deploy(url);
        }
    }

    public void undeploy(String urlspec) throws DeploymentException, MalformedURLException {
        this.undeploy(new URL(urlspec));
    }

    public void undeploy(URL url) throws DeploymentException {
        String deploymentName = this.contextMap.remove(url);
        if (deploymentName != null) {
            try {
                this.delegate.removeDeployment(deploymentName);
                this.delegate.process();
            }
            catch (Exception e) {
                DeploymentException ex = new DeploymentException("Error during undeploy of: " + url, e);
                throw ex;
            }
        } else {
            this.log.warn((Object)("undeploy '" + url + "' : package not deployed"));
        }
    }

    public void deploy(String urlspec) throws DeploymentException, MalformedURLException {
        URL url;
        if (this.server == null) {
            throw new DeploymentException("The MainDeployer has been unregistered");
        }
        try {
            url = new URL(urlspec);
        }
        catch (MalformedURLException e) {
            File file = new File(urlspec);
            url = file.toURL();
        }
        this.deploy(url);
    }

    public void deploy(URL url) throws DeploymentException {
        this.log.info((Object)("deploy, url=" + url));
        String deploymentName = this.contextMap.get(url);
        if (deploymentName == null) {
            try {
                VirtualFile file = VFS.getChild((URL)url);
                VFSDeployment deployment = this.deploymentFactory.createVFSDeployment(file);
                this.delegate.addDeployment((Deployment)deployment);
                deploymentName = deployment.getName();
                this.delegate.process();
                this.contextMap.put(url, deploymentName);
                this.delegate.checkComplete(new Deployment[]{deployment});
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to deploy: " + url), (Throwable)e);
                DeploymentException ex = new DeploymentException("Failed to deploy: " + url, e);
                throw ex;
            }
        }
    }

    protected void copy(URL src, File dest) throws IOException {
        File srcFile;
        boolean deleted;
        boolean created;
        this.log.debug((Object)("Copying " + src + " -> " + dest));
        File dir = dest.getParentFile();
        if (!dir.exists() && !(created = dir.mkdirs())) {
            throw new IOException("mkdirs failed for: " + dir.getAbsolutePath());
        }
        if (dest.exists() && !(deleted = Files.delete((File)dest))) {
            throw new IOException("delete of previous content failed for: " + dest.getAbsolutePath());
        }
        if (src.getProtocol().equals("file") && (srcFile = new File(src.getFile())).isDirectory()) {
            this.log.debug((Object)("Making zip copy of: " + srcFile));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
            JarUtils.jar((OutputStream)out, (File[])srcFile.listFiles());
            ((OutputStream)out).close();
            return;
        }
        BufferedInputStream in = new BufferedInputStream(src.openStream());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        Streams.copy((InputStream)in, (OutputStream)out);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        ((InputStream)in).close();
    }

    public boolean isDeployed(String url) throws MalformedURLException {
        return this.isDeployed(new URL(url));
    }

    public boolean isDeployed(URL url) {
        String name = this.contextMap.get(url);
        if (name == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("No such context: " + url));
            }
            if (url == null) {
                throw new IllegalArgumentException("Null url");
            }
            String urlString = url.toString();
            if (!urlString.startsWith("vfs")) {
                return this.checkDeployed("vfs" + urlString);
            }
            return this.checkDeployed(urlString);
        }
        return this.checkDeployed(name);
    }

    protected boolean checkDeployed(String name) {
        DeploymentState deploymentState = this.delegate.getDeploymentState(name);
        this.log.debug((Object)("isDeployed, url=" + name + ", state=" + deploymentState));
        return deploymentState == DeploymentState.DEPLOYED;
    }

    public Deployment getDeployment(URL url) {
        String name = this.contextMap.get(url);
        if (name == null) {
            return null;
        }
        Deployment dc = this.delegate.getDeployment(name);
        this.log.debug((Object)("getDeployment, url=" + url + ", dc=" + dc));
        return dc;
    }

    @Deprecated
    public DeploymentContext getDeploymentContext(URL url) {
        String name = this.contextMap.get(url);
        if (name == null) {
            return null;
        }
        MainDeployerInternals structure = (MainDeployerInternals)this.delegate;
        DeploymentContext dc = structure.getDeploymentContext(name);
        this.log.debug((Object)("getDeploymentContext, url=" + url + ", dc=" + dc));
        return dc;
    }

    public DeploymentUnit getDeploymentUnit(URL url) {
        String name = this.contextMap.get(url);
        if (name == null) {
            return null;
        }
        DeploymentContext context = this.getDeploymentContext(url);
        DeploymentUnit du = context.getDeploymentUnit();
        this.log.debug((Object)("getDeploymentUnit, url=" + url + ", du=" + du));
        return du;
    }

    public URL getWatchUrl(URL url) {
        return url;
    }

    public void checkIncompleteDeployments() throws DeploymentException {
        try {
            this.delegate.checkComplete();
        }
        catch (Exception e) {
            throw new DeploymentException("Deployments are incomplete", e);
        }
    }

    public void deploy(Deployment deployment) throws org.jboss.deployers.spi.DeploymentException {
        this.delegate.deploy(new Deployment[]{deployment});
    }

    public void undeploy(Deployment deployment) throws org.jboss.deployers.spi.DeploymentException {
        this.delegate.undeploy(new Deployment[]{deployment});
    }
}

