/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.scanner;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.bootstrap.api.as.config.JBossASServerConfig;
import org.jboss.deployment.DefaultDeploymentSorter;
import org.jboss.deployment.IncompleteDeploymentException;
import org.jboss.deployment.scanner.AbstractDeploymentScanner;
import org.jboss.deployment.scanner.DeploymentScanner;
import org.jboss.deployment.scanner.URLDeploymentScannerMBean;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.net.protocol.URLLister;
import org.jboss.net.protocol.URLListerFactory;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.NullArgumentException;
import org.jboss.util.StringPropertyReplacer;

public class URLDeploymentScanner
extends AbstractDeploymentScanner
implements DeploymentScanner,
URLDeploymentScannerMBean {
    protected Set skipSet = Collections.synchronizedSet(new HashSet());
    protected List urlList = Collections.synchronizedList(new ArrayList());
    protected Set deployedSet = Collections.synchronizedSet(new HashSet());
    protected URLListerFactory listerFactory = new URLListerFactory();
    protected File serverHome;
    protected URL serverHomeURL;
    protected Comparator sorter;
    protected URLLister.URLFilter filter;
    protected IncompleteDeploymentException lastIncompleteDeploymentException;
    protected boolean doRecursiveSearch = true;

    public void setRecursiveSearch(boolean recurse) {
        this.doRecursiveSearch = recurse;
    }

    public boolean getRecursiveSearch() {
        return this.doRecursiveSearch;
    }

    public void setURLList(List list) {
        if (list == null) {
            throw new NullArgumentException("list");
        }
        this.urlList.clear();
        for (URL url : list) {
            if (url == null) {
                throw new NullArgumentException("list element");
            }
            this.addURL(url);
        }
        this.log.debug((Object)("URL list: " + this.urlList));
    }

    public void setURLComparator(String classname) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.sorter = (Comparator)Thread.currentThread().getContextClassLoader().loadClass(classname).newInstance();
    }

    public String getURLComparator() {
        if (this.sorter == null) {
            return null;
        }
        return this.sorter.getClass().getName();
    }

    public void setFilter(String classname) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> filterClass = Thread.currentThread().getContextClassLoader().loadClass(classname);
        this.filter = (URLLister.URLFilter)filterClass.newInstance();
    }

    public String getFilter() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getClass().getName();
    }

    public void setFilterInstance(URLLister.URLFilter filter) {
        this.filter = filter;
    }

    public URLLister.URLFilter getFilterInstance() {
        return this.filter;
    }

    public List getURLList() {
        return new ArrayList(this.urlList);
    }

    public void addURL(URL url) {
        if (url == null) {
            throw new NullArgumentException("url");
        }
        try {
            url.openConnection().connect();
        }
        catch (IOException e) {
            this.log.warn((Object)("addURL(), caught " + e.getClass().getName() + ": " + e.getMessage()));
        }
        this.urlList.add(url);
        this.log.debug((Object)("Added url: " + url));
    }

    public void removeURL(URL url) {
        if (url == null) {
            throw new NullArgumentException("url");
        }
        boolean success = this.urlList.remove(url);
        if (success) {
            this.log.debug((Object)("Removed url: " + url));
        }
    }

    public boolean hasURL(URL url) {
        if (url == null) {
            throw new NullArgumentException("url");
        }
        return this.urlList.contains(url);
    }

    public void suspendDeployment(URL url) {
        if (url == null) {
            throw new NullArgumentException("url");
        }
        if (!this.skipSet.add(url)) {
            throw new IllegalStateException("Deployment URL already suspended: " + url);
        }
        this.log.debug((Object)("Deployment URL added to skipSet: " + url));
    }

    public void resumeDeployment(URL url, boolean markUpToDate) {
        if (url == null) {
            throw new NullArgumentException("url");
        }
        if (this.skipSet.contains(url)) {
            if (markUpToDate) {
                for (DeployedURL deployedURL : this.deployedSet) {
                    if (!deployedURL.url.equals(url)) continue;
                    this.log.debug((Object)("Marking up-to-date: " + url));
                    deployedURL.deployed();
                    break;
                }
            }
        } else {
            throw new IllegalStateException("Deployment URL not suspended: " + url);
        }
        this.skipSet.remove(url);
        this.log.debug((Object)("Deployment URL removed from skipSet: " + url));
    }

    public String listDeployedURLs() {
        StringBuffer sbuf = new StringBuffer();
        Iterator i = this.deployedSet.iterator();
        while (i.hasNext()) {
            URL url = ((DeployedURL)i.next()).url;
            if (sbuf.length() > 0) {
                sbuf.append("\n").append(url);
                continue;
            }
            sbuf.append(url);
        }
        return sbuf.toString();
    }

    public void setURLs(String listspec) throws MalformedURLException {
        if (listspec == null) {
            throw new NullArgumentException("listspec");
        }
        LinkedList<URL> list = new LinkedList<URL>();
        StringTokenizer stok = new StringTokenizer(listspec, ",");
        while (stok.hasMoreTokens()) {
            String urlspec = stok.nextToken().trim();
            this.log.debug((Object)("Adding URL from spec: " + urlspec));
            URL url = this.makeURL(urlspec);
            this.log.debug((Object)("URL: " + url));
            list.add(url);
        }
        this.setURLList(list);
    }

    protected URL makeURL(String urlspec) throws MalformedURLException {
        urlspec = StringPropertyReplacer.replaceProperties((String)urlspec);
        return new URL(this.serverHomeURL, urlspec);
    }

    public void addURL(String urlspec) throws MalformedURLException {
        this.addURL(this.makeURL(urlspec));
    }

    public void removeURL(String urlspec) throws MalformedURLException {
        this.removeURL(this.makeURL(urlspec));
    }

    public boolean hasURL(String urlspec) throws MalformedURLException {
        return this.hasURL(this.makeURL(urlspec));
    }

    protected void deploy(DeployedURL du) {
        if (this.deployer == null) {
            return;
        }
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Deploying: " + du));
            }
            this.deployer.deploy(du.url);
        }
        catch (IncompleteDeploymentException e) {
            this.lastIncompleteDeploymentException = e;
        }
        catch (Exception e) {
            this.log.debug((Object)("Failed to deploy: " + du), (Throwable)e);
        }
        du.deployed();
        if (!this.deployedSet.contains(du)) {
            this.deployedSet.add(du);
        }
    }

    protected void undeploy(DeployedURL du) {
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Undeploying: " + du));
            }
            this.deployer.undeploy(du.url);
            this.deployedSet.remove(du);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to undeploy: " + du), (Throwable)e);
        }
    }

    protected boolean isDeployed(URL url) {
        DeployedURL du = new DeployedURL(url);
        return this.deployedSet.contains(du);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scan() throws Exception {
        int i;
        Object url2;
        this.lastIncompleteDeploymentException = null;
        if (this.urlList == null) {
            throw new IllegalStateException("not initialized");
        }
        this.updateSorter();
        boolean trace = this.log.isTraceEnabled();
        LinkedList<URL> urlsToDeploy = new LinkedList<URL>();
        if (trace) {
            this.log.trace((Object)"Scanning for new deployments");
        }
        List list = this.urlList;
        synchronized (list) {
            for (Object url2 : this.urlList) {
                try {
                    if (((URL)url2).toString().endsWith("/")) {
                        URLLister lister = this.listerFactory.createURLLister((URL)url2);
                        urlsToDeploy.addAll(lister.listMembers((URL)url2, this.filter, this.doRecursiveSearch));
                        continue;
                    }
                    ((URL)url2).openConnection().connect();
                    urlsToDeploy.add((URL)url2);
                }
                catch (IOException e) {
                    this.log.warn((Object)("Scan URL, caught " + e.getClass().getName() + ": " + e.getMessage()));
                    return;
                }
            }
        }
        if (trace) {
            this.log.trace((Object)"Updating existing deployments");
        }
        LinkedList<DeployedURL> urlsToRemove = new LinkedList<DeployedURL>();
        LinkedList<DeployedURL> urlsToCheckForUpdate = new LinkedList<DeployedURL>();
        url2 = this.deployedSet;
        synchronized (url2) {
            for (DeployedURL deployedURL : this.deployedSet) {
                if (this.skipSet.contains(deployedURL.url)) {
                    if (!trace) continue;
                    this.log.trace((Object)("Skipping update/removal check for: " + deployedURL.url));
                    continue;
                }
                if (urlsToDeploy.contains(deployedURL.url)) {
                    urlsToCheckForUpdate.add(deployedURL);
                    continue;
                }
                urlsToRemove.add(deployedURL);
            }
        }
        for (DeployedURL deployedURL : urlsToRemove) {
            if (trace) {
                this.log.trace((Object)("Removing " + deployedURL.url));
            }
            this.undeploy(deployedURL);
        }
        ArrayList<DeployedURL> urlsToUpdate = new ArrayList<DeployedURL>(urlsToCheckForUpdate.size());
        for (DeployedURL deployedURL : urlsToCheckForUpdate) {
            if (!deployedURL.isModified()) continue;
            if (trace) {
                this.log.trace((Object)("Re-deploying " + deployedURL.url));
            }
            urlsToUpdate.add(deployedURL);
        }
        Collections.sort(urlsToUpdate, new Comparator(){

            public int compare(Object o1, Object o2) {
                return URLDeploymentScanner.this.sorter.compare(((DeployedURL)o1).url, ((DeployedURL)o2).url);
            }
        });
        for (i = urlsToUpdate.size() - 1; i >= 0; --i) {
            this.undeploy((DeployedURL)urlsToUpdate.get(i));
        }
        for (i = 0; i < urlsToUpdate.size(); ++i) {
            this.deploy((DeployedURL)urlsToUpdate.get(i));
        }
        Collections.sort(urlsToDeploy, this.sorter);
        Iterator i2 = urlsToDeploy.iterator();
        while (i2.hasNext()) {
            URL url3 = (URL)i2.next();
            DeployedURL deployedURL = new DeployedURL(url3);
            if (!this.deployedSet.contains(deployedURL)) {
                if (this.skipSet.contains(url3)) {
                    if (trace) {
                        this.log.trace((Object)("Skipping deployment of: " + url3));
                    }
                } else {
                    if (trace) {
                        this.log.trace((Object)("Deploying " + deployedURL.url));
                    }
                    this.deploy(deployedURL);
                }
            }
            i2.remove();
            if (!i2.hasNext() || !this.updateSorter()) continue;
            Collections.sort(urlsToDeploy, this.sorter);
            i2 = urlsToDeploy.iterator();
        }
        if (this.lastIncompleteDeploymentException != null) {
            try {
                Object[] args = new Object[]{};
                String[] sig = new String[]{};
                this.getServer().invoke(this.getDeployer(), "checkIncompleteDeployments", args, sig);
            }
            catch (Exception e) {
                Throwable t = JMXExceptionDecoder.decode((Throwable)e);
                this.log.error((Object)t);
            }
        }
    }

    protected boolean updateSorter() {
        DefaultDeploymentSorter defaultSorter;
        if (this.sorter instanceof DefaultDeploymentSorter && (defaultSorter = (DefaultDeploymentSorter)((Object)this.sorter)).getSuffixOrder() != this.mainDeployer.getSuffixOrder()) {
            defaultSorter.setSuffixOrder(this.mainDeployer.getSuffixOrder());
            return true;
        }
        return false;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        JBossASServerConfig serverConfig = ServerConfigLocator.locate();
        this.serverHomeURL = serverConfig.getServerHomeLocation();
        this.serverHome = new File(this.serverHomeURL.toURI());
        return super.preRegister(server, name);
    }

    protected void createService() throws Exception {
        if (this.filter == null) {
            throw new IllegalStateException("'FilterInstance' attribute not configured");
        }
        if (this.sorter == null) {
            throw new IllegalStateException("'URLComparator' attribute not configured");
        }
        super.createService();
    }

    protected class DeployedURL {
        public URL url;
        public URL watchUrl;
        public long deployedLastModified;

        public DeployedURL(URL url) {
            this.url = url;
        }

        public void deployed() {
            this.deployedLastModified = this.getLastModified();
        }

        public boolean isFile() {
            return this.url.getProtocol().equals("file");
        }

        public File getFile() {
            return new File(this.url.getFile());
        }

        public boolean isRemoved() {
            if (this.isFile()) {
                File file = this.getFile();
                return !file.exists();
            }
            return false;
        }

        public long getLastModified() {
            if (this.watchUrl == null) {
                try {
                    Object o = URLDeploymentScanner.this.getServer().invoke(URLDeploymentScanner.this.getDeployer(), "getWatchUrl", new Object[]{this.url}, new String[]{URL.class.getName()});
                    this.watchUrl = o == null ? this.url : (URL)o;
                    URLDeploymentScanner.this.getLog().debug((Object)("Watch URL for: " + this.url + " -> " + this.watchUrl));
                }
                catch (Exception e) {
                    this.watchUrl = this.url;
                    URLDeploymentScanner.this.getLog().debug((Object)("Unable to obtain watchUrl from deployer. Use url: " + this.url), (Throwable)e);
                }
            }
            try {
                URLConnection connection = this.watchUrl != null ? this.watchUrl.openConnection() : this.url.openConnection();
                long lastModified = connection.getLastModified();
                return lastModified;
            }
            catch (IOException e) {
                URLDeploymentScanner.this.log.warn((Object)("Failed to check modification of deployed url: " + this.url), (Throwable)e);
                return -1L;
            }
        }

        public boolean isModified() {
            long lastModified = this.getLastModified();
            if (lastModified == -1L) {
                return false;
            }
            return this.deployedLastModified != lastModified;
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof DeployedURL) {
                return ((DeployedURL)other).url.equals(this.url);
            }
            return false;
        }

        public String toString() {
            return super.toString() + "{ url=" + this.url + ", deployedLastModified=" + this.deployedLastModified + " }";
        }
    }
}

