/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.bootstrap.spi.Bootstrap;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.IncompleteDeploymentException;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.plugins.main.MainDeployerImpl;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.system.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileServiceBootstrap
implements Bootstrap {
    private static final Logger log = Logger.getLogger(ProfileServiceBootstrap.class);
    protected String profileName = "default";
    protected MainDeployer mainDeployer;
    protected ProfileService profileService;
    protected Kernel kernel;
    private AtomicBoolean shutdown = new AtomicBoolean(false);

    public MainDeployer getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(MainDeployer mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public ProfileService getProfileService() {
        return this.profileService;
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public void start(Server server) throws Exception {
        this.shutdown.set(false);
        if (this.profileService == null) {
            throw new IllegalStateException("The ProfileService has not been injected");
        }
        log.debug((Object)("Using ProfileService: " + this.profileService));
        if (this.profileService == null) {
            throw new IllegalStateException("The MainDeployer has not been injected");
        }
        log.debug((Object)("Using MainDeployer: " + this.mainDeployer));
        this.mainDeployer.checkComplete();
        try {
            this.loadProfile(this.profileName);
        }
        catch (IncompleteDeploymentException e) {
            log.error((Object)("Failed to load profile: " + e.getMessage()));
        }
        catch (Exception e) {
            log.error((Object)"Failed to load profile: ", (Throwable)e);
        }
        Profile profile = this.profileService.getActiveProfile();
        if (profile != null) {
            profile.enableModifiedDeploymentChecks(true);
        }
    }

    public void prepareShutdown(Server server) {
        this.shutdown.set(true);
        if (this.mainDeployer != null) {
            this.mainDeployer.prepareShutdown();
        }
    }

    public void shutdown(Server server) {
        this.unloadProfile(this.profileName);
        try {
            this.mainDeployer.shutdown();
        }
        catch (Throwable t) {
            log.warn((Object)"Error shutting down the main deployer", t);
        }
    }

    protected <T> T getBean(KernelController controller, Object name, Class<T> expectedType) {
        ControllerContext context = controller.getInstalledContext(name);
        if (context == null) {
            throw new IllegalStateException("Context not installed: " + name);
        }
        Object result = context.getTarget();
        if (result == null) {
            throw new IllegalStateException("No target for " + name);
        }
        if (!expectedType.isInstance(result)) {
            throw new IllegalStateException(name + " expected " + expectedType.getName() + " was " + result.getClass().getName());
        }
        return expectedType.cast(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProfile(String name) throws Exception {
        DeploymentContext ctx;
        MainDeployer deployer = this.getMainDeployer();
        if (deployer == null) {
            throw new NullPointerException("MainDeployer has not been set");
        }
        ProfileService ps = this.getProfileService();
        if (ps == null) {
            throw new NullPointerException("ProfileService has not been set");
        }
        ProfileKey key = new ProfileKey(name);
        Profile profile = ps.getProfile(key);
        VFSDeployment first = null;
        Collection<VFSDeployment> boostraps = profile.getDeployments(ManagedDeployment.DeploymentPhase.BOOTSTRAP);
        for (VFSDeployment d : boostraps) {
            deployer.addDeployment((Deployment)d);
            if (first != null) continue;
            first = d;
        }
        deployer.process();
        deployer.checkComplete();
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        MainDeployerImpl hack = (MainDeployerImpl)deployer;
        ClassLoader cl = null;
        if (first != null && (ctx = hack.getDeploymentContext(first.getName())) != null) {
            cl = ctx.getClassLoader();
        }
        try {
            Collection<VFSDeployment> profileDeployers = profile.getDeployments(ManagedDeployment.DeploymentPhase.DEPLOYER);
            for (VFSDeployment d : profileDeployers) {
                deployer.addDeployment((Deployment)d);
            }
            deployer.process();
            deployer.checkComplete();
            Collection<VFSDeployment> profileDeployments = profile.getDeployments(ManagedDeployment.DeploymentPhase.APPLICATION);
            for (VFSDeployment d : profileDeployments) {
                deployer.addDeployment((Deployment)d);
            }
            deployer.process();
            deployer.checkComplete();
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unloadProfile(String name) {
        MainDeployer deployer = this.getMainDeployer();
        if (deployer == null) {
            log.warn((Object)"MainDeployer has not been set");
            return;
        }
        ProfileService ps = this.getProfileService();
        if (ps == null) {
            log.warn((Object)"ProfileService has not been set");
            return;
        }
        try {
            ProfileKey key = new ProfileKey(name);
            Profile profile = ps.getProfile(key);
            VFSDeployment first = null;
            Collection<VFSDeployment> boostraps = profile.getDeployments(ManagedDeployment.DeploymentPhase.BOOTSTRAP);
            for (VFSDeployment d : boostraps) {
                if (first != null) continue;
                first = d;
                break;
            }
            Thread thread = Thread.currentThread();
            ClassLoader old = thread.getContextClassLoader();
            MainDeployerImpl hack = (MainDeployerImpl)deployer;
            ClassLoader cl = null;
            if (first != null) {
                try {
                    DeploymentContext ctx = hack.getDeploymentContext(first.getName());
                    if (ctx != null) {
                        cl = ctx.getClassLoader();
                    }
                }
                catch (Exception e) {
                    log.debug((Object)"Unable to get first deployment", (Throwable)e);
                }
            }
            try {
                this.unload(deployer, profile.getDeployments(ManagedDeployment.DeploymentPhase.APPLICATION));
                this.unload(deployer, profile.getDeployments(ManagedDeployment.DeploymentPhase.DEPLOYER));
                this.unload(deployer, profile.getDeployments(ManagedDeployment.DeploymentPhase.BOOTSTRAP));
            }
            finally {
                thread.setContextClassLoader(old);
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Error unloading profile", t);
        }
    }

    protected void unload(MainDeployer deployer, Collection<VFSDeployment> deployments) {
        if (deployments == null || deployments.isEmpty()) {
            return;
        }
        for (VFSDeployment d : deployments) {
            try {
                deployer.removeDeployment((Deployment)d);
            }
            catch (Exception e) {
                log.warn((Object)("Unable to remove deployment: " + d));
            }
        }
        deployer.process();
    }
}

