/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.system.server.profileservice.repository.AbstractFileAttachmentsSerializer;
import org.jboss.system.server.profileservice.repository.TCLObjectInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSerializationAttachmentsSerializer
extends AbstractFileAttachmentsSerializer {
    private static final Logger log = Logger.getLogger(JavaSerializationAttachmentsSerializer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Object> loadAttachments(File attachmentsStore, ClassLoader loader) throws Exception {
        log.debug((Object)("loadAttachments, attachmentsStore=" + attachmentsStore));
        Thread.currentThread().setContextClassLoader(loader);
        FileInputStream fis = new FileInputStream(attachmentsStore);
        TCLObjectInputStream ois = new TCLObjectInputStream(fis, loader);
        Map map = null;
        try {
            map = (Map)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            URL[] path = JavaSerializationAttachmentsSerializer.getClassLoaderURLs(loader);
            log.debug((Object)("ClassNotFoundException: " + e.getMessage() + ", path: " + Arrays.asList(path)));
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception igore) {}
            try {
                fis.close();
            }
            catch (Exception igore) {}
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveAttachments(File attachmentsStore, Map<String, Object> map, ClassLoader loader) throws Exception {
        log.debug((Object)("saveAttachments, attachmentsStore=" + attachmentsStore));
        if (log.isTraceEnabled()) {
            log.trace((Object)("Attachments.size: " + map.size()));
            for (String key : map.keySet()) {
                log.trace((Object)(key + ", " + map.get(key)));
            }
        }
        FileOutputStream fos = new FileOutputStream(attachmentsStore);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        try {
            oos.writeObject(map);
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception igore) {}
            try {
                fos.close();
            }
            catch (Exception igore) {}
        }
    }

    private static URL[] getClassLoaderURLs(ClassLoader cl) {
        Object[] args;
        Method getURLs;
        Class<?> clClass;
        Class[] parameterTypes;
        Class<?> returnType;
        URL[] urls = new URL[]{};
        try {
            returnType = urls.getClass();
            parameterTypes = new Class[]{};
            clClass = cl.getClass();
            getURLs = clClass.getMethod("getURLs", parameterTypes);
            if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                args = new Object[]{};
                urls = (URL[])getURLs.invoke((Object)cl, args);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (urls == null || urls.length == 0) {
            try {
                returnType = urls.getClass();
                parameterTypes = new Class[]{};
                clClass = cl.getClass();
                getURLs = clClass.getMethod("getAllURLs", parameterTypes);
                if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                    args = new Object[]{};
                    urls = (URL[])getURLs.invoke((Object)cl, args);
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (urls == null || urls.length == 0) {
            try {
                returnType = urls.getClass();
                parameterTypes = new Class[]{};
                clClass = cl.getClass();
                getURLs = clClass.getMethod("getClasspath", parameterTypes);
                if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                    args = new Object[]{};
                    urls = (URL[])getURLs.invoke((Object)cl, args);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return urls;
    }
}

