/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.server.profileservice.repository;

import java.net.URI;
import java.util.Collections;
import java.util.Map;

import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.profileservice.spi.repository.Capability;
import org.jboss.profileservice.spi.repository.Repository;
import org.jboss.profileservice.spi.repository.Requirement;
import org.jboss.profileservice.spi.repository.Resource;
import org.jboss.profileservice.spi.repository.Version;

/**
 * A Resource implementation for a VFSDeployment attachments.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 65457 $
 */
public class AttachmentsResource implements Resource
{
   private String vfsPath;
   private Repository repository;
   private String[] categories = {};
   private Capability[] capabilities = {};
   private Map<String, Object> props;

   public AttachmentsResource(String vfsPath, Attachments edits, Repository repository)
   {
      this.vfsPath = vfsPath;
      this.repository = repository;
      this.props = Collections.singletonMap("attachments", (Object)edits);
   }

   public Capability[] getCapabilities()
   {
      return capabilities;
   }

   public String[] getCategories()
   {
      return categories;
   }

   public String getId()
   {
      return vfsPath;
   }

   public String getPresentationName()
   {
      return vfsPath;
   }

   public Map getProperties()
   {
      return props;
   }

   public Repository getRepository()
   {
      return repository;
   }

   public Requirement[] getRequirements()
   {
      // TODO Auto-generated method stub
      return null;
   }

   public String getSymbolicName()
   {
      return vfsPath;
   }

   public URI getURI()
   {
      URI repoURI = repository.getURI();
      URI uri = null;
      try
      {
         // TODO: this probably does not work
         uri = repoURI.resolve(vfsPath);
      }
      catch(Exception e)
      {
         throw new IllegalStateException(e);
      }
      return uri;
   }

   public Version getVersion()
   {
      // TODO Auto-generated method stub
      return null;
   }  
}
