/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import org.jboss.logging.Logger;
import org.jboss.profileservice.spi.AttachmentsSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileAttachmentsSerializer
implements AttachmentsSerializer {
    private static final Logger log = Logger.getLogger(AbstractFileAttachmentsSerializer.class);
    private static final String ATTACHMENT_SUFFIX = ".attachment";
    private File attachmentsStoreDir;

    public File getAttachmentsStoreDir() {
        return this.attachmentsStoreDir;
    }

    public void setAttachmentsStoreDir(File attachmentsStoreDir) {
        this.attachmentsStoreDir = attachmentsStoreDir;
    }

    public <T> T loadAttachment(String baseName, Class<T> expected) throws Exception {
        if (this.attachmentsStoreDir == null) {
            throw new IllegalStateException("attachmentsStoreDir has not been set");
        }
        File attachmentsStore = this.getAttachmentPath(baseName);
        if (!attachmentsStore.exists()) {
            return null;
        }
        return this.loadAttachment(attachmentsStore, expected);
    }

    public void saveAttachment(String baseName, Object attachment) throws Exception {
        if (this.attachmentsStoreDir == null) {
            throw new IllegalStateException("attachmentsStoreDir has not been set");
        }
        File attachmentsStore = this.getAttachmentPath(baseName);
        File attachmentsParent = attachmentsStore.getParentFile();
        if (!attachmentsParent.exists() && !attachmentsParent.mkdirs()) {
            throw new IOException("Failed to create attachmentsParent: " + attachmentsParent.getAbsolutePath());
        }
        if (attachment != null) {
            try {
                this.saveAttachment(attachmentsStore, attachment);
            }
            catch (NotSerializableException e) {
                StringBuilder tmp = new StringBuilder("Save failed with NSE, attachments contents: ");
                tmp.append(attachment).append(" to: ").append(attachmentsStore);
                log.error((Object)tmp.toString());
                throw e;
            }
        }
    }

    protected File getAttachmentPath(String baseName) {
        String vfsPath = baseName + ATTACHMENT_SUFFIX;
        return new File(this.attachmentsStoreDir, vfsPath);
    }

    protected abstract <T> T loadAttachment(File var1, Class<T> var2) throws Exception;

    protected abstract void saveAttachment(File var1, Object var2) throws Exception;
}

