/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.bootstrap.spi.Bootstrap;
import org.jboss.bootstrap.spi.Server;
import org.jboss.bootstrap.spi.ServerConfig;
import org.jboss.bootstrap.spi.microcontainer.MCServer;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.IncompleteDeploymentException;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.plugins.main.MainDeployerImpl;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.managed.ManagedDeploymentCreator;
import org.jboss.deployers.spi.management.KnownComponentTypes;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.deployer.kernel.KernelDeploymentDeployer;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.MutableManagedObject;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedComponentImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.ArrayValueSupport;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.EnumValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.profileservice.spi.types.ControllerStateMetaType;
import org.jboss.system.server.profileservice.BootstrapDeployment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileServiceBootstrap
implements Bootstrap {
    private static final Logger log = Logger.getLogger(ProfileServiceBootstrap.class);
    protected String profileName = "default";
    protected MainDeployer mainDeployer;
    protected ProfileService profileService;
    private ManagedDeploymentCreator mgtDeploymentCreator = null;
    private ManagedObjectFactory mof;
    private Map<String, ManagedDeployment> bootstrapMDs = new HashMap<String, ManagedDeployment>();
    private AtomicBoolean shutdown = new AtomicBoolean(false);

    public MainDeployer getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(MainDeployer mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public ProfileService getProfileService() {
        return this.profileService;
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public ManagedObjectFactory getMof() {
        return this.mof;
    }

    public void setMof(ManagedObjectFactory mof) {
        this.mof = mof;
    }

    public ManagedDeploymentCreator getMgtDeploymentCreator() {
        return this.mgtDeploymentCreator;
    }

    public void setMgtDeploymentCreator(ManagedDeploymentCreator mgtDeploymentCreator) {
        this.mgtDeploymentCreator = mgtDeploymentCreator;
    }

    public Map<String, ManagedDeployment> getBootstrapMDs() {
        return this.bootstrapMDs;
    }

    public void setBootstrapMDs(Map<String, ManagedDeployment> bootstrapMDs) {
        this.bootstrapMDs = bootstrapMDs;
    }

    public void start(Server server) throws Exception {
        this.shutdown.set(false);
        if (this.profileService == null) {
            throw new IllegalStateException("The ProfileService has not been injected");
        }
        log.debug((Object)("Using ProfileService: " + this.profileService));
        if (this.mainDeployer == null) {
            throw new IllegalStateException("The MainDeployer has not been injected");
        }
        log.debug((Object)("Using MainDeployer: " + this.mainDeployer));
        this.mainDeployer.checkComplete();
        this.initBootstrapMDs(server);
        try {
            this.profileName = server.getConfig().getServerName();
            this.loadProfile(this.profileName);
        }
        catch (IncompleteDeploymentException e) {
            log.error((Object)("Failed to load profile: " + e.getMessage()));
        }
        catch (Exception e) {
            log.error((Object)"Failed to load profile: ", (Throwable)e);
        }
        Profile profile = this.profileService.getActiveProfile();
        if (profile != null) {
            profile.enableModifiedDeploymentChecks(true);
        }
    }

    public void prepareShutdown(Server server) {
        this.shutdown.set(true);
        if (this.mainDeployer != null) {
            this.mainDeployer.prepareShutdown();
        }
    }

    public void shutdown(Server server) {
        this.unloadProfile(this.profileName);
        try {
            this.mainDeployer.shutdown();
        }
        catch (Throwable t) {
            log.warn((Object)"Error shutting down the main deployer", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProfile(String name) throws Exception {
        DeploymentContext ctx;
        MainDeployer deployer = this.getMainDeployer();
        if (deployer == null) {
            throw new NullPointerException("MainDeployer has not been set");
        }
        ProfileService ps = this.getProfileService();
        if (ps == null) {
            throw new NullPointerException("ProfileService has not been set");
        }
        ProfileKey key = new ProfileKey(name);
        Profile profile = ps.getProfile(key);
        VFSDeployment first = null;
        Collection boostraps = profile.getDeployments(ManagedDeployment.DeploymentPhase.BOOTSTRAP);
        for (VFSDeployment d : boostraps) {
            deployer.addDeployment((Deployment)d);
            if (first != null) continue;
            first = d;
        }
        deployer.process();
        deployer.checkComplete();
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        MainDeployerImpl hack = (MainDeployerImpl)deployer;
        ClassLoader cl = null;
        if (first != null && (ctx = hack.getDeploymentContext(first.getName())) != null) {
            cl = ctx.getClassLoader();
        }
        try {
            Collection profileDeployers = profile.getDeployments(ManagedDeployment.DeploymentPhase.DEPLOYER);
            for (VFSDeployment d : profileDeployers) {
                deployer.addDeployment((Deployment)d);
            }
            deployer.process();
            deployer.checkComplete();
            Collection profileDeployments = profile.getDeployments(ManagedDeployment.DeploymentPhase.APPLICATION);
            for (VFSDeployment d : profileDeployments) {
                deployer.addDeployment((Deployment)d);
            }
            deployer.process();
            deployer.checkComplete();
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unloadProfile(String name) {
        MainDeployer deployer = this.getMainDeployer();
        if (deployer == null) {
            log.warn((Object)"MainDeployer has not been set");
            return;
        }
        ProfileService ps = this.getProfileService();
        if (ps == null) {
            log.warn((Object)"ProfileService has not been set");
            return;
        }
        try {
            ProfileKey key = new ProfileKey(name);
            Profile profile = ps.getProfile(key);
            VFSDeployment first = null;
            Collection boostraps = profile.getDeployments(ManagedDeployment.DeploymentPhase.BOOTSTRAP);
            for (VFSDeployment d : boostraps) {
                if (first != null) continue;
                first = d;
                break;
            }
            Thread thread = Thread.currentThread();
            ClassLoader old = thread.getContextClassLoader();
            MainDeployerImpl hack = (MainDeployerImpl)deployer;
            ClassLoader cl = null;
            if (first != null) {
                try {
                    DeploymentContext ctx = hack.getDeploymentContext(first.getName());
                    if (ctx != null) {
                        cl = ctx.getClassLoader();
                    }
                }
                catch (Exception e) {
                    log.debug((Object)"Unable to get first deployment", (Throwable)e);
                }
            }
            try {
                this.unload(deployer, profile.getDeployments(ManagedDeployment.DeploymentPhase.APPLICATION));
                this.unload(deployer, profile.getDeployments(ManagedDeployment.DeploymentPhase.DEPLOYER));
                this.unload(deployer, profile.getDeployments(ManagedDeployment.DeploymentPhase.BOOTSTRAP));
            }
            finally {
                thread.setContextClassLoader(old);
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Error unloading profile", t);
        }
    }

    protected void unload(MainDeployer deployer, Collection<VFSDeployment> deployments) {
        if (deployments == null || deployments.isEmpty()) {
            return;
        }
        for (VFSDeployment d : deployments) {
            try {
                deployer.removeDeployment((Deployment)d);
            }
            catch (Exception e) {
                log.warn((Object)("Unable to remove deployment: " + d));
            }
        }
        deployer.process();
    }

    protected void initBootstrapMDs(Server server) {
        if (this.mof == null || this.mgtDeploymentCreator == null) {
            log.warn((Object)"Skipping ManagedDeployment creation due to missing mof, mgtDeploymentCreator");
            return;
        }
        Map serverDeployments = null;
        if (server instanceof MCServer) {
            MCServer mcserver = (MCServer)MCServer.class.cast(server);
            Kernel kernel = mcserver.getKernel();
            serverDeployments = mcserver.getDeployments();
            ManagedDeployment firstDeployment = null;
            for (KernelDeployment kd : serverDeployments.values()) {
                ManagedObject kdMO = this.mof.initManagedObject((Object)kd, null);
                Map<String, ManagedObject> kdMOs = Collections.singletonMap(kd.getName(), kdMO);
                BootstrapDeployment deploymentUnit = new BootstrapDeployment(kd);
                KernelDeploymentDeployer.KernelDeploymentVisitor visitor = new KernelDeploymentDeployer.KernelDeploymentVisitor();
                try {
                    visitor.deploy((DeploymentUnit)deploymentUnit, (Object)kd);
                }
                catch (DeploymentException e) {
                    log.debug((Object)("Failed to build ManagedDeployment for: " + kd), (Throwable)e);
                    continue;
                }
                ManagedDeployment md = this.mgtDeploymentCreator.build((DeploymentUnit)deploymentUnit, kdMOs, null);
                if (firstDeployment == null) {
                    firstDeployment = md;
                }
                for (DeploymentUnit compUnit : deploymentUnit.getComponents()) {
                    BeanMetaData bmd = (BeanMetaData)compUnit.getAttachment(BeanMetaData.class);
                    ManagedObject bmdMO = this.mof.initManagedObject((Object)bmd, compUnit.getMetaData());
                    if (bmdMO == null) continue;
                    if (bmdMO instanceof MutableManagedObject) {
                        MutableManagedObject mmo = (MutableManagedObject)bmdMO;
                        mmo.setName(bmd.getName());
                        mmo.setParent(kdMO);
                        Set bmdAliases = bmd.getAliases();
                        if (bmdAliases != null && bmdAliases.size() > 0) {
                            Map oldProps = mmo.getProperties();
                            HashMap<String, ManagedPropertyImpl> newProps = new HashMap<String, ManagedPropertyImpl>(oldProps);
                            ArrayMetaType aliasType = new ArrayMetaType(SimpleMetaType.STRING, false);
                            DefaultFieldsImpl fields = this.getFields("alias", (MetaType)aliasType);
                            fields.setDescription("Aliases of the bean");
                            String[] aliases = new String[bmdAliases.size()];
                            Iterator i = bmdAliases.iterator();
                            int n = 0;
                            while (i.hasNext()) {
                                aliases[n] = i.next().toString();
                                ++n;
                            }
                            ArrayValueSupport value = new ArrayValueSupport(aliasType, (Object)aliases);
                            fields.setValue((MetaValue)value);
                            ManagedPropertyImpl aliasesMP = new ManagedPropertyImpl(bmdMO, (Fields)fields);
                            newProps.put("alias", aliasesMP);
                            DefaultFieldsImpl stateFields = this.getFields("state", (MetaType)ControllerStateMetaType.TYPE);
                            stateFields.setViewUse(new ViewUse[]{ViewUse.STATISTIC});
                            EnumValue stateValue = this.getState(bmd.getName(), kernel);
                            stateFields.setValue((MetaValue)stateValue);
                            stateFields.setDescription("The bean controller state");
                            ManagedPropertyImpl stateMP = new ManagedPropertyImpl((ManagedObject)mmo, (Fields)stateFields);
                            newProps.put("state", stateMP);
                            mmo.setProperties(newProps);
                        }
                    }
                    log.debug((Object)("Created ManagedObject: " + bmdMO + " for bean: " + bmd.getName()));
                    ComponentType type = KnownComponentTypes.MCBean.Any.getType();
                    Map moAnns = bmdMO.getAnnotations();
                    ManagementComponent mc = (ManagementComponent)moAnns.get(ManagementComponent.class.getName());
                    if (mc != null) {
                        type = new ComponentType(mc.type(), mc.subtype());
                    }
                    ManagedComponentImpl comp = new ManagedComponentImpl(type, md, bmdMO);
                    md.addComponent(bmdMO.getName(), (ManagedComponent)comp);
                    log.debug((Object)("Created ManagedComponent of type: " + type + " for bean: " + bmd.getName()));
                }
                if (md == null) continue;
                this.bootstrapMDs.put(kd.getName(), md);
            }
            if (firstDeployment != null) {
                ComponentType type = KnownComponentTypes.MCBean.Any.getType();
                ManagedObject serverMO = this.mof.initManagedObject((Object)mcserver, null);
                ManagedComponentImpl serverComp = new ManagedComponentImpl(type, firstDeployment, serverMO);
                firstDeployment.addComponent("MCServer", (ManagedComponent)serverComp);
                ServerConfig config = mcserver.getConfig();
                ManagedObject mo = this.mof.initManagedObject((Object)config, null);
                ManagedComponentImpl configComp = new ManagedComponentImpl(type, firstDeployment, mo);
                firstDeployment.addComponent("ServerConfig", (ManagedComponent)configComp);
                log.debug((Object)("Created ManagedComponent of type: " + type + " for ServerConfig"));
            }
        }
    }

    protected DefaultFieldsImpl getFields(String name, MetaType type) {
        DefaultFieldsImpl fields = new DefaultFieldsImpl();
        fields.setMetaType(type);
        fields.setName(name);
        fields.setMandatory(false);
        return fields;
    }

    protected EnumValue getState(Object name, Kernel kernel) {
        KernelController controller = kernel.getController();
        ControllerContext context = controller.getContext(name, null);
        if (context == null) {
            throw new IllegalStateException("Context not installed: " + name);
        }
        ControllerState state = context.getState();
        return new EnumValueSupport(ControllerStateMetaType.TYPE, state.getStateString());
    }
}

