/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.tools;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.deployers.vfs.spi.structure.modified.StructureModificationChecker;
import org.jboss.logging.Logger;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.MutableProfile;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.system.server.profileservice.hotdeploy.Scanner;
import org.jboss.system.server.profileservice.repository.HotDeploymentRepository;
import org.jboss.system.server.profileservice.repository.TypedProfileRepository;
import org.jboss.system.tools.DeploymentRepositoryAdapter;
import org.jboss.virtual.VirtualFile;

public class ProfileServiceDeploymentRepositoryAdapter
implements DeploymentRepositoryAdapter {
    private static final Logger log = Logger.getLogger(ProfileServiceDeploymentRepositoryAdapter.class);
    private static final ProfileKey profileName = new ProfileKey("deployment-scanner-profile");
    private Scanner scanner;
    private ProfileService ps;
    private TypedProfileRepository repositories;
    private StructureModificationChecker checker;
    private DeploymentScannerProfile profile;

    public ProfileServiceDeploymentRepositoryAdapter(Scanner scanner, ProfileService ps, StructureModificationChecker checker) {
        if (scanner == null) {
            throw new IllegalArgumentException("Null scanner");
        }
        if (ps == null) {
            throw new IllegalArgumentException("Null profile service");
        }
        if (checker == null) {
            throw new IllegalArgumentException("Null structure checker");
        }
        this.scanner = scanner;
        this.ps = ps;
        this.checker = checker;
    }

    public TypedProfileRepository getProfileRepository() {
        return this.repositories;
    }

    public void setProfileRepository(TypedProfileRepository repositories) {
        this.repositories = repositories;
    }

    public void create() throws Exception {
        this.profile = new DeploymentScannerProfile(this.checker);
        this.registerProfile();
    }

    public void destroy() {
        this.stopProfile();
    }

    protected void registerProfile() throws Exception {
        if (this.ps == null) {
            throw new IllegalStateException("Null profile service.");
        }
        this.ps.registerProfile((Profile)this.profile);
        log.debug((Object)("Activating deployment scanner profile " + profileName));
        this.ps.activateProfile(profileName);
        this.ps.validateProfile(profileName);
        if (this.repositories != null) {
            this.repositories.registerDeploymentRepository(this.profile);
        }
    }

    public void resume() {
        this.scanner.resume();
    }

    public void suspend() {
        this.scanner.suspend();
    }

    public void stopProfile() {
        if (this.repositories != null) {
            this.repositories.unregisterDeploymentRepository(this.profile);
        }
        try {
            log.debug((Object)("Deactivating deployment scanner profile: " + profileName));
            this.ps.deactivateProfile(profileName);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to deactivate deployment scanner profile: ", (Throwable)e);
        }
        try {
            log.debug((Object)("Unregistering transient profile: " + profileName));
            this.ps.unregisterProfile(profileName);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to unregister deployment scanner profile: ", (Throwable)e);
        }
    }

    public void addURL(URL url) throws URISyntaxException {
        URI uri = url.toURI();
        Collection<URI> uris = this.profile.getURIs();
        if (!uris.contains(uri)) {
            uris.add(uri);
        }
    }

    public void removeURL(URL url) throws URISyntaxException {
        URI uri = url.toURI();
        Collection<URI> uris = this.profile.getURIs();
        uris.remove(uri);
    }

    public boolean hasURL(URL url) throws URISyntaxException {
        URI uri = url.toURI();
        return this.profile.getURIs().contains(uri);
    }

    public String[] listDeployedURLs() {
        ArrayList<String> urls = new ArrayList<String>();
        Collection activeProfiles = this.ps.getActiveProfileKeys();
        if (activeProfiles != null && !activeProfiles.isEmpty()) {
            for (ProfileKey key : activeProfiles) {
                Profile profile;
                try {
                    profile = this.ps.getActiveProfile(key);
                }
                catch (NoSuchProfileException ignore) {
                    continue;
                }
                Collection deployments = profile.getDeployments();
                if (deployments == null || deployments.isEmpty()) continue;
                for (ProfileDeployment pd : deployments) {
                    VirtualFile root = pd.getRoot();
                    if (root == null) continue;
                    try {
                        urls.add(root.toURL().toExternalForm());
                    }
                    catch (Exception e) {
                        log.warn((Object)("Exception while reading root's URL: " + root));
                    }
                }
            }
        }
        return urls.toArray(new String[urls.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeploymentScannerProfile
    extends HotDeploymentRepository
    implements MutableProfile {
        private volatile boolean enableHotDeployment;
        private Map<URI, List<VirtualFile>> oldCache = new ConcurrentHashMap<URI, List<VirtualFile>>();
        private Map<URI, List<VirtualFile>> newCache = new ConcurrentHashMap<URI, List<VirtualFile>>();

        public DeploymentScannerProfile(StructureModificationChecker checker) {
            super(profileName, new URI[0]);
            this.setChecker(checker);
        }

        Collection<URI> getURIs() {
            return this.uris;
        }

        public void addDeployment(ProfileDeployment deployment) throws Exception {
            super.addDeployment(deployment.getName(), deployment);
        }

        public void enableModifiedDeploymentChecks(boolean flag) {
            this.enableHotDeployment = flag;
        }

        @Override
        public Collection<ModificationInfo> getModifiedDeployments() throws Exception {
            if (!this.enableHotDeployment) {
                return Collections.emptySet();
            }
            return super.getModifiedDeployments();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void checkForAdditions(List<ModificationInfo> modified) throws Exception {
            this.newCache.clear();
            super.checkForAdditions(modified);
            long lastModified = System.currentTimeMillis();
            for (List<VirtualFile> files : this.oldCache.values()) {
                for (VirtualFile file : files) {
                    ProfileDeployment previous;
                    String name = file.toURI().toString();
                    if (this.acceptsDeployment(name)) continue;
                    this.unlockRead();
                    try {
                        previous = this.removeDeployment(name, false);
                    }
                    finally {
                        this.lockRead();
                    }
                    ModificationInfo removed = new ModificationInfo(previous, lastModified, ModificationInfo.ModifyStatus.REMOVED);
                    modified.add(removed);
                }
            }
            this.oldCache.clear();
            this.oldCache.putAll(this.newCache);
        }

        @Override
        protected void applyAddedDeployments(URI applicationDir, List<ModificationInfo> modified, List<VirtualFile> added) throws Exception {
            List<VirtualFile> files = this.oldCache.remove(applicationDir);
            super.applyAddedDeployments(applicationDir, modified, added);
            if (files == null) {
                files = new ArrayList<VirtualFile>(added);
            } else {
                files.addAll(added);
            }
            this.newCache.put(applicationDir, files);
        }

        @Override
        protected List<String> findDeploymentContent(String name) {
            VirtualFile cached = this.getCachedVirtualFile(name);
            if (cached != null) {
                try {
                    name = cached.toURI().toString();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                return Collections.singletonList(name);
            }
            ArrayList<String> contents = new ArrayList<String>();
            for (URI uri : this.uris) {
                VirtualFile vf;
                String cacheName;
                String fixedName = cacheName = uri.toString();
                if (cacheName.endsWith("/")) {
                    fixedName = cacheName.substring(0, cacheName.length() - 1);
                }
                if (!fixedName.endsWith(name) || (vf = this.getCachedVirtualFile(cacheName)) == null) continue;
                try {
                    contents.add(vf.toURI().toString());
                }
                catch (Exception ignore) {}
            }
            return contents;
        }

        @Override
        public ProfileDeployment removeDeployment(String vfsPath) throws Exception {
            return super.removeDeployment(vfsPath, false);
        }

        public ProfileKey getKey() {
            return profileName;
        }

        public Collection<ProfileKey> getSubProfiles() {
            return Collections.emptySet();
        }

        public boolean hasDeployment(String name) {
            return false;
        }

        public boolean isMutable() {
            return true;
        }
    }
}

