/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.managed;

import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.metadata.spi.MetaData;
import org.jboss.system.server.profileservice.persistence.PersistenceFactory;
import org.jboss.system.server.profileservice.persistence.component.AbstractComponentMapper;
import org.jboss.system.server.profileservice.persistence.xml.PersistedComponent;

public class KernelDeploymentComponentMapper
extends AbstractComponentMapper {
    public KernelDeploymentComponentMapper(PersistenceFactory persistenceFactory) {
        super(persistenceFactory);
    }

    protected void setComponentName(PersistedComponent component, ManagedObject mo) {
        BeanMetaData bmd = (BeanMetaData)mo.getAttachment();
        component.setName(bmd.getName());
    }

    protected ManagedObject getComponent(Object attachment, PersistedComponent component, boolean create) {
        AbstractKernelDeployment deployment = (AbstractKernelDeployment)attachment;
        HashMap<String, BeanMetaData> beans = new HashMap<String, BeanMetaData>();
        for (BeanMetaData bmd : deployment.getBeans()) {
            beans.put(bmd.getName(), bmd);
        }
        BeanMetaData bmd = (BeanMetaData)beans.get(component.getOriginalName());
        if (bmd == null && create) {
            AbstractBeanMetaData bean = this.createEmptyBeanMetaData(component);
            if (deployment.getBeanFactories() == null) {
                deployment.setBeanFactories(new ArrayList());
            }
            deployment.getBeanFactories().add(bean);
            bmd = bean;
        }
        if (bmd == null) {
            throw new IllegalStateException("Could not find bean: " + component.getOriginalName());
        }
        MetaData metaData = null;
        return this.getMOF().initManagedObject((Object)bmd, metaData);
    }

    protected void removeComponent(Object attachment, PersistedComponent component) {
        AbstractKernelDeployment deployment = (AbstractKernelDeployment)attachment;
        if (deployment.getBeanFactories() != null && !deployment.getBeanFactories().isEmpty()) {
            boolean removed = false;
            ArrayList<BeanMetaDataFactory> beanFactories = new ArrayList<BeanMetaDataFactory>();
            for (BeanMetaDataFactory bmdf : deployment.getBeanFactories()) {
                if (bmdf instanceof AbstractBeanMetaData) {
                    AbstractBeanMetaData bean = (AbstractBeanMetaData)bmdf;
                    if (bean.getName().equals(component.getOriginalName())) {
                        removed = true;
                        continue;
                    }
                    beanFactories.add(bmdf);
                    continue;
                }
                beanFactories.add(bmdf);
            }
            if (!removed) {
                throw new IllegalStateException("Could not remove component " + component.getOriginalName());
            }
            deployment.setBeanFactories(beanFactories);
        }
    }

    protected AbstractBeanMetaData createEmptyBeanMetaData(PersistedComponent component) {
        AbstractBeanMetaData bean = new AbstractBeanMetaData();
        bean.setName(component.getOriginalName());
        String beanClassName = component.getTemplateName();
        if (beanClassName == null) {
            beanClassName = component.getClassName();
        }
        if (beanClassName != null && !beanClassName.equals(AbstractBeanMetaData.class.getName())) {
            bean.setBean(beanClassName);
        }
        return bean;
    }

    public String getType() {
        return AbstractKernelDeployment.class.getName();
    }
}

