/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.profile.plugins;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.vfs.metadata.VFSClassLoaderFactory10;
import org.jboss.logging.Logger;
import org.jboss.profileservice.repository.ProfileDeploymentFactory;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.system.server.profileservice.profile.plugins.ClassPathProfileMetaData;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathAdapterProfile
implements Profile {
    private static final Logger log = Logger.getLogger(ClassPathAdapterProfile.class);
    private final ProfileKey key;
    private final String deploymentName;
    private final List<ClassPathProfileMetaData.ClassPathItem> items;
    private final long lastModified;
    private ProfileDeployment classPathDeployment;

    public ClassPathAdapterProfile(ProfileKey key, List<ClassPathProfileMetaData.ClassPathItem> items) {
        if (key == null) {
            throw new IllegalArgumentException("null profile key");
        }
        this.key = key;
        this.deploymentName = key.getName();
        this.items = items;
        this.lastModified = System.currentTimeMillis();
    }

    public void create() throws Exception {
        List<VirtualFile> classpath = this.determineRoots();
        ArrayList<String> roots = new ArrayList<String>();
        for (VirtualFile vf : classpath) {
            roots.add(vf.toURI().toString());
        }
        VFSClassLoaderFactory10 clMetaData = new VFSClassLoaderFactory10();
        clMetaData.setRoots(roots);
        this.classPathDeployment = ProfileDeploymentFactory.getInstance().createDeployment(this.deploymentName);
        this.classPathDeployment.getPredeterminedAttachments().putAttachment(ClassLoadingMetaData.class.getName(), (Object)clMetaData);
    }

    public ProfileDeployment getDeployment(String name) throws NoSuchDeploymentException {
        if (this.deploymentName.equals(name)) {
            return this.classPathDeployment;
        }
        throw new NoSuchDeploymentException(name);
    }

    public Set<String> getDeploymentNames() {
        return Collections.singleton(this.deploymentName);
    }

    public Collection<ProfileDeployment> getDeployments() {
        return Collections.singleton(this.classPathDeployment);
    }

    public ProfileKey getKey() {
        return this.key;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean hasDeployment(String name) {
        return false;
    }

    public boolean isMutable() {
        return false;
    }

    protected List<VirtualFile> determineRoots() throws IOException, URISyntaxException {
        ArrayList<VirtualFile> classpath = new ArrayList<VirtualFile>();
        for (ClassPathProfileMetaData.ClassPathItem item : this.items) {
            URI uri = new URI(item.getPath());
            String codebase = item.getPath();
            String archives = item.getArchives();
            log.debug((Object)("Processing classpath: codebase=" + codebase + " archives=" + archives));
            VirtualFile codebaseFile = VFS.getChild((URI)uri);
            if (codebaseFile == null) {
                throw new RuntimeException("Cannot use classpath without a root: " + uri);
            }
            if (archives == null) {
                classpath.add(codebaseFile);
                continue;
            }
            ClassPathFilter filter = new ClassPathFilter(archives);
            List archiveFiles = codebaseFile.getChildren((VirtualFileFilter)filter);
            classpath.addAll(archiveFiles);
        }
        return classpath;
    }

    static class ClassPathFilter
    implements VirtualFileFilter {
        private final Set<String> patterns;
        private final boolean allowAll;

        public ClassPathFilter(String patternsString) {
            if (patternsString == null) {
                throw new IllegalArgumentException("Null patternsString");
            }
            StringTokenizer tokens = new StringTokenizer(patternsString, ",");
            this.patterns = new HashSet<String>(tokens.countTokens());
            int i = 0;
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                this.patterns.add(token.trim());
                ++i;
            }
            this.allowAll = this.patterns.contains("*");
        }

        public boolean accepts(VirtualFile file) {
            if (this.allowAll) {
                return true;
            }
            return this.patterns.contains(file.getName());
        }
    }
}

