/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.deployers;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextHandler;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.CatalinaProperties;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.web.jboss.JBoss50WebMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.Web25MetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.plugins.JaasSecurityManagerServiceMBean;
import org.jboss.system.server.ServerImplMBean;
import org.jboss.virtual.VirtualFile;
import org.jboss.web.deployers.AbstractWarDeployer;
import org.jboss.web.deployers.AbstractWarDeployment;
import org.jboss.web.tomcat.security.HttpServletRequestPolicyContextHandler;
import org.jboss.web.tomcat.service.deployers.DeployerConfig;
import org.jboss.web.tomcat.service.deployers.TomcatDeployerMBean;
import org.jboss.web.tomcat.service.deployers.TomcatDeployment;
import org.jboss.web.tomcat.service.session.SessionIDGenerator;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.builder.JBossXBBuilder;

public class TomcatDeployer
extends AbstractWarDeployer
implements NotificationListener,
TomcatDeployerMBean {
    public static final String NAME = "TomcatDeployer";
    private String contextClassName = "org.apache.catalina.core.StandardContext";
    private static final UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
    private Properties authenticators = null;
    private String catalinaDomain = "Catalina";
    protected String managerClass = "org.jboss.web.tomcat.service.session.JBossCacheManager";
    private boolean useJBossWebLoader = true;
    private boolean deleteWorkDirOnContextDestroy = false;
    private String httpHeaderForSSOAuth = null;
    private String sessionCookieForSSOAuth = null;
    private JBossWebMetaData sharedMetaData = null;
    private String serverConfigFile = "server.xml";
    private String subjectAttributeName = null;
    private boolean allowSelfPrivilegedWebApps = false;
    private JaasSecurityManagerServiceMBean secMgrService;
    private Class deploymentClass = TomcatDeployment.class;
    private ISecurityManagement securityManagement;
    private String securityContextClassName;
    private String[] filteredPackages;
    private boolean runtimeLifecycleCoupled = false;

    public String getName() {
        return NAME;
    }

    public String getManagerClass() {
        return this.managerClass;
    }

    public void setManagerClass(String managerClass) {
        this.managerClass = managerClass;
    }

    public String getDomain() {
        return this.catalinaDomain;
    }

    public Properties getAuthenticators() {
        return this.authenticators;
    }

    public void setAuthenticators(Properties prop) {
        this.authenticators = prop;
        this.log.debug((Object)("Passed set of authenticators=" + prop));
    }

    public void setDomain(String catalinaDomain) {
        this.catalinaDomain = catalinaDomain;
    }

    public void setContextMBeanCode(String className) {
        this.contextClassName = className;
    }

    public String getContextMBeanCode() {
        return this.contextClassName;
    }

    public boolean getDeleteWorkDirOnContextDestroy() {
        return this.deleteWorkDirOnContextDestroy;
    }

    public void setDeleteWorkDirOnContextDestroy(boolean deleteFlag) {
        this.deleteWorkDirOnContextDestroy = deleteFlag;
    }

    public String getHttpHeaderForSSOAuth() {
        return this.httpHeaderForSSOAuth;
    }

    public void setHttpHeaderForSSOAuth(String httpHeader) {
        this.httpHeaderForSSOAuth = httpHeader;
    }

    public String getSessionCookieForSSOAuth() {
        return this.sessionCookieForSSOAuth;
    }

    public void setSessionCookieForSSOAuth(String sessionC) {
        this.sessionCookieForSSOAuth = sessionC;
    }

    public void setSessionIdAlphabet(String sessionIdAlphabet) {
        SessionIDGenerator.getInstance().setSessionIdAlphabet(sessionIdAlphabet);
    }

    public String getSessionIdAlphabet() {
        return SessionIDGenerator.getInstance().getSessionIdAlphabet();
    }

    public boolean getUseJBossWebLoader() {
        return this.useJBossWebLoader;
    }

    public void setUseJBossWebLoader(boolean flag) {
        this.useJBossWebLoader = flag;
    }

    public String getConfigFile() {
        return this.serverConfigFile;
    }

    public void setConfigFile(String configFile) {
        this.serverConfigFile = configFile;
    }

    public String getSubjectAttributeName() {
        return this.subjectAttributeName;
    }

    public void setSubjectAttributeName(String name) {
        this.subjectAttributeName = name;
    }

    public boolean isAllowSelfPrivilegedWebApps() {
        return this.allowSelfPrivilegedWebApps;
    }

    public void setAllowSelfPrivilegedWebApps(boolean allowSelfPrivilegedWebApps) {
        this.allowSelfPrivilegedWebApps = allowSelfPrivilegedWebApps;
    }

    public void setSecurityManagerService(JaasSecurityManagerServiceMBean mgr) {
        this.secMgrService = mgr;
    }

    public void setSecurityManagement(ISecurityManagement securityManagement) {
        this.securityManagement = securityManagement;
    }

    public void setSecurityContextClassName(String securityContextClassName) {
        this.securityContextClassName = securityContextClassName;
    }

    public String[] getFilteredPackages() {
        return this.filteredPackages;
    }

    public void setFilteredPackages(String[] pkgs) {
        this.filteredPackages = pkgs;
    }

    public Class getDeploymentClass() {
        return this.deploymentClass;
    }

    public void setDeploymentClass(Class deploymentClass) {
        this.deploymentClass = deploymentClass;
    }

    public boolean isRuntimeLifecycleCoupled() {
        return this.runtimeLifecycleCoupled;
    }

    public void setRuntimeLifecycleCoupled(boolean coupled) {
        this.runtimeLifecycleCoupled = coupled;
    }

    public void start() throws Exception {
        super.start();
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        URL webXml = this.getClass().getClassLoader().getResource("web.xml");
        if (webXml == null) {
            webXml = this.getClass().getClassLoader().getResource("conf/web.xml");
        }
        if (webXml == null) {
            throw new IllegalStateException("Unable to find shared web.xml or conf/web.xml");
        }
        SchemaBinding schema = JBossXBBuilder.build(Web25MetaData.class);
        Web25MetaData confWebMD = (Web25MetaData)unmarshaller.unmarshal(webXml.toString(), schema);
        this.sharedMetaData = new JBoss50WebMetaData();
        this.sharedMetaData.merge(null, (WebMetaData)confWebMD);
        if (this.isRuntimeLifecycleCoupled()) {
            this.startWebServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWebServer() throws Exception {
        CatalinaProperties.getProperty((String)"");
        this.log.debug((Object)"Starting tomcat deployer");
        MBeanServer server = super.getServer();
        System.setProperty("catalina.ext.dirs", System.getProperty("jboss.server.home.dir") + File.separator + "lib");
        String objectNameS = this.catalinaDomain + ":type=server";
        ObjectName objectName = new ObjectName(objectNameS);
        Registry.getRegistry().setMBeanServer(server);
        Registry.getRegistry().registerComponent(Class.forName("org.apache.catalina.startup.Catalina").newInstance(), objectName, "org.apache.catalina.startup.Catalina");
        server.setAttribute(objectName, new Attribute("catalinaHome", System.getProperty("jboss.server.home.dir")));
        server.setAttribute(objectName, new Attribute("configFile", this.serverConfigFile));
        server.setAttribute(objectName, new Attribute("useNaming", new Boolean(false)));
        server.setAttribute(objectName, new Attribute("useShutdownHook", new Boolean(false)));
        server.setAttribute(objectName, new Attribute("await", new Boolean(false)));
        server.setAttribute(objectName, new Attribute("redirectStreams", new Boolean(false)));
        server.invoke(objectName, "create", new Object[0], new String[0]);
        server.invoke(objectName, "start", new Object[0], new String[0]);
        InitialContext ic = new InitialContext();
        try {
            ic.bind("TomcatAuthenticators", (Object)this.authenticators);
        }
        catch (NamingException ne) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Binding Authenticators to JNDI failed", (Throwable)ne);
            }
        }
        finally {
            try {
                ic.close();
            }
            catch (NamingException nee) {}
        }
        HttpServletRequestPolicyContextHandler handler = new HttpServletRequestPolicyContextHandler();
        PolicyContext.registerHandler((String)"javax.servlet.http.HttpServletRequest", (PolicyContextHandler)handler, (boolean)true);
        Boolean started = (Boolean)server.getAttribute(ServerImplMBean.OBJECT_NAME, "Started");
        if (started.booleanValue()) {
            this.log.debug((Object)("Server '" + ServerImplMBean.OBJECT_NAME + "' already started, starting connectors now"));
            this.startConnectors();
        } else {
            this.log.debug((Object)("Server '" + ServerImplMBean.OBJECT_NAME + "' not started, registering for start-up notification"));
            server.addNotificationListener(ServerImplMBean.OBJECT_NAME, this, null, null);
        }
    }

    public void stop() throws Exception {
        if (this.isRuntimeLifecycleCoupled()) {
            this.stopWebServer();
        }
        super.stop();
    }

    public void stopWebServer() throws Exception {
        MBeanServer server = super.getServer();
        String objectNameS = this.catalinaDomain + ":type=server";
        ObjectName objectName = new ObjectName(objectNameS);
        server.invoke(objectName, "stop", new Object[0], new String[0]);
        server.invoke(objectName, "destroy", new Object[0], new String[0]);
        server.unregisterMBean(objectName);
        MBeanServer server2 = server;
        ObjectName queryObjectName = new ObjectName(this.catalinaDomain + ":*");
        for (ObjectInstance oi : server2.queryMBeans(queryObjectName, null)) {
            ObjectName toRemove = oi.getObjectName();
            if ("WebServer".equals(toRemove.getKeyProperty("service")) || !server2.isRegistered(toRemove)) continue;
            server2.unregisterMBean(toRemove);
        }
        queryObjectName = new ObjectName("Catalina:*");
        for (ObjectInstance oi : server2.queryMBeans(queryObjectName, null)) {
            ObjectName name = oi.getObjectName();
            server2.unregisterMBean(name);
        }
    }

    public void startConnectors() throws Exception {
        MBeanServer server = super.getServer();
        ObjectName service = new ObjectName(this.catalinaDomain + ":type=Service,serviceName=jboss.web");
        Object[] args = new Object[]{};
        String[] sig = new String[]{};
        Connector[] connectors = (Connector[])server.invoke(service, "findConnectors", args, sig);
        for (int n = 0; n < connectors.length; ++n) {
            Connector lc = connectors[n];
            lc.start();
        }
    }

    public void stopConnectors() throws Exception {
        MBeanServer server = super.getServer();
        ObjectName service = new ObjectName(this.catalinaDomain + ":type=Service,serviceName=jboss.web");
        Object[] args = new Object[]{};
        String[] sig = new String[]{};
        Connector[] connectors = (Connector[])server.invoke(service, "findConnectors", args, sig);
        for (int n = 0; n < connectors.length; ++n) {
            Connector lc = connectors[n];
            lc.stop();
        }
    }

    public void handleNotification(Notification msg, Object handback) {
        String type = msg.getType();
        if (type.equals("org.jboss.system.server.started")) {
            this.log.debug((Object)("Saw " + type + " notification, starting connectors"));
            try {
                this.startConnectors();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to startConnectors", (Throwable)e);
            }
        }
    }

    public static ClassLoader getTmpLoader(URL warURL, ClassLoader parent, boolean parentFirst) throws Exception {
        File libDir;
        String path = warURL.getFile();
        ArrayList<URL> list = new ArrayList<URL>();
        File classesDir = new File(path, "WEB-INF/classes");
        if (classesDir.exists()) {
            list.add(classesDir.toURL());
        }
        if ((libDir = new File(path, "WEB-INF/lib")).exists()) {
            File[] jars = libDir.listFiles();
            int length = jars != null ? jars.length : 0;
            for (int j = 0; j < length; ++j) {
                File jar = jars[j];
                if (!jar.getAbsolutePath().endsWith(".jar")) continue;
                list.add(jar.toURL());
            }
        }
        ENCLoader loader = new ENCLoader(list.toArray(new URL[list.size()]), parent, parentFirst);
        return loader;
    }

    public AbstractWarDeployment getDeployment(VFSDeploymentUnit unit, JBossWebMetaData metaData) throws Exception {
        ArrayList<String> depends;
        AbstractWarDeployment deployment = (AbstractWarDeployment)this.deploymentClass.newInstance();
        DeployerConfig config = new DeployerConfig();
        config.setDefaultSecurityDomain(this.defaultSecurityDomain);
        config.setSubjectAttributeName(this.subjectAttributeName);
        config.setServiceClassLoader(this.getClass().getClassLoader());
        config.setManagerClass(this.managerClass);
        config.setJava2ClassLoadingCompliance(this.java2ClassLoadingCompliance);
        config.setUnpackWars(this.unpackWars);
        config.setLenientEjbLink(this.lenientEjbLink);
        config.setCatalinaDomain(this.catalinaDomain);
        config.setContextClassName(this.contextClassName);
        config.setServiceName(null);
        config.setSubjectAttributeName(this.subjectAttributeName);
        config.setUseJBossWebLoader(this.useJBossWebLoader);
        config.setAllowSelfPrivilegedWebApps(this.allowSelfPrivilegedWebApps);
        config.setSecurityManagerService(this.secMgrService);
        config.setFilteredPackages(this.filteredPackages);
        config.setSharedMetaData(this.sharedMetaData);
        config.setSecurityContextClassName(this.securityContextClassName);
        config.setSecurityManagement(this.securityManagement);
        VirtualFile vf = unit.getMetaDataFile("jboss-xacml-policy.xml");
        if (vf != null) {
            config.setXacmlPolicyURL(vf.toURL());
        }
        if ((depends = metaData.getDepends()) == null) {
            depends = new ArrayList<String>();
        }
        depends.add(TomcatDeployerMBean.OBJECT_NAME.getCanonicalName());
        metaData.setDepends(depends);
        deployment.setServer(super.getServer());
        deployment.init((Object)config);
        return deployment;
    }

    public void create() throws Exception {
    }

    public void destroy() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ENCLoader
    extends URLClassLoader {
        private boolean parentFirst;

        ENCLoader(URL[] urls, ClassLoader parent, boolean parentFirst) {
            super(urls, parent);
            this.parentFirst = parentFirst;
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.parentFirst) {
                return super.loadClass(name, resolve);
            }
            try {
                Class<?> clazz = this.findClass(name);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            catch (ClassNotFoundException e) {
                return this.getParent().loadClass(name);
            }
        }
    }
}

