/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.transaction.TransactionManager;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.AbstractJBossManager;
import org.jboss.web.tomcat.service.session.JBossCacheManager;

public class BatchReplicationClusteredSessionValve
extends ValveBase
implements Lifecycle {
    private static Logger log_ = Logger.getLogger(BatchReplicationClusteredSessionValve.class);
    private static final String info = "BatchReplicationClusteredSessionValve/1.0";
    protected LifecycleSupport support = new LifecycleSupport((Lifecycle)this);
    protected JBossCacheManager manager_;

    public BatchReplicationClusteredSessionValve(AbstractJBossManager manager) {
        this.manager_ = (JBossCacheManager)manager;
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        TransactionManager tm = this.manager_.getCacheService().getTransactionManager();
        if (tm == null) {
            throw new RuntimeException("BatchReplicationClusteredSessionValve.invoke(): Obtain null tm");
        }
        request.getSession(false);
        try {
            tm.begin();
            this.getNext().invoke(request, response);
            log_.trace((Object)"Ready to commit batch replication for field level granularity");
            tm.commit();
        }
        catch (Exception e) {
            try {
                tm.rollback();
            }
            catch (Exception exn) {
                log_.error((Object)"Caught exception rolling back transaction", (Throwable)exn);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.support.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.support.removeLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.support.findLifecycleListeners();
    }

    public void start() throws LifecycleException {
        this.support.fireLifecycleEvent("start", (Object)this);
    }

    public void stop() throws LifecycleException {
        this.support.fireLifecycleEvent("stop", (Object)this);
    }
}

