/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import org.jboss.cache.Fqn;
import org.jboss.cache.notifications.annotation.CacheStarted;
import org.jboss.cache.notifications.annotation.CacheStopped;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.event.CacheStartedEvent;
import org.jboss.cache.notifications.event.CacheStoppedEvent;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.notifications.event.NodeRemovedEvent;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.web.tomcat.service.session.CacheListenerBase;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.JBossCacheManager;
import org.jboss.web.tomcat.service.session.JBossCacheWrapper;

@org.jboss.cache.notifications.annotation.CacheListener
public class CacheListener
extends CacheListenerBase {
    private static final int POJO_ATTRIBUTE_FQN_INDEX = 4;
    private static final int POJO_KEY_FQN_INDEX = 5;
    private static final int POJO_KEY_FQN_SIZE = 6;
    private static Logger log_ = Logger.getLogger(CacheListener.class);
    private boolean fieldBased_;

    CacheListener(JBossCacheWrapper wrapper, JBossCacheManager manager, String hostname, String webapp) {
        super(manager, hostname, webapp);
        this.fieldBased_ = this.manager_.getReplicationGranularity() == ReplicationGranularity.FIELD;
    }

    @NodeRemoved
    public void nodeRemoved(NodeRemovedEvent event) {
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        Fqn fqn = event.getFqn();
        boolean isBuddy = CacheListener.isBuddyFqn(fqn);
        if (this.fieldBased_ && CacheListener.isFqnPojoKeySized(fqn, isBuddy) && this.isFqnForOurWebapp(fqn, isBuddy)) {
            String sessId = CacheListener.getIdFromFqn(fqn, isBuddy);
            String attrKey = CacheListener.getPojoKeyFromFqn(fqn, isBuddy);
            this.manager_.processRemoteAttributeRemoval(sessId, attrKey);
        } else if (CacheListener.isFqnSessionRootSized(fqn, isBuddy) && this.isFqnForOurWebapp(fqn, isBuddy)) {
            String sessId = CacheListener.getIdFromFqn(fqn, isBuddy);
            this.manager_.processRemoteInvalidation(sessId);
        }
    }

    @NodeModified
    public void nodeModified(NodeModifiedEvent event) {
        boolean isBuddy;
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        Fqn fqn = event.getFqn();
        if (!CacheListener.isFqnSessionRootSized(fqn, isBuddy = CacheListener.isBuddyFqn(fqn))) {
            return;
        }
        if (!this.isFqnForOurWebapp(fqn, isBuddy)) {
            return;
        }
        Integer version = (Integer)event.getData().get("VERSION");
        if (version != null) {
            String realId = CacheListener.getIdFromFqn(fqn, isBuddy);
            ClusteredSession session = this.manager_.findLocalSession(realId);
            if (session == null) {
                String owner = isBuddy ? CacheListener.getBuddyOwner(fqn) : null;
                this.manager_.unloadedSessionChanged(realId, owner);
            } else if (session.isNewData(version)) {
                session.setOutdatedVersion(version);
                if (log_.isTraceEnabled()) {
                    log_.trace((Object)("nodeDirty(): session in-memory data is invalidated with id: " + realId + " and version: " + version));
                }
            } else if (!isBuddy) {
                log_.warn((Object)("Possible concurrency problem: Replicated version id " + version + " matches in-memory version for session " + realId));
            }
        }
    }

    @CacheStarted
    public void cacheStarted(CacheStartedEvent event) {
    }

    @CacheStopped
    public void cacheStopped(CacheStoppedEvent event) {
    }

    public static boolean isFqnPojoKeySized(Fqn fqn, boolean isBuddy) {
        return fqn.size() == (isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 6 : 6);
    }

    public static String getPojoKeyFromFqn(Fqn fqn, boolean isBuddy) {
        return (String)fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 5 : 5);
    }
}

