/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.transaction.RollbackException;
import javax.transaction.TransactionManager;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.jboss.cache.CacheException;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.PassivationConfig;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.metadata.web.jboss.ReplicationTrigger;
import org.jboss.metadata.web.jboss.SnapshotMode;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.web.tomcat.service.session.AttributeBasedClusteredSession;
import org.jboss.web.tomcat.service.session.BatchReplicationClusteredSessionValve;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.ClusteredSessionValve;
import org.jboss.web.tomcat.service.session.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.FieldBasedClusteredSession;
import org.jboss.web.tomcat.service.session.InstantSnapshotManager;
import org.jboss.web.tomcat.service.session.IntervalSnapshotManager;
import org.jboss.web.tomcat.service.session.JBossCacheCluster;
import org.jboss.web.tomcat.service.session.JBossCacheClusteredSession;
import org.jboss.web.tomcat.service.session.JBossCacheManagerMBean;
import org.jboss.web.tomcat.service.session.JBossCacheService;
import org.jboss.web.tomcat.service.session.JBossManager;
import org.jboss.web.tomcat.service.session.JvmRouteValve;
import org.jboss.web.tomcat.service.session.SessionBasedClusteredSession;
import org.jboss.web.tomcat.service.session.SessionReplicationContext;
import org.jboss.web.tomcat.service.session.SnapshotManager;
import org.jboss.web.tomcat.service.session.Util;

public class JBossCacheManager
extends JBossManager
implements JBossCacheManagerMBean {
    static final String info_ = "JBossCacheManager/1.0";
    private TransactionManager tm;
    private JBossCacheService proxy_;
    private Map<String, OwnedSessionUpdate> unloadedSessions_ = new ConcurrentHashMap<String, OwnedSessionUpdate>();
    private AtomicInteger passivatedCount_ = new AtomicInteger();
    private int maxPassivatedCount_;
    private int maxLocalActiveCounter_;
    private PojoCache pojoCache_;
    private String cacheObjectNameString_ = "jboss.cache:service=TomcatClusteringCache";
    private Boolean useJK_;
    private boolean embedded_ = false;
    private MBeanServer mserver_ = null;
    private SnapshotMode snapshotMode_ = null;
    private int snapshotInterval_ = 0;
    private ReplicationGranularity replicationGranularity_;
    private Boolean replicationFieldBatchMode_;
    protected int passivationMaxObjectIdleTime_ = -1;
    protected int passivationMaxObjects_ = -1;
    private ClassLoader tcl_;
    private SnapshotManager snapshotManager_;

    public JBossCacheManager() {
    }

    public JBossCacheManager(PojoCache cache) {
        this.pojoCache_ = cache;
    }

    public void init(String name, JBossWebMetaData webMetaData) throws ClusteringNotSupportedException {
        Boolean batch;
        super.init(name, webMetaData);
        ReplicationConfig repCfg = webMetaData.getReplicationConfig();
        this.replicationGranularity_ = repCfg.getReplicationGranularity();
        Boolean jk = repCfg.getUseJK();
        if (jk != null) {
            this.useJK_ = jk;
        }
        this.replicationFieldBatchMode_ = (batch = repCfg.getReplicationFieldBatchMode()) == null ? Boolean.TRUE : batch;
        this.setSnapshotMode(repCfg.getSnapshotMode());
        Integer snapshotInt = repCfg.getSnapshotInterval();
        this.setSnapshotInterval(snapshotInt == null ? 0 : snapshotInt);
        if (this.passivationMode_) {
            PassivationConfig pConfig = webMetaData.getPassivationConfig();
            Integer max = pConfig.getObjectMaxIdleTime();
            if (max != null) {
                this.passivationMaxObjectIdleTime_ = max;
            }
            if ((max = pConfig.getMaxObjects()) != null) {
                this.passivationMaxObjects_ = max;
            }
        }
        this.log_.debug((Object)("init(): replicationGranularity_ is " + this.replicationGranularity_ + " and replicationFieldBatchMode is " + this.replicationFieldBatchMode_ + " and useJK is " + this.useJK_ + " and snapshotMode is " + this.snapshotMode_ + " and snapshotInterval is " + this.snapshotInterval_));
        PojoCache pc = this.getPojoCache();
        this.proxy_ = pc == null ? new JBossCacheService(this.cacheObjectNameString_) : new JBossCacheService(pc);
        this.validateFieldMarshalling();
        this.embedded_ = true;
    }

    public JBossCacheService getCacheService() {
        return this.proxy_;
    }

    public String getCacheObjectNameString() {
        return this.cacheObjectNameString_;
    }

    public void setCacheObjectNameString(String treeCacheObjectName) {
        this.cacheObjectNameString_ = treeCacheObjectName;
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode_;
    }

    public void setSnapshotMode(SnapshotMode snapshotMode) {
        this.snapshotMode_ = snapshotMode;
    }

    public int getSnapshotInterval() {
        return this.snapshotInterval_;
    }

    public void setSnapshotInterval(int snapshotInterval) {
        this.snapshotInterval_ = snapshotInterval;
    }

    public boolean getUseJK() {
        return this.useJK_ == null ? false : this.useJK_;
    }

    public void setUseJK(boolean useJK) {
        this.useJK_ = useJK;
    }

    public ReplicationGranularity getReplicationGranularity() {
        return this.replicationGranularity_;
    }

    public void setReplicationGranularity(ReplicationGranularity granularity) {
        this.replicationGranularity_ = granularity;
    }

    public String getReplicationGranularityString() {
        return this.replicationGranularity_ == null ? null : this.replicationGranularity_.toString();
    }

    public void setReplicationGranularityString(String granularity) {
        this.setReplicationGranularity(granularity == null ? null : ReplicationGranularity.fromString((String)granularity.toUpperCase()));
    }

    public String getReplicationTriggerString() {
        return this.replicationTrigger_ == null ? null : this.replicationTrigger_.toString();
    }

    public void setReplicationTriggerString(String trigger) {
        this.setReplicationTrigger(trigger == null ? null : ReplicationTrigger.fromString((String)trigger.toUpperCase()));
    }

    public Boolean isReplicationFieldBatchMode() {
        return this.replicationFieldBatchMode_;
    }

    public void setReplicationFieldBatchMode(boolean replicationFieldBatchMode) {
        this.replicationFieldBatchMode_ = replicationFieldBatchMode;
    }

    public void expireSession(String sessionId) {
        Session session = this.findSession(sessionId);
        if (session != null) {
            session.expire();
        }
    }

    public String getLastAccessedTime(String sessionId) {
        Session session = this.findSession(sessionId);
        if (session == null) {
            if (this.log_.isTraceEnabled()) {
                this.log_.trace((Object)("getLastAccessedTime(): Session " + sessionId + " not found"));
            }
            return "";
        }
        return new Date(session.getLastAccessedTime()).toString();
    }

    public Object getSessionAttribute(String sessionId, String key) {
        ClusteredSession session = (ClusteredSession)this.findSession(sessionId);
        return session == null ? null : session.getAttribute(key);
    }

    public String getSessionAttributeString(String sessionId, String key) {
        Object attr = this.getSessionAttribute(sessionId, key);
        return attr == null ? null : attr.toString();
    }

    public String listLocalSessionIds() {
        return this.reportSessionIds(this.sessions_.keySet());
    }

    public String listSessionIds() {
        HashSet ids = new HashSet(this.sessions_.keySet());
        ids.addAll(this.unloadedSessions_.keySet());
        return this.reportSessionIds(ids);
    }

    private String reportSessionIds(Set ids) {
        StringBuffer sb = new StringBuffer();
        boolean added = false;
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            if (added) {
                sb.append(',');
            } else {
                added = true;
            }
            sb.append(it.next());
        }
        return sb.toString();
    }

    public long getLocalActiveSessionCount() {
        return this.activeCounter_;
    }

    public long getMaxLocalActiveSessionCount() {
        return super.getMaxActiveSessionCount();
    }

    public long getMaxPassivatedSessionCount() {
        return 0L;
    }

    public long getPassivatedSessionCount() {
        return this.passivatedCount_.get();
    }

    public int getActiveSessions() {
        return this.calcActiveSessions();
    }

    public long getActiveSessionCount() {
        return this.calcActiveSessions();
    }

    public long getPassivationMaxIdleTime() {
        return this.passivationMaxIdleTime_;
    }

    public long getPassivationMinIdleTime() {
        return this.passivationMinIdleTime_;
    }

    public int getPassivationMaxObjectIdleTime() {
        return this.passivationMaxObjectIdleTime_;
    }

    public void setPassivationMaxObjectIdleTime(int passivationMaxObjectIdleTime) {
        this.passivationMaxObjectIdleTime_ = passivationMaxObjectIdleTime;
    }

    public int getPassivationMaxObjects() {
        return this.passivationMaxObjects_;
    }

    public void setPassivationMaxObjects(int passivationMaxObjects) {
        this.passivationMaxObjects_ = passivationMaxObjects;
    }

    public void start() throws LifecycleException {
        if (this.embedded_) {
            this.startEmbedded();
        } else {
            this.startUnembedded();
        }
        this.log_.debug((Object)("JBossCacheManager for " + this.getContainer().getName() + " started"));
    }

    public void stop() throws LifecycleException {
        if (!this.started_) {
            throw new IllegalStateException("Manager not started");
        }
        this.log_.debug((Object)"Stopping");
        this.resetStats();
        this.lifecycle_.fireLifecycleEvent("before_stop", (Object)this);
        this.clearSessions();
        this.tcl_ = null;
        this.proxy_.stop();
        this.tm = null;
        this.snapshotManager_.stop();
        this.sessions_.clear();
        this.unloadedSessions_.clear();
        this.passivatedCount_.set(0);
        this.started_ = false;
        this.lifecycle_.fireLifecycleEvent("after_stop", (Object)this);
        try {
            this.unregisterMBeans();
        }
        catch (Exception e) {
            this.log_.error((Object)"Could not unregister ManagerMBean from MBeanServer", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearSessions() {
        boolean passivation = this.isPassivationEnabled();
        ClusteredSession[] sessions = this.findLocalSessions();
        for (int i = 0; i < sessions.length; ++i) {
            ClusteredSession ses = sessions[i];
            if (this.log_.isTraceEnabled()) {
                this.log_.trace((Object)("clearSessions(): clear session by expiring or passivating: " + ses));
            }
            boolean notify = true;
            boolean localCall = true;
            boolean localOnly = true;
            try {
                if (passivation && ses.isValid()) {
                    this.processSessionPassivation(ses.getRealId());
                    continue;
                }
                ses.expire(notify, localCall, localOnly);
                continue;
            }
            catch (Throwable t) {
                this.log_.warn((Object)("clearSessions(): Caught exception expiring or passivating session " + ses.getIdInternal()), t);
                continue;
            }
            finally {
                ses.recycle();
            }
        }
        Set<Map.Entry<String, OwnedSessionUpdate>> unloaded = this.unloadedSessions_.entrySet();
        Iterator<Map.Entry<String, OwnedSessionUpdate>> it = unloaded.iterator();
        while (it.hasNext()) {
            Map.Entry<String, OwnedSessionUpdate> entry = it.next();
            String realId = entry.getKey();
            if (passivation) {
                OwnedSessionUpdate osu = entry.getValue();
                if (!osu.passivated) {
                    this.proxy_.evictSession(realId, osu.owner);
                }
            } else {
                this.proxy_.removeSessionLocal(realId);
            }
            it.remove();
        }
    }

    public Session createSession() {
        return this.createSession(null);
    }

    public Session createSession(String sessionId) {
        if (this.maxActive_ != -1 && this.calcActiveSessions() >= this.maxActive_) {
            if (this.log_.isTraceEnabled()) {
                this.log_.trace((Object)("createSession(): active sessions = " + this.calcActiveSessions() + " and max allowed sessions = " + this.maxActive_));
            }
            this.processExpires();
            if (this.calcActiveSessions() >= this.maxActive_) {
                ++this.rejectedCounter_;
                String msgEnd = sessionId == null ? "" : " id " + sessionId;
                throw new IllegalStateException("createSession(): number of active sessions exceeds the maximum limit: " + this.maxActive_ + " when trying to create session" + msgEnd);
            }
        }
        ClusteredSession session = this.createEmptyClusteredSession();
        session.setNew(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval_);
        session.setValid(true);
        if (sessionId == null) {
            sessionId = this.getNextId();
            if (this.getUseJK()) {
                if (this.log_.isTraceEnabled()) {
                    this.log_.trace((Object)("createSession(): useJK is true. Will append JvmRoute: " + this.getJvmRoute()));
                }
                sessionId = sessionId + "." + this.getJvmRoute();
            }
        }
        session.setId(sessionId);
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("Created a ClusteredSession with id: " + sessionId));
        }
        ++this.createdCounter_;
        SessionReplicationContext.bindSession(session, this.snapshotManager_);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeSession(Session baseSession) {
        boolean stored = false;
        if (baseSession != null && this.started_) {
            ClusteredSession session;
            ClusteredSession clusteredSession = session = (ClusteredSession)baseSession;
            synchronized (clusteredSession) {
                if (this.log_.isTraceEnabled()) {
                    this.log_.trace((Object)("check to see if needs to store and replicate session with id " + session.getIdInternal()));
                }
                if (session.isValid() && (session.isSessionDirty() || session.getExceedsMaxUnreplicatedInterval())) {
                    String realId = session.getRealId();
                    long begin = System.currentTimeMillis();
                    session.passivate();
                    long elapsed = System.currentTimeMillis() - begin;
                    this.stats_.updatePassivationStats(realId, elapsed);
                    begin = System.currentTimeMillis();
                    this.processSessionRepl(session);
                    elapsed = System.currentTimeMillis() - begin;
                    stored = true;
                    this.stats_.updateReplicationStats(realId, elapsed);
                } else if (this.log_.isTraceEnabled()) {
                    this.log_.trace((Object)("Session " + session.getIdInternal() + " did not require replication."));
                }
            }
        }
        return stored;
    }

    public void add(Session session) {
        if (session == null) {
            return;
        }
        if (!(session instanceof ClusteredSession)) {
            throw new IllegalArgumentException("You can only add instances of type ClusteredSession to this Manager. Session class name: " + session.getClass().getName());
        }
        this.add((ClusteredSession)session, false);
    }

    private void add(ClusteredSession session, boolean replicate) {
        if (!session.isValid()) {
            this.log_.error((Object)("Cannot add session with id=" + session.getIdInternal() + " because it is invalid"));
            return;
        }
        String realId = session.getRealId();
        ClusteredSession existing = this.sessions_.put(realId, session);
        this.unloadedSessions_.remove(realId);
        if (!session.equals(existing)) {
            if (replicate) {
                this.storeSession((Session)session);
            }
            this.calcActiveSessions();
            if (this.log_.isTraceEnabled()) {
                this.log_.trace((Object)("Session with id=" + session.getIdInternal() + " added. " + "Current active sessions " + this.activeCounter_));
            }
        }
    }

    public Session createEmptySession() {
        return this.createEmptyClusteredSession();
    }

    private ClusteredSession createEmptyClusteredSession() {
        this.log_.trace((Object)"Creating an empty ClusteredSession");
        JBossCacheClusteredSession session = null;
        switch (this.replicationGranularity_) {
            case ATTRIBUTE: {
                session = new AttributeBasedClusteredSession(this);
                break;
            }
            case FIELD: {
                session = new FieldBasedClusteredSession(this);
                break;
            }
            default: {
                session = new SessionBasedClusteredSession(this);
            }
        }
        return session;
    }

    public Session findSession(String id) {
        String realId = this.getRealId(id);
        ClusteredSession session = this.findLocalSession(realId);
        if (session == null && !SessionReplicationContext.isSessionBoundAndExpired(realId, this.snapshotManager_)) {
            if (this.log_.isTraceEnabled()) {
                this.log_.trace((Object)("Checking for session " + realId + " in the distributed cache"));
            }
            if ((session = this.loadSession(realId)) != null) {
                this.add((Session)session);
            }
        } else if (session != null && session.isOutdated()) {
            if (this.log_.isTraceEnabled()) {
                this.log_.trace((Object)("Updating session " + realId + " from the distributed cache"));
            }
            this.loadSession(realId);
        }
        if (session != null) {
            SessionReplicationContext.bindSession(session, this.snapshotManager_);
        }
        return session;
    }

    public Session[] findSessions() {
        if (this.unloadedSessions_.size() > 0) {
            HashSet<String> ids = new HashSet<String>(this.unloadedSessions_.keySet());
            if (this.log_.isTraceEnabled()) {
                this.log_.trace((Object)("findSessions: loading sessions from distributed cache: " + ids));
            }
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                this.loadSession((String)it.next());
            }
        }
        return this.findLocalSessions();
    }

    public ClusteredSession[] findLocalSessions() {
        Collection coll = this.sessions_.values();
        ClusteredSession[] sess = new ClusteredSession[coll.size()];
        sess = coll.toArray(sess);
        return sess;
    }

    public ClusteredSession findLocalSession(String realId) {
        return (ClusteredSession)this.sessions_.get(realId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session) {
        ClusteredSession clusterSess;
        ClusteredSession clusteredSession = clusterSess = (ClusteredSession)session;
        synchronized (clusteredSession) {
            String realId = clusterSess.getRealId();
            if (realId == null) {
                return;
            }
            if (this.log_.isTraceEnabled()) {
                this.log_.trace((Object)("Removing session from store with id: " + realId));
            }
            try {
                SessionReplicationContext.startCacheActivity();
                clusterSess.removeMyself();
            }
            finally {
                SessionReplicationContext.finishCacheActivity();
                SessionReplicationContext.sessionExpired(clusterSess, realId, this.snapshotManager_);
                this.sessions_.remove(realId);
                this.stats_.removeStats(realId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocal(Session session) {
        ClusteredSession clusterSess;
        ClusteredSession clusteredSession = clusterSess = (ClusteredSession)session;
        synchronized (clusteredSession) {
            String realId = clusterSess.getRealId();
            if (realId == null) {
                return;
            }
            if (this.log_.isTraceEnabled()) {
                this.log_.trace((Object)("Removing session from local store with id: " + realId));
            }
            try {
                SessionReplicationContext.startCacheActivity();
                clusterSess.removeMyselfLocal();
            }
            finally {
                SessionReplicationContext.finishCacheActivity();
                SessionReplicationContext.sessionExpired(clusterSess, realId, this.snapshotManager_);
                this.sessions_.remove(realId);
                this.stats_.removeStats(realId);
                ++this.expiredCounter_;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClusteredSession loadSession(String realId) {
        if (realId == null) {
            return null;
        }
        long begin = System.currentTimeMillis();
        boolean mustAdd = false;
        ClusteredSession session = (ClusteredSession)this.sessions_.get(realId);
        if (session == null) {
            mustAdd = true;
            session = this.createEmptyClusteredSession();
        }
        ClusteredSession clusteredSession = session;
        synchronized (clusteredSession) {
            boolean doTx = false;
            try {
                if (this.tm.getTransaction() == null) {
                    doTx = true;
                }
                if (doTx) {
                    this.tm.begin();
                }
                SessionReplicationContext.startCacheActivity();
                session = this.proxy_.loadSession(realId, session);
            }
            catch (Exception ex) {
                try {
                    this.tm.setRollbackOnly();
                }
                catch (Exception exn) {
                    this.log_.error((Object)"Caught exception rolling back transaction", (Throwable)exn);
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException("loadSession(): failed to load session " + realId, ex);
            }
            finally {
                try {
                    if (doTx) {
                        this.endTransaction(realId);
                    }
                }
                finally {
                    SessionReplicationContext.finishCacheActivity();
                }
            }
            if (session != null) {
                session.initAfterLoad(this);
                if (mustAdd) {
                    this.add(session, false);
                }
                long elapsed = System.currentTimeMillis() - begin;
                this.stats_.updateLoadStats(realId, elapsed);
                if (this.log_.isTraceEnabled()) {
                    this.log_.trace((Object)("loadSession(): id= " + realId + ", session=" + session));
                }
            } else if (this.log_.isTraceEnabled()) {
                this.log_.trace((Object)("loadSession(): session " + realId + " not found in distributed cache"));
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSessionRepl(ClusteredSession session) {
        boolean notSession = this.replicationGranularity_ != ReplicationGranularity.SESSION;
        boolean doTx = false;
        try {
            if (notSession && this.tm.getTransaction() == null) {
                doTx = true;
            }
            if (doTx) {
                this.tm.begin();
            }
            SessionReplicationContext.startCacheActivity();
            session.processSessionRepl();
        }
        catch (Exception ex) {
            this.log_.debug((Object)"processSessionRepl(): failed with exception", (Throwable)ex);
            try {
                if (notSession) {
                    this.tm.setRollbackOnly();
                }
            }
            catch (Exception exn) {
                this.log_.error((Object)"Caught exception rolling back transaction", (Throwable)exn);
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException("JBossCacheManager.processSessionRepl(): failed to replicate session.", ex);
        }
        finally {
            try {
                if (doTx) {
                    this.endTransaction(session.getId());
                }
            }
            finally {
                SessionReplicationContext.finishCacheActivity();
            }
        }
    }

    protected void endTransaction(String id) {
        if (this.tm == null) {
            this.log_.warn((Object)("JBossCacheManager.endTransaction(): tm is null for id: " + id));
            return;
        }
        try {
            if (this.tm.getTransaction().getStatus() != 1) {
                this.tm.commit();
            } else {
                this.log_.info((Object)("JBossCacheManager.endTransaction(): rolling back tx for id: " + id));
                this.tm.rollback();
            }
        }
        catch (RollbackException re) {
            this.log_.warn((Object)("JBossCacheManager.endTransaction(): rolling back transaction with exception: " + (Object)((Object)re)));
        }
        catch (Exception e) {
            throw new RuntimeException("JBossCacheManager.endTransaction(): Exception for id: " + id, e);
        }
    }

    protected ClassLoader getWebappClassLoader() {
        return this.tcl_;
    }

    protected void processExpires() {
        boolean expire = this.maxInactiveInterval_ >= 0;
        boolean passivate = this.isPassivationEnabled();
        if (!expire && !passivate) {
            return;
        }
        long expirationInterval = (long)this.maxInactiveInterval_ * 1000L;
        long passivationMax = (long)this.passivationMaxIdleTime_ * 1000L;
        long passivationMin = (long)this.passivationMinIdleTime_ * 1000L;
        boolean trace = this.log_.isTraceEnabled();
        if (trace) {
            this.log_.trace((Object)"processExpires(): Looking for sessions that have expired ...");
            this.log_.trace((Object)("processExpires(): active sessions = " + this.calcActiveSessions()));
            this.log_.trace((Object)("processExpires(): expired sessions = " + this.expiredCounter_));
            if (passivate) {
                this.log_.trace((Object)("processExpires(): passivated count = " + this.getPassivatedSessionCount()));
            }
        }
        try {
            ClusteredSession[] sessions = this.findLocalSessions();
            for (int i = 0; i < sessions.length; ++i) {
                try {
                    ClusteredSession session = sessions[i];
                    if (session == null) {
                        this.log_.warn((Object)("processExpires(): processing null session at index " + i));
                        continue;
                    }
                    if (expire) {
                        if (session.isOutdated() && !session.isValid(false)) {
                            this.loadSession(session.getRealId());
                        }
                        if (!session.isValid()) continue;
                    }
                    if (!passivate) continue;
                    long timeNow = System.currentTimeMillis();
                    long timeIdle = timeNow - session.getLastAccessedTimeInternal();
                    if (passivationMax >= 0L && timeIdle > passivationMax) {
                        this.processSessionPassivation(session.getRealId());
                        continue;
                    }
                    if (this.maxActive_ <= 0 || passivationMin <= 0L || this.calcActiveSessions() < this.maxActive_ || timeIdle <= passivationMin) continue;
                    this.processSessionPassivation(session.getRealId());
                    continue;
                }
                catch (Exception ex) {
                    this.log_.error((Object)("processExpires(): failed expiring " + sessions[i].getIdInternal() + " with exception: " + ex), (Throwable)ex);
                }
            }
            long now = System.currentTimeMillis();
            HashMap<String, OwnedSessionUpdate> unloaded = new HashMap<String, OwnedSessionUpdate>(this.unloadedSessions_);
            Set entries = unloaded.entrySet();
            for (Map.Entry entry : entries) {
                String realId = (String)entry.getKey();
                OwnedSessionUpdate osu = (OwnedSessionUpdate)entry.getValue();
                if (osu.passivated) continue;
                long elapsed = now - osu.updateTime;
                try {
                    if (expire && elapsed >= expirationInterval) {
                        this.proxy_.removeSessionLocal(realId, osu.owner);
                        this.unloadedSessions_.remove(realId);
                        continue;
                    }
                    if (!passivate) continue;
                    if (passivationMax >= 0L && elapsed > passivationMax) {
                        this.processUnloadedSessionPassivation(realId, osu);
                        continue;
                    }
                    if (this.maxActive_ <= 0 || passivationMin < 0L || this.calcActiveSessions() < this.maxActive_ || elapsed < passivationMin) continue;
                    this.processUnloadedSessionPassivation(realId, osu);
                }
                catch (Exception ex) {
                    this.log_.error((Object)("processExpires(): failed removing unloaded session " + realId), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            this.log_.error((Object)("processExpires: failed with exception: " + ex), (Throwable)ex);
        }
        if (trace) {
            this.log_.trace((Object)"processExpires(): Completed ...");
            this.log_.trace((Object)("processExpires(): active sessions = " + this.calcActiveSessions()));
            this.log_.trace((Object)("processExpires(): expired sessions = " + this.expiredCounter_));
            if (passivate) {
                this.log_.trace((Object)("processExpires(): passivated count = " + this.getPassivatedSessionCount()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRemoteAttributeRemoval(String realId, String attrKey) {
        ClusteredSession session = this.findLocalSession(realId);
        if (session != null) {
            boolean localCall = false;
            boolean localOnly = true;
            boolean notify = false;
            ClassLoader prevTcl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.tcl_);
                ClusteredSession clusteredSession = session;
                synchronized (clusteredSession) {
                    session.removeAttributeInternal(attrKey, localCall, localOnly, notify);
                }
                if (this.log_.isTraceEnabled()) {
                    this.log_.trace((Object)("processRemoteAttributeRemoval: removed attribute " + attrKey + " from " + realId));
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevTcl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRemoteInvalidation(String realId) {
        ClusteredSession session = (ClusteredSession)this.sessions_.remove(realId);
        if (session == null) {
            if (this.unloadedSessions_.remove(realId) != null && this.log_.isTraceEnabled()) {
                this.log_.trace((Object)("Removed entry for session " + realId + " from unloaded session map"));
            }
        } else {
            boolean notify = false;
            boolean localCall = false;
            boolean localOnly = true;
            ClassLoader prevTcl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.tcl_);
                session.expire(notify, localCall, localOnly);
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevTcl);
            }
            this.stats_.removeStats(realId);
        }
    }

    private void sessionPassivated() {
        int pc = this.passivatedCount_.incrementAndGet();
        if (pc > this.maxPassivatedCount_) {
            this.maxPassivatedCount_ = pc;
        }
    }

    public void sessionActivated() {
        int pc = this.passivatedCount_.decrementAndGet();
        if (pc < 0) {
            this.passivatedCount_.incrementAndGet();
        }
    }

    private int calcActiveSessions() {
        int count;
        this.activeCounter_ = this.sessions_.size();
        if (this.activeCounter_ > this.maxLocalActiveCounter_) {
            this.maxLocalActiveCounter_ = this.activeCounter_;
        }
        if ((count = this.activeCounter_ + this.unloadedSessions_.size() - this.passivatedCount_.get()) > this.maxActiveCounter_) {
            this.maxActiveCounter_ = count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessionPassivation(String realId) {
        ClusteredSession session = this.findLocalSession(realId);
        if (session != null) {
            ClusteredSession clusteredSession = session;
            synchronized (clusteredSession) {
                if (this.log_.isTraceEnabled()) {
                    this.log_.trace((Object)("Passivating session with id: " + realId));
                }
                try {
                    SessionReplicationContext.startCacheActivity();
                    session.passivate();
                    this.proxy_.evictSession(realId);
                    this.sessionPassivated();
                }
                finally {
                    SessionReplicationContext.finishCacheActivity();
                }
                OwnedSessionUpdate obj = this.unloadedSessions_.put(realId, new OwnedSessionUpdate(null, session.getLastAccessedTime(), true));
                if (this.log_.isTraceEnabled()) {
                    if (obj == null) {
                        this.log_.trace((Object)("New session " + realId + " added to unloaded session map"));
                    } else {
                        this.log_.trace((Object)("Updated timestamp for unloaded session " + realId));
                    }
                }
                this.sessions_.remove(realId);
            }
        }
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("processSessionPassivation():  could not find session " + realId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUnloadedSessionPassivation(String realId, OwnedSessionUpdate osu) {
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("Passivating session with id: " + realId));
        }
        try {
            SessionReplicationContext.startCacheActivity();
            this.proxy_.evictSession(realId, osu.owner);
            osu.passivated = true;
            this.sessionPassivated();
        }
        finally {
            SessionReplicationContext.finishCacheActivity();
        }
    }

    protected String getRealId(String id) {
        return this.getUseJK() ? Util.getRealId(id) : id;
    }

    protected void unloadedSessionChanged(String realId, String dataOwner) {
        OwnedSessionUpdate obj = this.unloadedSessions_.put(realId, new OwnedSessionUpdate(dataOwner, System.currentTimeMillis(), false));
        if (this.log_.isTraceEnabled()) {
            if (obj == null) {
                this.log_.trace((Object)("New session " + realId + " added to unloaded session map"));
                this.calcActiveSessions();
            } else {
                this.log_.trace((Object)("Updated timestamp for unloaded session " + realId));
            }
        }
    }

    public boolean isPassivationEnabled() {
        return this.passivationMode_ && this.proxy_.isCachePassivationEnabled();
    }

    private void startEmbedded() throws LifecycleException {
        super.start();
        this.tcl_ = super.getContainer().getLoader().getClassLoader();
        this.proxy_.start(this.tcl_, this);
        this.tm = this.proxy_.getTransactionManager();
        if (this.tm == null) {
            throw new LifecycleException("JBossCacheManager.start(): Obtain null tm");
        }
        try {
            this.initializeUnloadedSessions();
            this.initSnapshotManager();
            this.installValves();
            this.log_.debug((Object)"start(): JBossCacheService started");
        }
        catch (Exception e) {
            this.log_.error((Object)"Unable to start manager.", (Throwable)e);
            throw new LifecycleException((Throwable)e);
        }
    }

    private void startUnembedded() throws LifecycleException {
        if (this.started_) {
            return;
        }
        this.log_.info((Object)"Manager is about to start");
        this.lifecycle_.fireLifecycleEvent("before_start", (Object)this);
        if (this.snapshotMode_ == null) {
            try {
                JBossCacheCluster cluster = (JBossCacheCluster)this.container_.getCluster();
                cluster.configureManager(this);
            }
            catch (ClassCastException e) {
                String msg = "Cluster is not an instance of JBossCacheCluster";
                this.log_.error((Object)msg, (Throwable)e);
                throw new LifecycleException(msg, (Throwable)e);
            }
        }
        try {
            PojoCache pc = this.getPojoCache();
            this.proxy_ = pc == null ? new JBossCacheService(this.cacheObjectNameString_) : new JBossCacheService(pc);
            this.validateFieldMarshalling();
            this.tcl_ = this.container_.getLoader().getClassLoader();
            this.proxy_.start(this.tcl_, this);
        }
        catch (Throwable t) {
            String str = "Problem starting JBossCacheService for Tomcat clustering";
            this.log_.error((Object)str, t);
            throw new LifecycleException(str, t);
        }
        this.tm = this.proxy_.getTransactionManager();
        if (this.tm == null) {
            throw new LifecycleException("JBossCacheManager.start(): Obtain null tm");
        }
        try {
            this.initializeUnloadedSessions();
            this.installValves();
            this.started_ = true;
            this.lifecycle_.fireLifecycleEvent("after_start", (Object)this);
            this.log_.debug((Object)"start(): JBossCacheService started");
        }
        catch (Exception e) {
            this.log_.error((Object)"Unable to start manager.", (Throwable)e);
            throw new LifecycleException((Throwable)e);
        }
        try {
            this.registerMBeans();
        }
        catch (Exception e) {
            this.log_.error((Object)"Could not register ManagerMBean with MBeanServer", (Throwable)e);
        }
    }

    private void registerMBeans() {
        try {
            MBeanServer server = this.getMBeanServer();
            String domain = this.container_ instanceof ContainerBase ? ((ContainerBase)this.container_).getDomain() : server.getDefaultDomain();
            String hostName = ((Host)this.container_.getParent()).getName();
            hostName = hostName == null ? "localhost" : hostName;
            ObjectName clusterName = new ObjectName(domain + ":service=ClusterManager,WebModule=//" + hostName + ((Context)this.container_).getPath());
            if (server.isRegistered(clusterName)) {
                this.log_.warn((Object)("MBean " + clusterName + " already registered"));
                return;
            }
            this.objectName_ = clusterName;
            server.registerMBean(this, clusterName);
        }
        catch (Exception ex) {
            this.log_.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void unregisterMBeans() {
        if (this.mserver_ != null) {
            try {
                this.mserver_.unregisterMBean(this.objectName_);
            }
            catch (Exception e) {
                this.log_.error((Object)e);
            }
        }
    }

    private MBeanServer getMBeanServer() throws Exception {
        if (this.mserver_ == null) {
            this.mserver_ = MBeanServerLocator.locateJBoss();
        }
        return this.mserver_;
    }

    private void initializeUnloadedSessions() throws CacheException {
        Map<String, String> sessions = this.proxy_.getSessionIds();
        if (sessions != null) {
            boolean passivateExcess = this.isPassivationEnabled() && this.maxActive_ > 0 && this.passivationMinIdleTime_ >= 0;
            long now = System.currentTimeMillis();
            for (Map.Entry<String, String> entry : sessions.entrySet()) {
                String realId = entry.getKey();
                OwnedSessionUpdate osu = new OwnedSessionUpdate(entry.getValue(), now, false);
                this.unloadedSessions_.put(realId, osu);
                if (!passivateExcess || this.calcActiveSessions() <= this.maxActive_) continue;
                this.processUnloadedSessionPassivation(realId, osu);
            }
        }
    }

    private void installValves() {
        if (this.useJK_ == null) {
            this.useJK_ = this.getJvmRoute() != null;
        }
        if (this.getUseJK()) {
            this.log_.debug((Object)"We are using JK for load-balancing. Adding JvmRouteValve.");
            this.installContextValve((Valve)new JvmRouteValve(this));
        }
        if (this.replicationGranularity_ == ReplicationGranularity.FIELD && Boolean.TRUE.equals(this.replicationFieldBatchMode_)) {
            BatchReplicationClusteredSessionValve batchValve = new BatchReplicationClusteredSessionValve(this);
            this.log_.debug((Object)"Adding BatchReplicationClusteredSessionValve for batch replication.");
            this.installContextValve((Valve)batchValve);
        }
        ClusteredSessionValve valve = new ClusteredSessionValve();
        this.installContextValve((Valve)valve);
    }

    private void initSnapshotManager() {
        String ctxPath = ((Context)this.container_).getPath();
        if (SnapshotMode.INSTANT == this.snapshotMode_) {
            this.snapshotManager_ = new InstantSnapshotManager(this, ctxPath);
        } else if (this.snapshotMode_ == null) {
            this.log_.warn((Object)"Snapshot mode must be 'instant' or 'interval' - using 'instant'");
            this.snapshotMode_ = SnapshotMode.INSTANT;
            this.snapshotManager_ = new InstantSnapshotManager(this, ctxPath);
        } else {
            if (ReplicationGranularity.FIELD == this.replicationGranularity_) {
                throw new IllegalStateException("Property snapshotMode must be " + SnapshotMode.INTERVAL + " when FIELD granularity is used");
            }
            if (this.snapshotInterval_ < 1) {
                this.log_.warn((Object)"Snapshot mode set to 'interval' but snapshotInterval is < 1 using 'instant'");
                this.snapshotMode_ = SnapshotMode.INSTANT;
                this.snapshotManager_ = new InstantSnapshotManager(this, ctxPath);
            } else {
                this.snapshotManager_ = new IntervalSnapshotManager(this, ctxPath, this.snapshotInterval_);
            }
        }
        this.snapshotManager_.start();
    }

    private void installContextValve(Valve valve) {
        boolean installed = false;
        if (this.embedded_ && this.getContextObjectName() != null) {
            try {
                this.getMBeanServer().invoke(this.getContextObjectName(), "addValve", new Object[]{valve}, new String[]{"org.apache.catalina.Valve"});
                installed = true;
            }
            catch (Exception e) {
                this.log_.debug((Object)"Caught exception installing valve to Context", (Throwable)e);
            }
        }
        if (!installed) {
            if (this.container_ instanceof ContainerBase) {
                ((ContainerBase)this.container_).addValve(valve);
            } else {
                this.container_.getPipeline().addValve(valve);
            }
        }
    }

    private void validateFieldMarshalling() {
        if (this.replicationGranularity_ == ReplicationGranularity.FIELD && !this.proxy_.isMarshallingAvailable()) {
            throw new IllegalStateException("replication-granularity value is set to 'FIELD' but is not supported by the cache service configuration. Must set 'UseRegionBasedMarshalling' to 'true' in the jboss-web-cluster.sar jboss-service.xml");
        }
    }

    private ObjectName getContextObjectName() {
        String oname = this.container_.getObjectName();
        try {
            return oname == null ? null : new ObjectName(oname);
        }
        catch (MalformedObjectNameException e) {
            this.log_.warn((Object)("Error creating object name from string " + oname), (Throwable)e);
            return null;
        }
    }

    public PojoCache getPojoCache() {
        return this.pojoCache_;
    }

    private class OwnedSessionUpdate {
        String owner;
        long updateTime;
        boolean passivated;

        OwnedSessionUpdate(String owner, long updateTime, boolean passivated) {
            this.owner = owner;
            this.updateTime = updateTime;
            this.passivated = passivated;
        }
    }
}

