/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.util.Map;
import java.util.Set;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.pojo.PojoCache;

public class JBossCacheWrapper {
    private static final int RETRY = 3;
    private static final String RETRY_FAIL_MSG = "Continued to catch TimeoutException during 3 retry attempts. Giving up.";
    private PojoCache pojoCache_;
    private Cache plainCache_;

    JBossCacheWrapper(PojoCache cache) {
        this.pojoCache_ = cache;
        this.plainCache_ = this.pojoCache_.getCache();
    }

    Object get(Fqn fqn, String id) {
        return this.get(fqn, id, false);
    }

    Object get(Fqn fqn, String id, boolean gravitate) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                Object value = null;
                if (gravitate) {
                    this.plainCache_.getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
                    value = this.plainCache_.get(fqn, (Object)id);
                } else {
                    value = this.plainCache_.get(fqn, (Object)id);
                }
                return value;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    void put(Fqn fqn, String id, Object value) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.plainCache_.put(fqn, (Object)id, value);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    void put(Fqn fqn, Map map) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.plainCache_.put(fqn, map);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    Object remove(Fqn fqn, String id) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.plainCache_.remove(fqn, (Object)id);
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    void remove(Fqn fqn) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.plainCache_.removeNode(fqn);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    void removeLocal(Fqn fqn) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.plainCache_.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                this.plainCache_.removeNode(fqn);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    void evict(Fqn fqn) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.plainCache_.evict(fqn, false);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    void evictSubtree(Fqn fqn) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.plainCache_.evict(fqn, true);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    void removeLocalSubtree(Fqn fqn) {
        this.removeLocal(fqn);
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                Set children;
                this.removeLocal(fqn);
                Node base = this.plainCache_.getRoot().getChild(fqn);
                if (base != null && (children = base.getChildren()) != null) {
                    for (Node child : children) {
                        this.removeLocalSubtree(child.getFqn());
                    }
                    this.removeLocal(fqn);
                }
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }
}

