/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.jboss.invocation.MarshalledValue;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jboss.invocation.MarshalledValueOutputStream;
import org.jboss.logging.Logger;
import org.jboss.serial.io.JBossObjectInputStreamSharedTree;
import org.jboss.serial.io.JBossObjectOutputStreamSharedTree;
import org.jboss.serial.io.MarshalledObject;

public class SessionSerializationFactory {
    static Logger log_ = Logger.getLogger(SessionSerializationFactory.class);
    static boolean useJBossSerialization = false;

    public static ObjectOutputStream createObjectOutputStream(OutputStream out) throws IOException {
        return useJBossSerialization ? new JBossObjectOutputStreamSharedTree(out) : new MarshalledValueOutputStream(out);
    }

    public static ObjectInputStream createObjectInputStream(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return useJBossSerialization ? new JBossObjectInputStreamSharedTree((InputStream)in) : new MarshalledValueInputStream((InputStream)in);
    }

    public static MarshalledValue createMarshalledValue(Object o) throws IOException {
        return new MarshalledValue(o);
    }

    public static MarshalledObject createMarshalledObject(Object o) throws IOException {
        return new MarshalledObject(o);
    }

    public static boolean useJBossSerialization() {
        return useJBossSerialization;
    }

    static {
        String useJBossSerializationStr = System.getProperty("session.serialization.jboss", "false");
        useJBossSerialization = Boolean.valueOf(useJBossSerializationStr);
        try {
            if (useJBossSerialization) {
                log_.debug((Object)"Using JBossSerialization for web session replication");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

