/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.sso;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.util.LifecycleSupport;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.Region;
import org.jboss.cache.RegionNotEmptyException;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.notifications.event.NodeRemovedEvent;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.threadpool.ThreadPool;
import org.jboss.web.tomcat.service.sso.ClusteredSingleSignOn;
import org.jboss.web.tomcat.service.sso.JBossSingleSignOnEntry;
import org.jboss.web.tomcat.service.sso.SSOClusterManager;
import org.jgroups.Address;

@CacheListener
public final class TreeCacheSSOClusterManager
implements SSOClusterManager {
    private static final String CREDENTIALS = "credentials";
    private static final String SSO = "SSO";
    private static final String SESSIONS = "sessions";
    private static final String KEY = "key";
    public static final String DEFAULT_GLOBAL_CACHE_NAME = "jboss.cache:service=ClusteredSSOCache";
    public static final String DEFAULT_THREAD_POOL_NAME = "jboss.system:service=ThreadPool";
    private ThreadLocal<String> beingLocallyAdded = new ThreadLocal();
    private ThreadLocal<String> beingLocallyRemoved = new ThreadLocal();
    private ThreadLocal<String> beingRemotelyRemoved = new ThreadLocal();
    private ObjectName cacheObjectName = null;
    private String cacheName = null;
    private Cache cache = null;
    private TransactionManager tm = null;
    private String threadPoolName = "jboss.system:service=ThreadPool";
    private ThreadPool threadPool;
    private LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private Logger log = Logger.getLogger((String)this.getClass().getName());
    private boolean registeredAsListener = false;
    private MBeanServer server = null;
    private ClusteredSingleSignOn ssoValve = null;
    private boolean started = false;
    private boolean treeCacheAvailable = false;
    private boolean missingCacheErrorLogged = false;
    private Serializable localAddress = null;
    private Set currentView = new HashSet();
    private Object cleanupMutex = new Object();

    public TreeCacheSSOClusterManager() {
        this.server = MBeanServerLocator.locateJBoss();
        if (this.server == null) {
            this.server = MBeanServerLocator.locate();
        }
    }

    public TreeCacheSSOClusterManager(MBeanServer server) {
        this.server = server;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String objectName) throws Exception {
        if (objectName == null) {
            this.setCacheObjectName(null);
        } else if (!objectName.equals(this.cacheName)) {
            this.setCacheObjectName(new ObjectName(objectName));
        }
    }

    public ObjectName getCacheObjectName() {
        return this.cacheObjectName;
    }

    public void setCacheObjectName(ObjectName objectName) throws Exception {
        if (objectName != null && objectName.equals(this.cacheObjectName) || this.cacheObjectName != null && this.cacheObjectName.equals(objectName) || objectName == null && this.cacheObjectName == null) {
            return;
        }
        this.removeAsCacheListener();
        this.tm = null;
        this.cacheObjectName = objectName;
        String string = this.cacheName = objectName == null ? null : objectName.getCanonicalName();
        if (!this.isTreeCacheAvailable(true)) {
            if (this.started) {
                this.logMissingCacheError();
            } else {
                this.log.info((Object)("Cannot find TreeCache using " + this.cacheName + " -- tree" + "CacheName must be set to point to a running TreeCache " + "before ClusteredSingleSignOn can handle requests"));
            }
        }
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public void setThreadPoolName(String threadPoolName) {
        if (this.started) {
            this.log.info((Object)"Call to setThreadPoolName() ignored; already started");
        } else {
            this.threadPoolName = threadPoolName;
        }
    }

    public boolean isUsingThreadPool() {
        return this.threadPool != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(String ssoId, Session session) {
        if (ssoId == null || session == null) {
            return;
        }
        if (!this.checkTreeCacheAvailable()) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("addSession(): adding Session " + session.getId() + " to cached session set for SSO " + ssoId));
        }
        Fqn fqn = this.getSessionsFqn(ssoId);
        boolean doTx = false;
        try {
            if (this.tm == null) {
                this.configureFromCache();
            }
            if (this.tm.getTransaction() == null) {
                doTx = true;
            }
            if (doTx) {
                this.tm.begin();
            }
            this.putInTreeCache(fqn, session.getId(), null);
        }
        catch (Exception e) {
            try {
                if (doTx) {
                    this.tm.setRollbackOnly();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            String sessId = session == null ? "NULL" : session.getId();
            this.log.error((Object)("caught exception adding session " + sessId + " to SSO id " + ssoId), (Throwable)e);
        }
        finally {
            if (doTx) {
                this.endTransaction();
            }
        }
    }

    public ClusteredSingleSignOn getSingleSignOnValve() {
        return this.ssoValve;
    }

    public void setSingleSignOnValve(ClusteredSingleSignOn valve) {
        this.ssoValve = valve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(String ssoId) {
        if (!this.checkTreeCacheAvailable()) {
            return;
        }
        if (ssoId.equals(this.beingLocallyRemoved.get())) {
            return;
        }
        this.beingLocallyRemoved.set(ssoId);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Registering logout of SSO " + ssoId + " in clustered cache"));
        }
        Fqn fqn = this.getSingleSignOnFqn(ssoId);
        try {
            this.removeFromTreeCache(fqn, false);
        }
        catch (Exception e) {
            this.log.error((Object)("Exception attempting to remove node " + fqn.toString() + " from TreeCache"), (Throwable)e);
        }
        finally {
            this.beingLocallyRemoved.set(null);
        }
    }

    public JBossSingleSignOnEntry lookup(String ssoId) {
        if (!this.checkTreeCacheAvailable()) {
            return null;
        }
        JBossSingleSignOnEntry entry = null;
        Fqn fqn = this.getCredentialsFqn(ssoId);
        try {
            SSOCredentials data = (SSOCredentials)this.getFromTreeCache(fqn, KEY);
            if (data != null) {
                entry = new JBossSingleSignOnEntry(null, data.getAuthType(), data.getUsername(), data.getPassword());
            }
        }
        catch (Exception e) {
            this.log.error((Object)("caught exception looking up SSOCredentials for SSO id " + ssoId), (Throwable)e);
        }
        return entry;
    }

    public void register(String ssoId, String authType, String username, String password) {
        if (!this.checkTreeCacheAvailable()) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Registering SSO " + ssoId + " in clustered cache"));
        }
        this.storeSSOData(ssoId, authType, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(String ssoId, Session session) {
        if (ssoId == null || session == null) {
            return;
        }
        if (!this.checkTreeCacheAvailable()) {
            return;
        }
        if (ssoId.equals(this.beingRemotelyRemoved.get())) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("removeSession(): removing Session " + session.getId() + " from cached session set for SSO " + ssoId));
        }
        Fqn fqn = this.getSessionsFqn(ssoId);
        boolean doTx = false;
        boolean removing = false;
        try {
            Set keys;
            if (this.tm == null) {
                this.configureFromCache();
            }
            if (this.tm.getTransaction() == null) {
                doTx = true;
            }
            if (doTx) {
                this.tm.begin();
            }
            if ((keys = this.getSessionKeys(ssoId)).contains(session.getId())) {
                if (keys.size() == 1) {
                    this.removeFromTreeCache(fqn, false);
                } else {
                    this.removeFromTreeCache(fqn, session.getId());
                }
            }
        }
        catch (Exception e) {
            try {
                if (doTx) {
                    this.tm.setRollbackOnly();
                }
            }
            catch (Exception x) {
                // empty catch block
            }
            String sessId = session == null ? "NULL" : session.getId();
            this.log.error((Object)("caught exception removing session " + sessId + " from SSO id " + ssoId), (Throwable)e);
        }
        finally {
            try {
                if (removing) {
                    this.beingLocallyRemoved.set(null);
                }
            }
            finally {
                if (doTx) {
                    this.endTransaction();
                }
            }
        }
    }

    public void updateCredentials(String ssoId, String authType, String username, String password) {
        if (!this.checkTreeCacheAvailable()) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Updating credentials for SSO " + ssoId + " in clustered cache"));
        }
        this.storeSSOData(ssoId, authType, username, password);
    }

    @NodeRemoved
    public void nodeRemoved(NodeRemovedEvent event) {
        if (event.isPre()) {
            return;
        }
        Fqn fqn = event.getFqn();
        String ssoId = this.getIdFromFqn(fqn);
        if (ssoId == null) {
            return;
        }
        if (fqn.size() == 2) {
            if (!ssoId.equals(this.beingLocallyRemoved.get())) {
                this.handleRemoteInvalidation(ssoId);
            }
        } else if (fqn.size() == 4) {
            this.handlePeerRemoval(ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ViewChanged
    public synchronized void viewChange(ViewChangedEvent event) {
        if (event.isPre()) {
            return;
        }
        this.log.debug((Object)("Received ViewChangedEvent " + event));
        HashSet oldMembers = new HashSet(this.currentView);
        Set set = this.currentView;
        synchronized (set) {
            this.currentView.clear();
            this.currentView.addAll(event.getNewView().getMembers());
            if (this.localAddress == null || !this.currentView.contains(this.localAddress)) {
                return;
            }
            oldMembers.removeAll(this.currentView);
        }
        if (oldMembers.size() > 0) {
            this.log.debug((Object)("Members have been removed; will launch cleanup task. Dead members: " + oldMembers));
            this.launchSSOCleaner(false);
        }
    }

    private void launchSSOCleaner(boolean notifyIfEmpty) {
        SSOCleanerTask cleaner = new SSOCleanerTask();
        cleaner.setCheckForEmpty(notifyIfEmpty);
        if (this.threadPool != null) {
            this.threadPool.run((Runnable)cleaner);
        } else {
            Thread t = new Thread((Runnable)cleaner, "ClusteredSSOCleaner");
            t.setDaemon(true);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRemoteInvalidation(String ssoId) {
        this.beingRemotelyRemoved.set(ssoId);
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("received a node removed message for SSO " + ssoId));
            }
            this.ssoValve.deregister(ssoId);
        }
        finally {
            this.beingRemotelyRemoved.set(null);
        }
    }

    private void handlePeerRemoval(String ssoId) {
        try {
            Set peers = this.getSSOPeers(ssoId);
            if (peers.size() == 0) {
                this.ssoValve.notifySSOEmpty(ssoId);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Caught exception checking if " + ssoId + " is empty"), (Throwable)e);
        }
    }

    @NodeModified
    public void nodeModified(NodeModifiedEvent event) {
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        Fqn fqn = event.getFqn();
        String type = this.getTypeFromFqn(fqn);
        if (CREDENTIALS.equals(type)) {
            this.handleCredentialUpdate(this.getIdFromFqn(fqn), event.getData());
        } else if (SESSIONS.equals(type)) {
            this.handleSessionSetChange(fqn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCredentialUpdate(String ssoId, Map nodeData) {
        block9: {
            if (ssoId.equals(this.beingLocallyAdded.get())) {
                return;
            }
            JBossSingleSignOnEntry sso = this.ssoValve.localLookup(ssoId);
            if (sso == null || sso.getCanReauthenticate()) {
                return;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("received a credentials modified message for SSO " + ssoId));
            }
            try {
                SSOCredentials data = (SSOCredentials)nodeData.get(KEY);
                if (data == null) break block9;
                String authType = data.getAuthType();
                String username = data.getUsername();
                String password = data.getPassword();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Updating credentials for SSO " + (Object)((Object)sso)));
                }
                JBossSingleSignOnEntry jBossSingleSignOnEntry = sso;
                synchronized (jBossSingleSignOnEntry) {
                    Principal p = sso.getPrincipal();
                    sso.updateCredentials(p, authType, username, password);
                }
            }
            catch (Exception e) {
                this.log.error((Object)("failed to update credentials for SSO " + ssoId), (Throwable)e);
            }
        }
    }

    private void handleSessionSetChange(Fqn fqn) {
        if (fqn.size() != 4) {
            return;
        }
        this.ssoValve.notifySSONotEmpty(this.getIdFromFqn(fqn));
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException("TreeCacheSSOClusterManager already Started");
        }
        this.initThreadPool();
        try {
            if (this.isTreeCacheAvailable(true)) {
                this.integrateWithCache();
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Caught exception looking up TransactionManager from TreeCache", (Throwable)e);
        }
        this.started = true;
        this.lifecycle.fireLifecycleEvent("start", null);
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException("TreeCacheSSOClusterManager not Started");
        }
        this.started = false;
        this.lifecycle.fireLifecycleEvent("stop", null);
    }

    public int getSessionCount(String ssoId) throws Exception {
        int count = 0;
        Set peers = this.getSSOPeers(ssoId);
        Iterator it = peers.iterator();
        while (it.hasNext()) {
            Set ids = this.getSessionKeys(ssoId, (Serializable)it.next());
            count += ids.size();
        }
        return count;
    }

    private Object getFromTreeCache(Fqn fqn, Object key) throws Exception {
        return this.cache.get(fqn, key);
    }

    private Set getSSOIds() throws Exception {
        Fqn ssoRootFqn = new Fqn(new Object[]{SSO});
        Node ssoRoot = this.cache.getRoot().getChild(ssoRootFqn);
        return ssoRoot == null ? new HashSet() : ssoRoot.getChildrenNames();
    }

    private Set getSSOPeers(String ssoId) throws Exception {
        Fqn fqn = this.getSessionRootFqn(ssoId);
        Node ssoRoot = this.cache.getRoot().getChild(fqn);
        return ssoRoot == null ? new HashSet() : ssoRoot.getChildrenNames();
    }

    private Fqn getCredentialsFqn(String ssoid) {
        Object[] objs = new Object[]{SSO, ssoid, CREDENTIALS};
        return new Fqn(objs);
    }

    private Fqn getSessionRootFqn(String ssoId) {
        Object[] objs = new Object[]{SSO, ssoId, SESSIONS};
        return new Fqn(objs);
    }

    private Fqn getSessionsFqn(String ssoid) {
        return this.getSessionsFqn(ssoid, this.localAddress);
    }

    private Fqn getSessionsFqn(String ssoid, Serializable address) {
        Object[] objs = new Object[]{SSO, ssoid, SESSIONS, address};
        return new Fqn(objs);
    }

    private Fqn getSingleSignOnFqn(String ssoid) {
        Object[] objs = new Object[]{SSO, ssoid};
        return new Fqn(objs);
    }

    private String getIdFromFqn(Fqn fqn) {
        String id = null;
        if (fqn.size() > 1 && SSO.equals(fqn.get(0))) {
            id = (String)fqn.get(1);
        }
        return id;
    }

    private String getTypeFromFqn(Fqn fqn) {
        String type = null;
        if (fqn.size() > 2 && SSO.equals(fqn.get(0))) {
            type = (String)fqn.get(2);
        }
        return type;
    }

    private Set getSessionKeys(String ssoId) {
        return this.getSessionKeys(ssoId, this.localAddress);
    }

    private Set getSessionKeys(String ssoId, Serializable peer) {
        Fqn fqn = this.getSessionsFqn(ssoId, peer);
        HashSet keys = null;
        Node sessions = this.cache.getRoot().getChild(fqn);
        keys = sessions != null ? sessions.getKeys() : new HashSet();
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureFromCache() throws Exception {
        this.tm = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        if (this.tm == null) {
            throw new IllegalStateException("Cache does not have a transaction manager; please configure a valid TransactionManagerLookupClass");
        }
        if (this.cache.getConfiguration().getBuddyReplicationConfig() != null && this.cache.getConfiguration().getBuddyReplicationConfig().isEnabled()) {
            throw new IllegalStateException("Underlying cache is configured for buddy replication; use of buddy replication with ClusteredSingleSignOn is not supported");
        }
        Address address = this.cache.getLocalAddress();
        if (address instanceof Serializable) {
            this.localAddress = (Serializable)address;
        } else if (address != null) {
            this.localAddress = address.toString();
        } else if (Configuration.CacheMode.LOCAL == this.cache.getConfiguration().getCacheMode()) {
            this.localAddress = "LOCAL";
        } else {
            throw new IllegalStateException("Cannot get local address from cache");
        }
        this.log.debug((Object)("Local address is " + this.localAddress));
        Set set = this.currentView;
        synchronized (set) {
            this.currentView.clear();
            List members = this.cache.getMembers();
            if (members != null) {
                this.currentView.addAll(members);
                this.log.debug((Object)("Current view is " + this.currentView));
            }
        }
    }

    private void endTransaction() {
        try {
            if (this.tm.getTransaction().getStatus() != 1) {
                this.tm.commit();
            } else {
                this.tm.rollback();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new NestedRuntimeException("TreeCacheSSOClusterManager.endTransaction(): ", (Throwable)e);
        }
    }

    private synchronized boolean isTreeCacheAvailable(boolean forceCheck) {
        if (forceCheck || !this.treeCacheAvailable) {
            boolean available;
            boolean bl = available = this.cacheObjectName != null;
            if (available) {
                Set<ObjectInstance> s = this.server.queryMBeans(this.cacheObjectName, null);
                boolean bl2 = available = s.size() > 0;
                if (available) {
                    try {
                        if (this.started) {
                            this.integrateWithCache();
                        }
                        this.setMissingCacheErrorLogged(false);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Caught exception configuring from cache " + this.cacheObjectName), (Throwable)e);
                        available = false;
                    }
                }
            }
            this.treeCacheAvailable = available;
        }
        return this.treeCacheAvailable;
    }

    private boolean checkTreeCacheAvailable() {
        boolean avail = this.isTreeCacheAvailable(false);
        if (!avail) {
            this.logMissingCacheError();
        }
        return avail;
    }

    private void putInTreeCache(Fqn fqn, Object key, Object data) throws Exception {
        this.cache.put(fqn, key, data);
    }

    private void integrateWithCache() throws Exception {
        if (this.cache == null) {
            MBeanAttributeInfo[] attrs;
            MBeanInfo info = this.server.getMBeanInfo(this.getCacheObjectName());
            for (MBeanAttributeInfo attr : attrs = info.getAttributes()) {
                if ("PojoCache".equals(attr.getName())) {
                    this.cache = ((PojoCache)this.server.getAttribute(this.getCacheObjectName(), "PojoCache")).getCache();
                    break;
                }
                if (!"Cache".equals(attr.getName())) continue;
                this.cache = (Cache)this.server.getAttribute(this.getCacheObjectName(), "Cache");
                break;
            }
            this.configureFromCache();
            this.activateCacheRegion();
            this.registerAsCacheListener();
            this.launchSSOCleaner(true);
            this.log.debug((Object)("Successfully integrated with cache service " + this.cacheObjectName));
        }
    }

    private void activateCacheRegion() throws Exception {
        if (this.cache.getConfiguration().isInactiveOnStartup() && this.cache.getConfiguration().isUseRegionBasedMarshalling()) {
            Region region = this.cache.getRegion(Fqn.fromString((String)"/SSO"), true);
            try {
                region.activate();
            }
            catch (RegionNotEmptyException e) {
                this.log.debug((Object)"SSO region already active", (Throwable)e);
            }
        }
    }

    private void registerAsCacheListener() throws Exception {
        this.cache.addCacheListener((Object)this);
        this.registeredAsListener = true;
    }

    private void removeAsCacheListener() throws Exception {
        if (this.registeredAsListener && this.cache != null) {
            this.cache.removeCacheListener((Object)this);
            this.registeredAsListener = false;
        }
    }

    private void removeFromTreeCache(Fqn fqn, boolean localOnly) throws Exception {
        if (localOnly) {
            InvocationContext ctx = this.cache.getInvocationContext();
            Option option = new Option();
            option.setCacheModeLocal(true);
            ctx.setOptionOverrides(option);
        }
        this.cache.removeNode(fqn);
    }

    private void removeFromTreeCache(Fqn fqn, Object key) throws Exception {
        this.cache.remove(fqn, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSSOData(String ssoId, String authType, String username, String password) {
        SSOCredentials data = new SSOCredentials(authType, username, password);
        this.beingLocallyAdded.set(ssoId);
        try {
            this.putInTreeCache(this.getCredentialsFqn(ssoId), KEY, data);
        }
        catch (Exception e) {
            this.log.error((Object)("Exception attempting to add TreeCache nodes for SSO " + ssoId), (Throwable)e);
        }
        finally {
            this.beingLocallyAdded.set(null);
        }
    }

    private void initThreadPool() {
        if (this.threadPoolName != null) {
            try {
                ObjectName on = new ObjectName(this.threadPoolName);
                this.threadPool = (ThreadPool)this.server.getAttribute(on, "Instance");
                this.log.debug((Object)("Using ThreadPool at " + this.threadPoolName + " to clean dead members"));
            }
            catch (Exception e) {
                this.log.info((Object)("Unable to access ThreadPool at " + this.threadPoolName + " -- will use individual threads for cleanup work"));
                this.log.debug((Object)("Failure to access ThreadPool due to: " + e));
            }
        } else {
            this.log.debug((Object)"No ThreadPool configured -- will use individual threads for cleanup work");
        }
    }

    private boolean isMissingCacheErrorLogged() {
        return this.missingCacheErrorLogged;
    }

    private void setMissingCacheErrorLogged(boolean missingCacheErrorLogged) {
        this.missingCacheErrorLogged = missingCacheErrorLogged;
    }

    private void logMissingCacheError() {
        StringBuffer msg = new StringBuffer("Cannot find TreeCache using ");
        msg.append(this.getCacheName());
        msg.append(" -- TreeCache must be started before ClusteredSingleSignOn ");
        msg.append("can handle requests");
        if (this.isMissingCacheErrorLogged()) {
            this.log.warn((Object)msg);
        } else {
            this.log.error((Object)msg);
            this.setMissingCacheErrorLogged(true);
        }
    }

    private class SSOCleanerTask
    implements Runnable {
        boolean checkForEmpty = false;

        private SSOCleanerTask() {
        }

        boolean getCheckForEmpty() {
            return this.checkForEmpty;
        }

        void setCheckForEmpty(boolean checkForEmpty) {
            this.checkForEmpty = checkForEmpty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = TreeCacheSSOClusterManager.this.cleanupMutex;
            synchronized (object) {
                try {
                    if (TreeCacheSSOClusterManager.this.tm == null) {
                        TreeCacheSSOClusterManager.this.configureFromCache();
                    }
                    Set ids = TreeCacheSSOClusterManager.this.getSSOIds();
                    Iterator iter = ids.iterator();
                    while (iter.hasNext()) {
                        this.cleanSSO((String)iter.next());
                    }
                }
                catch (Exception e) {
                    TreeCacheSSOClusterManager.this.log.error((Object)"Caught exception cleaning sessions from dead cluster members from SSOs ", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanSSO(String ssoId) {
            block18: {
                boolean doTx = false;
                try {
                    Set peers;
                    if (TreeCacheSSOClusterManager.this.tm.getTransaction() == null) {
                        doTx = true;
                    }
                    if (doTx) {
                        TreeCacheSSOClusterManager.this.tm.begin();
                    }
                    if ((peers = TreeCacheSSOClusterManager.this.getSSOPeers(ssoId)) != null && peers.size() > 0) {
                        for (Serializable peer : peers) {
                            boolean alive = true;
                            Set set = TreeCacheSSOClusterManager.this.currentView;
                            synchronized (set) {
                                alive = TreeCacheSSOClusterManager.this.currentView.contains(peer);
                            }
                            if (alive) continue;
                            if (TreeCacheSSOClusterManager.this.log.isTraceEnabled()) {
                                TreeCacheSSOClusterManager.this.log.trace((Object)("Removing peer " + peer + " from SSO " + ssoId));
                            }
                            Fqn fqn = TreeCacheSSOClusterManager.this.getSessionsFqn(ssoId, peer);
                            TreeCacheSSOClusterManager.this.removeFromTreeCache(fqn, true);
                        }
                        break block18;
                    }
                    if (this.checkForEmpty) {
                        TreeCacheSSOClusterManager.this.ssoValve.notifySSOEmpty(ssoId);
                    }
                }
                catch (Exception e) {
                    try {
                        if (doTx) {
                            TreeCacheSSOClusterManager.this.tm.setRollbackOnly();
                        }
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    TreeCacheSSOClusterManager.this.log.error((Object)("caught exception cleaning dead members from SSO " + ssoId), (Throwable)e);
                }
                finally {
                    if (doTx) {
                        TreeCacheSSOClusterManager.this.endTransaction();
                    }
                }
            }
        }
    }

    public static class SSOCredentials
    implements Serializable {
        private static final long serialVersionUID = 5704877226920571663L;
        private String authType = null;
        private String password = null;
        private String username = null;

        private SSOCredentials(String authType, String username, String password) {
            this.authType = authType;
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getAuthType() {
            return this.authType;
        }

        private String getPassword() {
            return this.password;
        }
    }
}

