/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.net.protocol.jndi;

import org.apache.naming.resources.DirContextURLConnection;
import org.apache.naming.resources.DirContextURLStreamHandler;

import javax.naming.directory.DirContext;
import java.io.IOException;

import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

/**
 * A protocol handler for the 'jndi' protocol.  Provides
 * access to jndi resources required by Tomcat 4.1.12. This
 * is basically a place-marker class so the org.jboss.net.protocol.URLStreamHandlerFactory
 * class can find org.apache.naming.resources.DirContextURLStreamHandler.
 * See org.jboss.net.protocol.URLStreamHandlerFactory and org.jboss.net.protocol.file.Handler
 * for the pattern adopted here
 */
public class Handler
   extends DirContextURLStreamHandler
{
}
