package org.jboss.web.tomcat.service.session;

import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyManager;

public class CacheListenerBase
{

   private static final int JSESSION_FQN_INDEX = 0;
   private static final int HOSTNAME_FQN_INDEX = 1;
   private static final int WEBAPP_FQN_INDEX = 2;
   protected static final int SESSION_ID_FQN_INDEX = 3;
   private static final int SESSION_FQN_SIZE = SESSION_ID_FQN_INDEX + 1;
   private static final int BUDDY_BACKUP_ROOT_OWNER_INDEX = BuddyManager.BUDDY_BACKUP_SUBTREE_FQN.size();
   protected static final int BUDDY_BACKUP_ROOT_OWNER_SIZE = BUDDY_BACKUP_ROOT_OWNER_INDEX + 1;
   protected JBossCacheManager manager_;
   private String webapp_;
   private String hostname_;

   CacheListenerBase(JBossCacheManager manager, String hostname, String webapp)
   {      
      manager_ = manager;
      hostname_ = hostname;
      webapp_ =  webapp;
   }

   protected boolean isFqnForOurWebapp(Fqn fqn, boolean isBuddy)
   {
      try
      {
         if (webapp_.equals(fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + WEBAPP_FQN_INDEX : WEBAPP_FQN_INDEX))
               && hostname_.equals(fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + HOSTNAME_FQN_INDEX : HOSTNAME_FQN_INDEX))
               && JBossCacheService.SESSION.equals(fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + JSESSION_FQN_INDEX : JSESSION_FQN_INDEX)))
            return true;
      }
      catch (IndexOutOfBoundsException e)
      {
         // can't be ours; too small; just fall through
      }
   
      return false;
   }

   public static boolean isFqnSessionRootSized(Fqn fqn, boolean isBuddy)
   {
      return fqn.size() == (isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + SESSION_FQN_SIZE : SESSION_FQN_SIZE);
   }

   public static String getIdFromFqn(Fqn fqn, boolean isBuddy)
   {
      return (String)fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + SESSION_ID_FQN_INDEX : SESSION_ID_FQN_INDEX);
   }

   public static boolean isBuddyFqn(Fqn fqn)
   {
      try
      {
         return BuddyManager.BUDDY_BACKUP_SUBTREE.equals(fqn.get(0));
      }
      catch (IndexOutOfBoundsException e)
      {
         // Can only happen if fqn is ROOT, and we shouldn't get
         // notifications for ROOT.
         // If it does, just means it's not a buddy
         return false;
      }      
   }

   /**
    * Extracts the owner portion of an buddy subtree Fqn.
    * 
    * @param fqn An Fqn that is a child of the buddy backup root node.
    */
   public static String getBuddyOwner(Fqn fqn)
   {
      return (String) fqn.get(BUDDY_BACKUP_ROOT_OWNER_INDEX);     
   }
}