/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.deployers;

import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.management.ObjectName;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.web.jboss.JBoss50WebMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.Web25MetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.security.plugins.JaasSecurityManagerServiceMBean;
import org.jboss.virtual.VirtualFile;
import org.jboss.web.deployers.AbstractWarDeployer;
import org.jboss.web.deployers.AbstractWarDeployment;
import org.jboss.web.tomcat.service.deployers.DeployerConfig;
import org.jboss.web.tomcat.service.deployers.TomcatDeployerMBean;
import org.jboss.web.tomcat.service.session.SessionIDGenerator;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.builder.JBossXBBuilder;

public class TomcatDeployer
extends AbstractWarDeployer
implements TomcatDeployerMBean {
    public static final ObjectName TOMCAT_SERVICE_NAME = ObjectNameFactory.create((String)"jboss.web:service=WebServer");
    public static final String NAME = "TomcatDeployer";
    private String contextClassName = "org.apache.catalina.core.StandardContext";
    private static final UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
    private Properties authenticators = null;
    private String catalinaDomain = "Catalina";
    protected String managerClass = "org.jboss.web.tomcat.service.session.JBossCacheManager";
    private boolean useJBossWebLoader = true;
    private boolean deleteWorkDirOnContextDestroy = false;
    private String httpHeaderForSSOAuth = null;
    private String sessionCookieForSSOAuth = null;
    private JBossWebMetaData sharedMetaData = null;
    private String serverConfigFile = "server.xml";
    private String subjectAttributeName = null;
    private boolean allowSelfPrivilegedWebApps = false;
    private JaasSecurityManagerServiceMBean secMgrService;
    private String deploymentClass = null;
    private ClassLoader serviceClassLoader = null;
    private String securityManagement;
    private String securityContextClassName;
    private String[] filteredPackages;
    private boolean runtimeLifecycleCoupled = false;
    private String policyRegistrationName;

    public String getName() {
        return NAME;
    }

    public String getManagerClass() {
        return this.managerClass;
    }

    public void setManagerClass(String managerClass) {
        this.managerClass = managerClass;
    }

    public ClassLoader getServiceClassLoader() {
        return this.serviceClassLoader;
    }

    public void setServiceClassLoader(ClassLoader serviceClassLoader) {
        this.serviceClassLoader = serviceClassLoader;
    }

    public String getDomain() {
        return this.catalinaDomain;
    }

    public Properties getAuthenticators() {
        return this.authenticators;
    }

    public void setAuthenticators(Properties prop) {
        this.authenticators = prop;
        this.log.debug((Object)("Passed set of authenticators=" + prop));
    }

    public void setDomain(String catalinaDomain) {
        this.catalinaDomain = catalinaDomain;
    }

    public void setContextMBeanCode(String className) {
        this.contextClassName = className;
    }

    public String getContextMBeanCode() {
        return this.contextClassName;
    }

    public boolean getDeleteWorkDirOnContextDestroy() {
        return this.deleteWorkDirOnContextDestroy;
    }

    public void setDeleteWorkDirOnContextDestroy(boolean deleteFlag) {
        this.deleteWorkDirOnContextDestroy = deleteFlag;
    }

    public String getHttpHeaderForSSOAuth() {
        return this.httpHeaderForSSOAuth;
    }

    public void setHttpHeaderForSSOAuth(String httpHeader) {
        this.httpHeaderForSSOAuth = httpHeader;
    }

    public String getSessionCookieForSSOAuth() {
        return this.sessionCookieForSSOAuth;
    }

    public void setSessionCookieForSSOAuth(String sessionC) {
        this.sessionCookieForSSOAuth = sessionC;
    }

    public void setSessionIdAlphabet(String sessionIdAlphabet) {
        SessionIDGenerator.getInstance().setSessionIdAlphabet(sessionIdAlphabet);
    }

    public String getSessionIdAlphabet() {
        return SessionIDGenerator.getInstance().getSessionIdAlphabet();
    }

    public boolean getUseJBossWebLoader() {
        return this.useJBossWebLoader;
    }

    public void setUseJBossWebLoader(boolean flag) {
        this.useJBossWebLoader = flag;
    }

    public String getConfigFile() {
        return this.serverConfigFile;
    }

    public void setConfigFile(String configFile) {
        this.serverConfigFile = configFile;
    }

    public String getSubjectAttributeName() {
        return this.subjectAttributeName;
    }

    public void setSubjectAttributeName(String name) {
        this.subjectAttributeName = name;
    }

    public boolean isAllowSelfPrivilegedWebApps() {
        return this.allowSelfPrivilegedWebApps;
    }

    public void setAllowSelfPrivilegedWebApps(boolean allowSelfPrivilegedWebApps) {
        this.allowSelfPrivilegedWebApps = allowSelfPrivilegedWebApps;
    }

    public void setSecurityManagerService(JaasSecurityManagerServiceMBean mgr) {
        this.secMgrService = mgr;
    }

    public void setPolicyRegistrationName(String policyRegistration) {
        this.policyRegistrationName = policyRegistration;
    }

    public void setSecurityManagementName(String securityManagement) {
        this.securityManagement = securityManagement;
    }

    public void setSecurityContextClassName(String securityContextClassName) {
        this.securityContextClassName = securityContextClassName;
    }

    public String[] getFilteredPackages() {
        return this.filteredPackages;
    }

    public void setFilteredPackages(String[] pkgs) {
        this.filteredPackages = pkgs;
    }

    public String getDeploymentClass() {
        return this.deploymentClass;
    }

    public void setDeploymentClass(String deploymentClass) {
        this.deploymentClass = deploymentClass;
    }

    public boolean isRuntimeLifecycleCoupled() {
        return this.runtimeLifecycleCoupled;
    }

    public void setRuntimeLifecycleCoupled(boolean coupled) {
        this.runtimeLifecycleCoupled = coupled;
    }

    public void start() throws Exception {
        super.start();
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        URL webXml = this.getClass().getClassLoader().getResource("web.xml");
        if (webXml == null) {
            webXml = this.getClass().getClassLoader().getResource("conf/web.xml");
        }
        if (webXml == null) {
            throw new IllegalStateException("Unable to find shared web.xml or conf/web.xml");
        }
        SchemaBinding schema = JBossXBBuilder.build(Web25MetaData.class);
        Web25MetaData confWebMD = (Web25MetaData)unmarshaller.unmarshal(webXml.toString(), schema);
        this.sharedMetaData = new JBoss50WebMetaData();
        this.sharedMetaData.merge(null, (WebMetaData)confWebMD);
    }

    public void stop() throws Exception {
        super.stop();
    }

    public AbstractWarDeployment getDeployment(VFSDeploymentUnit unit, JBossWebMetaData metaData) throws Exception {
        ArrayList<String> depends;
        String className = this.deploymentClass == null ? "org.jboss.web.tomcat.service.deployers.TomcatDeployment" : this.deploymentClass;
        AbstractWarDeployment deployment = (AbstractWarDeployment)this.getClass().getClassLoader().loadClass(className).newInstance();
        DeployerConfig config = new DeployerConfig();
        config.setDefaultSecurityDomain(this.defaultSecurityDomain);
        config.setSubjectAttributeName(this.subjectAttributeName);
        config.setServiceClassLoader(this.getServiceClassLoader() == null ? this.getClass().getClassLoader() : this.getServiceClassLoader());
        config.setManagerClass(this.managerClass);
        config.setJava2ClassLoadingCompliance(this.java2ClassLoadingCompliance);
        config.setUnpackWars(this.unpackWars);
        config.setLenientEjbLink(this.lenientEjbLink);
        config.setCatalinaDomain(this.catalinaDomain);
        config.setContextClassName(this.contextClassName);
        config.setServiceName(null);
        config.setSubjectAttributeName(this.subjectAttributeName);
        config.setUseJBossWebLoader(this.useJBossWebLoader);
        config.setAllowSelfPrivilegedWebApps(this.allowSelfPrivilegedWebApps);
        config.setSecurityManagerService(this.secMgrService);
        config.setFilteredPackages(this.filteredPackages);
        config.setSharedMetaData(this.sharedMetaData);
        config.setDeleteWorkDirs(this.deleteWorkDirOnContextDestroy);
        config.setSecurityContextClassName(this.securityContextClassName);
        deployment.setSecurityManagementName(this.securityManagement);
        deployment.setPolicyRegistrationName(this.policyRegistrationName);
        VirtualFile vf = unit.getMetaDataFile("jboss-xacml-policy.xml");
        if (vf != null) {
            config.setXacmlPolicyURL(vf.toURL());
        }
        if ((depends = metaData.getDepends()) == null) {
            depends = new ArrayList<String>();
        }
        depends.add(TOMCAT_SERVICE_NAME.getCanonicalName());
        metaData.setDepends(depends);
        deployment.setServer(super.getServer());
        deployment.init((Object)config);
        return deployment;
    }

    public void create() throws Exception {
    }

    public void destroy() throws Exception {
    }
}

