/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.StringManager;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.ReplicationTrigger;
import org.jboss.web.tomcat.service.session.AbstractJBossManager;
import org.jboss.web.tomcat.service.session.Util;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionMetadata;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionTimestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClusteredSession
extends StandardSession {
    private static final long serialVersionUID = -758573655613558722L;
    protected static Logger log = Logger.getLogger(ClusteredSession.class);
    protected static final String info = "ClusteredSession/1.0";
    protected static final String[] excludedAttributes = new String[]{"javax.security.auth.subject"};
    protected static final Set replicationExcludes;
    protected ReplicationTrigger invalidationPolicy;
    protected transient boolean sessionMetadataDirty;
    protected transient boolean sessionAttributesDirty;
    protected transient DistributableSessionTimestamp timestamp = new DistributableSessionTimestamp();
    protected transient DistributableSessionMetadata metadata = new DistributableSessionMetadata();
    protected transient int outdatedVersion;
    protected transient long outdatedTime;
    protected int version;
    protected transient String realId;
    private transient boolean useJK;
    protected transient long lastReplicated;
    protected transient long maxUnreplicatedInterval;
    protected transient boolean alwaysReplicateTimestamp = true;
    protected transient Boolean hasActivationListener;
    protected transient boolean firstAccess;
    protected static StringManager sm;

    protected ClusteredSession(AbstractJBossManager manager, ReplicationTrigger replicationTrigger, boolean useJK) {
        super((Manager)manager);
        this.invalidationPolicy = replicationTrigger;
        this.useJK = useJK;
        this.firstAccess = true;
        this.checkAlwaysReplicateTimestamp();
    }

    public boolean isOutdated() {
        return this.thisAccessedTime < this.outdatedTime;
    }

    public void clearOutdated() {
        if (this.outdatedTime > this.thisAccessedTime) {
            this.lastAccessedTime = this.thisAccessedTime;
            this.thisAccessedTime = this.outdatedTime;
        }
        this.outdatedTime = 0L;
        if (this.outdatedVersion > this.version) {
            this.version = this.outdatedVersion;
        }
        this.outdatedVersion = 0;
    }

    public void updateAccessTimeFromOutdatedTime() {
        if (this.outdatedTime > this.thisAccessedTime) {
            this.lastAccessedTime = this.thisAccessedTime;
            this.thisAccessedTime = this.outdatedTime;
        }
        this.outdatedTime = 0L;
    }

    public String getRealId() {
        return this.realId;
    }

    private void parseRealId(String sessionId) {
        String newId = null;
        newId = this.useJK ? Util.getRealId(sessionId) : sessionId;
        if (!newId.equals(this.realId)) {
            this.realId = newId;
        }
    }

    public void resetIdWithRouteInfo(String id) {
        this.id = id;
        this.parseRealId(id);
    }

    public boolean getUseJK() {
        return this.useJK;
    }

    public int getVersion() {
        return this.version;
    }

    public int incrementVersionFromLocalActivity() {
        return this.version++;
    }

    public boolean setVersionFromDistributedCache(int version) {
        boolean outdated;
        boolean bl = outdated = this.version < version;
        if (outdated) {
            this.outdatedVersion = version;
            this.outdatedTime = System.currentTimeMillis();
        }
        return outdated;
    }

    public void setMaxInactiveInterval(int interval) {
        super.setMaxInactiveInterval(interval);
        this.checkAlwaysReplicateTimestamp();
        this.sessionMetadataDirty();
    }

    public long getLastReplicated() {
        return this.lastReplicated;
    }

    public void updateLastReplicated() {
        this.lastReplicated = System.currentTimeMillis();
    }

    public long getMaxUnreplicatedInterval() {
        return this.maxUnreplicatedInterval;
    }

    public void setMaxUnreplicatedInterval(long interval) {
        this.maxUnreplicatedInterval = Math.max(interval, -1L);
        this.checkAlwaysReplicateTimestamp();
    }

    public boolean getMustReplicateTimestamp() {
        boolean exceeds;
        boolean touched = this.thisAccessedTime != this.lastAccessedTime;
        boolean bl = exceeds = this.alwaysReplicateTimestamp && touched;
        if (!exceeds && touched && this.maxUnreplicatedInterval > 0L) {
            long unrepl = System.currentTimeMillis() - this.lastReplicated;
            exceeds = unrepl >= this.maxUnreplicatedInterval;
        }
        return exceeds;
    }

    public DistributableSessionTimestamp getSessionTimestamp() {
        this.timestamp.setTimestamp(this.thisAccessedTime);
        return this.timestamp;
    }

    public DistributableSessionMetadata getSessionMetadata() {
        this.metadata.setId(this.id);
        this.metadata.setCreationTime(this.creationTime);
        this.metadata.setMaxInactiveInterval(this.maxInactiveInterval);
        this.metadata.setNew(this.isNew);
        this.metadata.setValid(this.isValid);
        return this.metadata;
    }

    public Map<String, Object> getSessionAttributeMap() {
        return null;
    }

    public long getCreationTimeInternal() {
        return this.creationTime;
    }

    public abstract void initAfterLoad(AbstractJBossManager var1);

    public abstract void processSessionRepl();

    public abstract void removeMyself();

    public abstract void removeMyselfLocal();

    public void access() {
        super.access();
        if (!this.firstAccess && this.isNew) {
            this.setNew(false);
        }
    }

    public void endAccess() {
        super.endAccess();
        this.lastAccessedTime = this.thisAccessedTime;
        if (this.firstAccess) {
            this.firstAccess = false;
            this.isNew = true;
        }
    }

    public Object getAttribute(String name) {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("clusteredSession.getAttribute.ise"));
        }
        return this.getAttributeInternal(name);
    }

    public Enumeration getAttributeNames() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("clusteredSession.getAttributeNames.ise"));
        }
        return new Enumerator(this.getAttributesInternal().keySet(), true);
    }

    public void setAttribute(String name, Object value) {
        Context context;
        Object[] listeners;
        Object unbound;
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("clusteredSession.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("clusteredSession.setAttribute.ise"));
        }
        if (!this.canAttributeBeReplicated(value)) {
            throw new IllegalArgumentException(sm.getString("clusteredSession.setAttribute.iae"));
        }
        HttpSessionBindingEvent event = null;
        if (value instanceof HttpSessionBindingListener) {
            event = new HttpSessionBindingEvent(this.getSession(), name, value);
            try {
                ((HttpSessionBindingListener)value).valueBound(event);
            }
            catch (Throwable t) {
                this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.bindingEvent"), t);
            }
        }
        if ((unbound = this.setInternalAttribute(name, value)) != null && unbound != value && unbound instanceof HttpSessionBindingListener) {
            try {
                ((HttpSessionBindingListener)unbound).valueUnbound(new HttpSessionBindingEvent(this.getSession(), name));
            }
            catch (Throwable t) {
                this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.bindingEvent"), t);
            }
        }
        if ((listeners = (context = (Context)this.manager.getContainer()).getApplicationEventListeners()) == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
            try {
                if (unbound != null) {
                    this.fireContainerEvent(context, "beforeSessionAttributeReplaced", listener);
                    if (event == null) {
                        event = new HttpSessionBindingEvent(this.getSession(), name, unbound);
                    }
                    listener.attributeReplaced(event);
                    this.fireContainerEvent(context, "afterSessionAttributeReplaced", listener);
                    continue;
                }
                this.fireContainerEvent(context, "beforeSessionAttributeAdded", listener);
                if (event == null) {
                    event = new HttpSessionBindingEvent(this.getSession(), name, value);
                }
                listener.attributeAdded(event);
                this.fireContainerEvent(context, "afterSessionAttributeAdded", listener);
                continue;
            }
            catch (Throwable t) {
                try {
                    if (unbound != null) {
                        this.fireContainerEvent(context, "afterSessionAttributeReplaced", listener);
                    } else {
                        this.fireContainerEvent(context, "afterSessionAttributeAdded", listener);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.attributeEvent"), t);
            }
        }
    }

    protected boolean canAttributeBeReplicated(Object attribute) {
        if (attribute instanceof Serializable || attribute == null) {
            return true;
        }
        Class<?> clazz = attribute.getClass().getComponentType();
        return clazz != null && clazz.isPrimitive();
    }

    public void invalidate() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("clusteredSession.invalidate.ise"));
        }
        boolean notify = true;
        boolean localCall = true;
        boolean localOnly = false;
        this.expire(notify, localCall, localOnly);
    }

    public boolean isValid() {
        return this.isValid(true);
    }

    public boolean isValid(boolean expireIfInvalid) {
        long timeNow;
        int timeIdle;
        if (this.expiring) {
            return true;
        }
        if (!this.isValid) {
            return false;
        }
        if (ACTIVITY_CHECK && this.accessCount.get() > 0) {
            return true;
        }
        if (this.maxInactiveInterval >= 0 && (timeIdle = (int)(((timeNow = System.currentTimeMillis()) - this.thisAccessedTime) / 1000L)) >= this.maxInactiveInterval) {
            if (expireIfInvalid) {
                this.expire(true);
            } else {
                return false;
            }
        }
        return this.isValid;
    }

    public void expire(boolean notify) {
        boolean localCall = true;
        boolean localOnly = true;
        this.expire(notify, localCall, localOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(boolean notify, boolean localCall, boolean localOnly) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("The session has expired with id: " + this.id + " -- is expiration local? " + localOnly));
        }
        if (this.expiring) {
            return;
        }
        ClusteredSession clusteredSession = this;
        synchronized (clusteredSession) {
            int i;
            if (!this.isValid) {
                return;
            }
            if (this.manager == null) {
                return;
            }
            this.expiring = true;
            Context context = (Context)this.manager.getContainer();
            Object[] listeners = context.getApplicationLifecycleListeners();
            if (notify && listeners != null) {
                HttpSessionEvent event = new HttpSessionEvent(this.getSession());
                for (i = 0; i < listeners.length; ++i) {
                    int j = listeners.length - 1 - i;
                    if (!(listeners[j] instanceof HttpSessionListener)) continue;
                    HttpSessionListener listener = (HttpSessionListener)listeners[j];
                    try {
                        this.fireContainerEvent(context, "beforeSessionDestroyed", listener);
                        listener.sessionDestroyed(event);
                        this.fireContainerEvent(context, "afterSessionDestroyed", listener);
                        continue;
                    }
                    catch (Throwable t) {
                        try {
                            this.fireContainerEvent(context, "afterSessionDestroyed", listener);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.sessionEvent"), t);
                    }
                }
            }
            if (ACTIVITY_CHECK) {
                this.accessCount.set(0);
            }
            if (notify) {
                this.fireSessionEvent("destroySession", null);
            }
            String[] keys = this.keys();
            for (i = 0; i < keys.length; ++i) {
                this.removeAttributeInternal(keys[i], localCall, localOnly, notify);
            }
            this.removeFromManager(localCall, localOnly);
            this.setValid(false);
            this.expiring = false;
        }
    }

    protected void removeFromManager(boolean localCall, boolean localOnly) {
        if (localOnly) {
            ((AbstractJBossManager)this.manager).removeLocal((Session)this);
        } else {
            this.manager.remove((Session)this);
        }
    }

    public void passivate() {
        this.fireSessionEvent("passivateSession", null);
        if (this.hasActivationListener != Boolean.FALSE) {
            boolean hasListener = false;
            HttpSessionEvent event = null;
            String[] keys = this.keys();
            Map attrs = this.getAttributesInternal();
            for (int i = 0; i < keys.length; ++i) {
                Object attribute = attrs.get(keys[i]);
                if (!(attribute instanceof HttpSessionActivationListener)) continue;
                hasListener = true;
                if (event == null) {
                    event = new HttpSessionEvent(this.getSession());
                }
                try {
                    ((HttpSessionActivationListener)attribute).sessionWillPassivate(event);
                    continue;
                }
                catch (Throwable t) {
                    this.manager.getContainer().getLogger().error((Object)sm.getString("clusteredSession.attributeEvent"), t);
                }
            }
            this.hasActivationListener = hasListener ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public void activate() {
        this.fireSessionEvent("activateSession", null);
        if (this.hasActivationListener != Boolean.FALSE) {
            boolean hasListener = false;
            HttpSessionEvent event = null;
            String[] keys = this.keys();
            Map attrs = this.getAttributesInternal();
            for (int i = 0; i < keys.length; ++i) {
                Object attribute = attrs.get(keys[i]);
                if (!(attribute instanceof HttpSessionActivationListener)) continue;
                hasListener = true;
                if (event == null) {
                    event = new HttpSessionEvent(this.getSession());
                }
                try {
                    ((HttpSessionActivationListener)attribute).sessionDidActivate(event);
                    continue;
                }
                catch (Throwable t) {
                    this.manager.getContainer().getLogger().error((Object)sm.getString("clusteredSession.attributeEvent"), t);
                }
            }
            this.hasActivationListener = hasListener ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public void recycle() {
        super.recycle();
        this.listeners.clear();
        this.support = new PropertyChangeSupport((Object)this);
        this.invalidationPolicy = ReplicationTrigger.ACCESS;
        this.outdatedTime = 0L;
        this.outdatedVersion = 0;
        this.sessionAttributesDirty = false;
        this.sessionMetadataDirty = false;
        this.realId = null;
        this.useJK = false;
        this.version = 0;
        this.hasActivationListener = null;
        this.lastReplicated = 0L;
        this.maxUnreplicatedInterval = 0L;
        this.alwaysReplicateTimestamp = true;
    }

    public void setCreationTime(long time) {
        super.setCreationTime(time);
        this.sessionMetadataDirty();
    }

    public void setId(String id) {
        this.parseRealId(id);
        super.setId(id);
    }

    public void setPrincipal(Principal principal) {
        Principal oldPrincipal = this.principal;
        this.principal = principal;
        this.support.firePropertyChange("principal", oldPrincipal, this.principal);
        if (oldPrincipal != null && !((Object)oldPrincipal).equals(principal) || oldPrincipal == null && principal != null) {
            this.sessionMetadataDirty();
        }
    }

    public void setNew(boolean isNew) {
        super.setNew(isNew);
    }

    public void setValid(boolean isValid) {
        super.setValid(isValid);
        this.sessionMetadataDirty();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("id: " + this.id).append(" lastAccessedTime: " + this.lastAccessedTime).append(" version: " + this.version).append(" lastOutdated: " + this.outdatedTime);
        return buf.toString();
    }

    protected static Map removeExcludedAttributes(Map attributes) {
        HashMap excluded = null;
        for (int i = 0; i < excludedAttributes.length; ++i) {
            Object attr = attributes.remove(excludedAttributes[i]);
            if (attr == null) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Excluding attribute " + excludedAttributes[i] + " from replication"));
            }
            if (excluded == null) {
                excluded = new HashMap();
            }
            excluded.put(excludedAttributes[i], attr);
        }
        return excluded;
    }

    public void update(Integer version, DistributableSessionTimestamp timestamp, DistributableSessionMetadata metadata, Map attributes) {
        assert (version != null) : "version is null";
        assert (timestamp != null) : "timestamp is null";
        assert (metadata != null) : "metadata is null";
        this.version = version;
        this.lastAccessedTime = this.thisAccessedTime = timestamp.getTimestamp();
        this.timestamp = timestamp;
        this.id = metadata.getId();
        this.creationTime = metadata.getCreationTime();
        this.maxInactiveInterval = metadata.getMaxInactiveInterval();
        this.isNew = metadata.isNew();
        this.isValid = metadata.isValid();
        this.metadata = metadata;
        this.parseRealId(this.id);
        this.hasActivationListener = null;
        this.firstAccess = false;
        this.lastReplicated = this.creationTime;
        this.checkAlwaysReplicateTimestamp();
    }

    protected String[] keys() {
        return this.getAttributesInternal().keySet().toArray(EMPTY_ARRAY);
    }

    protected void removeAttributeInternal(String name, boolean notify) {
        boolean localCall = true;
        boolean localOnly = false;
        this.removeAttributeInternal(name, localCall, localOnly, notify);
    }

    protected void removeAttributeInternal(String name, boolean localCall, boolean localOnly, boolean notify) {
        Context context;
        Object[] listeners;
        Object value = this.removeJBossInternalAttribute(name, localCall, localOnly);
        if (!notify || value == null) {
            return;
        }
        HttpSessionBindingEvent event = null;
        if (value instanceof HttpSessionBindingListener) {
            event = new HttpSessionBindingEvent(this.getSession(), name, value);
            ((HttpSessionBindingListener)value).valueUnbound(event);
        }
        if ((listeners = (context = (Context)this.manager.getContainer()).getApplicationEventListeners()) == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
            try {
                this.fireContainerEvent(context, "beforeSessionAttributeRemoved", listener);
                if (event == null) {
                    event = new HttpSessionBindingEvent(this.getSession(), name, value);
                }
                listener.attributeRemoved(event);
                this.fireContainerEvent(context, "afterSessionAttributeRemoved", listener);
                continue;
            }
            catch (Throwable t) {
                try {
                    this.fireContainerEvent(context, "afterSessionAttributeRemoved", listener);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.attributeEvent"), t);
            }
        }
    }

    protected Object getAttributeInternal(String name) {
        return this.getJBossInternalAttribute(name);
    }

    protected Map getAttributesInternal() {
        return this.getJBossInternalAttributes();
    }

    protected Object setInternalAttribute(String name, Object value) {
        if (value instanceof HttpSessionActivationListener) {
            this.hasActivationListener = Boolean.TRUE;
        }
        return this.setJBossInternalAttribute(name, value);
    }

    protected abstract Object getJBossInternalAttribute(String var1);

    protected abstract Object removeJBossInternalAttribute(String var1, boolean var2, boolean var3);

    protected abstract Map getJBossInternalAttributes();

    protected abstract Object setJBossInternalAttribute(String var1, Object var2);

    protected void sessionAttributesDirty() {
        if (!this.sessionAttributesDirty && log.isTraceEnabled()) {
            log.trace((Object)("Marking session attributes dirty " + this.id));
        }
        this.sessionAttributesDirty = true;
    }

    protected void sessionMetadataDirty() {
        if (!this.sessionMetadataDirty && !this.isNew && log.isTraceEnabled()) {
            log.trace((Object)("Marking session metadata dirty " + this.id));
        }
        this.sessionMetadataDirty = true;
    }

    public boolean isSessionMetadataDirty() {
        return this.sessionMetadataDirty;
    }

    public boolean isSessionDirty() {
        return this.sessionAttributesDirty || this.sessionMetadataDirty;
    }

    public boolean isSessionAttributeMapDirty() {
        return this.sessionAttributesDirty;
    }

    public boolean getCreateRegionForSession() {
        return false;
    }

    protected boolean isGetDirty(Object attribute) {
        boolean result = false;
        switch (this.invalidationPolicy) {
            case SET_AND_GET: {
                result = true;
                break;
            }
            case SET_AND_NON_PRIMITIVE_GET: {
                result = this.isMutable(attribute);
                break;
            }
        }
        return result;
    }

    protected boolean isMutable(Object attribute) {
        return attribute != null && !(attribute instanceof String) && !(attribute instanceof Number) && !(attribute instanceof Character) && !(attribute instanceof Boolean);
    }

    private void checkAlwaysReplicateTimestamp() {
        this.alwaysReplicateTimestamp = this.maxUnreplicatedInterval == 0L || this.maxUnreplicatedInterval > 0L && this.maxInactiveInterval >= 0 && this.maxUnreplicatedInterval > (long)(this.maxInactiveInterval * 1000);
    }

    static {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < excludedAttributes.length; ++i) {
            set.add(excludedAttributes[i]);
        }
        replicationExcludes = Collections.unmodifiableSet(set);
        sm = StringManager.getManager((String)ClusteredSession.class.getPackage().getName());
    }
}

