/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.metadata.web.jboss.ReplicationTrigger;
import org.jboss.metadata.web.jboss.SnapshotMode;
import org.jboss.web.tomcat.service.session.AttributeBasedClusteredSession;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.ClusteredSessionValve;
import org.jboss.web.tomcat.service.session.FieldBasedClusteredSession;
import org.jboss.web.tomcat.service.session.InstantSnapshotManager;
import org.jboss.web.tomcat.service.session.IntervalSnapshotManager;
import org.jboss.web.tomcat.service.session.JBossCacheCluster;
import org.jboss.web.tomcat.service.session.JBossCacheClusteredSession;
import org.jboss.web.tomcat.service.session.JBossCacheManagerMBean;
import org.jboss.web.tomcat.service.session.JBossManager;
import org.jboss.web.tomcat.service.session.JvmRouteValve;
import org.jboss.web.tomcat.service.session.SessionBasedClusteredSession;
import org.jboss.web.tomcat.service.session.SessionReplicationContext;
import org.jboss.web.tomcat.service.session.SnapshotManager;
import org.jboss.web.tomcat.service.session.Util;
import org.jboss.web.tomcat.service.session.distributedcache.spi.BatchingManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSession;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionMetadata;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionTimestamp;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManagerFactory;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManagerFactoryFactory;
import org.jboss.web.tomcat.service.session.distributedcache.spi.FieldBasedDistributedCacheManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;

public class JBossCacheManager
extends JBossManager
implements JBossCacheManagerMBean,
LocalDistributableSessionManager {
    private static final String info_ = "JBossCacheManager/1.0";
    private BatchingManager batchingManager;
    private DistributedCacheManager proxy_;
    private final DistributedCacheManagerFactory distributedCacheManagerFactory;
    private Map<String, OwnedSessionUpdate> unloadedSessions_ = new ConcurrentHashMap<String, OwnedSessionUpdate>();
    private AtomicInteger passivatedCount_ = new AtomicInteger();
    private AtomicInteger maxPassivatedCount_ = new AtomicInteger();
    private Boolean useJK_;
    private boolean embedded_ = false;
    private SnapshotMode snapshotMode_ = null;
    private int snapshotInterval_ = 0;
    private ReplicationGranularity replicationGranularity_;
    private ReplicationTrigger replicationTrigger_;
    private Boolean replicationFieldBatchMode_;
    private ClassLoader tcl_;
    private SnapshotManager snapshotManager_;
    private String cacheConfigName_;
    private int maxUnreplicatedInterval_ = -1;

    public JBossCacheManager() throws ClusteringNotSupportedException {
        this(DistributedCacheManagerFactoryFactory.getInstance().getDistributedCacheManagerFactory());
    }

    public JBossCacheManager(DistributedCacheManagerFactory distributedManagerFactory) {
        assert (distributedManagerFactory != null) : "distributedManagerFactory is null";
        this.distributedCacheManagerFactory = distributedManagerFactory;
    }

    public void init(String name, JBossWebMetaData webMetaData) throws ClusteringNotSupportedException {
        Boolean batch;
        Boolean jk;
        super.init(name, webMetaData);
        ReplicationConfig repCfg = webMetaData.getReplicationConfig();
        if (repCfg != null) {
            this.replicationTrigger_ = repCfg.getReplicationTrigger();
            this.replicationGranularity_ = repCfg.getReplicationGranularity();
        }
        if ((jk = repCfg.getUseJK()) != null) {
            this.useJK_ = jk;
        }
        this.replicationFieldBatchMode_ = (batch = repCfg.getReplicationFieldBatchMode()) == null ? Boolean.TRUE : batch;
        this.setSnapshotMode(repCfg.getSnapshotMode());
        Integer snapshotInt = repCfg.getSnapshotInterval();
        this.setSnapshotInterval(snapshotInt == null ? 0 : snapshotInt);
        Integer maxUnrep = repCfg.getMaxUnreplicatedInterval();
        if (maxUnrep != null) {
            this.maxUnreplicatedInterval_ = maxUnrep;
        }
        this.log_.debug((Object)("init(): replicationGranularity_ is " + this.replicationGranularity_ + " and replicationTrigger is " + this.replicationTrigger_ + " and replicationFieldBatchMode is " + this.replicationFieldBatchMode_ + " and useJK is " + this.useJK_ + " and snapshotMode is " + this.snapshotMode_ + " and snapshotInterval is " + this.snapshotInterval_));
        this.cacheConfigName_ = repCfg.getCacheName();
        this.initCacheProxy();
        this.embedded_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocal(Session session) {
        ClusteredSession clusterSess;
        ClusteredSession clusteredSession = clusterSess = (ClusteredSession)session;
        synchronized (clusteredSession) {
            String realId = clusterSess.getRealId();
            if (realId == null) {
                return;
            }
            if (this.trace_) {
                this.log_.trace((Object)("Removing session from local store with id: " + realId));
            }
            try {
                SessionReplicationContext.startCacheActivity();
                clusterSess.removeMyselfLocal();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                SessionReplicationContext.finishCacheActivity();
                SessionReplicationContext.sessionExpired(clusterSess, realId, this.snapshotManager_);
                this.sessions_.remove(realId);
                this.stats_.removeStats(realId);
                int timeAlive = (int)((System.currentTimeMillis() - clusterSess.getCreationTimeInternal()) / 1000L);
                this.sessionExpired(timeAlive);
                throw throwable;
            }
            SessionReplicationContext.finishCacheActivity();
            SessionReplicationContext.sessionExpired(clusterSess, realId, this.snapshotManager_);
            this.sessions_.remove(realId);
            this.stats_.removeStats(realId);
            int timeAlive = (int)((System.currentTimeMillis() - clusterSess.getCreationTimeInternal()) / 1000L);
            this.sessionExpired(timeAlive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeSession(Session baseSession) {
        boolean stored = false;
        if (baseSession != null && this.started_) {
            ClusteredSession session;
            ClusteredSession clusteredSession = session = (ClusteredSession)baseSession;
            synchronized (clusteredSession) {
                if (this.trace_) {
                    this.log_.trace((Object)("check to see if needs to store and replicate session with id " + session.getIdInternal()));
                }
                if (session.isValid() && (session.isSessionDirty() || session.getMustReplicateTimestamp())) {
                    String realId = session.getRealId();
                    long begin = System.currentTimeMillis();
                    session.passivate();
                    long elapsed = System.currentTimeMillis() - begin;
                    this.stats_.updatePassivationStats(realId, elapsed);
                    begin = System.currentTimeMillis();
                    this.processSessionRepl(session);
                    elapsed = System.currentTimeMillis() - begin;
                    stored = true;
                    this.stats_.updateReplicationStats(realId, elapsed);
                } else if (this.trace_) {
                    this.log_.trace((Object)("Session " + session.getIdInternal() + " did not require replication."));
                }
            }
        }
        return stored;
    }

    public void add(Session session) {
        if (session == null) {
            return;
        }
        if (!(session instanceof ClusteredSession)) {
            throw new IllegalArgumentException("You can only add instances of type ClusteredSession to this Manager. Session class name: " + session.getClass().getName());
        }
        this.add((ClusteredSession)session, false);
    }

    private void add(ClusteredSession session, boolean replicate) {
        if (!session.isValid()) {
            this.log_.debug((Object)("Cannot add session with id=" + session.getIdInternal() + " because it is invalid"));
            return;
        }
        String realId = session.getRealId();
        ClusteredSession existing = this.sessions_.put(realId, session);
        this.unloadedSessions_.remove(realId);
        if (!((Object)((Object)session)).equals((Object)existing)) {
            if (replicate) {
                this.storeSession((Session)session);
            }
            this.calcActiveSessions();
            if (this.trace_) {
                this.log_.trace((Object)("Session with id=" + session.getIdInternal() + " added. " + "Current active sessions " + this.localActiveCounter_.get()));
            }
        }
    }

    public Session createEmptySession() {
        if (this.trace_) {
            this.log_.trace((Object)"Creating an empty ClusteredSession");
        }
        return this.createEmptyClusteredSession();
    }

    public Session createSession() {
        return this.createSession(null);
    }

    public Session createSession(String sessionId) {
        if (this.maxActiveAllowed_ != -1 && this.calcActiveSessions() >= this.maxActiveAllowed_) {
            if (this.trace_) {
                this.log_.trace((Object)("createSession(): active sessions = " + this.calcActiveSessions() + " and max allowed sessions = " + this.maxActiveAllowed_));
            }
            this.processExpirationPassivation();
            if (this.calcActiveSessions() >= this.maxActiveAllowed_) {
                this.rejectedCounter_.incrementAndGet();
                String msgEnd = sessionId == null ? "" : " id " + sessionId;
                throw new IllegalStateException("createSession(): number of active sessions exceeds the maximum limit: " + this.maxActiveAllowed_ + " when trying to create session" + msgEnd);
            }
        }
        JBossCacheClusteredSession session = this.createEmptyClusteredSession();
        session.setNew(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval_);
        session.setValid(true);
        if (sessionId == null) {
            sessionId = this.getNextId();
            if (this.getUseJK()) {
                if (this.trace_) {
                    this.log_.trace((Object)("createSession(): useJK is true. Will append JvmRoute: " + this.getJvmRoute()));
                }
                sessionId = sessionId + "." + this.getJvmRoute();
            }
        }
        session.setId(sessionId);
        if (this.trace_) {
            this.log_.trace((Object)("Created a ClusteredSession with id: " + sessionId));
        }
        this.createdCounter_.incrementAndGet();
        SessionReplicationContext.bindSession(session, this.snapshotManager_);
        return session;
    }

    public Session findSession(String id) {
        String realId = this.getRealId(id);
        ClusteredSession session = this.findLocalSession(realId);
        if (session == null && !SessionReplicationContext.isSessionBoundAndExpired(realId, this.snapshotManager_)) {
            if (this.trace_) {
                this.log_.trace((Object)("Checking for session " + realId + " in the distributed cache"));
            }
            if ((session = this.loadSession(realId)) != null) {
                this.add((Session)session);
            }
        } else if (session != null && session.isOutdated()) {
            if (this.trace_) {
                this.log_.trace((Object)("Updating session " + realId + " from the distributed cache"));
            }
            this.loadSession(realId);
        }
        if (session != null) {
            SessionReplicationContext.bindSession(session, this.snapshotManager_);
        }
        return session;
    }

    public Session[] findSessions() {
        if (this.unloadedSessions_.size() > 0) {
            HashSet<String> ids = new HashSet<String>(this.unloadedSessions_.keySet());
            if (this.trace_) {
                this.log_.trace((Object)("findSessions: loading sessions from distributed cache: " + ids));
            }
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                this.loadSession((String)it.next());
            }
        }
        return this.findLocalSessions();
    }

    public String getInfo() {
        return info_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session) {
        ClusteredSession clusterSess;
        ClusteredSession clusteredSession = clusterSess = (ClusteredSession)session;
        synchronized (clusteredSession) {
            String realId = clusterSess.getRealId();
            if (realId == null) {
                return;
            }
            if (this.trace_) {
                this.log_.trace((Object)("Removing session from store with id: " + realId));
            }
            try {
                SessionReplicationContext.startCacheActivity();
                clusterSess.removeMyself();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                SessionReplicationContext.finishCacheActivity();
                SessionReplicationContext.sessionExpired(clusterSess, realId, this.snapshotManager_);
                this.sessions_.remove(realId);
                this.stats_.removeStats(realId);
                int timeAlive = (int)((System.currentTimeMillis() - clusterSess.getCreationTimeInternal()) / 1000L);
                this.sessionExpired(timeAlive);
                throw throwable;
            }
            SessionReplicationContext.finishCacheActivity();
            SessionReplicationContext.sessionExpired(clusterSess, realId, this.snapshotManager_);
            this.sessions_.remove(realId);
            this.stats_.removeStats(realId);
            int timeAlive = (int)((System.currentTimeMillis() - clusterSess.getCreationTimeInternal()) / 1000L);
            this.sessionExpired(timeAlive);
        }
    }

    public void start() throws LifecycleException {
        if (this.embedded_) {
            this.startEmbedded();
        } else {
            this.startUnembedded();
        }
        this.log_.debug((Object)("JBossCacheManager for " + this.getContainer().getName() + " started"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws LifecycleException {
        if (!this.started_) {
            throw new IllegalStateException("Manager not started");
        }
        this.log_.debug((Object)"Stopping");
        AtomicBoolean atomicBoolean = this.backgroundProcessAllowed;
        synchronized (atomicBoolean) {
            this.backgroundProcessAllowed.set(false);
        }
        this.resetStats();
        this.lifecycle_.fireLifecycleEvent("before_stop", (Object)this);
        this.clearSessions();
        this.tcl_ = null;
        this.proxy_.stop();
        this.proxy_ = null;
        this.batchingManager = null;
        this.snapshotManager_.stop();
        this.sessions_.clear();
        this.unloadedSessions_.clear();
        this.passivatedCount_.set(0);
        this.started_ = false;
        this.lifecycle_.fireLifecycleEvent("after_stop", (Object)this);
        this.unregisterManagerMBean();
    }

    public void expireSession(String sessionId) {
        Session session = this.findSession(sessionId);
        if (session != null) {
            session.expire();
        }
    }

    public String getCacheConfigName() {
        return this.cacheConfigName_;
    }

    public String getCreationTime(String sessionId) {
        Session session = this.findSession(sessionId);
        if (session == null) {
            this.log_.info((Object)("getCreationTime(): Session " + sessionId + " not found"));
            return "";
        }
        return new Date(session.getCreationTime()).toString();
    }

    public int getDuplicates() {
        return this.duplicates_.get();
    }

    public String getLastAccessedTime(String sessionId) {
        Session session = this.findSession(sessionId);
        if (session == null) {
            this.log_.info((Object)("getLastAccessedTime(): Session " + sessionId + " not found"));
            return "";
        }
        return new Date(session.getLastAccessedTime()).toString();
    }

    public String getSessionAttribute(String sessionId, String key) {
        Object attr = null;
        ClusteredSession session = (ClusteredSession)this.findSession(sessionId);
        if (session != null) {
            attr = session.getAttribute(key);
        }
        return attr == null ? null : attr.toString();
    }

    public long getMaxPassivatedSessionCount() {
        return this.maxPassivatedCount_.get();
    }

    public int getMaxUnreplicatedInterval() {
        return this.maxUnreplicatedInterval_;
    }

    public void setMaxUnreplicatedInterval(int maxUnreplicatedInterval) {
        this.maxUnreplicatedInterval_ = maxUnreplicatedInterval;
    }

    public long getPassivatedSessionCount() {
        return this.passivatedCount_.get();
    }

    public long getPassivationMaxIdleTime() {
        return this.passivationMaxIdleTime_;
    }

    public long getPassivationMinIdleTime() {
        return this.passivationMinIdleTime_;
    }

    public ReplicationGranularity getReplicationGranularity() {
        return this.replicationGranularity_;
    }

    public ReplicationTrigger getReplicationTrigger() {
        return this.replicationTrigger_;
    }

    public int getSnapshotInterval() {
        return this.snapshotInterval_;
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode_;
    }

    public boolean getUseJK() {
        return this.useJK_ == null ? false : this.useJK_;
    }

    public boolean isPassivationEnabled() {
        return this.passivationMode_ && this.proxy_.isPassivationEnabled();
    }

    public Boolean isReplicationFieldBatchMode() {
        return this.replicationFieldBatchMode_;
    }

    public String listLocalSessionIds() {
        return this.reportSessionIds(this.sessions_.keySet());
    }

    public String listSessionIds() {
        HashSet ids = new HashSet(this.sessions_.keySet());
        ids.addAll(this.unloadedSessions_.keySet());
        return this.reportSessionIds(ids);
    }

    public String getContextName() {
        return this.getContainer().getName();
    }

    public String getHostName() {
        return this.getContainer().getParent().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRemoteInvalidation(String realId) {
        ClusteredSession session = (ClusteredSession)((Object)this.sessions_.remove(realId));
        if (session == null) {
            if (this.unloadedSessions_.remove(realId) != null && this.trace_) {
                this.log_.trace((Object)("Removed entry for session " + realId + " from unloaded session map"));
            }
        } else {
            boolean notify = false;
            boolean localCall = false;
            boolean localOnly = true;
            ClassLoader prevTcl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.tcl_);
                session.expire(notify, localCall, localOnly);
                Object var8_7 = null;
                Thread.currentThread().setContextClassLoader(prevTcl);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                Thread.currentThread().setContextClassLoader(prevTcl);
                throw throwable;
            }
            this.stats_.removeStats(realId);
        }
    }

    public void notifyLocalAttributeModification(String realId) {
        ClusteredSession session = (ClusteredSession)((Object)this.sessions_.get(realId));
        if (session != null) {
            session.sessionAttributesDirty();
        } else {
            this.log_.warn((Object)"");
        }
    }

    public void sessionActivated() {
        int pc = this.passivatedCount_.decrementAndGet();
        if (pc < 0) {
            this.passivatedCount_.incrementAndGet();
        }
    }

    public boolean sessionChangedInDistributedCache(String realId, String dataOwner, int distributedVersion, DistributableSessionTimestamp timestamp, DistributableSessionMetadata metadata) {
        boolean updated = true;
        ClusteredSession session = this.findLocalSession(realId);
        if (session != null) {
            updated = session.setVersionFromDistributedCache(distributedVersion);
            if (updated && this.trace_) {
                this.log_.trace((Object)("session in-memory data is invalidated for id: " + realId + " new version: " + distributedVersion));
            }
        } else {
            int maxLife;
            long lastMod = timestamp == null ? System.currentTimeMillis() : timestamp.getTimestamp();
            OwnedSessionUpdate existing = this.unloadedSessions_.put(realId, new OwnedSessionUpdate(dataOwner, lastMod, maxLife = metadata == null ? this.getMaxInactiveInterval() : metadata.getMaxInactiveInterval(), false));
            if (existing == null) {
                this.calcActiveSessions();
                if (this.trace_) {
                    this.log_.trace((Object)("New session " + realId + " added to unloaded session map"));
                }
            } else if (this.trace_) {
                this.log_.trace((Object)("Updated timestamp for unloaded session " + realId));
            }
        }
        return updated;
    }

    public void setSnapshotInterval(int snapshotInterval) {
        this.snapshotInterval_ = snapshotInterval;
    }

    public void setSnapshotMode(SnapshotMode snapshotMode) {
        this.snapshotMode_ = snapshotMode;
    }

    public void setUseJK(boolean useJK) {
        this.useJK_ = useJK;
    }

    public void setReplicationGranularity(ReplicationGranularity granularity) {
        this.replicationGranularity_ = granularity;
    }

    public String getReplicationGranularityString() {
        return this.replicationGranularity_ == null ? null : this.replicationGranularity_.toString();
    }

    public void setReplicationGranularityString(String granularity) {
        this.setReplicationGranularity(granularity == null ? null : ReplicationGranularity.fromString((String)granularity.toUpperCase()));
    }

    public void setReplicationTrigger(ReplicationTrigger trigger) {
        this.replicationTrigger_ = trigger;
    }

    public String getReplicationTriggerString() {
        return this.replicationTrigger_ == null ? null : this.replicationTrigger_.toString();
    }

    public void setReplicationTriggerString(String trigger) {
        this.setReplicationTrigger(trigger == null ? null : ReplicationTrigger.fromString((String)trigger.toUpperCase()));
    }

    public void setReplicationFieldBatchMode(boolean replicationFieldBatchMode) {
        this.replicationFieldBatchMode_ = replicationFieldBatchMode;
    }

    public FieldBasedDistributedCacheManager getFieldBasedDistributedCacheManager() {
        if (this.proxy_ != null && !(this.proxy_ instanceof FieldBasedDistributedCacheManager)) {
            throw new IllegalStateException("PojoCache not being used");
        }
        return (FieldBasedDistributedCacheManager)this.proxy_;
    }

    public DistributedCacheManager getDistributedCacheManager() {
        return this.proxy_;
    }

    protected String getNextId() {
        String id;
        while (this.sessions_.containsKey(id = super.getNextId()) || this.unloadedSessions_.containsKey(id)) {
            this.duplicates_.incrementAndGet();
        }
        return id;
    }

    protected int getTotalActiveSessions() {
        return this.localActiveCounter_.get() + this.unloadedSessions_.size() - this.passivatedCount_.get();
    }

    protected void processExpirationPassivation() {
        boolean passivate;
        block22: {
            boolean expire = this.maxInactiveInterval_ >= 0;
            passivate = this.isPassivationEnabled();
            long passivationMax = (long)this.passivationMaxIdleTime_ * 1000L;
            long passivationMin = (long)this.passivationMinIdleTime_ * 1000L;
            if (this.trace_) {
                this.log_.trace((Object)"processExpirationPassivation(): Looking for sessions that have expired ...");
                this.log_.trace((Object)("processExpirationPassivation(): active sessions = " + this.calcActiveSessions()));
                this.log_.trace((Object)("processExpirationPassivation(): expired sessions = " + this.expiredCounter_));
                if (passivate) {
                    this.log_.trace((Object)("processExpirationPassivation(): passivated count = " + this.getPassivatedSessionCount()));
                }
            }
            TreeSet<PassivationCheck> passivationChecks = new TreeSet<PassivationCheck>();
            try {
                ClusteredSession[] sessions = this.findLocalSessions();
                for (int i = 0; i < sessions.length; ++i) {
                    try {
                        ClusteredSession session = sessions[i];
                        if (session == null) {
                            this.log_.warn((Object)("processExpirationPassivation(): processing null session at index " + i));
                            continue;
                        }
                        if (expire) {
                            if (session.isOutdated() && !session.isValid(false)) {
                                this.loadSession(session.getRealId());
                            }
                            if (!session.isValid()) continue;
                        }
                        if (!passivate) continue;
                        passivationChecks.add(new PassivationCheck(session));
                        continue;
                    }
                    catch (Exception ex) {
                        this.log_.error((Object)("processExpirationPassivation(): failed handling " + sessions[i].getIdInternal() + " with exception: " + ex), (Throwable)ex);
                    }
                }
                long maxUnrep = this.maxUnreplicatedInterval_ < 0 ? 60L : (long)this.maxUnreplicatedInterval_;
                HashMap<String, OwnedSessionUpdate> unloaded = new HashMap<String, OwnedSessionUpdate>(this.unloadedSessions_);
                for (Map.Entry entry : unloaded.entrySet()) {
                    String realId = (String)entry.getKey();
                    OwnedSessionUpdate osu = (OwnedSessionUpdate)entry.getValue();
                    long now = System.currentTimeMillis();
                    long elapsed = now - osu.updateTime;
                    try {
                        if (expire && osu.maxInactive >= 1 && elapsed >= ((long)osu.maxInactive + maxUnrep) * 1000L) {
                            if (osu.passivated) {
                                Session session = this.findSession(realId);
                                session.isValid();
                                continue;
                            }
                            this.proxy_.removeSessionLocal(realId, osu.owner);
                            this.unloadedSessions_.remove(realId);
                            continue;
                        }
                        if (!passivate || osu.passivated) continue;
                        passivationChecks.add(new PassivationCheck(realId, osu));
                    }
                    catch (Exception ex) {
                        this.log_.error((Object)("processExpirationPassivation(): failed handling unloaded session " + realId), (Throwable)ex);
                    }
                }
                if (!passivate) break block22;
                for (PassivationCheck passivationCheck : passivationChecks) {
                    try {
                        long timeNow = System.currentTimeMillis();
                        long timeIdle = timeNow - passivationCheck.getLastUpdate();
                        if (passivationMax >= 0L && timeIdle > passivationMax) {
                            passivationCheck.passivate();
                            continue;
                        }
                        if (this.maxActiveAllowed_ > 0 && passivationMin > 0L && this.calcActiveSessions() >= this.maxActiveAllowed_ && timeIdle > passivationMin) {
                            passivationCheck.passivate();
                        }
                        break;
                    }
                    catch (Exception e) {
                        String unloadMark = passivationCheck.isUnloaded() ? "unloaded " : "";
                        this.log_.error((Object)("processExpirationPassivation(): failed passivating " + unloadMark + "session " + passivationCheck.getRealId()), (Throwable)e);
                    }
                }
            }
            catch (Exception ex) {
                this.log_.error((Object)("processExpirationPassivation(): failed with exception: " + ex), (Throwable)ex);
            }
        }
        if (this.trace_) {
            this.log_.trace((Object)"processExpirationPassivation(): Completed ...");
            this.log_.trace((Object)("processExpirationPassivation(): active sessions = " + this.calcActiveSessions()));
            this.log_.trace((Object)("processExpirationPassivation(): expired sessions = " + this.expiredCounter_));
            if (passivate) {
                this.log_.trace((Object)("processExpirationPassivation(): passivated count = " + this.getPassivatedSessionCount()));
            }
        }
    }

    public void resetStats() {
        super.resetStats();
        this.maxPassivatedCount_.set(this.passivatedCount_.get());
    }

    private JBossCacheClusteredSession createEmptyClusteredSession() {
        JBossCacheClusteredSession session = null;
        switch (this.replicationGranularity_) {
            case ATTRIBUTE: {
                session = new AttributeBasedClusteredSession(this);
                break;
            }
            case FIELD: {
                session = new FieldBasedClusteredSession(this);
                break;
            }
            default: {
                session = new SessionBasedClusteredSession(this);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClusteredSession loadSession(String realId) {
        if (realId == null) {
            return null;
        }
        long begin = System.currentTimeMillis();
        boolean mustAdd = false;
        JBossCacheClusteredSession session = (JBossCacheClusteredSession)((Object)this.sessions_.get(realId));
        if (session == null) {
            mustAdd = true;
            session = this.createEmptyClusteredSession();
        }
        JBossCacheClusteredSession jBossCacheClusteredSession = session;
        synchronized (jBossCacheClusteredSession) {
            boolean doTx = false;
            try {
                block19: {
                    try {
                        if (!this.batchingManager.isBatchInProgress()) {
                            this.batchingManager.startBatch();
                            doTx = true;
                        }
                        SessionReplicationContext.startCacheActivity();
                        session = (JBossCacheClusteredSession)this.proxy_.loadSession(realId, (DistributableSession)session);
                        if (session == null) break block19;
                        session.initAfterLoad(this);
                    }
                    catch (Exception ex) {
                        try {
                            this.batchingManager.setBatchRollbackOnly();
                        }
                        catch (Exception exn) {
                            this.log_.error((Object)"Caught exception rolling back transaction", (Throwable)exn);
                        }
                        if (!(ex instanceof RuntimeException)) throw new RuntimeException("loadSession(): failed to load session " + realId, ex);
                        throw (RuntimeException)ex;
                    }
                }
                Object var11_7 = null;
                try {
                    if (doTx) {
                        this.batchingManager.endBatch();
                    }
                    Object var13_9 = null;
                    SessionReplicationContext.finishCacheActivity();
                }
                catch (Throwable throwable) {
                    Object var13_10 = null;
                    SessionReplicationContext.finishCacheActivity();
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                Object var11_8 = null;
                try {}
                catch (Throwable throwable2) {
                    Object var13_12 = null;
                    SessionReplicationContext.finishCacheActivity();
                    throw throwable2;
                }
                if (doTx) {
                    this.batchingManager.endBatch();
                }
                Object var13_11 = null;
                SessionReplicationContext.finishCacheActivity();
                throw throwable;
            }
            if (session != null) {
                if (mustAdd) {
                    this.add(session, false);
                }
                long elapsed = System.currentTimeMillis() - begin;
                this.stats_.updateLoadStats(realId, elapsed);
                if (!this.trace_) return session;
                this.log_.trace((Object)("loadSession(): id= " + realId + ", session=" + (Object)((Object)session)));
            } else {
                if (!this.trace_) return session;
                this.log_.trace((Object)("loadSession(): session " + realId + " not found in distributed cache"));
            }
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processSessionRepl(ClusteredSession session) {
        boolean notSession = this.replicationGranularity_ != ReplicationGranularity.SESSION;
        boolean doTx = false;
        try {
            try {
                if (notSession && !this.batchingManager.isBatchInProgress()) {
                    this.batchingManager.startBatch();
                    doTx = true;
                }
                SessionReplicationContext.startCacheActivity();
                session.processSessionRepl();
            }
            catch (Exception ex) {
                this.log_.debug((Object)"processSessionRepl(): failed with exception", (Throwable)ex);
                try {
                    if (notSession) {
                        this.batchingManager.setBatchRollbackOnly();
                    }
                }
                catch (Exception exn) {
                    this.log_.error((Object)"Caught exception rolling back transaction", (Throwable)exn);
                }
                if (!(ex instanceof RuntimeException)) throw new RuntimeException("JBossCacheManager.processSessionRepl(): failed to replicate session.", ex);
                throw (RuntimeException)ex;
            }
            Object var7_4 = null;
            try {
                if (doTx) {
                    this.batchingManager.endBatch();
                }
                Object var9_6 = null;
                SessionReplicationContext.finishCacheActivity();
                return;
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                SessionReplicationContext.finishCacheActivity();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            try {}
            catch (Throwable throwable2) {
                Object var9_9 = null;
                SessionReplicationContext.finishCacheActivity();
                throw throwable2;
            }
            if (doTx) {
                this.batchingManager.endBatch();
            }
            Object var9_8 = null;
            SessionReplicationContext.finishCacheActivity();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessionPassivation(String realId) {
        ClusteredSession session = this.findLocalSession(realId);
        if (session != null) {
            ClusteredSession clusteredSession = session;
            synchronized (clusteredSession) {
                if (this.trace_) {
                    this.log_.trace((Object)("Passivating session with id: " + realId));
                }
                try {
                    SessionReplicationContext.startCacheActivity();
                    session.passivate();
                    this.proxy_.evictSession(realId);
                    this.sessionPassivated();
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    SessionReplicationContext.finishCacheActivity();
                    throw throwable;
                }
                SessionReplicationContext.finishCacheActivity();
                OwnedSessionUpdate obj = this.unloadedSessions_.put(realId, new OwnedSessionUpdate(null, session.getLastAccessedTime(), session.getMaxInactiveInterval(), true));
                if (this.trace_) {
                    if (obj == null) {
                        this.log_.trace((Object)("New session " + realId + " added to unloaded session map"));
                    } else {
                        this.log_.trace((Object)("Updated timestamp for unloaded session " + realId));
                    }
                }
                this.sessions_.remove(realId);
            }
        }
        if (this.trace_) {
            this.log_.trace((Object)("processSessionPassivation():  could not find session " + realId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUnloadedSessionPassivation(String realId, OwnedSessionUpdate osu) {
        if (this.trace_) {
            this.log_.trace((Object)("Passivating session with id: " + realId));
        }
        try {
            SessionReplicationContext.startCacheActivity();
            this.proxy_.evictSession(realId, osu.owner);
            osu.passivated = true;
            this.sessionPassivated();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            SessionReplicationContext.finishCacheActivity();
            throw throwable;
        }
        SessionReplicationContext.finishCacheActivity();
    }

    private void sessionPassivated() {
        int pc = this.passivatedCount_.incrementAndGet();
        int max = this.maxPassivatedCount_.get();
        while (pc > max) {
            if (this.maxPassivatedCount_.compareAndSet(max, pc)) continue;
            max = this.maxPassivatedCount_.get();
        }
    }

    private void startUnembedded() throws LifecycleException {
        if (this.started_) {
            return;
        }
        this.log_.info((Object)"Manager is about to start");
        this.lifecycle_.fireLifecycleEvent("before_start", (Object)this);
        if (this.snapshotMode_ == null) {
            try {
                JBossCacheCluster cluster = (JBossCacheCluster)this.container_.getCluster();
                cluster.configureManager(this);
            }
            catch (ClassCastException e) {
                String msg = "Cluster is not an instance of JBossCacheCluster";
                this.log_.error((Object)msg, (Throwable)e);
                throw new LifecycleException(msg, (Throwable)e);
            }
        }
        try {
            if (this.proxy_ == null) {
                this.initCacheProxy();
            }
            this.tcl_ = this.container_.getLoader().getClassLoader();
            this.proxy_.start(this.tcl_, (LocalDistributableSessionManager)this);
        }
        catch (Throwable t) {
            String str = "Problem starting JBossCacheService for Tomcat clustering";
            this.log_.error((Object)str, t);
            throw new LifecycleException(str, t);
        }
        this.batchingManager = this.proxy_.getBatchingManager();
        if (this.batchingManager == null) {
            throw new LifecycleException("JBossCacheManager.start(): Obtain null batchingManager");
        }
        try {
            this.initializeUnloadedSessions();
            this.installValves();
            this.started_ = true;
            this.lifecycle_.fireLifecycleEvent("after_start", (Object)this);
            this.log_.debug((Object)"start(): JBossCacheService started");
        }
        catch (Exception e) {
            this.log_.error((Object)"Unable to start manager.", (Throwable)e);
            throw new LifecycleException((Throwable)e);
        }
        this.registerManagerMBean();
    }

    private void initCacheProxy() throws ClusteringNotSupportedException {
        this.proxy_ = ReplicationGranularity.FIELD == this.replicationGranularity_ ? this.distributedCacheManagerFactory.getFieldBasedDistributedCacheManager(this.cacheConfigName_) : this.distributedCacheManagerFactory.getDistributedCacheManager(this.cacheConfigName_);
    }

    private void initializeUnloadedSessions() {
        Map sessions = this.proxy_.getSessionIds();
        if (sessions != null) {
            boolean passivate = this.isPassivationEnabled();
            long passivationMax = (long)this.passivationMaxIdleTime_ * 1000L;
            long passivationMin = (long)this.passivationMinIdleTime_ * 1000L;
            for (Map.Entry entry : sessions.entrySet()) {
                String realId = (String)entry.getKey();
                String owner = (String)entry.getValue();
                DistributableSessionTimestamp ts = null;
                DistributableSessionMetadata md = null;
                try {
                    Map sessionData = this.proxy_.getSessionData(realId, owner);
                    ts = (DistributableSessionTimestamp)sessionData.get("T");
                    md = (DistributableSessionMetadata)sessionData.get("M");
                }
                catch (Exception e) {
                    this.log_.debug((Object)("Problem reading metadata for session " + realId + " -- " + e.toString()));
                }
                long lastMod = ts == null ? System.currentTimeMillis() : ts.getTimestamp();
                int maxLife = md == null ? this.getMaxInactiveInterval() : md.getMaxInactiveInterval();
                OwnedSessionUpdate osu = new OwnedSessionUpdate(owner, lastMod, maxLife, false);
                this.unloadedSessions_.put(realId, osu);
                if (!passivate) continue;
                try {
                    long elapsed = System.currentTimeMillis() - lastMod;
                    if (passivationMax >= 0L && elapsed > passivationMax) {
                        if (this.trace_) {
                            this.log_.trace((Object)("Elapsed time of " + elapsed + " for session " + realId + " exceeds max of " + passivationMax + "; passivating"));
                        }
                        this.processUnloadedSessionPassivation(realId, osu);
                        continue;
                    }
                    if (this.maxActiveAllowed_ <= 0 || passivationMin < 0L || this.calcActiveSessions() <= this.maxActiveAllowed_ || elapsed < passivationMin) continue;
                    if (this.trace_) {
                        this.log_.trace((Object)("Elapsed time of " + elapsed + " for session " + realId + " exceeds min of " + passivationMin + "; passivating"));
                    }
                    this.processUnloadedSessionPassivation(realId, osu);
                }
                catch (Exception e) {
                    this.log_.debug((Object)("Problem passivating session " + realId + " -- " + e.toString()));
                }
            }
        }
    }

    private void installValves() {
        if (this.useJK_ == null) {
            this.useJK_ = this.getJvmRoute() != null;
        }
        if (this.getUseJK()) {
            this.log_.debug((Object)"We are using JK for load-balancing. Adding JvmRouteValve.");
            this.installContextValve((Valve)new JvmRouteValve(this));
        }
        BatchingManager valveBM = null;
        if (this.replicationGranularity_ == ReplicationGranularity.FIELD && Boolean.TRUE.equals(this.replicationFieldBatchMode_)) {
            valveBM = this.batchingManager;
            this.log_.debug((Object)"Including transaction manager in ClusteredSessionValve to support batch replication.");
        }
        ClusteredSessionValve valve = new ClusteredSessionValve(this, valveBM);
        this.log_.debug((Object)"Adding ClusteredSessionValve");
        this.installContextValve((Valve)valve);
    }

    private void initSnapshotManager() {
        String ctxPath = ((Context)this.container_).getPath();
        if (SnapshotMode.INSTANT == this.snapshotMode_) {
            this.snapshotManager_ = new InstantSnapshotManager(this, ctxPath);
        } else if (this.snapshotMode_ == null) {
            this.log_.warn((Object)"Snapshot mode must be 'instant' or 'interval' - using 'instant'");
            this.snapshotMode_ = SnapshotMode.INSTANT;
            this.snapshotManager_ = new InstantSnapshotManager(this, ctxPath);
        } else {
            if (ReplicationGranularity.FIELD == this.replicationGranularity_) {
                throw new IllegalStateException("Property snapshotMode must be " + SnapshotMode.INTERVAL + " when FIELD granularity is used");
            }
            if (this.snapshotInterval_ < 1) {
                this.log_.warn((Object)"Snapshot mode set to 'interval' but snapshotInterval is < 1 using 'instant'");
                this.snapshotMode_ = SnapshotMode.INSTANT;
                this.snapshotManager_ = new InstantSnapshotManager(this, ctxPath);
            } else {
                this.snapshotManager_ = new IntervalSnapshotManager(this, ctxPath, this.snapshotInterval_);
            }
        }
        this.snapshotManager_.start();
    }

    private void installContextValve(Valve valve) {
        boolean installed = false;
        if (this.embedded_ && this.getContextObjectName() != null) {
            try {
                this.getMBeanServer().invoke(this.getContextObjectName(), "addValve", new Object[]{valve}, new String[]{"org.apache.catalina.Valve"});
                installed = true;
            }
            catch (Exception e) {
                this.log_.debug((Object)"Caught exception installing valve to Context", (Throwable)e);
            }
        }
        if (!installed) {
            if (this.container_ instanceof ContainerBase) {
                ((ContainerBase)this.container_).addValve(valve);
            } else {
                this.container_.getPipeline().addValve(valve);
            }
        }
    }

    private ObjectName getContextObjectName() {
        String oname = this.container_.getObjectName();
        try {
            return oname == null ? null : new ObjectName(oname);
        }
        catch (MalformedObjectNameException e) {
            this.log_.warn((Object)("Error creating object name from string " + oname), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSessions() {
        boolean passivation = this.isPassivationEnabled();
        ClusteredSession[] sessions = this.findLocalSessions();
        for (int i = 0; i < sessions.length; ++i) {
            Object var9_13;
            ClusteredSession ses = sessions[i];
            if (this.trace_) {
                this.log_.trace((Object)("clearSessions(): clear session by expiring or passivating: " + (Object)((Object)ses)));
            }
            try {
                block13: {
                    try {
                        if (passivation && ses.isValid()) {
                            this.processSessionPassivation(ses.getRealId());
                            break block13;
                        }
                        boolean notify = true;
                        boolean localCall = true;
                        boolean localOnly = true;
                        ses.expire(notify, localCall, localOnly);
                    }
                    catch (Throwable t) {
                        this.log_.warn((Object)("clearSessions(): Caught exception expiring or passivating session " + ses.getIdInternal()), t);
                        var9_13 = null;
                        ses.recycle();
                        continue;
                    }
                }
                var9_13 = null;
                ses.recycle();
                continue;
            }
            catch (Throwable throwable) {
                var9_13 = null;
                ses.recycle();
                throw throwable;
            }
        }
        String action = passivation ? "evicting" : "removing";
        Set<Map.Entry<String, OwnedSessionUpdate>> unloaded = this.unloadedSessions_.entrySet();
        Iterator<Map.Entry<String, OwnedSessionUpdate>> it = unloaded.iterator();
        while (it.hasNext()) {
            Map.Entry<String, OwnedSessionUpdate> entry = it.next();
            String realId = entry.getKey();
            try {
                if (passivation) {
                    OwnedSessionUpdate osu = entry.getValue();
                    if (!osu.passivated) {
                        this.proxy_.evictSession(realId, osu.owner);
                    }
                } else {
                    this.proxy_.removeSessionLocal(realId, false);
                }
            }
            catch (Exception e) {
                this.log_.debug((Object)("Problem " + action + " session " + realId + " -- " + e));
            }
            it.remove();
        }
    }

    private void startEmbedded() throws LifecycleException {
        super.start();
        this.tcl_ = super.getContainer().getLoader().getClassLoader();
        try {
            if (this.proxy_ == null) {
                this.initCacheProxy();
            }
            this.proxy_.start(this.tcl_, (LocalDistributableSessionManager)this);
            this.batchingManager = this.proxy_.getBatchingManager();
            if (this.batchingManager == null) {
                throw new LifecycleException("JBossCacheManager.start(): Obtain null batchingManager");
            }
            this.initializeUnloadedSessions();
            this.initSnapshotManager();
            this.installValves();
            this.log_.debug((Object)"start(): JBossCacheService started");
        }
        catch (LifecycleException le) {
            throw le;
        }
        catch (Exception e) {
            this.log_.error((Object)"Unable to start manager.", (Throwable)e);
            throw new LifecycleException((Throwable)e);
        }
    }

    private String getRealId(String id) {
        return this.getUseJK() ? Util.getRealId(id) : id;
    }

    private String reportSessionIds(Set ids) {
        StringBuffer sb = new StringBuffer();
        boolean added = false;
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            if (added) {
                sb.append(',');
            } else {
                added = true;
            }
            sb.append(it.next());
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PassivationCheck
    implements Comparable<PassivationCheck> {
        private final String realId;
        private final OwnedSessionUpdate osu;
        private final ClusteredSession session;

        private PassivationCheck(String realId, OwnedSessionUpdate osu) {
            assert (osu != null) : "osu is null";
            assert (realId != null) : "realId is null";
            this.realId = realId;
            this.osu = osu;
            this.session = null;
        }

        private PassivationCheck(ClusteredSession session) {
            assert (session != null) : "session is null";
            this.realId = session.getRealId();
            this.session = session;
            this.osu = null;
        }

        private long getLastUpdate() {
            return this.osu == null ? this.session.getLastAccessedTimeInternal() : this.osu.updateTime;
        }

        private void passivate() {
            if (this.osu == null) {
                JBossCacheManager.this.processSessionPassivation(this.realId);
            } else {
                JBossCacheManager.this.processUnloadedSessionPassivation(this.realId, this.osu);
            }
        }

        private String getRealId() {
            return this.realId;
        }

        private boolean isUnloaded() {
            return this.osu != null;
        }

        @Override
        public int compareTo(PassivationCheck o) {
            long anotherVal;
            long thisVal = this.getLastUpdate();
            return thisVal < (anotherVal = o.getLastUpdate()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    }

    private class OwnedSessionUpdate {
        String owner;
        long updateTime;
        int maxInactive;
        boolean passivated;

        OwnedSessionUpdate(String owner, long updateTime, int maxInactive, boolean passivated) {
            this.owner = owner;
            this.updateTime = updateTime;
            this.maxInactive = maxInactive;
            this.passivated = passivated;
        }
    }
}

