/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.deployers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextHandler;
import javax.xml.namespace.QName;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Catalina;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.bootstrap.api.lifecycle.LifecycleState;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.security.plugins.JaasSecurityManagerServiceMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerImplMBean;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.web.tomcat.metadata.AnyXmlMetaData;
import org.jboss.web.tomcat.metadata.ConnectorMetaData;
import org.jboss.web.tomcat.metadata.HostMetaData;
import org.jboss.web.tomcat.metadata.ListenerMetaData;
import org.jboss.web.tomcat.metadata.ServerMetaData;
import org.jboss.web.tomcat.metadata.ServiceMetaData;
import org.jboss.web.tomcat.metadata.ValveMetaData;
import org.jboss.web.tomcat.security.HttpServletRequestPolicyContextHandler;
import org.jboss.web.tomcat.service.deployers.JBossWebMicrocontainerBeanLocator;
import org.jboss.web.tomcat.service.deployers.SecurityActions;
import org.jboss.web.tomcat.service.deployers.TomcatDeployer;
import org.jboss.web.tomcat.service.deployers.TomcatServiceMBean;
import org.jboss.web.tomcat.service.ondemand.DefaultOnDemandContextIntegrator;
import org.jboss.web.tomcat.service.ondemand.OnDemandContextIntegrator;
import org.jboss.web.tomcat.service.request.ActiveRequestResponseCacheValve;
import org.jboss.web.tomcat.service.session.SessionIDGenerator;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.builder.JBossXBBuilder;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatService
extends ServiceMBeanSupport
implements NotificationListener,
TomcatServiceMBean {
    private TomcatDeployer tomcatDeployer;
    private Executor executor;
    private boolean connectorsRunning = false;
    private DefaultOnDemandContextIntegrator onDemandContextIntegrator = new DefaultOnDemandContextIntegrator();

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public TomcatDeployer getTomcatDeployer() {
        return this.tomcatDeployer;
    }

    @Override
    public void setTomcatDeployer(TomcatDeployer tomcatDeployer) {
        this.tomcatDeployer = tomcatDeployer;
    }

    public OnDemandContextIntegrator getOnDemandContextIntegrator() {
        return this.onDemandContextIntegrator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void startService() throws Exception {
        block42: {
            block41: {
                block39: {
                    if (this.tomcatDeployer == null) {
                        throw new IllegalStateException("Must set TomcatDeployer before starting");
                    }
                    this.tomcatDeployer.setServiceClassLoader(this.getClass().getClassLoader());
                    propertiesIs = null;
                    try {
                        try {
                            propertiesIs = this.getClass().getClassLoader().getResourceAsStream("catalina.properties");
                            properties = new Properties();
                            properties.load(propertiesIs);
                            enumeration = properties.propertyNames();
                            while (enumeration.hasMoreElements()) {
                                name = (String)enumeration.nextElement();
                                value = properties.getProperty(name);
                                if (value == null || System.getProperty(name) != null) continue;
                                System.setProperty(name, value);
                            }
                            var7_7 = null;
                            if (propertiesIs == null) break block39;
                        }
                        catch (IOException e) {
                            this.log.info((Object)"Could not read catalina.properties");
                            var7_7 = null;
                            if (propertiesIs != null) {
                                try {
                                    propertiesIs.close();
                                }
                                catch (IOException e) {}
                            }
                            break block39;
                        }
                    }
                    catch (Throwable var6_11) {
                        var7_8 = null;
                        if (propertiesIs == null) throw var6_11;
                        ** try [egrp 2[TRYBLOCK] [4 : 152->159)] { 
lbl36:
                        // 1 sources

                        propertiesIs.close();
                        throw var6_11;
lbl38:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        throw var6_11;
                    }
                    try {}
                    catch (IOException e) {}
                    propertiesIs.close();
                }
                this.log.debug((Object)"Starting tomcat deployer");
                server = super.getServer();
                SecurityActions.setSystemProperty("catalina.ext.dirs", SecurityActions.getSystemProperty("jboss.server.home.dir", null) + File.separator + "lib");
                objectNameS = this.tomcatDeployer.getDomain() + ":type=Catalina";
                objectName = new ObjectName(objectNameS);
                schema = JBossXBBuilder.build(ServerMetaData.class);
                u = UnmarshallerFactory.newInstance().newUnmarshaller();
                u.setSchemaValidation(false);
                u.setValidation(false);
                u.setEntityResolver((EntityResolver)new JBossEntityResolver());
                is = null;
                serverMetaData = null;
                try {
                    configFile = new File(this.tomcatDeployer.getConfigFile());
                    is = configFile.exists() != false ? new FileInputStream(configFile) : this.getClass().getClassLoader().getResourceAsStream(this.tomcatDeployer.getConfigFile());
                    if (is == null) {
                        this.log.error((Object)("Could not read configured server.xml (will try default): " + this.tomcatDeployer.getConfigFile()));
                        is = this.getClass().getClassLoader().getResourceAsStream("server.xml");
                    }
                    serverMetaData = (ServerMetaData)ServerMetaData.class.cast(u.unmarshal(is, schema));
                    var11_14 = null;
                    if (is == null) break block41;
                }
                catch (Throwable var10_18) {
                    var11_15 = null;
                    if (is == null) throw var10_18;
                    try {
                        is.close();
                        throw var10_18;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var10_18;
                }
                try {}
                catch (IOException e) {}
                is.close();
            }
            catalina = new Catalina();
            catalina.setCatalinaHome(System.getProperty("jboss.server.home.dir"));
            Registry.getRegistry(null, null).setMBeanServer(server);
            Registry.getRegistry(null, null).registerComponent((Object)catalina, objectName, "org.apache.catalina.startup.Catalina");
            catalinaServer = (Server)TomcatService.getInstance(serverMetaData, "org.apache.catalina.core.StandardServer");
            Registry.getRegistry(null, null).registerComponent((Object)catalinaServer, new ObjectName(this.tomcatDeployer.getDomain() + ":type=Server"), "org.apache.catalina.startup.StandardServer");
            TomcatService.addLifecycleListeners(catalinaServer, serverMetaData.getListeners());
            if (serverMetaData.getServices() == null) {
                throw new IllegalArgumentException("No services");
            }
            for (ServiceMetaData serviceMetaData : serverMetaData.getServices()) {
                service = (Service)TomcatService.getInstance(serviceMetaData, "org.apache.catalina.core.StandardService");
                TomcatService.addLifecycleListeners(service, serviceMetaData.getListeners());
                service.setName(serviceMetaData.getName());
                service.setServer(catalinaServer);
                catalinaServer.addService(service);
                this.onDemandContextIntegrator.registerMapper(service.getName(), service.getMapper());
                if (serviceMetaData.getConnectors() != null) {
                    for (ConnectorMetaData connectorMetaData : serviceMetaData.getConnectors()) {
                        connector = new Connector(connectorMetaData.getProtocol());
                        if (connectorMetaData.getAttributes() != null) {
                            for (QName name : connectorMetaData.getAttributes().keySet()) {
                                value = (String)connectorMetaData.getAttributes().get(name);
                                value = StringPropertyReplacer.replaceProperties((String)value);
                                IntrospectionUtils.setProperty((Object)connector, (String)name.getLocalPart(), (String)value);
                            }
                        }
                        if (this.executor != null) {
                            IntrospectionUtils.callMethod1((Object)connector.getProtocolHandler(), (String)"setExecutor", (Object)this.executor, (String)Executor.class.getName(), (ClassLoader)this.getClass().getClassLoader());
                        }
                        service.addConnector(connector);
                    }
                }
                engineMetaData = serviceMetaData.getEngine();
                engine = (Engine)TomcatService.getInstance(engineMetaData, "org.apache.catalina.core.StandardEngine");
                TomcatService.addLifecycleListeners(engine, engineMetaData.getListeners());
                engine.setName(engineMetaData.getName());
                if (engineMetaData.getJvmRoute() != null) {
                    engine.setJvmRoute(StringPropertyReplacer.replaceProperties((String)engineMetaData.getJvmRoute()));
                }
                engine.getPipeline().addValve((Valve)new ActiveRequestResponseCacheValve());
                engine.setDefaultHost(engineMetaData.getDefaultHost());
                service.setContainer((Container)engine);
                if (engineMetaData.getRealm() != null) {
                    engine.setRealm((Realm)TomcatService.getInstance(engineMetaData.getRealm(), null));
                }
                TomcatService.addValves(engine, engineMetaData.getValves());
                if (engineMetaData.getHosts() == null) continue;
                for (HostMetaData hostMetaData : engineMetaData.getHosts()) {
                    host = (Host)TomcatService.getInstance(hostMetaData, "org.apache.catalina.core.StandardHost");
                    TomcatService.addLifecycleListeners(host, hostMetaData.getListeners());
                    host.setName(hostMetaData.getName());
                    engine.addChild((Container)host);
                    if (hostMetaData.getRealm() != null) {
                        host.setRealm((Realm)TomcatService.getInstance(hostMetaData.getRealm(), null));
                    }
                    TomcatService.addValves(host, hostMetaData.getValves());
                    if (hostMetaData.getAliases() == null) continue;
                    aliases = hostMetaData.getAliases().iterator();
                    while (aliases.hasNext()) {
                        host.addAlias(aliases.next());
                    }
                }
            }
            catalina.setServer(catalinaServer);
            catalina.create();
            catalinaServer.initialize();
            catalina.start();
            ic = new InitialContext();
            try {
                try {
                    ic.bind("TomcatAuthenticators", (Object)this.tomcatDeployer.getAuthenticators());
                }
                catch (NamingException ne) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"Binding Authenticators to JNDI failed", (Throwable)ne);
                    }
                    var21_29 = null;
                    try {
                        ic.close();
                    }
                    catch (NamingException nee) {}
                    break block42;
                }
                var21_28 = null;
            }
            catch (Throwable var20_34) {
                var21_30 = null;
                ** try [egrp 7[TRYBLOCK] [12 : 1297->1305)] { 
lbl169:
                // 1 sources

                ic.close();
                throw var20_34;
lbl171:
                // 1 sources

                catch (NamingException nee) {
                    // empty catch block
                }
                throw var20_34;
            }
            try {}
            catch (NamingException nee) {}
            ic.close();
        }
        handler = new HttpServletRequestPolicyContextHandler();
        PolicyContext.registerHandler((String)"javax.servlet.http.HttpServletRequest", (PolicyContextHandler)handler, (boolean)true);
        started = (Boolean)server.getAttribute(ServerImplMBean.OBJECT_NAME, "Started");
        if (started.booleanValue()) {
            this.log.debug((Object)("Server '" + ServerImplMBean.OBJECT_NAME + "' already started, starting connectors now"));
            this.startConnectors();
            return;
        }
        this.log.debug((Object)("Server '" + ServerImplMBean.OBJECT_NAME + "' not started, registering for start-up notification"));
        server.addNotificationListener(ServerImplMBean.OBJECT_NAME, this, null, null);
    }

    protected static Object getInstance(AnyXmlMetaData metaData, String defaultClassName) throws Exception {
        String className = metaData.getClassName();
        if (className == null) {
            className = defaultClassName;
        }
        if (className == null) {
            throw new IllegalArgumentException("No className specified for element");
        }
        Object instance = TomcatService.class.getClassLoader().loadClass(className).newInstance();
        if (metaData.getAttributes() != null) {
            for (QName name : metaData.getAttributes().keySet()) {
                String value = (String)metaData.getAttributes().get(name);
                value = StringPropertyReplacer.replaceProperties((String)value);
                IntrospectionUtils.setProperty(instance, (String)name.getLocalPart(), (String)value);
            }
        }
        return instance;
    }

    protected static void addLifecycleListeners(Object instance, List<ListenerMetaData> list) throws Exception {
        if (list == null) {
            return;
        }
        Lifecycle lifecycle = null;
        if (!(instance instanceof Lifecycle)) {
            return;
        }
        lifecycle = (Lifecycle)instance;
        for (ListenerMetaData listenerMetaData : list) {
            lifecycle.addLifecycleListener((LifecycleListener)TomcatService.getInstance(listenerMetaData, null));
        }
    }

    protected static void addValves(Object instance, List<ValveMetaData> list) throws Exception {
        if (list == null) {
            return;
        }
        Pipeline pipeline = null;
        if (!(instance instanceof Pipeline)) {
            return;
        }
        pipeline = (Pipeline)instance;
        for (ValveMetaData valveMetaData : list) {
            pipeline.addValve((Valve)TomcatService.getInstance(valveMetaData, null));
        }
    }

    protected void stopService() throws Exception {
        if (this.tomcatDeployer == null) {
            throw new IllegalStateException("Must set TomcatDeployer before stopping");
        }
        LifecycleState currentState = (LifecycleState)this.server.getAttribute(ServerImplMBean.OBJECT_NAME, "State");
        boolean inShutdown = currentState.equals((Object)LifecycleState.STOPPING);
        if (!inShutdown || this.connectorsRunning) {
            this.log.debug((Object)("Server '" + ServerImplMBean.OBJECT_NAME + "' already started, stopping connectors now"));
            this.stopConnectors();
        }
        MBeanServer server = super.getServer();
        String objectNameS = this.tomcatDeployer.getDomain() + ":type=Catalina";
        ObjectName objectName = new ObjectName(objectNameS);
        server.invoke(objectName, "stop", new Object[0], new String[0]);
        server.invoke(objectName, "destroy", new Object[0], new String[0]);
        server.unregisterMBean(objectName);
        MBeanServer server2 = server;
        ObjectName queryObjectName = new ObjectName(this.tomcatDeployer.getDomain() + ":*");
        for (ObjectInstance oi : server2.queryMBeans(queryObjectName, null)) {
            ObjectName toRemove = oi.getObjectName();
            if ("WebServer".equals(toRemove.getKeyProperty("service")) || !server2.isRegistered(toRemove)) continue;
            server2.unregisterMBean(toRemove);
        }
    }

    public String getConfigFile() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getConfigFile();
    }

    public String getContextMBeanCode() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getContextMBeanCode();
    }

    public String getDomain() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getDomain();
    }

    @Override
    public String getSessionIdAlphabet() {
        return SessionIDGenerator.getSessionIdAlphabet();
    }

    public String getSubjectAttributeName() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getSubjectAttributeName();
    }

    public boolean getDeleteWorkDirOnContextDestroy() {
        return this.tomcatDeployer == null ? false : this.tomcatDeployer.getDeleteWorkDirOnContextDestroy();
    }

    public boolean isAllowSelfPrivilegedWebApps() {
        return this.tomcatDeployer == null ? false : this.tomcatDeployer.isAllowSelfPrivilegedWebApps();
    }

    public void setAllowSelfPrivilegedWebApps(boolean flag) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setAllowSelfPrivilegedWebApps(flag);
        }
    }

    public void setConfigFile(String configFile) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setConfigFile(configFile);
        }
    }

    public void setContextMBeanCode(String className) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setContextMBeanCode(className);
        }
    }

    public void setDeleteWorkDirOnContextDestroy(boolean flag) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setDeleteWorkDirOnContextDestroy(flag);
        }
    }

    public void setDomain(String domainName) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setDomain(domainName);
        }
    }

    public void setSecurityManagerService(JaasSecurityManagerServiceMBean mgr) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setSecurityManagerService(mgr);
        }
    }

    @Override
    public void setSessionIdAlphabet(String sessionIdAlphabet) {
        SessionIDGenerator.setSessionIdAlphabet(sessionIdAlphabet);
    }

    public void setSubjectAttributeName(String name) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setSubjectAttributeName(name);
        }
    }

    public void startConnectors() throws Exception {
        if (this.tomcatDeployer == null) {
            throw new IllegalStateException("Must set TomcatDeployer before starting connectors");
        }
        if (this.connectorsRunning) {
            return;
        }
        MBeanServer server = super.getServer();
        ObjectName service = new ObjectName(this.tomcatDeployer.getDomain() + ":type=Service,serviceName=jboss.web");
        Object[] args = new Object[]{};
        String[] sig = new String[]{};
        Connector[] connectors = (Connector[])server.invoke(service, "findConnectors", args, sig);
        for (int n = 0; n < connectors.length; ++n) {
            Connector lc = connectors[n];
            lc.start();
        }
        this.connectorsRunning = true;
        this.sendNotification(new Notification("jboss.tomcat.connectors.started", this, this.getNextNotificationSequenceNumber()));
    }

    public synchronized void stopConnectors() throws Exception {
        if (this.tomcatDeployer == null) {
            throw new IllegalStateException("Must set TomcatDeployer before stopping connectors");
        }
        if (!this.connectorsRunning) {
            return;
        }
        this.sendNotification(new Notification("jboss.tomcat.connectors.stopped", this, this.getNextNotificationSequenceNumber()));
        MBeanServer server = super.getServer();
        ObjectName service = new ObjectName(this.tomcatDeployer.getDomain() + ":type=Service,serviceName=jboss.web");
        Object[] args = new Object[]{};
        String[] sig = new String[]{};
        Connector[] connectors = (Connector[])server.invoke(service, "findConnectors", args, sig);
        for (int n = 0; n < connectors.length; ++n) {
            connectors[n].pause();
            connectors[n].stop();
        }
        this.connectorsRunning = false;
    }

    @Override
    public void handleNotification(Notification msg, Object handback) {
        String type = msg.getType();
        if (type.equals("org.jboss.system.server.started")) {
            this.log.debug((Object)("Saw " + type + " notification, starting connectors"));
            try {
                this.startConnectors();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to startConnectors", (Throwable)e);
            }
        }
        if (type.equals("org.jboss.system.server.stopped")) {
            this.log.debug((Object)("Saw " + type + " notification, stopping connectors"));
            try {
                this.stopConnectors();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to stopConnectors", (Throwable)e);
            }
        }
    }

    public String getDefaultSecurityDomain() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getDefaultSecurityDomain();
    }

    public boolean getJava2ClassLoadingCompliance() {
        return this.tomcatDeployer == null ? false : this.tomcatDeployer.getJava2ClassLoadingCompliance();
    }

    public boolean getLenientEjbLink() {
        return this.tomcatDeployer == null ? false : this.tomcatDeployer.getLenientEjbLink();
    }

    public boolean getUnpackWars() {
        return this.tomcatDeployer == null ? false : this.tomcatDeployer.getUnpackWars();
    }

    public void setDefaultSecurityDomain(String defaultSecurityDomain) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setDefaultSecurityDomain(defaultSecurityDomain);
        }
    }

    public void setJava2ClassLoadingCompliance(boolean flag) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setJava2ClassLoadingCompliance(flag);
        }
    }

    public void setLenientEjbLink(boolean flag) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setLenientEjbLink(flag);
        }
    }

    public void setUnpackWars(boolean flag) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setUnpackWars(flag);
        }
    }

    public String getHttpHeaderForSSOAuth() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getHttpHeaderForSSOAuth();
    }

    public void setHttpHeaderForSSOAuth(String httpHeaderForSSOAuth) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setHttpHeaderForSSOAuth(httpHeaderForSSOAuth);
        }
    }

    public String getSessionCookieForSSOAuth() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getSessionCookieForSSOAuth();
    }

    public void setSessionCookieForSSOAuth(String sessionCookieForSSOAuth) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setSessionCookieForSSOAuth(sessionCookieForSSOAuth);
        }
    }

    public void setKernelControllerContext(KernelControllerContext controllerContext) throws Exception {
        super.setKernelControllerContext(controllerContext);
        KernelController kernelController = controllerContext == null ? null : controllerContext.getKernel().getController();
        JBossWebMicrocontainerBeanLocator.setKernelController(kernelController);
    }

    public void unsetKernelControllerContext(KernelControllerContext controllerContext) throws Exception {
        super.unsetKernelControllerContext(controllerContext);
        JBossWebMicrocontainerBeanLocator.setKernelController(null);
    }
}

