/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.ssl;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.naming.InitialContext;
import org.apache.coyote.http11.Http11AprProtocol;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityUtil;
import org.jboss.security.plugins.JaasSecurityDomain;

public class JBossHttp11AprProtocol
extends Http11AprProtocol {
    private String securityDomain;
    private String SSLPassword;
    private static final Logger log = Logger.getLogger(JBossHttp11AprProtocol.class);

    public void setSSLPassword(String SSLPassword) {
        this.SSLPassword = SSLPassword;
        if (this.securityDomain != null) {
            char[] password;
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Decoding password with security domain: " + this.securityDomain));
                }
                password = DecodeAction.decode(this.SSLPassword, this.securityDomain);
            }
            catch (Exception e) {
                log.error((Object)"Error decoding password", (Throwable)e);
                throw new IllegalArgumentException("Error decoding password", e);
            }
            super.setSSLPassword(new String(password));
            Object var2_2 = null;
        }
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = SecurityUtil.unprefixSecurityDomain((String)securityDomain);
        if (this.SSLPassword != null) {
            this.setSSLPassword(this.SSLPassword);
        }
    }

    private static class DecodeAction
    implements PrivilegedExceptionAction {
        String password;
        String jaasSecurityDomain;

        DecodeAction(String password, String jaasSecurityDomain) {
            this.password = password;
            this.jaasSecurityDomain = "java:/jaas/" + jaasSecurityDomain;
        }

        public Object run() throws Exception {
            InitialContext ctx = new InitialContext();
            JaasSecurityDomain securityDomain = (JaasSecurityDomain)ctx.lookup(this.jaasSecurityDomain);
            byte[] secret = securityDomain.decode64(this.password);
            String secretPassword = new String(secret, "UTF-8");
            return secretPassword.toCharArray();
        }

        static char[] decode(String password, String jaasSecurityDomain) throws Exception {
            DecodeAction action = new DecodeAction(password, jaasSecurityDomain);
            try {
                char[] decode = (char[])AccessController.doPrivileged(action);
                return decode;
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
    }
}

