/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.catalina.Globals;
import org.jboss.logging.Logger;

public class SessionIDGenerator {
    public static final String DEFAULT_SESSION_ID_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-_";
    public static final String DEFAULT_RANDOM_FILE = "/dev/urandom";
    public static final String DEFAULT_RANDOM_CLASS = SecureRandom.class.getName();
    public static final int SESSION_ID_BYTES = 16;
    public static final String SESSION_ID_HASH_ALGORITHM = "MD5";
    private static char[] sessionIdAlphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-_".toCharArray();
    protected Logger log = Logger.getLogger(SessionIDGenerator.class);
    private String randomFile = "/dev/urandom";
    private String randomClass = DEFAULT_RANDOM_CLASS;
    private String algorithm = "MD5";
    private String entropy;
    private DataInputStream randomIS;
    private MessageDigest digest;
    private Random random;

    public static void setSessionIdAlphabet(String alphabet) {
        if (alphabet.length() != 65) {
            throw new IllegalArgumentException("SessionIdAlphabet must be exactly 65 characters long");
        }
        SessionIDGenerator.checkDuplicateChars(alphabet);
        sessionIdAlphabet = alphabet.toCharArray();
    }

    protected static void checkDuplicateChars(String sessionIdAlphabet) {
        char[] alphabet = sessionIdAlphabet.toCharArray();
        for (int i = 0; i < alphabet.length; ++i) {
            if (SessionIDGenerator.uniqueChar(alphabet[i], sessionIdAlphabet)) continue;
            throw new IllegalArgumentException("All chars in SessionIdAlphabet must be unique");
        }
    }

    protected static boolean uniqueChar(char c, String s) {
        int firstIndex = s.indexOf(c);
        if (firstIndex == -1) {
            return false;
        }
        return s.indexOf(c, firstIndex + 1) == -1;
    }

    public static String getSessionIdAlphabet() {
        return new String(sessionIdAlphabet);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getEntropy() {
        if (this.entropy == null) {
            try {
                byte[] result = new byte[32];
                Class<?> jniOSClazz = Class.forName("org.apache.tomcat.jni.OS");
                Class[] paramTypes = new Class[]{result.getClass(), Integer.TYPE};
                Object[] paramValues = new Object[]{result, 32};
                jniOSClazz.getMethod("random", paramTypes).invoke(null, paramValues);
                this.entropy = new String(result);
            }
            catch (Throwable t) {
                this.entropy = this.toString();
            }
        }
        return this.entropy;
    }

    public void setEntropy(String entropy) {
        this.entropy = entropy;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String randomClass) {
        this.randomClass = randomClass;
    }

    public String getRandomFile() {
        return this.randomFile;
    }

    public void setRandomFile(String randomFile) {
        this.randomFile = randomFile;
    }

    public synchronized String getSessionId() {
        return this.generateSessionId();
    }

    protected synchronized String generateSessionId() {
        byte[] bytes = this.getRandomBytes();
        bytes = this.getDigest().digest(bytes);
        return this.encode(bytes);
    }

    protected byte[] getRandomBytes() {
        byte[] bytes = new byte[16];
        InputStream randomIS = this.getRandomInputStream();
        if (randomIS != null) {
            try {
                if (randomIS.read(bytes) == bytes.length) {
                    return bytes;
                }
                this.log.debug((Object)("Failed to read " + bytes.length + " bytes from random source; closing stream"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.closeRandomInputStream();
        }
        this.getRandom().nextBytes(bytes);
        return bytes;
    }

    protected String encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        char[] alphabet = sessionIdAlphabet;
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return new String(out);
    }

    protected synchronized Random getRandom() {
        if (this.random == null) {
            Random r = null;
            long seed = System.nanoTime();
            char[] entropy = this.getEntropy().toCharArray();
            for (int i = 0; i < entropy.length; ++i) {
                long update = (byte)entropy[i] << i % 8 * 8;
                seed ^= update;
            }
            try {
                Class<?> clazz = Class.forName(this.randomClass);
                r = (Random)clazz.newInstance();
            }
            catch (Exception e) {
                this.log.warn((Object)("Exception initializing random number generator of class " + this.randomClass), (Throwable)e);
                r = new Random();
            }
            r.setSeed(seed);
            this.random = r;
        }
        return this.random;
    }

    protected synchronized MessageDigest getDigest() {
        if (this.digest == null) {
            MessageDigest d;
            block5: {
                d = null;
                try {
                    d = MessageDigest.getInstance(this.algorithm);
                }
                catch (NoSuchAlgorithmException e) {
                    this.log.error((Object)("MessageDigest algorithm " + this.algorithm + " is unavailable"), (Throwable)e);
                    if (SESSION_ID_HASH_ALGORITHM.equals(this.algorithm)) break block5;
                    try {
                        d = MessageDigest.getInstance(SESSION_ID_HASH_ALGORITHM);
                    }
                    catch (NoSuchAlgorithmException f) {
                        this.log.error((Object)"MessageDigest algorithm MD5 is unavailable", (Throwable)e);
                    }
                }
            }
            this.digest = d;
        }
        return this.digest;
    }

    private InputStream getRandomInputStream() {
        if (this.randomIS == null && this.randomFile != null) {
            if (Globals.IS_SECURITY_ENABLED) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        SessionIDGenerator.this.openRandomInputStream();
                        return null;
                    }
                });
            } else {
                this.openRandomInputStream();
            }
        }
        return this.randomIS;
    }

    private void openRandomInputStream() {
        try {
            File f = new File(this.randomFile);
            if (f.exists()) {
                this.randomIS = new DataInputStream(new FileInputStream(f));
                this.randomIS.readLong();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Opened " + this.randomFile));
                }
            }
        }
        catch (IOException ex) {
            this.log.warn((Object)("Error reading " + this.randomFile), (Throwable)ex);
            this.closeRandomInputStream();
        }
    }

    private void closeRandomInputStream() {
        this.randomFile = null;
        if (this.randomIS != null) {
            try {
                this.randomIS.close();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to close randomIS.");
            }
            this.randomIS = null;
        }
    }
}

