/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.persistent;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.web.tomcat.service.session.distributedcache.spi.BatchingManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionMetadata;
import org.jboss.web.tomcat.service.session.distributedcache.spi.IncomingDistributableSessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingSessionGranularitySessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.SessionOwnershipSupport;
import org.jboss.web.tomcat.service.session.persistent.ExtendedDistributedCacheManager;
import org.jboss.web.tomcat.service.session.persistent.PersistentStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentStoreDistributedCacheManager
implements ExtendedDistributedCacheManager<OutgoingSessionGranularitySessionData> {
    private static final BatchingManager BATCH_MGR = new NoOpBatchingManager();
    private final PersistentStore store;
    private final LocalDistributableSessionManager manager;

    public PersistentStoreDistributedCacheManager(LocalDistributableSessionManager manager, PersistentStore store) {
        if (store == null) {
            throw new IllegalArgumentException("Null store");
        }
        this.store = store;
        this.manager = manager;
    }

    public BatchingManager getBatchingManager() {
        return BATCH_MGR;
    }

    public boolean isPassivationEnabled() {
        return true;
    }

    public void evictSession(String realId, String dataOwner) {
    }

    public void evictSession(String realId) {
    }

    public IncomingDistributableSessionData getSessionData(String realId, boolean initialLoad) {
        return this.getSessionData(realId, null, true);
    }

    public IncomingDistributableSessionData getSessionData(String realId, String dataOwner, boolean includeAttributes) {
        return this.store.getSessionData(realId, includeAttributes);
    }

    public Map<String, String> getSessionIds() {
        HashMap<String, String> result = new HashMap<String, String>();
        Set<String> keys = this.store.getSessionIds();
        if (keys != null) {
            for (String key : keys) {
                result.put(key, null);
            }
        }
        return result;
    }

    public void removeSession(String realId) {
        this.store.remove(realId);
    }

    public void removeSessionLocal(String realId, String dataOwner) {
        this.removeSessionLocal(realId);
    }

    public void removeSessionLocal(String realId) {
    }

    public void sessionCreated(String realId) {
    }

    @Override
    public Long getSessionTimestamp(String realId) {
        return this.store.getSessionTimestamp(realId);
    }

    @Override
    public Integer getSessionVersion(String realId) {
        return this.store.getSessionVersion(realId);
    }

    public void start() {
        this.store.start();
    }

    public void stop() {
        this.store.stop();
    }

    public void storeSessionData(OutgoingSessionGranularitySessionData sessionData) {
        this.store.storeSessionData(sessionData);
    }

    public void setForceSynchronous(boolean forceSynchronous) {
    }

    public SessionOwnershipSupport getSessionOwnershipSupport() {
        return null;
    }

    public boolean isLocal(String realId) {
        return true;
    }

    public String locate(String sessionId) {
        return this.manager.getJvmRoute();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IncomingDistributableSessionDataImpl
    implements IncomingDistributableSessionData {
        private final int version;
        private final long timestamp;
        private final DistributableSessionMetadata metadata;
        private final Map<String, Object> attributes;

        public IncomingDistributableSessionDataImpl(Integer version, Long timestamp, DistributableSessionMetadata metadata, Map<String, Object> attributes) {
            if (version == null) {
                throw new IllegalStateException("version is null");
            }
            if (timestamp == null) {
                throw new IllegalStateException("timestamp is null");
            }
            if (metadata == null) {
                throw new IllegalStateException("metadata is null");
            }
            this.version = version;
            this.timestamp = timestamp;
            this.metadata = metadata;
            this.attributes = attributes;
        }

        public boolean providesSessionAttributes() {
            return this.attributes != null;
        }

        public Map<String, Object> getSessionAttributes() {
            if (this.attributes == null) {
                throw new IllegalStateException("Not configured to provide session attributes");
            }
            return this.attributes;
        }

        public DistributableSessionMetadata getMetadata() {
            return this.metadata;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getVersion() {
            return this.version;
        }
    }

    public static class NoOpBatchingManager
    implements BatchingManager {
        public boolean isBatchInProgress() throws Exception {
            return false;
        }

        public void startBatch() throws Exception {
        }

        public void endBatch() {
        }

        public void setBatchRollbackOnly() throws Exception {
        }
    }
}

