/**
 * 
 */
package org.jboss.web.tomcat.service.session.persistent;

import java.util.Set;

import org.jboss.web.tomcat.service.session.distributedcache.spi.IncomingDistributableSessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingSessionGranularitySessionData;

/**
 * Interface exposed by a cluster-wide store for distributable web sessions.
 *
 *
 * @author Brian Stansberry
 * 
 * @version $Revision: $
 */
public interface PersistentStore
{
   Set<String> getSessionIds();
   IncomingDistributableSessionData getSessionData(String realId, boolean includeAttributes);
   Long getSessionTimestamp(String realId);
   Integer getSessionVersion(String realId);
   void storeSessionData(OutgoingSessionGranularitySessionData sessionData);
   void remove(String id);
   void processExpires();
   void start();
   void stop();
}
