/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.request;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.servlet.http.HttpEvent;

public class ActiveRequestResponseCacheValve
extends ValveBase {
    public static ThreadLocal<Request> activeRequest = new ThreadLocal();
    public static ThreadLocal<Response> activeResponse = new ThreadLocal();

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.internalProcess(request, response, null);
    }

    public void event(Request request, Response response, HttpEvent event) throws IOException, ServletException {
        this.internalProcess(request, response, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalProcess(Request request, Response response, HttpEvent event) throws IOException, ServletException {
        activeRequest.set(request);
        activeResponse.set(response);
        try {
            if (event == null) {
                this.getNext().invoke(request, response);
            } else {
                this.getNext().event(request, response, event);
            }
        }
        finally {
            activeRequest.set(null);
            activeResponse.set(null);
        }
    }
}

