/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.stats;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.varia.stats.DataSourceInterceptorMBean;
import org.jboss.varia.stats.StatisticalItem;
import org.jboss.varia.stats.TxReport;

public class DataSourceInterceptor
extends ServiceMBeanSupport
implements DataSource,
DataSourceInterceptorMBean {
    private String bindName;
    private String targetName;
    private DataSource target;
    private ObjectName statsCollector;

    public ObjectName getStatsCollector() {
        return this.statsCollector;
    }

    public void setStatsCollector(ObjectName statsCollector) {
        this.statsCollector = statsCollector;
    }

    public String getBindName() {
        return this.bindName;
    }

    public void setBindName(String bindName) throws NamingException {
        this.bindName = bindName;
        if (this.getState() == 3) {
            this.bind();
        }
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) throws NamingException {
        this.targetName = targetName;
        if (this.getState() == 3) {
            this.updateTarget();
        }
    }

    public void startService() throws Exception {
        this.updateTarget();
        this.bind();
    }

    public void stopService() throws Exception {
        this.unbind();
    }

    public int getLoginTimeout() throws SQLException {
        return this.target.getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.target.setLoginTimeout(seconds);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.target.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.target.setLogWriter(out);
    }

    public Connection getConnection() throws SQLException {
        return new ConnectionInterceptor(this.target.getConnection());
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return new ConnectionInterceptor(this.target.getConnection());
    }

    private void logSql(String sql) {
        try {
            TxReport.SqlStats item = new TxReport.SqlStats(sql);
            this.server.invoke(this.statsCollector, "addStatisticalItem", new Object[]{item}, new String[]{StatisticalItem.class.getName()});
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to add invocation.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind() throws NamingException {
        InitialContext ic = null;
        try {
            ic = new InitialContext();
            Name name = ic.getNameParser("").parse(this.bindName);
            NonSerializableFactory.rebind((Name)name, (Object)this, (boolean)true);
            this.log.debug((Object)("bound to JNDI name " + this.bindName));
        }
        finally {
            if (ic != null) {
                ic.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind() throws NamingException {
        InitialContext ic = null;
        try {
            ic = new InitialContext();
            ic.unbind(this.bindName);
            NonSerializableFactory.unbind((String)this.bindName);
        }
        finally {
            if (ic != null) {
                ic.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTarget() throws NamingException {
        InitialContext ic = null;
        try {
            ic = new InitialContext();
            this.target = (DataSource)ic.lookup(this.targetName);
            this.log.debug((Object)("target updated to " + this.targetName));
        }
        finally {
            if (ic != null) {
                ic.close();
            }
        }
    }

    public class PreparedStatementInterceptor
    extends StatementInterceptor
    implements PreparedStatement {
        private final PreparedStatement target;

        public PreparedStatementInterceptor(Connection con, PreparedStatement target) {
            super(con, target);
            this.target = target;
        }

        public int executeUpdate() throws SQLException {
            return this.target.executeUpdate();
        }

        public void addBatch() throws SQLException {
            this.target.addBatch();
        }

        public void clearParameters() throws SQLException {
            this.target.clearParameters();
        }

        public boolean execute() throws SQLException {
            return this.target.execute();
        }

        public void setByte(int parameterIndex, byte x) throws SQLException {
            this.target.setByte(parameterIndex, x);
        }

        public void setDouble(int parameterIndex, double x) throws SQLException {
            this.target.setDouble(parameterIndex, x);
        }

        public void setFloat(int parameterIndex, float x) throws SQLException {
            this.target.setFloat(parameterIndex, x);
        }

        public void setInt(int parameterIndex, int x) throws SQLException {
            this.target.setInt(parameterIndex, x);
        }

        public void setNull(int parameterIndex, int sqlType) throws SQLException {
            this.target.setNull(parameterIndex, sqlType);
        }

        public void setLong(int parameterIndex, long x) throws SQLException {
            this.target.setLong(parameterIndex, x);
        }

        public void setShort(int parameterIndex, short x) throws SQLException {
            this.target.setShort(parameterIndex, x);
        }

        public void setBoolean(int parameterIndex, boolean x) throws SQLException {
            this.target.setBoolean(parameterIndex, x);
        }

        public void setBytes(int parameterIndex, byte[] x) throws SQLException {
            this.target.setBytes(parameterIndex, x);
        }

        public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
            this.target.setAsciiStream(parameterIndex, x, length);
        }

        public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
            this.target.setBinaryStream(parameterIndex, x, length);
        }

        public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
            this.target.setUnicodeStream(parameterIndex, x, length);
        }

        public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
            this.target.setCharacterStream(parameterIndex, reader, length);
        }

        public void setObject(int parameterIndex, Object x) throws SQLException {
            this.target.setObject(parameterIndex, x);
        }

        public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
            this.target.setObject(parameterIndex, x, targetSqlType);
        }

        public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
            this.target.setObject(parameterIndex, x, targetSqlType, scale);
        }

        public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
            this.target.setNull(paramIndex, sqlType, typeName);
        }

        public void setString(int parameterIndex, String x) throws SQLException {
            this.target.setString(parameterIndex, x);
        }

        public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
            this.target.setBigDecimal(parameterIndex, x);
        }

        public void setURL(int parameterIndex, URL x) throws SQLException {
            this.target.setURL(parameterIndex, x);
        }

        public void setArray(int i, Array x) throws SQLException {
            this.target.setArray(i, x);
        }

        public void setBlob(int i, Blob x) throws SQLException {
            this.target.setBlob(i, x);
        }

        public void setClob(int i, Clob x) throws SQLException {
            this.target.setClob(i, x);
        }

        public void setDate(int parameterIndex, Date x) throws SQLException {
            this.target.setDate(parameterIndex, x);
        }

        public ParameterMetaData getParameterMetaData() throws SQLException {
            return this.target.getParameterMetaData();
        }

        public void setRef(int i, Ref x) throws SQLException {
            this.target.setRef(i, x);
        }

        public ResultSet executeQuery() throws SQLException {
            return this.target.executeQuery();
        }

        public ResultSetMetaData getMetaData() throws SQLException {
            return this.target.getMetaData();
        }

        public void setTime(int parameterIndex, Time x) throws SQLException {
            this.target.setTime(parameterIndex, x);
        }

        public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
            this.target.setTimestamp(parameterIndex, x);
        }

        public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
            this.target.setDate(parameterIndex, x, cal);
        }

        public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
            this.target.setTime(parameterIndex, x, cal);
        }

        public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
            this.target.setTimestamp(parameterIndex, x, cal);
        }
    }

    public class StatementInterceptor
    implements Statement {
        private final Connection con;
        private final Statement target;

        public StatementInterceptor(Connection con, Statement target) {
            this.con = con;
            this.target = target;
        }

        public int getFetchDirection() throws SQLException {
            return this.target.getFetchDirection();
        }

        public int getFetchSize() throws SQLException {
            return this.target.getFetchSize();
        }

        public int getMaxFieldSize() throws SQLException {
            return this.target.getMaxFieldSize();
        }

        public int getMaxRows() throws SQLException {
            return this.target.getMaxRows();
        }

        public int getQueryTimeout() throws SQLException {
            return this.target.getQueryTimeout();
        }

        public int getResultSetConcurrency() throws SQLException {
            return this.target.getResultSetConcurrency();
        }

        public int getResultSetHoldability() throws SQLException {
            return this.target.getResultSetHoldability();
        }

        public int getResultSetType() throws SQLException {
            return this.target.getResultSetType();
        }

        public int getUpdateCount() throws SQLException {
            return this.target.getUpdateCount();
        }

        public void cancel() throws SQLException {
            this.target.cancel();
        }

        public void clearBatch() throws SQLException {
            this.target.clearBatch();
        }

        public void clearWarnings() throws SQLException {
            this.target.clearWarnings();
        }

        public void close() throws SQLException {
            this.target.close();
        }

        public boolean getMoreResults() throws SQLException {
            return this.target.getMoreResults();
        }

        public int[] executeBatch() throws SQLException {
            return this.target.executeBatch();
        }

        public void setFetchDirection(int direction) throws SQLException {
            this.target.setFetchDirection(direction);
        }

        public void setFetchSize(int rows) throws SQLException {
            this.target.setFetchSize(rows);
        }

        public void setMaxFieldSize(int max) throws SQLException {
            this.target.setMaxFieldSize(max);
        }

        public void setMaxRows(int max) throws SQLException {
            this.target.setMaxRows(max);
        }

        public void setQueryTimeout(int seconds) throws SQLException {
            this.target.setQueryTimeout(seconds);
        }

        public boolean getMoreResults(int current) throws SQLException {
            return this.target.getMoreResults(current);
        }

        public void setEscapeProcessing(boolean enable) throws SQLException {
            this.target.setEscapeProcessing(enable);
        }

        public int executeUpdate(String sql) throws SQLException {
            DataSourceInterceptor.this.logSql(sql);
            return this.target.executeUpdate(sql);
        }

        public void addBatch(String sql) throws SQLException {
            DataSourceInterceptor.this.logSql(sql);
            this.target.addBatch(sql);
        }

        public void setCursorName(String name) throws SQLException {
            this.target.setCursorName(name);
        }

        public boolean execute(String sql) throws SQLException {
            DataSourceInterceptor.this.logSql(sql);
            return this.target.execute(sql);
        }

        public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
            DataSourceInterceptor.this.logSql(sql);
            return this.target.executeUpdate(sql, autoGeneratedKeys);
        }

        public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
            DataSourceInterceptor.this.logSql(sql);
            return this.target.execute(sql, autoGeneratedKeys);
        }

        public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
            DataSourceInterceptor.this.logSql(sql);
            return this.target.executeUpdate(sql, columnIndexes);
        }

        public boolean execute(String sql, int[] columnIndexes) throws SQLException {
            DataSourceInterceptor.this.logSql(sql);
            return this.target.execute(sql, columnIndexes);
        }

        public Connection getConnection() throws SQLException {
            return this.con;
        }

        public ResultSet getGeneratedKeys() throws SQLException {
            return this.target.getGeneratedKeys();
        }

        public ResultSet getResultSet() throws SQLException {
            return this.target.getResultSet();
        }

        public SQLWarning getWarnings() throws SQLException {
            return this.target.getWarnings();
        }

        public int executeUpdate(String sql, String[] columnNames) throws SQLException {
            DataSourceInterceptor.this.logSql(sql);
            return this.target.executeUpdate(sql, columnNames);
        }

        public boolean execute(String sql, String[] columnNames) throws SQLException {
            DataSourceInterceptor.this.logSql(sql);
            return this.target.execute(sql, columnNames);
        }

        public ResultSet executeQuery(String sql) throws SQLException {
            DataSourceInterceptor.this.logSql(sql);
            return this.target.executeQuery(sql);
        }
    }

    public class ConnectionInterceptor
    implements Connection {
        private final Connection target;

        public ConnectionInterceptor(Connection target) {
            this.target = target;
        }

        public int getHoldability() throws SQLException {
            return this.target.getHoldability();
        }

        public int getTransactionIsolation() throws SQLException {
            return this.target.getTransactionIsolation();
        }

        public void clearWarnings() throws SQLException {
            this.target.clearWarnings();
        }

        public void close() throws SQLException {
            this.target.close();
        }

        public void commit() throws SQLException {
            this.target.commit();
        }

        public void rollback() throws SQLException {
            this.target.rollback();
        }

        public boolean getAutoCommit() throws SQLException {
            return this.target.getAutoCommit();
        }

        public boolean isClosed() throws SQLException {
            return this.target.isClosed();
        }

        public boolean isReadOnly() throws SQLException {
            return this.target.isReadOnly();
        }

        public void setHoldability(int holdability) throws SQLException {
            this.target.setHoldability(holdability);
        }

        public void setTransactionIsolation(int level) throws SQLException {
            this.target.setTransactionIsolation(level);
        }

        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.target.setAutoCommit(autoCommit);
        }

        public void setReadOnly(boolean readOnly) throws SQLException {
            this.target.setReadOnly(readOnly);
        }

        public String getCatalog() throws SQLException {
            return this.target.getCatalog();
        }

        public void setCatalog(String catalog) throws SQLException {
            this.target.setCatalog(catalog);
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            return this.target.getMetaData();
        }

        public SQLWarning getWarnings() throws SQLException {
            return this.target.getWarnings();
        }

        public Savepoint setSavepoint() throws SQLException {
            return this.target.setSavepoint();
        }

        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.target.releaseSavepoint(savepoint);
        }

        public void rollback(Savepoint savepoint) throws SQLException {
            this.target.rollback(savepoint);
        }

        public Statement createStatement() throws SQLException {
            return new StatementInterceptor(this, this.target.createStatement());
        }

        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return new StatementInterceptor(this, this.target.createStatement(resultSetType, resultSetConcurrency));
        }

        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return new StatementInterceptor(this, this.target.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }

        public Map getTypeMap() throws SQLException {
            return this.target.getTypeMap();
        }

        public void setTypeMap(Map map) throws SQLException {
            this.target.setTypeMap(map);
        }

        public String nativeSQL(String sql) throws SQLException {
            return this.target.nativeSQL(sql);
        }

        public CallableStatement prepareCall(String sql) throws SQLException {
            return this.target.prepareCall(sql);
        }

        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.target.prepareCall(sql, resultSetType, resultSetConcurrency);
        }

        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.target.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            DataSourceInterceptor.this.logSql(sql);
            return new PreparedStatementInterceptor((Connection)this, this.target.prepareStatement(sql));
        }

        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            DataSourceInterceptor.this.logSql(sql);
            return new PreparedStatementInterceptor((Connection)this, this.target.prepareStatement(sql, autoGeneratedKeys));
        }

        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            DataSourceInterceptor.this.logSql(sql);
            return new PreparedStatementInterceptor((Connection)this, this.target.prepareStatement(sql, resultSetType, resultSetConcurrency));
        }

        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            DataSourceInterceptor.this.logSql(sql);
            return new PreparedStatementInterceptor((Connection)this, this.target.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }

        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            DataSourceInterceptor.this.logSql(sql);
            return new PreparedStatementInterceptor((Connection)this, this.target.prepareStatement(sql, columnIndexes));
        }

        public Savepoint setSavepoint(String name) throws SQLException {
            return this.target.setSavepoint(name);
        }

        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            DataSourceInterceptor.this.logSql(sql);
            return new PreparedStatementInterceptor((Connection)this, this.target.prepareStatement(sql, columnNames));
        }
    }
}

