/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.examples.configuration;

import java.io.Serializable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.jmx.examples.configuration.MBeanConfiguratorMBean;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;

public class MBeanConfigurator
extends ServiceMBeanSupport
implements MBeanConfiguratorMBean,
NotificationListener {
    private static final Logger log = Logger.getLogger((String)MBeanConfigurator.class.getName());

    public String getName() {
        return "MBeanConfigurator";
    }

    public void startService() {
        try {
            log.debug((Object)"Starting MBeanConfigurator service.");
            ObjectName mbeanserver = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            RegistrationNotificationFilter mbeanServerNotificationFilter = new RegistrationNotificationFilter();
            this.getServer().addNotificationListener(mbeanserver, this, (NotificationFilter)mbeanServerNotificationFilter, null);
        }
        catch (Exception e) {
            log.error((Object)"Could not start MBeanConfigurator service.", (Throwable)e);
        }
    }

    public void mbeanRegistered(ObjectName objectName) throws ReflectionException, InstanceNotFoundException, MBeanException, MalformedObjectNameException {
        log.debug((Object)("MBean " + objectName + " registered.  Will see if any attribute bindings present."));
        ObjectName serviceBindingMgr = new ObjectName("jboss.system:service=ServiceBindingManager");
        Object[] args = new Object[]{objectName};
        String[] sig = new String[]{"javax.management.ObjectName"};
        MBeanServer server = this.getServer();
        if (server != null) {
            server.invoke(serviceBindingMgr, "applyServiceConfig", args, sig);
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification && notification.getType().equals("JMX.mbean.registered")) {
            MBeanServerNotification serverNotification = (MBeanServerNotification)notification;
            try {
                this.mbeanRegistered(serverNotification.getMBeanName());
            }
            catch (Exception e) {
                log.error((Object)("Error configuring mbean " + serverNotification.getMBeanName()), (Throwable)e);
            }
        }
    }

    public class RegistrationNotificationFilter
    implements NotificationFilter,
    Serializable {
        public boolean isNotificationEnabled(Notification notification) {
            boolean processNotification = false;
            if (notification instanceof MBeanServerNotification && notification.getType().equals("JMX.mbean.registered")) {
                processNotification = true;
            }
            return processNotification;
        }
    }
}

