/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding.impl;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.net.URL;
import org.jboss.services.binding.ElementServiceBindingValueSource;
import org.jboss.services.binding.ServiceBinding;
import org.jboss.services.binding.StringServiceBindingValueSource;
import org.jboss.services.binding.URLServiceBindingValueSource;
import org.jboss.services.binding.impl.StringReplacementServiceBindingValueSourceConfig;
import org.jboss.services.binding.impl.Util;
import org.w3c.dom.Element;

public class StringReplacementServiceBindingValueSourceImpl
implements StringServiceBindingValueSource,
ElementServiceBindingValueSource,
URLServiceBindingValueSource {
    public String getStringServiceBindingValue(ServiceBinding binding, String input) throws Exception {
        if (input == null) {
            return binding.getHostName();
        }
        StringReplacementServiceBindingValueSourceConfig config = this.getConfig(binding);
        return this.replaceHostAndPort(input, binding.getHostName(), binding.getPort(), config.getHostMarker(), config.getPortMarker());
    }

    public Element getElementServiceBindingValue(ServiceBinding binding, Element input) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(Element.class);
        if (editor == null) {
            throw new IllegalStateException("Cannot find PropertyEditor for type Element");
        }
        StringReplacementServiceBindingValueSourceConfig config = this.getConfig(binding);
        editor.setValue(input);
        String text = editor.getAsText();
        text = this.replaceHostAndPort(text, binding.getHostName(), binding.getPort(), config.getHostMarker(), config.getPortMarker());
        editor.setAsText(text);
        return (Element)editor.getValue();
    }

    public String getResourceServiceBindingValue(ServiceBinding binding, String input) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        StringReplacementServiceBindingValueSourceConfig config = this.getConfig(binding);
        String content = Util.getContentAsString(input);
        String transformed = this.replaceHostAndPort(content, binding.getHostName(), binding.getPort(), config.getHostMarker(), config.getPortMarker());
        return Util.writeToTempFile(transformed).getAbsolutePath();
    }

    public URL getURLServiceBindingValue(ServiceBinding binding, URL input) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        StringReplacementServiceBindingValueSourceConfig config = this.getConfig(binding);
        String content = Util.getContentAsString(input);
        String transformed = this.replaceHostAndPort(content, binding.getHostName(), binding.getPort(), config.getHostMarker(), config.getPortMarker());
        return Util.writeToTempFile(transformed).toURL();
    }

    public Object getServiceBindingValue(ServiceBinding binding, Object ... params) throws Exception {
        if (params == null) {
            return this.getStringServiceBindingValue(binding, null);
        }
        if (params.length != 1) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".getServiceBindingValue() requires a single-value 'params'");
        }
        if (params[0] instanceof String) {
            return this.getStringServiceBindingValue(binding, (String)params[0]);
        }
        if (params[0] instanceof Element) {
            return this.getElementServiceBindingValue(binding, (Element)params[0]);
        }
        if (params[0] instanceof URL) {
            return this.getURLServiceBindingValue(binding, (URL)params[0]);
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + ".getServiceBindingValue() requires a single-value 'params' of type String, Element or URL");
    }

    private StringReplacementServiceBindingValueSourceConfig getConfig(ServiceBinding binding) {
        Object configSource = binding.getServiceBindingValueSourceConfig();
        if (configSource instanceof StringReplacementServiceBindingValueSourceConfig) {
            return (StringReplacementServiceBindingValueSourceConfig)configSource;
        }
        return new StringReplacementServiceBindingValueSourceConfig();
    }

    private String replaceHostAndPort(String text, String host, int port, String hostMarker, String portMarker) {
        if (text == null) {
            return null;
        }
        if (host == null) {
            host = "localhost";
        }
        String portStr = String.valueOf(port);
        text = text.replace(hostMarker, host);
        return text.replace(portMarker, portStr);
    }
}

