/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.html;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.jmx.adaptor.control.AddressPort;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.logging.Logger;

public class ClusteredConsoleServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(ClusteredConsoleServlet.class);
    private static final String ACTION_PARAM = "action";
    private static final String CLUSTER_BOOTSTRAP_ACTION = "bootstrap";
    private static final String CLUSTER_INDEX_ACTION = "index";
    private static final String BOOTSTRAP_PARAM = "bootstrap";
    private static final String PARTITION_PARAM = "partition";
    private static final String HOSTNAME_PARAM = "hostname";
    private static final String PORT_PARAM = "port";
    private static final String DISCOVERY_GROUP_PARAM = "discoveryGroup";
    private static final String DISCOVERY_TIMEOUT_PARAM = "discoveryTimeout";
    private String jgProps;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.jgProps = config.getInitParameter("jgProps");
        if (this.jgProps == null) {
            throw new ServletException("No jgProps init-param specified");
        }
        StringBuffer trimedProps = new StringBuffer();
        StringReader sr = new StringReader(this.jgProps);
        BufferedReader br = new BufferedReader(sr);
        String protocol = null;
        try {
            while ((protocol = br.readLine()) != null) {
                trimedProps.append(protocol.trim());
            }
        }
        catch (IOException e) {
            throw new ServletException("Failed to process jgProps", (Throwable)e);
        }
        this.jgProps = trimedProps.toString();
        log.debug((Object)("Using jbPropgs: " + this.jgProps));
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter(ACTION_PARAM);
        if (action == null) {
            action = CLUSTER_INDEX_ACTION;
        }
        if (action.equals(CLUSTER_INDEX_ACTION)) {
            this.clusterIndex(request, response);
        } else if (action.equals("bootstrap")) {
            this.clusterBootstrap(request, response);
        }
    }

    private void clusterIndex(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String[] hosts = new String[]{};
            request.setAttribute(PARTITION_PARAM, (Object)"none");
            request.setAttribute("partitionHosts", (Object)hosts);
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/cluster/clusterView.jsp");
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get partition view", (Throwable)e);
            response.sendError(204, "No partition view found");
        }
    }

    private void clusterBootstrap(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Properties env;
        String[] hosts;
        String partition;
        block13: {
            String hostname;
            String bootstrap = request.getParameter("bootstrap");
            log.debug((Object)"processRequest, parameters:");
            Enumeration params = request.getParameterNames();
            while (params.hasMoreElements()) {
                String name = (String)params.nextElement();
                log.debug((Object)(name + "=" + request.getParameter(name)));
            }
            if (bootstrap == null) {
                bootstrap = "discovery";
            }
            if ((hostname = request.getParameter(HOSTNAME_PARAM)) == null || hostname.equalsIgnoreCase("localhost")) {
                hostname = request.getServerName();
            }
            partition = request.getParameter(PARTITION_PARAM);
            String port = request.getParameter(PORT_PARAM);
            String discoveryGroup = request.getParameter(DISCOVERY_GROUP_PARAM);
            String discoveryTimeout = request.getParameter(DISCOVERY_TIMEOUT_PARAM);
            log.debug((Object)("bootstrap: " + bootstrap));
            hosts = new String[]{};
            env = new Properties();
            try {
                if (bootstrap.equals("discovery")) {
                    if (partition != null && partition.length() > 0) {
                        env.setProperty("jnp.partitionName", partition);
                    }
                    if (port != null && port.length() > 0) {
                        env.setProperty("jnp.discoveryPort", port);
                    }
                    if (discoveryGroup != null && discoveryGroup.length() > 0) {
                        env.setProperty("jnp.discoveryGroup", discoveryGroup);
                    }
                    if (discoveryTimeout != null && discoveryTimeout.length() > 0) {
                        env.setProperty("jnp.discoveryTimeout", discoveryTimeout);
                    }
                    hosts = this.discoverHosts(env);
                    break block13;
                }
                if (bootstrap.equals("byhost")) {
                    this.queryHost(hostname, port, env);
                    break block13;
                }
                throw new ServletException("Unkown bootstrap mode specified: " + bootstrap);
            }
            catch (Exception e) {
                throw new ServletException("Failed to bootstrap hosts", (Throwable)e);
            }
        }
        try {
            partition = env.getProperty("jnp.partitionName");
            request.setAttribute(PARTITION_PARAM, (Object)partition);
            request.setAttribute("partitionHosts", (Object)hosts);
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/cluster/clusterView.jsp");
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get partition view", (Throwable)e);
            response.sendError(204, "No partition view found");
        }
    }

    private String[] discoverHosts(Properties env) throws NamingException, IOException {
        String[] hosts;
        block3: {
            String partitionName;
            InitialContext ctx;
            block2: {
                env.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                hosts = new String[]{};
                log.debug((Object)("Querying HAJNDI: " + env));
                ctx = new InitialContext(env);
                partitionName = env.getProperty("jnp.partitionName");
                if (partitionName == null) break block2;
                String partitionJndiName = "/HAPartition/" + partitionName;
                HAPartition partition = (HAPartition)ctx.lookup(partitionJndiName);
                Vector view = partition.getCurrentView();
                log.debug((Object)("Found HAPartition: " + partitionName));
                hosts = new String[view.size()];
                for (int v = 0; v < view.size(); ++v) {
                    Object addr = view.get(v);
                    log.debug(addr);
                    hosts[v] = addr.toString();
                }
                break block3;
            }
            NamingEnumeration<NameClassPair> iter = ctx.list("/HAPartition");
            if (!iter.hasMore()) break block3;
            NameClassPair pair = iter.next();
            partitionName = pair.getName();
            String partitionJndiName = "/HAPartition/" + partitionName;
            HAPartition partition = (HAPartition)ctx.lookup(partitionJndiName);
            env.setProperty("jnp.partitionName", partitionName);
            Vector view = partition.getCurrentView();
            log.debug((Object)("Found HAPartition: " + partitionName));
            hosts = new String[view.size()];
            for (int v = 0; v < view.size(); ++v) {
                Object addr = view.get(v);
                AddressPort ap = AddressPort.getMemberAddress(addr);
                log.debug((Object)ap);
                hosts[v] = ap.getHostAddress();
            }
        }
        return hosts;
    }

    private String[] queryHost(String hostname, String port, Properties env) throws Exception {
        String[] hosts = new String[]{};
        env.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        env.setProperty("java.naming.provider.url", hostname + ":" + port);
        InitialContext ctx = new InitialContext(env);
        NamingEnumeration<NameClassPair> iter = ctx.list("/HAPartition");
        String partitionName = null;
        if (iter.hasMore()) {
            NameClassPair pair = iter.next();
            partitionName = pair.getName();
        }
        if (partitionName == null) {
            throw new NamingException("Failed to find any parition");
        }
        env.setProperty("jnp.partitionName", partitionName);
        RMIAdaptor adaptor = (RMIAdaptor)ctx.lookup("jmx/rmi/RMIAdaptor");
        ObjectName clusterPartition = new ObjectName("jboss:service=" + partitionName);
        Vector view = (Vector)adaptor.getAttribute(clusterPartition, "CurrentView");
        log.debug((Object)("Found ClusterPartition: " + clusterPartition));
        hosts = new String[view.size()];
        for (int v = 0; v < view.size(); ++v) {
            Object addr = view.get(v);
            AddressPort ap = AddressPort.getMemberAddress(addr);
            log.debug((Object)ap);
            hosts[v] = ap.getHostAddress();
        }
        return hosts;
    }
}

